/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRedudantBlocks {
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private final Path dirPath = new Path("/striped");
    private Path filePath = new Path(this.dirPath, "file");
    private final ErasureCodingPolicy ecPolicy = (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(1);
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final short groupSize = (short)(this.dataBlocks + this.parityBlocks);
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripesPerBlock = 4;
    private final int blockSize = 4 * this.cellSize;
    private final int numDNs = this.groupSize;

    @BeforeEach
    public void setup() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        conf.setInt("dfs.heartbeat.interval", 1);
        SimulatedFSDataset.setFactory(conf);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(this.numDNs).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(this.ecPolicy.getName());
        this.fs.mkdirs(this.dirPath);
        this.fs.getClient().setErasureCodingPolicy(this.dirPath.toString(), this.ecPolicy.getName());
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testProcessOverReplicatedAndRedudantBlock() throws Exception {
        LocatedBlock[] blocks;
        int i;
        long fileLen = this.dataBlocks * this.blockSize;
        DFSTestUtil.createStripedFile(this.cluster, this.filePath, null, 1, 4, false);
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        long gs = bg.getBlock().getGenerationStamp();
        String bpid = bg.getBlock().getBlockPoolId();
        long groupId = bg.getBlock().getBlockId();
        Block blk = new Block(groupId, (long)this.blockSize, gs);
        for (i = 0; i < this.groupSize - 1; ++i) {
            blk.setBlockId(groupId + (long)i);
            this.cluster.injectBlocks(i, Arrays.asList(blk), bpid);
        }
        this.cluster.triggerBlockReports();
        blk.setBlockId(groupId + 2L);
        this.cluster.injectBlocks(i, Arrays.asList(blk), bpid);
        BlockInfoStriped blockInfo = (BlockInfoStriped)this.cluster.getNamesystem().getBlockManager().getStoredBlock(new Block(groupId));
        this.cluster.triggerBlockReports();
        this.cluster.triggerHeartbeats();
        GenericTestUtils.waitFor(() -> this.cluster.getNamesystem().getBlockManager().countNodes((BlockInfo)blockInfo).liveReplicas() >= this.groupSize - 1, (long)500L, (long)10000L);
        this.cluster.triggerHeartbeats();
        GenericTestUtils.waitFor(() -> this.cluster.getNamesystem().getBlockManager().countNodes((BlockInfo)blockInfo).liveReplicas() >= this.groupSize, (long)500L, (long)10000L);
        HashSet<Long> blockIdsSet = new HashSet<Long>();
        lbs = this.cluster.getNameNodeRpc().getBlockLocations(this.filePath.toString(), 0L, fileLen);
        bg = (LocatedStripedBlock)lbs.get(0);
        for (LocatedBlock dn : blocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)bg, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks)) {
            if (dn == null) continue;
            blockIdsSet.add(dn.getBlock().getBlockId());
        }
        Assertions.assertEquals((int)this.groupSize, (int)blockIdsSet.size());
    }
}

