/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQuotaCounts {
    @Test
    public void testBuildConstEnumCounters() throws Exception {
        QuotaCounts qc = new QuotaCounts.Builder().nameSpace(-1L).storageSpace(-1L).build();
        Assertions.assertSame((Object)QuotaCounts.QUOTA_RESET, (Object)qc.nsSsCounts);
        Assertions.assertSame((Object)QuotaCounts.STORAGE_TYPE_DEFAULT, (Object)qc.tsCounts);
        Assertions.assertEquals((long)-1L, (long)qc.getNameSpace());
        Assertions.assertEquals((long)-1L, (long)qc.getStorageSpace());
        for (StorageType st : StorageType.values()) {
            Assertions.assertEquals((long)0L, (long)qc.getTypeSpace(st));
        }
    }

    @Test
    public void testAddSpace() throws Exception {
        QuotaCounts qc = new QuotaCounts.Builder().build();
        qc.addNameSpace(1L);
        qc.addStorageSpace(1024L);
        Assertions.assertEquals((long)1L, (long)qc.getNameSpace());
        Assertions.assertEquals((long)1024L, (long)qc.getStorageSpace());
    }

    @Test
    public void testAdd() throws Exception {
        QuotaCounts qc1 = new QuotaCounts.Builder().build();
        QuotaCounts qc2 = new QuotaCounts.Builder().nameSpace(1L).storageSpace(512L).typeSpaces(5L).build();
        qc1.add(qc2);
        Assertions.assertEquals((long)1L, (long)qc1.getNameSpace());
        Assertions.assertEquals((long)512L, (long)qc1.getStorageSpace());
        for (StorageType type : StorageType.values()) {
            Assertions.assertEquals((long)5L, (long)qc1.getTypeSpace(type));
        }
    }

    @Test
    public void testAddTypeSpaces() throws Exception {
        QuotaCounts qc = new QuotaCounts.Builder().build();
        for (StorageType t : StorageType.values()) {
            qc.addTypeSpace(t, 10L);
        }
        for (StorageType type : StorageType.values()) {
            Assertions.assertEquals((long)10L, (long)qc.getTypeSpace(type));
        }
    }

    @Test
    public void testSubtract() throws Exception {
        QuotaCounts qc1 = new QuotaCounts.Builder().build();
        QuotaCounts qc2 = new QuotaCounts.Builder().nameSpace(1L).storageSpace(512L).typeSpaces(5L).build();
        qc1.subtract(qc2);
        Assertions.assertEquals((long)-1L, (long)qc1.getNameSpace());
        Assertions.assertEquals((long)-512L, (long)qc1.getStorageSpace());
        for (StorageType type : StorageType.values()) {
            Assertions.assertEquals((long)-5L, (long)qc1.getTypeSpace(type));
        }
    }

    @Test
    public void testSetTypeSpaces() throws Exception {
        QuotaCounts qc1 = new QuotaCounts.Builder().build();
        QuotaCounts qc2 = new QuotaCounts.Builder().nameSpace(1L).storageSpace(512L).typeSpaces(5L).build();
        qc1.setTypeSpaces(qc2.getTypeSpaces());
        for (StorageType t : StorageType.values()) {
            Assertions.assertEquals((long)qc2.getTypeSpace(t), (long)qc1.getTypeSpace(t));
        }
        qc1.setTypeSpaces(QuotaCounts.STORAGE_TYPE_RESET);
        Assertions.assertSame((Object)QuotaCounts.STORAGE_TYPE_RESET, (Object)qc1.tsCounts);
    }

    @Test
    public void testSetSpaces() {
        QuotaCounts qc = new QuotaCounts.Builder().build();
        qc.setNameSpace(10L);
        qc.setStorageSpace(1024L);
        Assertions.assertEquals((long)10L, (long)qc.getNameSpace());
        Assertions.assertEquals((long)1024L, (long)qc.getStorageSpace());
        qc.setNameSpace(-1L);
        qc.setStorageSpace(-1L);
        Assertions.assertSame((Object)QuotaCounts.QUOTA_RESET, (Object)qc.nsSsCounts);
    }

    @Test
    public void testNegation() throws Exception {
        QuotaCounts qc = new QuotaCounts.Builder().nameSpace(-1L).storageSpace(-1L).typeSpaces(-1L).build();
        qc = qc.negation();
        Assertions.assertEquals((long)1L, (long)qc.getNameSpace());
        Assertions.assertEquals((long)1L, (long)qc.getStorageSpace());
        for (StorageType t : StorageType.values()) {
            Assertions.assertEquals((long)1L, (long)qc.getTypeSpace(t));
        }
    }
}

