/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestProcessCorruptBlocks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWhenDecreasingReplication() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.reconstruction.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            Assertions.assertEquals((int)2, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)1, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            namesystem.setReplication(fileName.toString(), (short)2);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertEquals((int)2, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)0, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testByAddingAnExtraDataNode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.reconstruction.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        MiniDFSCluster.DataNodeProperties dnPropsFourth = cluster.stopDataNode(3);
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            Assertions.assertEquals((int)2, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)1, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            cluster.restartDataNode(dnPropsFourth);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            Assertions.assertEquals((int)3, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)0, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=20L)
    public void testWithReplicationFactorAsOne() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.reconstruction.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)2, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)1);
            Assertions.assertEquals((int)1, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)1, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            namesystem.setReplication(fileName.toString(), (short)1);
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas() == 0) break;
            }
            Assertions.assertEquals((int)1, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)0, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithAllCorruptReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.reconstruction.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 0, block);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 1, block);
            this.corruptBlock(cluster, (FileSystem)fs, fileName, 2, block);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertEquals((int)0, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)3, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
            namesystem.setReplication(fileName.toString(), (short)1);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assertions.assertEquals((int)0, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).liveReplicas());
            Assertions.assertEquals((int)3, (int)TestProcessCorruptBlocks.countReplicas(namesystem, block).corruptReplicas());
        }
        finally {
            cluster.shutdown();
        }
    }

    private static NumberReplicas countReplicas(FSNamesystem namesystem, ExtendedBlock block) {
        BlockManager blockManager = namesystem.getBlockManager();
        return blockManager.countNodes(blockManager.getStoredBlock(block.getLocalBlock()));
    }

    private void corruptBlock(MiniDFSCluster cluster, FileSystem fs, Path fileName, int dnIndex, ExtendedBlock block) throws IOException {
        cluster.getMaterializedReplica(0, block).truncateData(10L);
        DataNodeTestUtils.runDirectoryScanner(cluster.getDataNodes().get(0));
        MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
        for (int dirIndex = 0; dirIndex < 2; ++dirIndex) {
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getStorageDir(dnIndex, dirIndex);
            File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            File scanLogFile = new File(dataDir, "dncp_block_verification.log.curr");
            if (!scanLogFile.exists()) continue;
            int i = 0;
            while (!scanLogFile.delete()) {
                Assertions.assertTrue((i < 60 ? 1 : 0) != 0, (String)"Could not delete log file in one minute");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        cluster.restartDataNode(dnProps);
    }
}

