/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParallelImageWrite {
    private static final int NUM_DATANODES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartDFS() throws Exception {
        FileStatus dirstatus;
        FileStatus rootstatus;
        long rootmtime;
        int numNamenodeDirs;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        DFSTestUtil files = new DFSTestUtil.Builder().setName("TestRestartDFS").setNumFiles(200).build();
        String dir = "/srcdat";
        Path rootpath = new Path("/");
        Path dirpath = new Path("/srcdat");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(4).build();
            String[] nameNodeDirs = conf.getStrings("dfs.namenode.name.dir", new String[0]);
            numNamenodeDirs = nameNodeDirs.length;
            Assertions.assertTrue((numNamenodeDirs != 0 ? 1 : 0) != 0, (String)"failed to get number of Namenode StorageDirs");
            DistributedFileSystem fs = cluster.getFileSystem();
            files.createFiles((FileSystem)fs, "/srcdat");
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
            rootstatus = fs.getFileStatus(dirpath);
            dirstatus = fs.getFileStatus(dirpath);
            fs.setOwner(rootpath, rootstatus.getOwner() + "_XXX", null);
            fs.setOwner(dirpath, null, dirstatus.getGroup() + "_XXX");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            conf.setInt("dfs.namenode.checkpoint.txns", 1);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).numDataNodes(4).build();
            fsn = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Assertions.assertTrue((boolean)files.checkFiles((FileSystem)fs, "/srcdat"), (String)"Filesystem corrupted after restart.");
            FileStatus newrootstatus = fs.getFileStatus(rootpath);
            Assertions.assertEquals((long)rootmtime, (long)newrootstatus.getModificationTime());
            Assertions.assertEquals((Object)(rootstatus.getOwner() + "_XXX"), (Object)newrootstatus.getOwner());
            Assertions.assertEquals((Object)rootstatus.getGroup(), (Object)newrootstatus.getGroup());
            FileStatus newdirstatus = fs.getFileStatus(dirpath);
            Assertions.assertEquals((Object)dirstatus.getOwner(), (Object)newdirstatus.getOwner());
            Assertions.assertEquals((Object)(dirstatus.getGroup() + "_XXX"), (Object)newdirstatus.getGroup());
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
            String checkAfterRestart = TestParallelImageWrite.checkImages(fsn, numNamenodeDirs);
            files.cleanup((FileSystem)fs, "/srcdat");
            files.createFiles((FileSystem)fs, "/srcdat");
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace(0L, 0L);
            String checkAfterModify = TestParallelImageWrite.checkImages(fsn, numNamenodeDirs);
            Assertions.assertFalse((boolean)checkAfterRestart.equals(checkAfterModify), (String)("Modified namespace should change fsimage contents. was: " + checkAfterRestart + " now: " + checkAfterModify));
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            files.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static String checkImages(FSNamesystem fsn, int numImageDirs) throws Exception {
        NNStorage stg = fsn.getFSImage().getStorage();
        Assertions.assertEquals((int)numImageDirs, (int)stg.getNumStorageDirs(NNStorage.NameNodeDirType.IMAGE), (String)"Some StorageDirectories failed Upgrade");
        Assertions.assertTrue((numImageDirs > 1 ? 1 : 0) != 0, (String)"Not enough fsimage copies in MiniDFSCluster to test parallel write");
        List<File> dirs = FSImageTestUtil.getCurrentDirs(stg, NNStorage.NameNodeDirType.IMAGE);
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, Collections.emptySet());
        FSImageTestUtil.assertSameNewestImage(dirs);
        Storage.StorageDirectory firstSd = (Storage.StorageDirectory)stg.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE).next();
        File latestImage = FSImageTestUtil.findLatestImageFile(firstSd);
        String md5 = FSImageTestUtil.getImageFileMD5IgnoringTxId(latestImage);
        System.err.println("md5 of " + latestImage + ": " + md5);
        return md5;
    }
}

