/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSXAttrBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNameNodeXAttr
extends FSXAttrBaseTest {
    private static final Path linkParent = new Path("/symdir1");
    private static final Path targetParent = new Path("/symdir2");
    private static final Path link = new Path(linkParent, "link");
    private static final Path target = new Path(targetParent, "target");

    @Test
    @Timeout(value=120L)
    public void testXAttrSymlinks() throws Exception {
        this.fs.mkdirs(linkParent);
        this.fs.mkdirs(targetParent);
        DFSTestUtil.createFile(this.fs, target, 1024L, (short)3, 48879L);
        this.fs.createSymlink(target, link, false);
        this.fs.setXAttr(target, "user.a1", value1);
        this.fs.setXAttr(target, "user.a2", value2);
        Map xattrs = this.fs.getXAttrs(link);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get("user.a1")));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get("user.a2")));
        this.fs.setXAttr(link, "user.a3", null);
        xattrs = this.fs.getXAttrs(target);
        Assertions.assertEquals((int)xattrs.size(), (int)3);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get("user.a1")));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get("user.a2")));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get("user.a3")));
        this.fs.removeXAttr(link, "user.a1");
        xattrs = this.fs.getXAttrs(target);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get("user.a2")));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get("user.a3")));
        this.fs.removeXAttr(target, "user.a3");
        xattrs = this.fs.getXAttrs(link);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get("user.a2")));
        this.fs.delete(linkParent, true);
        this.fs.delete(targetParent, true);
    }
}

