/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNameNodeOptionParsing {
    @Test
    @Timeout(value=10L)
    public void testUpgrade() {
        HdfsServerConstants.StartupOption opt = null;
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade"});
        Assertions.assertEquals((Object)opt, (Object)HdfsServerConstants.StartupOption.UPGRADE);
        Assertions.assertNull((Object)opt.getClusterId());
        Assertions.assertTrue((boolean)FSImageFormat.renameReservedMap.isEmpty());
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-clusterid", "mycid"});
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assertions.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assertions.assertTrue((boolean)FSImageFormat.renameReservedMap.isEmpty());
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-clusterid", "mycid", "-renameReserved", ".snapshot=.my-snapshot,.reserved=.my-reserved"});
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assertions.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assertions.assertEquals((Object)".my-snapshot", FSImageFormat.renameReservedMap.get(".snapshot"));
        Assertions.assertEquals((Object)".my-reserved", FSImageFormat.renameReservedMap.get(".reserved"));
        FSImageFormat.renameReservedMap.clear();
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.snapshot=.my-snapshot", "-clusterid", "mycid"});
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assertions.assertEquals((Object)"mycid", (Object)opt.getClusterId());
        Assertions.assertEquals((Object)".my-snapshot", FSImageFormat.renameReservedMap.get(".snapshot"));
        Assertions.assertEquals((Object)".my-reserved", FSImageFormat.renameReservedMap.get(".reserved"));
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved"});
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.UPGRADE, (Object)opt);
        Assertions.assertEquals((Object)(".snapshot." + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ".UPGRADE_RENAMED"), FSImageFormat.renameReservedMap.get(".snapshot"));
        Assertions.assertEquals((Object)(".reserved." + HdfsServerConstants.NAMENODE_LAYOUT_VERSION + ".UPGRADE_RENAMED"), FSImageFormat.renameReservedMap.get(".reserved"));
        try {
            opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.not-reserved=.my-not-reserved"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Unknown reserved path", (Throwable)e);
        }
        try {
            opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".reserved=.my-reserved,.snapshot=.snapshot"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid rename path", (Throwable)e);
        }
        try {
            opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-renameReserved", ".snapshot=.reserved"});
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid rename path", (Throwable)e);
        }
        opt = NameNode.parseArguments((String[])new String[]{"-upgrade", "-cid"});
        Assertions.assertNull((Object)opt);
    }

    @Test
    @Timeout(value=10L)
    public void testRollingUpgrade() {
        String[] args = new String[]{"-rollingUpgrade"};
        HdfsServerConstants.StartupOption opt = NameNode.parseArguments((String[])args);
        Assertions.assertNull((Object)opt);
        args = new String[]{"-rollingUpgrade", "started"};
        opt = NameNode.parseArguments((String[])args);
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assertions.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.STARTED, (Object)opt.getRollingUpgradeStartupOption());
        Assertions.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.STARTED.matches(opt));
        args = new String[]{"-rollingUpgrade", "rollback"};
        opt = NameNode.parseArguments((String[])args);
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.ROLLINGUPGRADE, (Object)opt);
        Assertions.assertEquals((Object)HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK, (Object)opt.getRollingUpgradeStartupOption());
        Assertions.assertTrue((boolean)HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(opt));
        args = new String[]{"-rollingUpgrade", "foo"};
        try {
            NameNode.parseArguments((String[])args);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFormat() {
        String[] args = new String[]{"-format"};
        HdfsServerConstants.StartupOption opt = NameNode.parseArguments((String[])args);
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.FORMAT, (Object)opt);
        Assertions.assertEquals((Object)true, (Object)opt.getInteractiveFormat());
        Assertions.assertEquals((Object)false, (Object)opt.getForceFormat());
        args = new String[]{"-format", "-nonInteractive"};
        opt = NameNode.parseArguments((String[])args);
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.FORMAT, (Object)opt);
        Assertions.assertEquals((Object)false, (Object)opt.getInteractiveFormat());
        Assertions.assertEquals((Object)false, (Object)opt.getForceFormat());
        args = new String[]{"-format", "-nonInteractive", "-force"};
        opt = NameNode.parseArguments((String[])args);
        Assertions.assertEquals((Object)HdfsServerConstants.StartupOption.FORMAT, (Object)opt);
        Assertions.assertEquals((Object)false, (Object)opt.getInteractiveFormat());
        Assertions.assertEquals((Object)true, (Object)opt.getForceFormat());
        args = new String[]{"-nonInteractive"};
        opt = NameNode.parseArguments((String[])args);
        Assertions.assertNull((Object)opt);
    }
}

