/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameNodeMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(TestNameNodeMXBean.class);
    private static final double DELTA = 1.0E-6;
    @TempDir
    java.nio.file.Path baseDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeMXBeanInfo() throws Exception {
        Configuration conf = new Configuration();
        Long maxLockedMemory = Shell.getMemlockLimit((Long)NativeIO.POSIX.getCacheManipulator().getMemlockLimit());
        conf.setLong("dfs.datanode.max.locked.memory", maxLockedMemory.longValue());
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(4).build();
            cluster.waitActive();
            String upgradeDomain = "abcd";
            DatanodeManager dm = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager();
            DatanodeDescriptor dd = dm.getDatanode(cluster.getDataNodes().get(0).getDatanodeId());
            dd.setUpgradeDomain(upgradeDomain);
            String dnXferAddrWithUpgradeDomainSet = dd.getXferAddr();
            DatanodeDescriptor maintenanceNode = dm.getDatanode(cluster.getDataNodes().get(1).getDatanodeId());
            maintenanceNode.setInMaintenance();
            String dnXferAddrInMaintenance = maintenanceNode.getXferAddr();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            Assertions.assertEquals((Object)fsn.getClusterId(), (Object)clusterId);
            String blockpoolId = (String)mbs.getAttribute(mxbeanName, "BlockPoolId");
            Assertions.assertEquals((Object)fsn.getBlockPoolId(), (Object)blockpoolId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            Assertions.assertEquals((Object)fsn.getVersion(), (Object)version);
            Assertions.assertTrue((boolean)version.equals(VersionInfo.getVersion() + ", r" + VersionInfo.getRevision()));
            Long used = (Long)mbs.getAttribute(mxbeanName, "Used");
            Assertions.assertEquals((long)fsn.getUsed(), (long)used);
            Long total = (Long)mbs.getAttribute(mxbeanName, "Total");
            Assertions.assertEquals((long)fsn.getTotal(), (long)total);
            String safemode = (String)mbs.getAttribute(mxbeanName, "Safemode");
            Assertions.assertEquals((Object)fsn.getSafemode(), (Object)safemode);
            Long nondfs = (Long)mbs.getAttribute(mxbeanName, "NonDfsUsedSpace");
            Assertions.assertEquals((long)fsn.getNonDfsUsedSpace(), (long)nondfs);
            Float percentremaining = (Float)mbs.getAttribute(mxbeanName, "PercentRemaining");
            Assertions.assertEquals((double)fsn.getPercentRemaining(), (double)percentremaining.floatValue(), (double)1.0E-6);
            Long totalblocks = (Long)mbs.getAttribute(mxbeanName, "TotalBlocks");
            Assertions.assertEquals((long)fsn.getTotalBlocks(), (long)totalblocks);
            String alivenodeinfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Map liveNodes = (Map)JSON.parse((String)alivenodeinfo);
            Assertions.assertTrue((liveNodes.size() == 4 ? 1 : 0) != 0);
            for (Map liveNode : liveNodes.values()) {
                Assertions.assertTrue((boolean)liveNode.containsKey("nonDfsUsedSpace"));
                Assertions.assertTrue(((Long)liveNode.get("nonDfsUsedSpace") >= 0L ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)liveNode.containsKey("capacity"));
                Assertions.assertTrue(((Long)liveNode.get("capacity") > 0L ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)liveNode.containsKey("numBlocks"));
                Assertions.assertTrue(((Long)liveNode.get("numBlocks") == 0L ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)liveNode.containsKey("lastBlockReport"));
                String xferAddr = (String)liveNode.get("xferaddr");
                if (!xferAddr.equals(dnXferAddrWithUpgradeDomainSet)) {
                    Assertions.assertTrue((!liveNode.containsKey("upgradeDomain") ? 1 : 0) != 0);
                } else {
                    Assertions.assertTrue((boolean)liveNode.get("upgradeDomain").equals(upgradeDomain));
                }
                boolean inMaintenance = liveNode.get("adminState").equals(DatanodeInfo.AdminStates.IN_MAINTENANCE.toString());
                Assertions.assertFalse((boolean)(xferAddr.equals(dnXferAddrInMaintenance) ^ inMaintenance));
            }
            Assertions.assertEquals((Object)fsn.getLiveNodes(), (Object)alivenodeinfo);
            DatanodeDescriptor decommissioningNode = dm.getDatanode(cluster.getDataNodes().get(2).getDatanodeId());
            decommissioningNode.startDecommission();
            DatanodeDescriptor decommissionedNode = dm.getDatanode(cluster.getDataNodes().get(3).getDatanodeId());
            decommissionedNode.setDecommissioned();
            String alivenodeinfo1 = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Map liveNodes1 = (Map)JSON.parse((String)alivenodeinfo1);
            for (Map liveNode : liveNodes1.values()) {
                Assertions.assertTrue((boolean)liveNode.containsKey("location"));
                Assertions.assertTrue((boolean)liveNode.containsKey("uuid"));
            }
            String deadNodeInfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assertions.assertEquals((Object)fsn.getDeadNodes(), (Object)deadNodeInfo);
            String nodeUsage = (String)mbs.getAttribute(mxbeanName, "NodeUsage");
            Assertions.assertEquals((Object)fsn.getNodeUsage(), (Object)nodeUsage, (String)"Bad value for NodeUsage");
            String nameJournalStatus = (String)mbs.getAttribute(mxbeanName, "NameJournalStatus");
            Assertions.assertEquals((Object)fsn.getNameJournalStatus(), (Object)nameJournalStatus, (String)"Bad value for NameJournalStatus");
            String journalTxnInfo = (String)mbs.getAttribute(mxbeanName, "JournalTransactionInfo");
            Assertions.assertEquals((Object)fsn.getJournalTransactionInfo(), (Object)journalTxnInfo, (String)"Bad value for NameTxnIds");
            String compileInfo = (String)mbs.getAttribute(mxbeanName, "CompileInfo");
            Assertions.assertEquals((Object)fsn.getCompileInfo(), (Object)compileInfo, (String)"Bad value for CompileInfo");
            String corruptFiles = (String)mbs.getAttribute(mxbeanName, "CorruptFiles");
            Assertions.assertEquals((Object)fsn.getCorruptFiles(), (Object)corruptFiles, (String)"Bad value for CorruptFiles");
            int corruptFilesCount = (Integer)mbs.getAttribute(mxbeanName, "CorruptFilesCount");
            Assertions.assertEquals((int)fsn.getCorruptFilesCount(), (int)corruptFilesCount, (String)"Bad value for CorruptFilesCount");
            String nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            Assertions.assertEquals((Object)fsn.getNameDirStatuses(), (Object)nameDirStatuses);
            Map statusMap = (Map)JSON.parse((String)nameDirStatuses);
            Collection<URI> nameDirUris = cluster.getNameDirs(0);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                System.out.println("Checking for the presence of " + nameDir + " in active name dirs.");
                Assertions.assertTrue((boolean)((Map)statusMap.get("active")).containsKey(nameDir.getAbsolutePath()));
            }
            Assertions.assertEquals((int)2, (int)((Map)statusMap.get("active")).size());
            Assertions.assertEquals((int)0, (int)((Map)statusMap.get("failed")).size());
            File failedNameDir = new File(nameDirUris.iterator().next());
            Assertions.assertEquals((int)0, (int)FileUtil.chmod((String)new File(failedNameDir, "current").getAbsolutePath(), (String)"000"));
            cluster.getNameNodeRpc().rollEditLog();
            nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            statusMap = (Map)JSON.parse((String)nameDirStatuses);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                String expectedStatus = nameDir.equals(failedNameDir) ? "failed" : "active";
                System.out.println("Checking for the presence of " + nameDir + " in " + expectedStatus + " name dirs.");
                Assertions.assertTrue((boolean)((Map)statusMap.get(expectedStatus)).containsKey(nameDir.getAbsolutePath()));
            }
            Assertions.assertEquals((int)1, (int)((Map)statusMap.get("active")).size());
            Assertions.assertEquals((int)1, (int)((Map)statusMap.get("failed")).size());
            Assertions.assertEquals((Object)0L, (Object)mbs.getAttribute(mxbeanName, "CacheUsed"));
            Assertions.assertEquals((Object)(maxLockedMemory * (long)cluster.getDataNodes().size()), (Object)mbs.getAttribute(mxbeanName, "CacheCapacity"));
            Assertions.assertNull((Object)mbs.getAttribute(mxbeanName, "RollingUpgradeStatus"), (String)"RollingUpgradeInfo should be null when there is no rolling upgrade");
        }
        finally {
            if (cluster != null) {
                for (URI dir : cluster.getNameDirs(0)) {
                    FileUtil.chmod((String)new File(new File(dir), "current").getAbsolutePath(), (String)"755");
                }
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastContactTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(3).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            cluster.stopDataNode(0);
            while (fsn.getBlockManager().getDatanodeManager().getNumLiveDataNodes() != 2) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            String deadNodeInfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assertions.assertEquals((Object)fsn.getDeadNodes(), (Object)deadNodeInfo);
            Map deadNodes = (Map)JSON.parse((String)deadNodeInfo);
            Assertions.assertTrue((deadNodes.size() > 0 ? 1 : 0) != 0);
            for (Map deadNode : deadNodes.values()) {
                Assertions.assertTrue((boolean)deadNode.containsKey("lastContact"));
                Assertions.assertTrue((boolean)deadNode.containsKey("adminState"));
                Assertions.assertTrue((boolean)deadNode.containsKey("xferaddr"));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testDecommissioningNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 30);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(3).build();
            cluster.waitActive();
            final FSNamesystem fsn = cluster.getNameNode().namesystem;
            final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            final ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            String liveNodesInfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            Map liveNodes = (Map)JSON.parse((String)liveNodesInfo);
            Assertions.assertEquals((Object)fsn.getLiveNodes(), (Object)liveNodesInfo);
            Assertions.assertEquals((int)fsn.getNumLiveDataNodes(), (int)liveNodes.size());
            for (Map liveNode : liveNodes.values()) {
                Assertions.assertTrue((boolean)liveNode.containsKey("lastContact"));
                Assertions.assertTrue((boolean)liveNode.containsKey("xferaddr"));
            }
            hostsFileWriter.initExcludeHost(cluster.getDataNodes().get(0).getDisplayName());
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        String decomNodesInfo = (String)mbs.getAttribute(mxbeanName, "DecomNodes");
                        Map decomNodes = (Map)JSON.parse((String)decomNodesInfo);
                        if (decomNodes.size() > 0) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return false;
                }
            }, (long)1000L, (long)60000L);
            String decomNodesInfo = (String)mbs.getAttribute(mxbeanName, "DecomNodes");
            Map decomNodes = (Map)JSON.parse((String)decomNodesInfo);
            Assertions.assertEquals((Object)fsn.getDecomNodes(), (Object)decomNodesInfo);
            Assertions.assertEquals((int)fsn.getNumDecommissioningDataNodes(), (int)decomNodes.size());
            Assertions.assertEquals((int)0, (int)fsn.getNumDecomLiveDataNodes());
            Assertions.assertEquals((int)0, (int)fsn.getNumDecomDeadDataNodes());
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    if (fsn.getNumDecomLiveDataNodes() == 1) {
                        return true;
                    }
                    return false;
                }
            }, (long)1000L, (long)60000L);
            decomNodesInfo = (String)mbs.getAttribute(mxbeanName, "DecomNodes");
            decomNodes = (Map)JSON.parse((String)decomNodesInfo);
            Assertions.assertEquals((int)0, (int)decomNodes.size());
            Assertions.assertEquals((Object)fsn.getDecomNodes(), (Object)decomNodesInfo);
            Assertions.assertEquals((int)1, (int)fsn.getNumDecomLiveDataNodes());
            Assertions.assertEquals((int)0, (int)fsn.getNumDecomDeadDataNodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testInServiceNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 30);
        conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestInServiceNodes");
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(3).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            final ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        int numLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumLiveDataNodes");
                        return numLiveDataNodes == 3;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }, (long)1000L, (long)60000L);
            int numDecomLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumDecomLiveDataNodes");
            int numInMaintenanceLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumInMaintenanceLiveDataNodes");
            int numInServiceLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumInServiceLiveDataNodes");
            Assertions.assertEquals((int)0, (int)numDecomLiveDataNodes);
            Assertions.assertEquals((int)0, (int)numInMaintenanceLiveDataNodes);
            Assertions.assertEquals((int)3, (int)numInServiceLiveDataNodes);
            ArrayList<String> decomNodes = new ArrayList<String>();
            decomNodes.add(cluster.getDataNodes().get(0).getDisplayName());
            HashMap<String, Long> maintenanceNodes = new HashMap<String, Long>();
            int expirationInMs = 30000;
            maintenanceNodes.put(cluster.getDataNodes().get(1).getDisplayName(), Time.now() + 30000L);
            hostsFileWriter.initOutOfServiceHosts(decomNodes, maintenanceNodes);
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        int numLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumLiveDataNodes");
                        int numDecomLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumDecomLiveDataNodes");
                        int numInMaintenanceLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumInMaintenanceLiveDataNodes");
                        return numLiveDataNodes == 3 && numDecomLiveDataNodes == 1 && numInMaintenanceLiveDataNodes == 1;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }, (long)1000L, (long)60000L);
            numInServiceLiveDataNodes = (Integer)mbs.getAttribute(mxbeanName, "NumInServiceLiveDataNodes");
            Assertions.assertEquals((int)1, (int)numInServiceLiveDataNodes);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testMaintenanceNodes() throws Exception {
        LOG.info("Starting testMaintenanceNodes");
        int expirationInMs = 30000;
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", expirationInMs);
        conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            Map enteringMaintenanceNodes;
            String enteringMaintenanceNodesInfo;
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(3).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            String liveNodesInfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            LOG.info("Live Nodes: " + liveNodesInfo);
            Map liveNodes = (Map)JSON.parse((String)liveNodesInfo);
            Assertions.assertEquals((Object)fsn.getLiveNodes(), (Object)liveNodesInfo);
            Assertions.assertEquals((int)fsn.getNumLiveDataNodes(), (int)liveNodes.size());
            for (Map liveNode : liveNodes.values()) {
                Assertions.assertTrue((boolean)liveNode.containsKey("lastContact"));
                Assertions.assertTrue((boolean)liveNode.containsKey("xferaddr"));
            }
            HashMap<String, Long> maintenanceNodes = new HashMap<String, Long>();
            maintenanceNodes.put(cluster.getDataNodes().get(0).getDisplayName(), Time.now() + (long)expirationInMs);
            hostsFileWriter.initOutOfServiceHosts(null, maintenanceNodes);
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            boolean recheck = true;
            while (recheck) {
                enteringMaintenanceNodesInfo = (String)mbs.getAttribute(mxbeanName, "EnteringMaintenanceNodes");
                enteringMaintenanceNodes = (Map)JSON.parse((String)enteringMaintenanceNodesInfo);
                if (enteringMaintenanceNodes.size() <= 0) {
                    LOG.info("Waiting for a node to Enter Maintenance state!");
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                LOG.info("Nodes entering Maintenance: " + enteringMaintenanceNodesInfo);
                recheck = false;
                Assertions.assertEquals((Object)fsn.getEnteringMaintenanceNodes(), (Object)enteringMaintenanceNodesInfo);
                Assertions.assertEquals((int)fsn.getNumEnteringMaintenanceDataNodes(), (int)enteringMaintenanceNodes.size());
                Assertions.assertEquals((int)0, (int)fsn.getNumInMaintenanceLiveDataNodes());
                Assertions.assertEquals((int)0, (int)fsn.getNumInMaintenanceDeadDataNodes());
            }
            while (fsn.getNumInMaintenanceLiveDataNodes() != 1) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            enteringMaintenanceNodesInfo = (String)mbs.getAttribute(mxbeanName, "EnteringMaintenanceNodes");
            enteringMaintenanceNodes = (Map)JSON.parse((String)enteringMaintenanceNodesInfo);
            Assertions.assertEquals((int)0, (int)enteringMaintenanceNodes.size());
            Assertions.assertEquals((Object)fsn.getEnteringMaintenanceNodes(), (Object)enteringMaintenanceNodesInfo);
            Assertions.assertEquals((int)1, (int)fsn.getNumInMaintenanceLiveDataNodes());
            Assertions.assertEquals((int)0, (int)fsn.getNumInMaintenanceDeadDataNodes());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testTopUsers() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/");
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                fs.listStatus(path);
                fs.setTimes(path, 0L, 1L);
            }
            String topUsers = (String)mbs.getAttribute(mxbeanNameFsns, "TopUserOpCounts");
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(topUsers, Map.class);
            Assertions.assertTrue((boolean)map.containsKey("timestamp"), (String)"Could not find map key timestamp");
            Assertions.assertTrue((boolean)map.containsKey("windows"), (String)"Could not find map key windows");
            List windows = (List)map.get("windows");
            Assertions.assertEquals((int)3, (int)windows.size(), (String)"Unexpected num windows");
            for (Map window : windows) {
                List ops = (List)window.get("ops");
                Assertions.assertEquals((int)4, (int)ops.size(), (String)"Unexpected num ops");
                for (Map op : ops) {
                    if (op.get("opType").equals("datanodeReport")) continue;
                    long count = Long.parseLong(op.get("totalCount").toString());
                    String opType = op.get("opType").toString();
                    int expected = opType.equals("*") ? 22 : (opType.equals("datanodeReport") ? 2 : 10);
                    Assertions.assertEquals((long)expected, (long)count, (String)"Unexpected total count");
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testTopUsersDisabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.top.enabled", false);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/");
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                fs.listStatus(path);
                fs.setTimes(path, 0L, 1L);
            }
            String topUsers = (String)mbs.getAttribute(mxbeanNameFsns, "TopUserOpCounts");
            Assertions.assertNull((Object)topUsers, (String)"Did not expect to find TopUserOpCounts bean!");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testTopUsersNoPeriods() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.top.enabled", true);
        conf.set("dfs.namenode.top.windows.minutes", "");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/");
            int NUM_OPS = 10;
            for (int i = 0; i < 10; ++i) {
                fs.listStatus(path);
                fs.setTimes(path, 0L, 1L);
            }
            String topUsers = (String)mbs.getAttribute(mxbeanNameFsns, "TopUserOpCounts");
            Assertions.assertNotNull((Object)topUsers, (String)"Expected TopUserOpCounts bean!");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testQueueLength() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(0).build();
            cluster.waitActive();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanNameFs = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
            int queueLength = (Integer)mbs.getAttribute(mxbeanNameFs, "LockQueueLength");
            Assertions.assertEquals((int)0, (int)queueLength);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNNDirectorySize() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.ha.log-roll.period", 0);
        MiniDFSCluster cluster = null;
        for (int i = 0; i < 5; ++i) {
            try {
                int[] ports = ServerSocketUtil.getPorts((int)2);
                MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setIpcPort(ports[0])).addNN(new MiniDFSNNTopology.NNConf("nn2").setIpcPort(ports[1])));
                cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).nnTopology(topology).numDataNodes(0).build();
                break;
            }
            catch (BindException e) {
                continue;
            }
        }
        if (cluster == null) {
            Assertions.fail((String)"failed to start mini cluster.");
        }
        DistributedFileSystem fs = null;
        try {
            cluster.waitActive();
            FSNamesystem nn0 = cluster.getNamesystem(0);
            FSNamesystem nn1 = cluster.getNamesystem(1);
            cluster.transitionToActive(0);
            fs = cluster.getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file"), 0L, (short)1, 0L);
            HATestUtil.waitForStandbyToCatchUp(cluster.getNameNode(0), cluster.getNameNode(1));
            this.checkNNDirSize(cluster.getNameDirs(0), nn0.getNameDirSize());
            this.checkNNDirSize(cluster.getNameDirs(1), nn1.getNameDirSize());
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file"), 0L, (short)1, 0L);
            nn0.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            nn0.saveNamespace(0L, 0L);
            this.checkNNDirSize(cluster.getNameDirs(0), nn0.getNameDirSize());
        }
        finally {
            cluster.shutdown();
        }
    }

    private void checkNNDirSize(Collection<URI> nameDirUris, String metric) {
        Map nnDirMap = (Map)JSON.parse((String)metric);
        Assertions.assertEquals((int)nameDirUris.size(), (int)nnDirMap.size());
        for (URI dirUrl : nameDirUris) {
            File dir = new File(dirUrl);
            Assertions.assertEquals((long)((Long)nnDirMap.get(dir.getAbsolutePath())), (long)FileUtils.sizeOfDirectory((File)dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnabledEcPoliciesMetric() throws Exception {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            ErasureCodingPolicy defaultPolicy = StripedFileTestUtil.getDefaultECPolicy();
            int dataBlocks = defaultPolicy.getNumDataUnits();
            int parityBlocks = defaultPolicy.getNumParityUnits();
            int totalSize = dataBlocks + parityBlocks;
            cluster = new MiniDFSCluster.Builder((Configuration)conf, this.baseDir.toFile()).numDataNodes(totalSize).build();
            fs = cluster.getFileSystem();
            String defaultPolicyName = defaultPolicy.getName();
            String rs104PolicyName = "RS-10-4-1024k";
            Assertions.assertEquals((Object)defaultPolicyName, (Object)this.getEnabledEcPoliciesMetric(), (String)"Enabled EC policies metric should return with the default EC policy");
            fs.enableErasureCodingPolicy("RS-10-4-1024k");
            Assertions.assertEquals((Object)("RS-10-4-1024k, " + defaultPolicyName), (Object)this.getEnabledEcPoliciesMetric(), (String)"Enabled EC policies metric should return with both enabled policies separated by a comma");
            fs.disableErasureCodingPolicy(defaultPolicyName);
            fs.disableErasureCodingPolicy("RS-10-4-1024k");
            Assertions.assertEquals((Object)"", (Object)this.getEnabledEcPoliciesMetric(), (String)"Enabled EC policies metric should return with an empty string if there is no enabled policy");
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyMissingBlockGroupsMetrics() throws Exception {
        MiniDFSCluster cluster = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int dataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
            int parityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
            int cellSize = StripedFileTestUtil.getDefaultECPolicy().getCellSize();
            int totalSize = dataBlocks + parityBlocks;
            cluster = new MiniDFSCluster.Builder((Configuration)conf, this.baseDir.toFile()).numDataNodes(totalSize).build();
            fs = cluster.getFileSystem();
            fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            Path ecDirPath = new Path("/striped");
            fs.mkdir(ecDirPath, FsPermission.getDirDefault());
            fs.getClient().setErasureCodingPolicy(ecDirPath.toString(), StripedFileTestUtil.getDefaultECPolicy().getName());
            Path file = new Path(ecDirPath, "corrupted");
            int length = cellSize * dataBlocks;
            byte[] bytes = StripedFileTestUtil.generateBytes(length);
            DFSTestUtil.writeFile((FileSystem)fs, file, bytes);
            LocatedStripedBlock lsb = (LocatedStripedBlock)fs.getClient().getLocatedBlocks(file.toString(), 0L, (long)(cellSize * dataBlocks)).get(0);
            LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lsb, (int)cellSize, (int)dataBlocks, (int)parityBlocks);
            for (int i = 0; i < parityBlocks + 1; ++i) {
                int ipcPort = blks[i].getLocations()[0].getIpcPort();
                cluster.corruptReplica(cluster.getDataNode(ipcPort), blks[i].getBlock());
            }
            for (DataNode dn : cluster.getDataNodes()) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
            }
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
            }
            catch (IOException ie) {
                Assertions.assertTrue((boolean)ie.getMessage().contains("missingChunksNum=" + (parityBlocks + 1)));
            }
            final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName replStateMBeanName = new ObjectName("Hadoop:service=NameNode,name=ReplicatedBlocksState");
            ObjectName ecBlkGrpStateMBeanName = new ObjectName("Hadoop:service=NameNode,name=ECBlockGroupsState");
            final ObjectName namenodeMXBeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            final long expectedMissingBlockCount = 1L;
            long expectedCorruptBlockCount = 1L;
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        Long numMissingBlocks = (Long)mbs.getAttribute(namenodeMXBeanName, "NumberOfMissingBlocks");
                        if (numMissingBlocks == expectedMissingBlockCount) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        Assertions.fail((String)"Caught unexpected exception.");
                    }
                    return false;
                }
            }, (long)1000L, (long)60000L);
            BlockManagerTestUtil.updateState(cluster.getNamesystem().getBlockManager());
            long totalMissingBlocks = cluster.getNamesystem().getMissingBlocksCount();
            Long replicaMissingBlocks = (Long)mbs.getAttribute(replStateMBeanName, "MissingReplicatedBlocks");
            Long ecMissingBlocks = (Long)mbs.getAttribute(ecBlkGrpStateMBeanName, "MissingECBlockGroups");
            Assertions.assertEquals((long)expectedMissingBlockCount, (long)totalMissingBlocks, (String)"Unexpected total missing blocks!");
            Assertions.assertEquals((long)totalMissingBlocks, (long)(replicaMissingBlocks + ecMissingBlocks), (String)"Unexpected total missing blocks!");
            Assertions.assertEquals((long)expectedMissingBlockCount, (long)ecMissingBlocks, (String)"Unexpected total ec missing blocks!");
            long totalCorruptBlocks = cluster.getNamesystem().getCorruptReplicaBlocks();
            Long replicaCorruptBlocks = (Long)mbs.getAttribute(replStateMBeanName, "CorruptReplicatedBlocks");
            Long ecCorruptBlocks = (Long)mbs.getAttribute(ecBlkGrpStateMBeanName, "CorruptECBlockGroups");
            Assertions.assertEquals((long)expectedCorruptBlockCount, (long)totalCorruptBlocks, (String)"Unexpected total corrupt blocks!");
            Assertions.assertEquals((long)totalCorruptBlocks, (long)(replicaCorruptBlocks + ecCorruptBlocks), (String)"Unexpected total corrupt blocks!");
            Assertions.assertEquals((long)expectedCorruptBlockCount, (long)ecCorruptBlocks, (String)"Unexpected total ec corrupt blocks!");
            String corruptFiles = (String)mbs.getAttribute(namenodeMXBeanName, "CorruptFiles");
            int numCorruptFiles = ((Object[])JSON.parse((String)corruptFiles)).length;
            Assertions.assertEquals((int)1, (int)numCorruptFiles);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTotalBlocksMetrics() throws Exception {
        MiniDFSCluster cluster = null;
        FSNamesystem activeNn = null;
        FSNamesystem standbyNn = null;
        DistributedFileSystem fs = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            int dataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
            int parityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
            int totalSize = dataBlocks + parityBlocks;
            int cellSize = StripedFileTestUtil.getDefaultECPolicy().getCellSize();
            int stripesPerBlock = 2;
            int blockSize = stripesPerBlock * cellSize;
            conf.setLong("dfs.blocksize", (long)blockSize);
            cluster = new MiniDFSCluster.Builder((Configuration)conf, this.baseDir.toFile()).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(1)).numDataNodes(totalSize).build();
            cluster.waitActive();
            cluster.transitionToActive(0);
            activeNn = cluster.getNamesystem(0);
            standbyNn = cluster.getNamesystem(1);
            fs = cluster.getFileSystem(0);
            fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            this.verifyTotalBlocksMetrics(0L, 0L, activeNn.getTotalBlocks());
            Path replDirPath = new Path("/replicated");
            Path replFileSmall = new Path(replDirPath, "replfile_small");
            int factor = 3;
            DFSTestUtil.createFile((FileSystem)fs, replFileSmall, blockSize, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, replFileSmall, (short)3);
            Path ecDirPath = new Path("/striped");
            fs.mkdir(ecDirPath, FsPermission.getDirDefault());
            fs.getClient().setErasureCodingPolicy(ecDirPath.toString(), StripedFileTestUtil.getDefaultECPolicy().getName());
            Path ecFileSmall = new Path(ecDirPath, "ecfile_small");
            int smallLength = cellSize * dataBlocks;
            byte[] smallBytes = StripedFileTestUtil.generateBytes(smallLength);
            DFSTestUtil.writeFile((FileSystem)fs, ecFileSmall, smallBytes);
            this.verifyTotalBlocksMetrics(1L, 1L, activeNn.getTotalBlocks());
            Path replFileLarge = new Path(replDirPath, "replfile_large");
            DFSTestUtil.createFile((FileSystem)fs, replFileLarge, 2 * blockSize, (short)3, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, replFileLarge, (short)3);
            Path ecFileLarge = new Path(ecDirPath, "ecfile_large");
            int largeLength = blockSize * totalSize + smallLength;
            byte[] largeBytes = StripedFileTestUtil.generateBytes(largeLength);
            DFSTestUtil.writeFile((FileSystem)fs, ecFileLarge, largeBytes);
            this.verifyTotalBlocksMetrics(3L, 3L, activeNn.getTotalBlocks());
            fs.delete(replDirPath, true);
            BlockManagerTestUtil.waitForMarkedDeleteQueueIsEmpty(cluster.getNamesystem(0).getBlockManager());
            this.verifyTotalBlocksMetrics(0L, 3L, activeNn.getTotalBlocks());
            fs.delete(ecDirPath, true);
            BlockManagerTestUtil.waitForMarkedDeleteQueueIsEmpty(cluster.getNamesystem(0).getBlockManager());
            this.verifyTotalBlocksMetrics(0L, 0L, activeNn.getTotalBlocks());
            this.verifyTotalBlocksMetrics(0L, 0L, standbyNn.getTotalBlocks());
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (activeNn != null) {
                activeNn.close();
            }
            if (standbyNn != null) {
                standbyNn.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadNodesInNameNodeMXBean() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        MiniDFSCluster cluster = null;
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize(conf, "temp/TestNameNodeMXBean");
        try {
            cluster = new MiniDFSCluster.Builder(conf, this.baseDir.toFile()).numDataNodes(3).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            ArrayList<String> hosts = new ArrayList<String>();
            for (DataNode dn : cluster.getDataNodes()) {
                hosts.add(dn.getDisplayName());
            }
            DatanodeDescriptor mockNode = new DatanodeDescriptor(new DatanodeID("127.0.0.2", "127.0.0.2", "", 5000, 5001, 5002, 5003));
            Assertions.assertEquals((Object)"", (Object)Optional.ofNullable(mockNode.getDatanodeUuid()).orElse(""));
            hosts.add(mockNode.getXferAddrWithHostname());
            hostsFileWriter.initIncludeHosts(hosts.toArray(new String[hosts.size()]));
            fsn.getBlockManager().getDatanodeManager().refreshNodes(conf);
            DatanodeManager dm = cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager();
            LOG.info("Get all include nodes: {}", (Object)dm.getHostConfigManager().getIncludes());
            String deadNodeInfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            Assertions.assertEquals((Object)fsn.getDeadNodes(), (Object)deadNodeInfo);
            LOG.info("Get deadNode info: {}", (Object)deadNodeInfo);
            Map deadNodes = (Map)JSON.parse((String)deadNodeInfo);
            Assertions.assertEquals((int)1, (int)deadNodes.size());
            for (Map deadNode : deadNodes.values()) {
                Assertions.assertTrue((boolean)deadNode.containsKey("lastContact"));
                Assertions.assertTrue((boolean)deadNode.containsKey("adminState"));
                Assertions.assertTrue((boolean)deadNode.containsKey("xferaddr"));
                Assertions.assertEquals((Object)"", deadNode.get("uuid"));
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            hostsFileWriter.cleanup();
        }
    }

    void verifyTotalBlocksMetrics(long expectedTotalReplicatedBlocks, long expectedTotalECBlockGroups, long actualTotalBlocks) throws Exception {
        long expectedTotalBlocks = expectedTotalReplicatedBlocks + expectedTotalECBlockGroups;
        Assertions.assertEquals((long)expectedTotalBlocks, (long)actualTotalBlocks, (String)"Unexpected total blocks!");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName replStateMBeanName = new ObjectName("Hadoop:service=NameNode,name=ReplicatedBlocksState");
        ObjectName ecBlkGrpStateMBeanName = new ObjectName("Hadoop:service=NameNode,name=ECBlockGroupsState");
        Long totalReplicaBlocks = (Long)mbs.getAttribute(replStateMBeanName, "TotalReplicatedBlocks");
        Long totalECBlockGroups = (Long)mbs.getAttribute(ecBlkGrpStateMBeanName, "TotalECBlockGroups");
        Assertions.assertEquals((long)expectedTotalReplicatedBlocks, (long)totalReplicaBlocks, (String)"Unexpected total replicated blocks!");
        Assertions.assertEquals((long)expectedTotalECBlockGroups, (long)totalECBlockGroups, (String)"Unexpected total ec block groups!");
        this.verifyEcClusterSetupVerifyResult(mbs);
    }

    private String getEnabledEcPoliciesMetric() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=ECBlockGroupsState");
        return (String)mbs.getAttribute(mxbeanName, "EnabledEcPolicies");
    }

    private void verifyEcClusterSetupVerifyResult(MBeanServer mbs) throws Exception {
        ObjectName namenodeMXBeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
        String result = (String)mbs.getAttribute(namenodeMXBeanName, "VerifyECWithTopologyResult");
        ObjectMapper mapper = new ObjectMapper();
        Map resultMap = (Map)mapper.readValue(result, Map.class);
        Boolean isSupported = Boolean.parseBoolean((String)resultMap.get("isSupported"));
        String resultMessage = (String)resultMap.get("resultMessage");
        Assertions.assertFalse((boolean)isSupported, (String)"Test cluster does not support all enabled erasure coding policies.");
        Assertions.assertTrue((boolean)resultMessage.contains("3 racks are required for the erasure coding policies: RS-6-3-1024k. The number of racks is only 1."));
    }

    static {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.NoMlockCacheManipulator());
    }
}

