/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNThroughputBenchmark;
import org.apache.hadoop.util.ExitUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestNNThroughputBenchmark {
    @BeforeAll
    public static void setUp() {
        ExitUtil.disableSystemExit();
    }

    @AfterEach
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testNNThroughput() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 16);
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        NNThroughputBenchmark.runBenchmark((Configuration)conf, new String[]{"-op", "all"});
    }

    @Test
    @Timeout(value=120L)
    public void testNNThroughputWithFsOption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 16);
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        NNThroughputBenchmark.runBenchmark((Configuration)conf, new String[]{"-fs", "file:///", "-op", "all"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNNThroughputAgainstRemoteNN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "all"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNNThroughputAgainstRemoteNNNonSuperUser() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "all", "-nonSuperUser"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNNThroughputRemoteAgainstNNWithFsOption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        conf.setInt("dfs.blocksize", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-fs", cluster.getURI().toString(), "-op", "all"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNNThroughputForAppendOp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-close"});
            FSNamesystem fsNamesystem = cluster.getNamesystem();
            DirectoryListing listing = fsNamesystem.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
            HdfsFileStatus[] partialListing = listing.getPartialListing();
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "append", "-files", "3", "-useExisting"});
            listing = fsNamesystem.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
            HdfsFileStatus[] partialListingAfter = listing.getPartialListing();
            Assertions.assertEquals((int)partialListing.length, (int)partialListingAfter.length);
            for (int i = 0; i < partialListing.length; ++i) {
                Assertions.assertNotEquals((long)partialListing[i].getModificationTime(), (long)partialListingAfter[i].getModificationTime());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=120L)
    public void testNNThroughputForBlockReportOp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        conf.setInt("dfs.blocksize", 16);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();){
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
            benchConf.setInt("dfs.blocksize", 16);
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-fs", cluster.getURI().toString(), "-op", "blockReport", "-datanodes", "3", "-reports", "2"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNNThroughputWithBaseDir() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setInt("dfs.blocksize", 16);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            DistributedFileSystem fs = cluster.getFileSystem();
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-baseDirName", "/nnThroughputBenchmark1", "-close"});
            Assertions.assertTrue((boolean)fs.exists(new Path("/nnThroughputBenchmark1")));
            Assertions.assertFalse((boolean)fs.exists(new Path("/nnThroughputBenchmark")));
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "all", "-baseDirName", "/nnThroughputBenchmark1"});
            Assertions.assertTrue((boolean)fs.exists(new Path("/nnThroughputBenchmark1")));
            Assertions.assertFalse((boolean)fs.exists(new Path("/nnThroughputBenchmark")));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=120L)
    public void testNNThroughputForBlockSizeWithLetterSuffix() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        conf.set("dfs.blocksize", "1m");
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setLong("dfs.namenode.fs-limits.min-block-size", 16L);
            benchConf.set("dfs.blocksize", "1m");
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-close"});
        }
    }

    @Test
    @Timeout(value=120L)
    public void testNNThroughputWithBlockSize() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setLong("dfs.namenode.fs-limits.min-block-size", 16L);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-blockSize", "32", "-close"});
        }
    }

    @Test
    @Timeout(value=120L)
    public void testNNThroughputBlockSizeArgWithLetterSuffix() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();){
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            benchConf.setLong("dfs.namenode.fs-limits.min-block-size", 16L);
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "create", "-keepResults", "-files", "3", "-blockSize", "1m", "-close"});
        }
    }
}

