/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.impl.CorruptFileBlockIterator;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;

public class TestListCorruptFileBlocks {
    static final Logger LOG = NameNode.stateChangeLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testListCorruptFilesCorruptedBlock() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            conf.setInt("dfs.client.retry.window.base", 10);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            int corruptionLength = 2;
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testCorruptFilesCorruptedBlock").setNumFiles(2).setMaxLevels(1).setMinSize(2).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat10");
            NameNode namenode = cluster.getNameNode();
            Collection badFiles = namenode.getNamesystem().listCorruptFileBlocks("/", null);
            Assertions.assertEquals((int)0, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " corrupt files. Expecting None."));
            this.assertCorruptFilesCount(cluster, badFiles.size());
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getInstanceStorageDir(0, 1);
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            Assertions.assertTrue((boolean)data_dir.exists(), (String)"data directory does not exist");
            List<File> metaFiles = MiniDFSCluster.getAllBlockFiles(data_dir);
            Assertions.assertTrue((metaFiles != null && !metaFiles.isEmpty() ? 1 : 0) != 0, (String)"Data directory does not contain any blocks or there was an IO error");
            File metaFile = metaFiles.get(0);
            RandomAccessFile file = new RandomAccessFile(metaFile, "rw");
            FileChannel channel = file.getChannel();
            long position = channel.size() - 2L;
            byte[] buffer = new byte[2];
            new Random(13L).nextBytes(buffer);
            channel.write(ByteBuffer.wrap(buffer), position);
            file.close();
            LOG.info("Deliberately corrupting file " + metaFile.getName() + " at offset " + position + " length " + 2);
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assertions.assertTrue((boolean)false, (String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e));
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assertions.assertEquals((int)1, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."));
            this.assertCorruptFilesCount(cluster, badFiles.size());
            util.cleanup((FileSystem)fs, "/srcdat10");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=300L)
    public void testListCorruptFileBlocksInSafeMode() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            conf.setFloat("dfs.namenode.safemode.threshold-pct", 1.5f);
            conf.setFloat("dfs.namenode.replqueue.threshold-pct", 0.0f);
            conf.setInt("dfs.client.retry.window.base", 10);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).waitSafeMode(false).build();
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            DistributedFileSystem fs = cluster.getFileSystem();
            int corruptionLength = 2;
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testListCorruptFileBlocksInSafeMode").setNumFiles(2).setMaxLevels(1).setMinSize(2).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat10");
            Collection badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            Assertions.assertEquals((int)0, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " corrupt files. Expecting None."));
            this.assertCorruptFilesCount(cluster, badFiles.size());
            File storageDir = cluster.getInstanceStorageDir(0, 0);
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, cluster.getNamesystem().getBlockPoolId());
            Assertions.assertTrue((boolean)data_dir.exists(), (String)"data directory does not exist");
            List<File> metaFiles = MiniDFSCluster.getAllBlockFiles(data_dir);
            Assertions.assertTrue((metaFiles != null && !metaFiles.isEmpty() ? 1 : 0) != 0, (String)"Data directory does not contain any blocks or there was an IO error");
            File metaFile = metaFiles.get(0);
            RandomAccessFile file = new RandomAccessFile(metaFile, "rw");
            FileChannel channel = file.getChannel();
            long position = channel.size() - 2L;
            byte[] buffer = new byte[2];
            new Random(13L).nextBytes(buffer);
            channel.write(ByteBuffer.wrap(buffer), position);
            file.close();
            LOG.info("Deliberately corrupting file " + metaFile.getName() + " at offset " + position + " length " + 2);
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assertions.assertTrue((boolean)false, (String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e));
            }
            badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assertions.assertEquals((int)1, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."));
            this.assertCorruptFilesCount(cluster, badFiles.size());
            cluster.restartNameNode(0);
            fs = cluster.getFileSystem();
            while (!cluster.getNameNode().namesystem.getBlockManager().isPopulatingReplQueues()) {
                try {
                    LOG.info("waiting for replication queues");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            try {
                util.checkFiles((FileSystem)fs, "/srcdat10");
            }
            catch (BlockMissingException e) {
                System.out.println("Received BlockMissingException as expected.");
            }
            catch (IOException e) {
                Assertions.assertTrue((boolean)false, (String)("Corrupted replicas not handled properly. Expecting BlockMissingException  but received IOException " + e));
            }
            badFiles = cluster.getNameNode().getNamesystem().listCorruptFileBlocks("/", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assertions.assertEquals((int)1, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " bad files. Expecting 1."));
            this.assertCorruptFilesCount(cluster, badFiles.size());
            Assertions.assertTrue((boolean)cluster.getNameNode().isInSafeMode(), (String)"Namenode is not in safe mode");
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            util.cleanup((FileSystem)fs, "/srcdat10");
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testlistCorruptFileBlocks() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData");
            NameNode namenode = cluster.getNameNode();
            Collection corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
            int numCorrupt = corruptFileBlocks.size();
            Assertions.assertEquals((int)0, (int)numCorrupt);
            this.assertCorruptFilesCount(cluster, numCorrupt);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                    List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                    if (metadataFiles == null) continue;
                    for (File metadataFile : metadataFiles) {
                        File blockFile = Block.metaToBlockFile((File)metadataFile);
                        LOG.info("Deliberately removing file " + blockFile.getName());
                        Assertions.assertTrue((boolean)blockFile.delete(), (String)"Cannot remove file.");
                        LOG.info("Deliberately removing file " + metadataFile.getName());
                        Assertions.assertTrue((boolean)metadataFile.delete(), (String)"Cannot remove file.");
                    }
                }
            }
            int count = 0;
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
            numCorrupt = corruptFileBlocks.size();
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", null);
                numCorrupt = corruptFileBlocks.size();
                if (++count <= 30) continue;
            }
            LOG.info("Namenode has bad files. " + numCorrupt);
            Assertions.assertEquals((int)3, (int)numCorrupt);
            this.assertCorruptFilesCount(cluster, numCorrupt);
            FSNamesystem.CorruptFileBlockInfo[] cfb = corruptFileBlocks.toArray(new FSNamesystem.CorruptFileBlockInfo[0]);
            String[] cookie = new String[]{"1"};
            Collection nextCorruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", cookie);
            FSNamesystem.CorruptFileBlockInfo[] ncfb = nextCorruptFileBlocks.toArray(new FSNamesystem.CorruptFileBlockInfo[0]);
            numCorrupt = nextCorruptFileBlocks.size();
            Assertions.assertEquals((int)2, (int)numCorrupt);
            Assertions.assertTrue((boolean)ncfb[0].block.getBlockName().equalsIgnoreCase(cfb[1].block.getBlockName()));
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/corruptData", cookie);
            numCorrupt = corruptFileBlocks.size();
            Assertions.assertEquals((int)0, (int)numCorrupt);
            util.createFiles((FileSystem)fs, "/goodData");
            corruptFileBlocks = namenode.getNamesystem().listCorruptFileBlocks("/goodData", null);
            numCorrupt = corruptFileBlocks.size();
            Assertions.assertEquals((int)0, (int)numCorrupt);
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private int countPaths(RemoteIterator<Path> iter) throws IOException {
        int i = 0;
        while (iter.hasNext()) {
            LOG.info("PATH: " + ((Path)iter.next()).toUri().getPath());
            ++i;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testlistCorruptFileBlocksDFS() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "/corruptData");
            RemoteIterator corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
            int numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            Assertions.assertEquals((int)0, (int)numCorrupt);
            this.assertCorruptFilesCount(cluster, numCorrupt);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 2; ++i) {
                File storageDir = cluster.getInstanceStorageDir(0, i);
                File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    LOG.info("Deliberately removing file " + blockFile.getName());
                    Assertions.assertTrue((boolean)blockFile.delete(), (String)"Cannot remove file.");
                    LOG.info("Deliberately removing file " + metadataFile.getName());
                    Assertions.assertTrue((boolean)metadataFile.delete(), (String)"Cannot remove file.");
                }
            }
            int count = 0;
            corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
            numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("/corruptData"));
                numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
                if (++count <= 30) continue;
            }
            LOG.info("Namenode has bad files. " + numCorrupt);
            Assertions.assertEquals((int)3, (int)numCorrupt);
            this.assertCorruptFilesCount(cluster, numCorrupt);
            util.cleanup((FileSystem)fs, "/corruptData");
            util.cleanup((FileSystem)fs, "/goodData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testMaxCorruptFiles() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.blockreport.intervalMsec", 3000);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            int maxCorruptFileBlocks = conf.getInt("dfs.namenode.max-corrupt-file-blocks-returned", 100);
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testMaxCorruptFiles").setNumFiles(maxCorruptFileBlocks * 3).setMaxLevels(1).setMaxSize(512).build();
            util.createFiles((FileSystem)fs, "/srcdat2", (short)1);
            util.waitReplication((FileSystem)fs, "/srcdat2", (short)1);
            NameNode namenode = cluster.getNameNode();
            Collection badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            Assertions.assertEquals((int)0, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " corrupt files. Expecting none."));
            this.assertCorruptFilesCount(cluster, badFiles.size());
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    File storageDir = cluster.getInstanceStorageDir(i, j);
                    File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                    LOG.info("Removing files from " + data_dir);
                    List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                    if (metadataFiles == null) continue;
                    for (File metadataFile : metadataFiles) {
                        File blockFile = Block.metaToBlockFile((File)metadataFile);
                        Assertions.assertTrue((boolean)blockFile.delete(), (String)"Cannot remove file.");
                        Assertions.assertTrue((boolean)metadataFile.delete(), (String)"Cannot remove file.");
                    }
                }
            }
            DataNode dn = cluster.getDataNodes().get(0);
            DataNodeTestUtils.runDirectoryScanner(dn);
            LOG.info("Restarting Datanode to trigger BlockPoolSliceScanner");
            cluster.restartDataNodes();
            cluster.waitActive();
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            while (badFiles.size() < maxCorruptFileBlocks) {
                LOG.info("# of corrupt files is: " + badFiles.size());
                Thread.sleep(10000L);
                badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            }
            badFiles = namenode.getNamesystem().listCorruptFileBlocks("/srcdat2", null);
            LOG.info("Namenode has bad files. " + badFiles.size());
            Assertions.assertEquals((int)maxCorruptFileBlocks, (int)badFiles.size(), (String)("Namenode has " + badFiles.size() + " bad files. Expecting " + maxCorruptFileBlocks + "."));
            CorruptFileBlockIterator iter = (CorruptFileBlockIterator)fs.listCorruptFileBlocks(new Path("/srcdat2"));
            int corruptPaths = this.countPaths((RemoteIterator<Path>)iter);
            Assertions.assertTrue((corruptPaths > maxCorruptFileBlocks ? 1 : 0) != 0, (String)("Expected more than " + maxCorruptFileBlocks + " corrupt file blocks but got " + corruptPaths));
            Assertions.assertTrue((iter.getCallsMade() > 1 ? 1 : 0) != 0, (String)("Iterator should have made more than 1 call but made " + iter.getCallsMade()));
            util.cleanup((FileSystem)fs, "/srcdat2");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testListCorruptFileBlocksOnRelativePath() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.datanode.directoryscan.interval", 1);
        MiniDFSCluster cluster = null;
        try {
            DistributedFileSystem fs;
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            DistributedFileSystem dfs = fs = cluster.getFileSystem();
            Path baseDir = new Path("/somewhere/base");
            fs.mkdirs(baseDir);
            fs.setWorkingDirectory(baseDir);
            DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFilesOnRelativePath").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
            util.createFiles((FileSystem)fs, "corruptData");
            RemoteIterator corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("corruptData"));
            int numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            Assertions.assertEquals((int)0, (int)numCorrupt);
            this.assertCorruptFilesCount(cluster, numCorrupt);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            for (int i = 0; i < 2; ++i) {
                File storageDir = cluster.getInstanceStorageDir(0, i);
                File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(data_dir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    LOG.info("Deliberately removing file " + blockFile.getName());
                    Assertions.assertTrue((boolean)blockFile.delete(), (String)"Cannot remove file.");
                    LOG.info("Deliberately removing file " + metadataFile.getName());
                    Assertions.assertTrue((boolean)metadataFile.delete(), (String)"Cannot remove file.");
                }
            }
            int count = 0;
            corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("corruptData"));
            numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
            while (numCorrupt < 3) {
                Thread.sleep(1000L);
                corruptFileBlocks = dfs.listCorruptFileBlocks(new Path("corruptData"));
                numCorrupt = this.countPaths((RemoteIterator<Path>)corruptFileBlocks);
                if (++count <= 30) continue;
            }
            LOG.info("Namenode has bad files. " + numCorrupt);
            Assertions.assertEquals((int)3, (int)numCorrupt, (String)"Failed to get corrupt files!");
            util.cleanup((FileSystem)fs, "corruptData");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void assertCorruptFilesCount(MiniDFSCluster cluster, int expectedCorrupt) {
        FSNamesystem fs = cluster.getNameNode().getNamesystem();
        Assertions.assertEquals((int)expectedCorrupt, (int)fs.getCorruptFilesCount(), (String)"Incorrect number of corrupt files returned");
    }
}

