/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.util.Lists;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=300L)
public class TestLeaseManager {
    public static long maxLockHoldToReleaseLeaseMs = 100L;

    @Test
    public void testRemoveLeases() throws Exception {
        long id;
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        LeaseManager lm = new LeaseManager(fsn);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{16386L, 16387L, 16388L, 16389L});
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            lm.addLease("foo", id);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)lm.getINodeIdWithLeases().size());
        iterator = ids.iterator();
        while (iterator.hasNext()) {
            id = (Long)iterator.next();
            lm.removeLease(id);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)lm.getINodeIdWithLeases().size());
    }

    @Test
    public void testCheckLease() throws InterruptedException {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        long numLease = 100L;
        long expiryTime = 0L;
        long waitTime = 1L;
        lm.setLeasePeriod(0L, 0L);
        for (long i = 0L; i <= 99L; ++i) {
            lm.addLease("holder" + i, 16385L + i);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)100L, (long)lm.countLease());
        Thread.sleep(1L);
        lm.checkLeases();
        org.junit.jupiter.api.Assertions.assertTrue(((long)lm.countLease() < 100L ? 1 : 0) != 0);
    }

    @Test
    public void testInternalLeaseHolder() throws Exception {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        lm.setLeasePeriod(100L, 500L);
        String holder = lm.getInternalLeaseHolder();
        Thread.sleep(1000L);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)holder, (Object)lm.getInternalLeaseHolder());
    }

    @Test
    public void testCountPath() {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        lm.addLease("holder1", 1L);
        Assertions.assertThat((long)lm.countPath()).isEqualTo(1L);
        lm.addLease("holder2", 2L);
        Assertions.assertThat((long)lm.countPath()).isEqualTo(2L);
        lm.addLease("holder2", 2L);
        Assertions.assertThat((long)lm.countPath()).isEqualTo(2L);
        Assertions.assertThat((long)lm.countPath()).isEqualTo(2L);
        lm.removeLease("holder2", TestLeaseManager.stubInodeFile(3L));
        lm.removeLease("InvalidLeaseHolder", TestLeaseManager.stubInodeFile(1L));
        Assertions.assertThat((long)lm.countPath()).isEqualTo(2L);
        INodeFile file = TestLeaseManager.stubInodeFile(1L);
        lm.reassignLease(lm.getLease(file), file, "holder2");
        Assertions.assertThat((long)lm.countPath()).isEqualTo(2L);
        lm.removeLease("holder2", TestLeaseManager.stubInodeFile(2L));
        Assertions.assertThat((long)lm.countPath()).isEqualTo(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseRestorationOnRestart() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(1).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String path = "/testLeaseRestorationOnRestart";
            FSDataOutputStream out = dfs.create(new Path(path));
            FSDirectory dir = cluster.getNamesystem().getFSDirectory();
            INodeFile file = dir.getINode(path).asFile();
            cluster.getNamesystem().leaseManager.removeLease(file.getFileUnderConstructionFeature().getClientName(), file);
            dfs.setSafeMode(SafeModeAction.ENTER);
            cluster.getNameNodeRpc().saveNamespace(0L, 0L);
            dfs.setSafeMode(SafeModeAction.LEAVE);
            cluster.restartNameNode(true);
            dir = cluster.getNamesystem().getFSDirectory();
            file = dir.getINode(path).asFile();
            org.junit.jupiter.api.Assertions.assertTrue((cluster.getNamesystem().leaseManager.getLease(file) != null ? 1 : 0) != 0, (String)"Lease should exist.");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    @Timeout(value=60L)
    public void testInodeWithLeases() throws Exception {
        FSNamesystem fsNamesystem = TestLeaseManager.makeMockFsNameSystem();
        Mockito.when((Object)fsNamesystem.getMaxListOpenFilesResponses()).thenReturn((Object)1024);
        FSDirectory fsDirectory = fsNamesystem.getFSDirectory();
        LeaseManager lm = new LeaseManager(fsNamesystem);
        HashSet<Long> iNodeIds = new HashSet<Long>(Arrays.asList(16386L, 16387L, 16388L, 16389L));
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)493));
        INodeDirectory rootInodeDirectory = new INodeDirectory(0L, DFSUtil.string2Bytes((String)""), perm, 0L);
        Mockito.when((Object)fsDirectory.getRoot()).thenReturn((Object)rootInodeDirectory);
        this.verifyINodeLeaseCounts(fsNamesystem, lm, rootInodeDirectory, 0, 0, 0);
        for (Long iNodeId : iNodeIds) {
            INodeFile iNodeFile = TestLeaseManager.stubInodeFile(iNodeId);
            iNodeFile.toUnderConstruction("hbase", "gce-100");
            iNodeFile.setParent(rootInodeDirectory);
            Mockito.when((Object)fsDirectory.getInode(iNodeId.longValue())).thenReturn((Object)iNodeFile);
            lm.addLease("holder_" + iNodeId, iNodeId.longValue());
        }
        this.verifyINodeLeaseCounts(fsNamesystem, lm, rootInodeDirectory, iNodeIds.size(), iNodeIds.size(), iNodeIds.size());
        for (Long iNodeId : iNodeIds) {
            lm.removeLease(iNodeId.longValue());
        }
        this.verifyINodeLeaseCounts(fsNamesystem, lm, rootInodeDirectory, 0, 0, 0);
    }

    @Test
    @Timeout(value=240L)
    public void testInodeWithLeasesAtScale() throws Exception {
        FSNamesystem fsNamesystem = TestLeaseManager.makeMockFsNameSystem();
        Mockito.when((Object)fsNamesystem.getMaxListOpenFilesResponses()).thenReturn((Object)4096);
        FSDirectory fsDirectory = fsNamesystem.getFSDirectory();
        LeaseManager lm = new LeaseManager(fsNamesystem);
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)493));
        INodeDirectory rootInodeDirectory = new INodeDirectory(0L, DFSUtil.string2Bytes((String)""), perm, 0L);
        Mockito.when((Object)fsDirectory.getRoot()).thenReturn((Object)rootInodeDirectory);
        int scale = 0;
        this.testInodeWithLeasesAtScaleImpl(fsNamesystem, lm, fsDirectory, rootInodeDirectory, scale);
        for (int workerCount = 1; workerCount <= 2; ++workerCount) {
            scale = workerCount * 512 / 2;
            this.testInodeWithLeasesAtScaleImpl(fsNamesystem, lm, fsDirectory, rootInodeDirectory, scale);
            scale = workerCount * 512 - 1;
            this.testInodeWithLeasesAtScaleImpl(fsNamesystem, lm, fsDirectory, rootInodeDirectory, scale);
            scale = workerCount * 512;
            this.testInodeWithLeasesAtScaleImpl(fsNamesystem, lm, fsDirectory, rootInodeDirectory, scale);
            scale = workerCount * 512 + 1;
            this.testInodeWithLeasesAtScaleImpl(fsNamesystem, lm, fsDirectory, rootInodeDirectory, scale);
        }
        scale = 1279;
        this.testInodeWithLeasesAtScaleImpl(fsNamesystem, lm, fsDirectory, rootInodeDirectory, scale);
    }

    private void testInodeWithLeasesAtScaleImpl(FSNamesystem fsNamesystem, LeaseManager leaseManager, FSDirectory fsDirectory, INodeDirectory ancestorDirectory, int scale) throws IOException {
        this.verifyINodeLeaseCounts(fsNamesystem, leaseManager, ancestorDirectory, 0, 0, 0);
        HashSet<Long> iNodeIds = new HashSet<Long>();
        for (int i = 0; i < scale; ++i) {
            iNodeIds.add(16385L + (long)i);
        }
        for (Long iNodeId : iNodeIds) {
            INodeFile iNodeFile = TestLeaseManager.stubInodeFile(iNodeId);
            iNodeFile.toUnderConstruction("hbase", "gce-100");
            iNodeFile.setParent(ancestorDirectory);
            Mockito.when((Object)fsDirectory.getInode(iNodeId.longValue())).thenReturn((Object)iNodeFile);
            leaseManager.addLease("holder_" + iNodeId, iNodeId.longValue());
        }
        this.verifyINodeLeaseCounts(fsNamesystem, leaseManager, ancestorDirectory, iNodeIds.size(), iNodeIds.size(), iNodeIds.size());
        leaseManager.removeAllLeases();
        this.verifyINodeLeaseCounts(fsNamesystem, leaseManager, ancestorDirectory, 0, 0, 0);
    }

    @Test
    @Timeout(value=60L)
    public void testInodeWithLeasesForAncestorDir() throws Exception {
        FSNamesystem fsNamesystem = TestLeaseManager.makeMockFsNameSystem();
        FSDirectory fsDirectory = fsNamesystem.getFSDirectory();
        LeaseManager lm = new LeaseManager(fsNamesystem);
        PermissionStatus perm = PermissionStatus.createImmutable((String)"user", (String)"group", (FsPermission)FsPermission.createImmutable((short)493));
        INodeDirectory rootInodeDirectory = new INodeDirectory(0L, DFSUtil.string2Bytes((String)""), perm, 0L);
        Mockito.when((Object)fsDirectory.getRoot()).thenReturn((Object)rootInodeDirectory);
        AtomicInteger inodeIds = new AtomicInteger(1234);
        String[] pathTree = new String[]{"/root.log", "/ENG/a/a1.log", "/ENG/a/b/b1.log", "/ENG/a/b/c/c1.log", "/ENG/a/b/c/c2.log", "/OPS/m/m1.log", "/OPS/m/n/n1.log", "/OPS/m/n/n2.log"};
        Map<String, INode> pathINodeMap = this.createINodeTree(rootInodeDirectory, pathTree, inodeIds);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)lm.getINodeIdWithLeases().size());
        for (Map.Entry<String, INode> entry : pathINodeMap.entrySet()) {
            long iNodeId = entry.getValue().getId();
            Mockito.when((Object)fsDirectory.getInode(iNodeId)).thenReturn((Object)entry.getValue());
            if (!entry.getKey().contains("log")) continue;
            lm.addLease("holder_" + iNodeId, iNodeId);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)pathTree.length, (int)lm.getINodeIdWithLeases().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)pathTree.length, (int)lm.getINodeWithLeases().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)pathTree.length, (int)lm.getINodeWithLeases(rootInodeDirectory).size());
        lm.removeAllLeases();
        HashSet<String> filesLeased = new HashSet<String>(Arrays.asList("root.log", "a1.log", "c1.log", "n2.log"));
        for (String fileName : filesLeased) {
            lm.addLease("holder", pathINodeMap.get(fileName).getId());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)filesLeased.size(), (int)lm.getINodeIdWithLeases().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)filesLeased.size(), (int)lm.getINodeWithLeases().size());
        Set set = lm.getINodeWithLeases();
        for (INodesInPath iNodesInPath : set) {
            String leasedFileName = DFSUtil.bytes2String((byte[])iNodesInPath.getLastLocalName());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)filesLeased.contains(leasedFileName));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)filesLeased.size(), (int)lm.getINodeWithLeases(rootInodeDirectory).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 2), (int)lm.getINodeWithLeases(pathINodeMap.get("ENG").asDirectory()).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 2), (int)lm.getINodeWithLeases(pathINodeMap.get("a").asDirectory()).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 3), (int)lm.getINodeWithLeases(pathINodeMap.get("c").asDirectory()).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 3), (int)lm.getINodeWithLeases(pathINodeMap.get("OPS").asDirectory()).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 3), (int)lm.getINodeWithLeases(pathINodeMap.get("n").asDirectory()).size());
        lm.removeLease(pathINodeMap.get("n2.log").getId());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 1), (int)lm.getINodeWithLeases(rootInodeDirectory).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(filesLeased.size() - 4), (int)lm.getINodeWithLeases(pathINodeMap.get("n").asDirectory()).size());
        lm.removeAllLeases();
        filesLeased.clear();
        org.junit.jupiter.api.Assertions.assertEquals((int)filesLeased.size(), (int)lm.getINodeWithLeases(rootInodeDirectory).size());
    }

    private void verifyINodeLeaseCounts(FSNamesystem fsNamesystem, LeaseManager leaseManager, INodeDirectory ancestorDirectory, int iNodeIdWithLeaseCount, int iNodeWithLeaseCount, int iNodeUnderAncestorLeaseCount) throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((int)iNodeIdWithLeaseCount, (int)leaseManager.getINodeIdWithLeases().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)iNodeWithLeaseCount, (int)leaseManager.getINodeWithLeases().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)iNodeUnderAncestorLeaseCount, (int)leaseManager.getINodeWithLeases(ancestorDirectory).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)iNodeIdWithLeaseCount, (int)leaseManager.getUnderConstructionFiles(0L).size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(fsNamesystem.getFilesBlockingDecom(0L, "/") == null ? 0 : fsNamesystem.getFilesBlockingDecom(0L, "/").size()));
    }

    private Map<String, INode> createINodeTree(INodeDirectory parentDir, String[] pathTree, AtomicInteger inodeId) throws QuotaExceededException {
        HashMap<String, INode> pathINodeMap = new HashMap<String, INode>();
        for (String path : pathTree) {
            byte[][] components = INode.getPathComponents((String)path);
            FsPermission perm = FsPermission.createImmutable((short)493);
            PermissionStatus permStatus = PermissionStatus.createImmutable((String)"", (String)"", (FsPermission)perm);
            INodeDirectory prev = parentDir;
            INodeDirectory dir = null;
            for (int i = 0; i < components.length - 1; ++i) {
                byte[] component = components[i];
                if (component.length == 0) continue;
                INode existingChild = prev.getChild(component, 0x7FFFFFFE);
                if (existingChild == null) {
                    String dirName = DFSUtil.bytes2String((byte[])component);
                    dir = new INodeDirectory((long)inodeId.incrementAndGet(), component, permStatus, 0L);
                    prev.addChild((INode)dir, false, 0x7FFFFFFE);
                    pathINodeMap.put(dirName, (INode)dir);
                    prev = dir;
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)existingChild.isDirectory());
                prev = existingChild.asDirectory();
            }
            PermissionStatus p = new PermissionStatus("user", "group", new FsPermission(511));
            byte[] fileNameBytes = components[components.length - 1];
            String fileName = DFSUtil.bytes2String((byte[])fileNameBytes);
            INodeFile iNodeFile = new INodeFile((long)inodeId.incrementAndGet(), fileNameBytes, p, 0L, 0L, BlockInfo.EMPTY_ARRAY, 1, 1L);
            iNodeFile.setParent(prev);
            pathINodeMap.put(fileName, (INode)iNodeFile);
        }
        return pathINodeMap;
    }

    private static FSNamesystem makeMockFsNameSystem() {
        FSDirectory dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasReadLock()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasReadLock(RwLockMode.FS)).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasWriteLock(RwLockMode.FS)).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasReadLock(RwLockMode.GLOBAL)).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasWriteLock(RwLockMode.GLOBAL)).thenReturn((Object)true);
        Mockito.when((Object)fsn.getFSDirectory()).thenReturn((Object)dir);
        Mockito.when((Object)fsn.getMaxLockHoldToReleaseLeaseMs()).thenReturn((Object)maxLockHoldToReleaseLeaseMs);
        return fsn;
    }

    private static INodeFile stubInodeFile(long inodeId) {
        PermissionStatus p = new PermissionStatus("dummy", "dummy", new FsPermission(511));
        return new INodeFile(inodeId, new String("foo-" + inodeId).getBytes(), p, 0L, 0L, BlockInfo.EMPTY_ARRAY, 1, 1L);
    }
}

