/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLargeDirectoryDelete {
    private static final Logger LOG = LoggerFactory.getLogger(TestLargeDirectoryDelete.class);
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int TOTAL_BLOCKS = 10000;
    private MiniDFSCluster mc = null;
    private int createOps = 0;
    private int lockOps = 0;

    private void createFile(String fileName, long filelen) throws IOException {
        DistributedFileSystem fs = this.mc.getFileSystem();
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile((FileSystem)fs, filePath, filelen, (short)1, 0L);
    }

    private void createFiles() throws IOException {
        Random rand = new Random();
        for (int i = 0; i < 10000; i += 100) {
            String filename = "/root/";
            int dirs = rand.nextInt(10);
            for (int j = i; j >= i - dirs; --j) {
                filename = filename + j + "/";
            }
            filename = filename + "file" + i;
            this.createFile(filename, 100L);
        }
    }

    private int getBlockCount() {
        Assertions.assertNotNull((Object)this.mc, (String)"Null cluster");
        Assertions.assertNotNull((Object)this.mc.getNameNode(), (String)"No Namenode in cluster");
        FSNamesystem namesystem = this.mc.getNamesystem();
        Assertions.assertNotNull((Object)namesystem, (String)"Null Namesystem in cluster");
        Assertions.assertNotNull((Object)namesystem.getBlockManager(), (String)"Null Namesystem.blockmanager");
        return (int)namesystem.getBlocksTotal();
    }

    private void runThreads() throws Throwable {
        TestThread[] threads = new TestThread[]{new TestThread(){

            @Override
            protected void execute() throws Throwable {
                while (this.live) {
                    try {
                        int blockcount = TestLargeDirectoryDelete.this.getBlockCount();
                        if (blockcount >= 10000 || blockcount <= 0) continue;
                        String file = "/tmp" + TestLargeDirectoryDelete.this.createOps;
                        TestLargeDirectoryDelete.this.createFile(file, 1L);
                        TestLargeDirectoryDelete.this.mc.getFileSystem().delete(new Path(file), true);
                        TestLargeDirectoryDelete.this.createOps++;
                    }
                    catch (IOException ex) {
                        LOG.info("createFile exception ", (Throwable)ex);
                        break;
                    }
                }
            }
        }, new TestThread(){

            @Override
            protected void execute() throws Throwable {
                while (this.live) {
                    try {
                        int blockcount = TestLargeDirectoryDelete.this.getBlockCount();
                        if (blockcount >= 10000 || blockcount <= 0) continue;
                        TestLargeDirectoryDelete.this.mc.getNamesystem().writeLock(RwLockMode.GLOBAL);
                        try {
                            TestLargeDirectoryDelete.this.lockOps++;
                        }
                        finally {
                            TestLargeDirectoryDelete.this.mc.getNamesystem().writeUnlock(RwLockMode.GLOBAL, "runThreads");
                        }
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        LOG.info("lockOperation exception ", (Throwable)ex);
                        break;
                    }
                }
            }
        }};
        threads[0].start();
        threads[1].start();
        long start = Time.now();
        this.mc.getFileSystem().delete(new Path("/root"), true);
        BlockManagerTestUtil.waitForMarkedDeleteQueueIsEmpty(this.mc.getNamesystem(0).getBlockManager());
        long end = Time.now();
        threads[0].endThread();
        threads[1].endThread();
        LOG.info("Deletion took " + (end - start) + "msecs");
        LOG.info("createOperations " + this.createOps);
        LOG.info("lockOperations " + this.lockOps);
        Assertions.assertTrue((this.lockOps + this.createOps > 0 ? 1 : 0) != 0);
        threads[0].rethrow();
        threads[1].rethrow();
    }

    @Test
    public void largeDelete() throws Throwable {
        this.mc = new MiniDFSCluster.Builder(CONF).build();
        try {
            this.mc.waitActive();
            Assertions.assertNotNull((Object)this.mc.getNameNode(), (String)"No Namenode in cluster");
            this.createFiles();
            Assertions.assertEquals((int)10000, (int)this.getBlockCount());
            this.runThreads();
        }
        finally {
            this.mc.shutdown();
        }
    }

    static {
        CONF.setLong("dfs.blocksize", 1L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
    }

    private abstract class TestThread
    extends Thread {
        volatile Throwable thrown;
        protected volatile boolean live = true;

        private TestThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                LOG.warn("{}", throwable);
                this.setThrown(throwable);
            }
            finally {
                TestThread testThread = this;
                synchronized (testThread) {
                    this.notify();
                }
            }
        }

        protected abstract void execute() throws Throwable;

        protected synchronized void setThrown(Throwable thrown) {
            this.thrown = thrown;
        }

        public synchronized void rethrow() throws Throwable {
            if (this.thrown != null) {
                throw this.thrown;
            }
        }

        public synchronized void endThread() {
            block2: {
                this.live = false;
                this.interrupt();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("Ignoring " + e, (Throwable)e);
                }
            }
        }
    }
}

