/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.namenode.TestFsck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFsckWithMultipleNameNodes {
    static final Logger LOG = LoggerFactory.getLogger(TestFsckWithMultipleNameNodes.class);
    private static final String FILE_NAME = "/tmp.txt";
    private static final Path FILE_PATH = new Path("/tmp.txt");
    private static final Random RANDOM = new Random();

    public TestFsckWithMultipleNameNodes() {
        DFSTestUtil.setNameNodeLogLevel(Level.TRACE);
    }

    private static Configuration createConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.accesstime.precision", 1L);
        conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(int nNameNodes, int nDataNodes, Configuration conf) throws Exception {
        LOG.info("nNameNodes=" + nNameNodes + ", nDataNodes=" + nDataNodes);
        LOG.info("RUN_TEST -1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(nNameNodes)).numDataNodes(nDataNodes).build();
        LOG.info("RUN_TEST 0");
        DFSTestUtil.setFederatedConfiguration(cluster, conf);
        try {
            int i;
            cluster.waitActive();
            LOG.info("RUN_TEST 1");
            Suite s = new Suite(cluster, nNameNodes, nDataNodes);
            for (int i2 = 0; i2 < nNameNodes; ++i2) {
                s.createFile(i2, 1024L);
            }
            LOG.info("RUN_TEST 2");
            String[] urls = new String[nNameNodes];
            for (int i3 = 0; i3 < urls.length; ++i3) {
                urls[i3] = cluster.getFileSystem(i3).getUri() + FILE_NAME;
                LOG.info("urls[" + i3 + "]=" + urls[i3]);
                String result = TestFsck.runFsck(conf, 0, false, urls[i3]);
                LOG.info("result=" + result);
                Assertions.assertTrue((boolean)result.contains("Status: HEALTHY"));
            }
            LOG.info("RUN_TEST 3");
            String[] vurls = new String[nNameNodes];
            for (i = 0; i < vurls.length; ++i) {
                String link = "/mount/nn_" + i + FILE_NAME;
                ConfigUtil.addLink((Configuration)conf, (String)link, (URI)new URI(urls[i]));
                vurls[i] = "viewfs:" + link;
            }
            for (i = 0; i < vurls.length; ++i) {
                LOG.info("vurls[" + i + "]=" + vurls[i]);
                String result = TestFsck.runFsck(conf, 0, false, vurls[i]);
                LOG.info("result=" + result);
                Assertions.assertTrue((boolean)result.contains("Status: HEALTHY"));
            }
        }
        finally {
            cluster.shutdown();
        }
        LOG.info("RUN_TEST 6");
    }

    @Test
    public void testFsck() throws Exception {
        Configuration conf = TestFsckWithMultipleNameNodes.createConf();
        this.runTest(3, 1, conf);
    }

    static {
        TestBalancer.initTestSetup();
    }

    private static class Suite {
        final MiniDFSCluster cluster;
        final ClientProtocol[] clients;
        final short replication;

        Suite(MiniDFSCluster cluster, int nNameNodes, int nDataNodes) throws IOException {
            this.cluster = cluster;
            this.clients = new ClientProtocol[nNameNodes];
            for (int i = 0; i < nNameNodes; ++i) {
                this.clients[i] = cluster.getNameNode(i).getRpcServer();
            }
            this.replication = (short)Math.max(1, nDataNodes - 1);
        }

        private void createFile(int index, long len) throws IOException, InterruptedException, TimeoutException {
            DistributedFileSystem fs = this.cluster.getFileSystem(index);
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, len, this.replication, RANDOM.nextLong());
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, this.replication);
        }
    }
}

