/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NamenodeFsck;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFsck {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestFsck.class.getName());
    static final Pattern FSCK_PATTERN = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=fsck\\ssrc=\\/\\sdst=null\\sperm=null\\sproto=.*");
    static final Pattern GET_FILE_INFO_PATTERN = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=getfileinfo\\ssrc=\\/\\sdst=null\\sperm=null\\sproto=.*");
    static final Pattern NUM_MISSING_BLOCKS_PATTERN = Pattern.compile(".*Missing blocks:\t\t([0123456789]*).*");
    static final Pattern NUM_CORRUPT_BLOCKS_PATTERN = Pattern.compile(".*Corrupt blocks:\t\t([0123456789]*).*");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static GenericTestUtils.LogCapturer auditLogCapture;
    @TempDir
    Path baseDir;
    private MiniDFSCluster cluster = null;
    private Configuration conf = null;

    public static String runFsck(Configuration conf, int expectedErrCode, boolean checkErrorCode, String ... path) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        GenericTestUtils.setLogLevel((Logger)FSPermissionChecker.LOG, (Level)Level.TRACE);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])path);
        LOG.info("OUTPUT = " + bStream.toString());
        if (checkErrorCode) {
            Assertions.assertEquals((int)expectedErrCode, (int)errCode);
        }
        GenericTestUtils.setLogLevel((Logger)FSPermissionChecker.LOG, (Level)Level.INFO);
        return bStream.toString();
    }

    @BeforeAll
    public static void beforeClass() {
        auditLogCapture = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
    }

    @AfterAll
    public static void afterClass() {
        auditLogCapture.stopCapturing();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setBoolean("dfs.namenode.corrupt.block.delete.immediately.enabled", false);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.shutdownCluster();
    }

    private void shutdownCluster() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFsck() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(20).build();
        DistributedFileSystem fs = null;
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        fs = this.cluster.getFileSystem();
        String fileName = "/srcdat";
        util.createFiles((FileSystem)fs, "/srcdat");
        util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
        org.apache.hadoop.fs.Path file = new org.apache.hadoop.fs.Path("/srcdat");
        long aTime = fs.getFileStatus(file).getAccessTime();
        Thread.sleep(1L);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        this.verifyAuditLogs();
        Assertions.assertEquals((long)aTime, (long)fs.getFileStatus(file).getAccessTime());
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        this.shutdownCluster();
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(0).format(false).build();
        outStr = TestFsck.runFsck(this.conf, 1, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        System.out.println(outStr);
        this.cluster.startDataNodes(this.conf, 4, true, null, null);
        this.cluster.waitActive();
        this.cluster.waitClusterUp();
        fs = this.cluster.getFileSystem();
        util.cleanup((FileSystem)fs, "/srcdat");
    }

    private void verifyAuditLogs() {
        String[] auditLogOutputLines = auditLogCapture.getOutput().split("\\n");
        int fileStatusSuccess = 0;
        int fsckCount = 0;
        for (String auditLogLine : auditLogOutputLines) {
            if (!auditLogLine.contains("allowed=")) continue;
            String extractedAuditLog = "allowed=" + auditLogLine.split("allowed=")[1];
            LOG.info("Line: {}", (Object)extractedAuditLog);
            if (extractedAuditLog.contains("cmd=getfileinfo") && GET_FILE_INFO_PATTERN.matcher(extractedAuditLog).matches()) {
                ++fileStatusSuccess;
                continue;
            }
            if (!FSCK_PATTERN.matcher(extractedAuditLog).matches()) continue;
            ++fsckCount;
        }
        if (fileStatusSuccess < 2) {
            throw new AssertionError((Object)("getfileinfo cmd should occur at least 2 times. Actual count: " + fileStatusSuccess));
        }
        if (fsckCount < 1) {
            throw new AssertionError((Object)("fsck should be present at least once. Actual count: " + fsckCount));
        }
    }

    @Test
    public void testFsckNonExistent() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(20).build();
        DistributedFileSystem fs = null;
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        fs = this.cluster.getFileSystem();
        util.createFiles((FileSystem)fs, "/srcdat");
        util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/non-existent");
        Assertions.assertEquals((int)-1, (int)outStr.indexOf("is HEALTHY"));
        System.out.println(outStr);
        util.cleanup((FileSystem)fs, "/srcdat");
    }

    @Test
    public void testFsckPermission() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(20).build();
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        MiniDFSCluster c2 = this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        String dir = "/dfsck";
        org.apache.hadoop.fs.Path dirpath = new org.apache.hadoop.fs.Path("/dfsck");
        DistributedFileSystem fs = c2.getFileSystem();
        util.createFiles((FileSystem)fs, "/dfsck");
        util.waitReplication((FileSystem)fs, "/dfsck", (short)3);
        fs.setPermission(dirpath, new FsPermission(448));
        UserGroupInformation fakeUGI = UserGroupInformation.createUserForTesting((String)"ProbablyNotARealUserName", (String[])new String[]{"ShangriLa"});
        fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                System.out.println(TestFsck.runFsck(TestFsck.this.conf, -1, true, "/dfsck"));
                return null;
            }
        });
        fs.setPermission(dirpath, new FsPermission(511));
        fakeUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                String outStr = TestFsck.runFsck(TestFsck.this.conf, 0, true, "/dfsck");
                System.out.println(outStr);
                Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
                return null;
            }
        });
        util.cleanup((FileSystem)fs, "/dfsck");
    }

    @Test
    public void testFsckMove() throws Exception {
        String numCorrupt;
        int dfsBlockSize = 1024;
        int numDatanodes = 4;
        this.conf.setLong("dfs.blocksize", 1024L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DFSTestUtil util = new DFSTestUtil("TestFsck", 5, 3, 6143, 5120);
        DistributedFileSystem fs = null;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        String topDir = "/srcdat";
        fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        util.createFiles((FileSystem)fs, topDir);
        util.waitReplication((FileSystem)fs, topDir, (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        String[] fileNames = util.getFileNames(topDir);
        CorruptedTestFile[] ctFiles = new CorruptedTestFile[]{new CorruptedTestFile(fileNames[0], new HashSet<Integer>(Arrays.asList(0)), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[1], new HashSet<Integer>(Arrays.asList(2, 3)), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[2], new HashSet<Integer>(Arrays.asList(4)), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[3], new HashSet<Integer>(Arrays.asList(0, 1, 2, 3)), dfsClient, 4, 1024), new CorruptedTestFile(fileNames[4], new HashSet<Integer>(Arrays.asList(1, 2, 3, 4)), dfsClient, 4, 1024)};
        int totalMissingBlocks = 0;
        for (CorruptedTestFile ctFile : ctFiles) {
            totalMissingBlocks += ctFile.getTotalMissingBlocks();
        }
        for (CorruptedTestFile ctFile : ctFiles) {
            ctFile.removeBlocks(this.cluster);
        }
        while (true) {
            outStr = TestFsck.runFsck(this.conf, 1, false, "/");
            String numMissing = null;
            numCorrupt = null;
            for (String line : outStr.split(LINE_SEPARATOR)) {
                Matcher m = NUM_MISSING_BLOCKS_PATTERN.matcher(line);
                if (m.matches()) {
                    numMissing = m.group(1);
                }
                if ((m = NUM_CORRUPT_BLOCKS_PATTERN.matcher(line)).matches()) {
                    numCorrupt = m.group(1);
                }
                if (numMissing != null && numCorrupt != null) break;
            }
            if (numMissing == null || numCorrupt == null) {
                throw new IOException("failed to find number of missing or corrupt blocks in fsck output.");
            }
            if (numMissing.equals(Integer.toString(totalMissingBlocks))) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assertions.assertTrue((boolean)numCorrupt.equals(Integer.toString(0)));
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        outStr = TestFsck.runFsck(this.conf, 1, false, "/", "-move");
        LOG.info("WATERMELON: outStr = " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        for (CorruptedTestFile ctFile : ctFiles) {
            ctFile.checkSalvagedRemains();
        }
        outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-delete");
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testFsckMoveAndDelete() throws Exception {
        int i2;
        int maxMoveTries = 5;
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsckMoveAndDelete").setNumFiles(5).build();
        DistributedFileSystem fs = null;
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        String topDir = "/srcdat";
        fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        util.createFiles((FileSystem)fs, topDir);
        util.waitReplication((FileSystem)fs, topDir, (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        String[] fileNames = util.getFileNames(topDir);
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        String corruptFileName = fileNames[0];
        ExtendedBlock block = dfsClient.getNamenode().getBlockLocations(corruptFileName, 0L, Long.MAX_VALUE).get(0).getBlock();
        for (i2 = 0; i2 < 4; ++i2) {
            File blockFile = this.cluster.getBlockFile(i2, block);
            if (blockFile == null || !blockFile.exists()) continue;
            Assertions.assertTrue((boolean)blockFile.delete());
        }
        outStr = TestFsck.runFsck(this.conf, 1, false, "/");
        while (!outStr.contains("is CORRUPT")) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
            outStr = TestFsck.runFsck(this.conf, 1, false, "/");
        }
        for (i2 = 0; i2 < 5; ++i2) {
            outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-move");
            Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
            String[] newFileNames = util.getFileNames(topDir);
            boolean found = false;
            for (String f : newFileNames) {
                if (!f.equals(corruptFileName)) continue;
                found = true;
                break;
            }
            Assertions.assertTrue((boolean)found);
        }
        outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-move", "-delete");
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testFsckOpenFiles() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setNumFiles(4).build();
        DistributedFileSystem fs = null;
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        String topDir = "/srcdat";
        String randomString = "HADOOP  ";
        fs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        util.createFiles((FileSystem)fs, topDir);
        util.waitReplication((FileSystem)fs, topDir, (short)3);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        org.apache.hadoop.fs.Path openFile = new org.apache.hadoop.fs.Path(topDir + "/openFile");
        FSDataOutputStream out = fs.create(openFile);
        for (int writeCount = 0; writeCount != 100; ++writeCount) {
            out.write(randomString.getBytes());
        }
        ((DFSOutputStream)out.getWrappedStream()).hflush();
        outStr = TestFsck.runFsck(this.conf, 0, true, topDir);
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
        outStr = TestFsck.runFsck(this.conf, 0, true, topDir, "-files", "-blocks", "-locations", "-openforwrite");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
        Assertions.assertTrue((boolean)outStr.contains("Under Construction Block:"));
        Assertions.assertTrue((boolean)outStr.contains("openFile"));
        out.close();
        outStr = TestFsck.runFsck(this.conf, 0, true, topDir);
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
        Assertions.assertFalse((boolean)outStr.contains("Under Construction Block:"));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testFsckOpenECFiles() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsckECFile").setNumFiles(4).build();
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
        int dataBlocks = ecPolicy.getNumDataUnits();
        int cellSize = ecPolicy.getCellSize();
        int numAllUnits = dataBlocks + ecPolicy.getNumParityUnits();
        int blockSize = 2 * cellSize;
        this.conf.setLong("dfs.blocksize", (long)blockSize);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numAllUnits + 1).build();
        String topDir = "/myDir";
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(ecPolicy.getName());
        util.createFiles((FileSystem)fs, topDir);
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy(topDir, ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)fs, new org.apache.hadoop.fs.Path(topDir, "ecFile"), 1024L, (short)1, 0L);
        org.apache.hadoop.fs.Path openFile = new org.apache.hadoop.fs.Path(topDir + "/openECFile");
        FSDataOutputStream out = fs.create(openFile);
        int blockGroupSize = dataBlocks * blockSize;
        byte[] randomBytes = new byte[2 * blockGroupSize - cellSize];
        int seed = 42;
        new Random(seed).nextBytes(randomBytes);
        out.write(randomBytes);
        TestFsck.runFsck(this.conf, 0, true, topDir, "-files", "-blocks", "-openforwrite");
        String outStr = TestFsck.runFsck(this.conf, 0, true, openFile.toString(), "-files", "-blocks", "-openforwrite");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
        Assertions.assertTrue((boolean)outStr.contains("Live_repl=" + numAllUnits));
        Assertions.assertTrue((boolean)outStr.contains("Expected_repl=" + numAllUnits));
        outStr = TestFsck.runFsck(this.conf, 0, true, openFile.toString(), "-files", "-blocks", "-locations", "-openforwrite", "-replicaDetails");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertTrue((boolean)outStr.contains("OPENFORWRITE"));
        Assertions.assertTrue((boolean)outStr.contains("Live_repl=" + numAllUnits));
        Assertions.assertTrue((boolean)outStr.contains("Expected_repl=" + numAllUnits));
        Assertions.assertTrue((boolean)outStr.contains("Under Construction Block:"));
        LocatedStripedBlock lsb = (LocatedStripedBlock)fs.getClient().getLocatedBlocks(openFile.toString(), 0L, (long)(cellSize * dataBlocks)).get(0);
        long groupId = lsb.getBlock().getBlockId();
        byte[] indices = lsb.getBlockIndices();
        DatanodeInfoWithStorage[] locs = lsb.getLocations();
        for (int i = 0; i < indices.length; ++i) {
            long blockId = groupId + (long)indices[i];
            String str = "blk_" + blockId + ":" + locs[i];
            Assertions.assertTrue((boolean)outStr.contains(str));
        }
        String regex = ".*Expected_repl=" + numAllUnits + "(.*)\nStatus:.*";
        Pattern p = Pattern.compile(regex, 32);
        Matcher m = p.matcher(outStr);
        Assertions.assertTrue((boolean)m.find());
        String ucBlockOutput = m.group(1);
        Assertions.assertFalse((boolean)ucBlockOutput.contains("blk_"));
        out.close();
        outStr = TestFsck.runFsck(this.conf, 0, true, openFile.toString(), "-files", "-blocks", "-locations", "-racks", "-replicaDetails");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertFalse((boolean)outStr.contains("OPENFORWRITE"));
        Assertions.assertFalse((boolean)outStr.contains("Under Construction Block:"));
        Assertions.assertFalse((boolean)outStr.contains("Expected_repl=" + numAllUnits));
        Assertions.assertTrue((boolean)outStr.contains("Live_repl=" + numAllUnits));
        util.cleanup((FileSystem)fs, topDir);
    }

    @Test
    public void testCorruptBlock() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(1).build();
        this.cluster.waitActive();
        fs = this.cluster.getFileSystem();
        org.apache.hadoop.fs.Path file1 = new org.apache.hadoop.fs.Path("/testCorruptBlock");
        DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, (short)factor, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)factor);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file1);
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        File blockFile = this.cluster.getBlockFile(0, block);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            FileChannel channel = raFile.getChannel();
            String badString = "BADBAD";
            int rand = random.nextInt((int)channel.size() / 2);
            raFile.seek(rand);
            raFile.write(badString.getBytes());
            raFile.close();
        }
        try {
            IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
        }
        catch (IOException ie) {
            Assertions.assertTrue((boolean)(ie instanceof ChecksumException));
        }
        dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
        replicaCount = blocks.get(0).getLocations().length;
        while (replicaCount != factor) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
        }
        Assertions.assertTrue((boolean)blocks.get(0).isCorrupt());
        outStr = TestFsck.runFsck(this.conf, 1, true, "/");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        Assertions.assertTrue((boolean)outStr.contains("testCorruptBlock"));
    }

    @Test
    public void testUnderMinReplicatedBlock() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        short minReplication = 2;
        this.conf.setInt("dfs.namenode.replication.min", (int)minReplication);
        DistributedFileSystem fs = null;
        DFSClient dfsClient = null;
        LocatedBlocks blocks = null;
        int replicaCount = 0;
        Random random = new Random();
        String outStr = null;
        int factor = 1;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(2).build();
        this.cluster.waitActive();
        fs = this.cluster.getFileSystem();
        org.apache.hadoop.fs.Path file1 = new org.apache.hadoop.fs.Path("/testUnderMinReplicatedBlock");
        DFSTestUtil.createFile((FileSystem)fs, file1, 1024L, minReplication, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, file1, minReplication);
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file1);
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        File blockFile = this.cluster.getBlockFile(0, block);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            FileChannel channel = raFile.getChannel();
            String badString = "BADBAD";
            int rand = random.nextInt((int)channel.size() / 2);
            raFile.seek(rand);
            raFile.write(badString.getBytes());
            raFile.close();
        }
        dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
        replicaCount = blocks.get(0).getLocations().length;
        while (replicaCount != factor) {
            try {
                Thread.sleep(100L);
                try {
                    IOUtils.copyBytes((InputStream)fs.open(file1), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
                }
                catch (IOException ie) {
                    Assertions.assertTrue((boolean)(ie instanceof ChecksumException));
                }
                System.out.println("sleep in try: replicaCount=" + replicaCount + "  factor=" + factor);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            blocks = dfsClient.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            replicaCount = blocks.get(0).getLocations().length;
        }
        outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertTrue((boolean)outStr.contains("UNDER MIN REPL'D BLOCKS:\t1 (100.0 %)"));
        Assertions.assertTrue((boolean)outStr.contains("MINIMAL BLOCK REPLICATION:\t2"));
    }

    @Test
    @Timeout(value=90L)
    public void testFsckReplicaDetails() throws Exception {
        boolean replFactor = true;
        int numDn = 1;
        long blockSize = 512L;
        long fileSize = 1024L;
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"host1"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        this.cluster.waitClusterUp();
        final DistributedFileSystem dfs = this.cluster.getFileSystem();
        String testFile = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        String fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
        Assertions.assertTrue((boolean)fsckOut.contains("(LIVE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        DatanodeDescriptor dnDesc0 = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        bm.getDatanodeManager().getDatanodeAdminManager().startDecommission(dnDesc0);
        final String dn0Name = dnDesc0.getXferAddr();
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONING)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack2"}, new String[]{"host2"}, null, false);
        final AtomicBoolean checkDecommissionInProgress = new AtomicBoolean(false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dn0Name.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (!checkDecommissionInProgress.get() && datanodeInfo != null && datanodeInfo.isDecommissionInProgress()) {
                        checkDecommissionInProgress.set(true);
                    }
                    if (datanodeInfo != null && datanodeInfo.isDecommissioned()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception: " + e);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)30000L);
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        DatanodeDescriptor dnDesc1 = dnm.getDatanode(this.cluster.getDataNodes().get(1).getDatanodeId());
        final String dn1Name = dnDesc1.getXferAddr();
        bm.getDatanodeManager().getDatanodeAdminManager().startMaintenance(dnDesc1, Long.MAX_VALUE);
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assertions.assertTrue((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack3"}, new String[]{"host3"}, null, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                DatanodeInfo dnInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dn1Name.equals(info.getXferAddr())) continue;
                        dnInfo = info;
                    }
                    if (dnInfo != null && dnInfo.isInMaintenance()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception: " + e);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)30000L);
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-maintenance", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertTrue((boolean)fsckOut.contains("(IN MAINTENANCE)"));
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-blocks", "-replicaDetails");
        Assertions.assertTrue((boolean)fsckOut.contains("(DECOMMISSIONED)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(ENTERING MAINTENANCE)"));
        Assertions.assertFalse((boolean)fsckOut.contains("(IN MAINTENANCE)"));
    }

    @Test
    public void testFsckError() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).build();
        String fileName = "/test.txt";
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(fileName);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        INodeFile node = (INodeFile)this.cluster.getNamesystem().dir.getINode(fileName, FSDirectory.DirOp.READ);
        BlockInfo[] blocks = node.getBlocks();
        Assertions.assertEquals((int)blocks.length, (int)1);
        blocks[0].setNumBytes(-1L);
        String outStr = TestFsck.runFsck(this.conf, -1, true, fileName);
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("FAILED"));
        fs.delete(filePath, true);
    }

    @Test
    public void testFsckListCorruptFilesBlocks() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem fs = null;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).build();
        this.cluster.waitActive();
        fs = this.cluster.getFileSystem();
        DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(3).setMaxLevels(1).setMaxSize(1024).build();
        util.createFiles((FileSystem)fs, "/corruptData", (short)1);
        util.waitReplication((FileSystem)fs, "/corruptData", (short)1);
        String outStr = TestFsck.runFsck(this.conf, 0, false, "/corruptData", "-list-corruptfileblocks");
        System.out.println("1. good fsck out: " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("has 0 CORRUPT blocks"));
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j <= 1; ++j) {
                File storageDir = this.cluster.getInstanceStorageDir(i, j);
                File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(dataDir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    Assertions.assertTrue((boolean)blockFile.delete(), (String)"Cannot remove file.");
                    Assertions.assertTrue((boolean)metadataFile.delete(), (String)"Cannot remove file.");
                }
            }
        }
        this.waitForCorruptionBlocks(3, "/corruptData");
        outStr = TestFsck.runFsck(this.conf, -1, true, "/corruptData", "-list-corruptfileblocks");
        System.out.println("2. bad fsck out: " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("has 3 CORRUPT blocks"));
        util.createFiles((FileSystem)fs, "/goodData");
        outStr = TestFsck.runFsck(this.conf, 0, true, "/goodData", "-list-corruptfileblocks");
        System.out.println("3. good fsck out: " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("has 0 CORRUPT blocks"));
        util.cleanup((FileSystem)fs, "/goodData");
        util.createFiles((FileSystem)fs, "/corruptDa");
        outStr = TestFsck.runFsck(this.conf, 0, true, "/corruptDa", "-list-corruptfileblocks");
        Assertions.assertTrue((boolean)outStr.contains("has 0 CORRUPT blocks"));
        util.cleanup((FileSystem)fs, "/corruptData");
        util.cleanup((FileSystem)fs, "/corruptDa");
    }

    @Test
    public void testToCheckTheFsckCommandOnIllegalArguments() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).build();
        String fileName = "/test.txt";
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(fileName);
        DistributedFileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)fs, filePath, 1L, (short)1, 1L);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        String outStr = TestFsck.runFsck(this.conf, -1, true, fileName, "-thisIsNotAValidFlag");
        System.out.println(outStr);
        Assertions.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
        outStr = TestFsck.runFsck(this.conf, -1, true, "/", fileName);
        System.out.println(outStr);
        Assertions.assertTrue((!outStr.contains("is HEALTHY") ? 1 : 0) != 0);
        fs.delete(filePath, true);
    }

    @Test
    public void testFsckMissingReplicas() throws IOException {
        int replFactor = 2;
        boolean numReplicas = true;
        int numBlocks = 3;
        long blockSize = 512L;
        this.conf.setLong("dfs.blocksize", 512L);
        DistributedFileSystem dfs = null;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(1).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        String pathString = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        long fileLen = 1536L;
        DFSTestUtil.createFile((FileSystem)dfs, path, fileLen, (short)2, 1L);
        NameNode namenode = this.cluster.getNameNode();
        NetworkTopology nettop = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology();
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        NamenodeFsck fsck = new NamenodeFsck(this.conf, namenode, nettop, pmap, out, 1, remoteAddress);
        HdfsFileStatus file = namenode.getRpcServer().getFileInfo("/testfile");
        Assertions.assertNotNull((Object)file);
        NamenodeFsck.ReplicationResult replRes = new NamenodeFsck.ReplicationResult(this.conf);
        NamenodeFsck.ErasureCodingResult ecRes = new NamenodeFsck.ErasureCodingResult(this.conf);
        fsck.check("/testfile", file, (NamenodeFsck.Result)replRes, (NamenodeFsck.Result)ecRes);
        System.out.println(((Object)result).toString());
        Assertions.assertEquals((long)replRes.missingReplicas, (long)3L);
        Assertions.assertEquals((long)replRes.numExpectedReplicas, (long)6L);
    }

    @Test
    public void testFsckMisPlacedReplicas() throws IOException {
        int replFactor = 2;
        int numDn = 2;
        int numBlocks = 3;
        long blockSize = 512L;
        String[] racks = new String[]{"/rack1", "/rack1"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        DistributedFileSystem dfs = null;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        String pathString = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        long fileLen = 1536L;
        DFSTestUtil.createFile((FileSystem)dfs, path, fileLen, (short)2, 1L);
        NameNode namenode = this.cluster.getNameNode();
        NetworkTopology nettop = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getNetworkTopology();
        nettop.add((Node)DFSTestUtil.getDatanodeDescriptor("/rack2", "/host3"));
        numDn = (short)(numDn + 1);
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        NamenodeFsck fsck = new NamenodeFsck(this.conf, namenode, nettop, pmap, out, numDn, remoteAddress);
        HdfsFileStatus file = namenode.getRpcServer().getFileInfo("/testfile");
        Assertions.assertNotNull((Object)file);
        NamenodeFsck.ReplicationResult replRes = new NamenodeFsck.ReplicationResult(this.conf);
        NamenodeFsck.ErasureCodingResult ecRes = new NamenodeFsck.ErasureCodingResult(this.conf);
        fsck.check("/testfile", file, (NamenodeFsck.Result)replRes, (NamenodeFsck.Result)ecRes);
        Assertions.assertEquals((long)replRes.numMisReplicatedBlocks, (long)3L);
    }

    @Test
    public void testFsckFileNotFound() throws Exception {
        boolean numReplicas = true;
        NameNode namenode = (NameNode)Mockito.mock(NameNode.class);
        NetworkTopology nettop = (NetworkTopology)Mockito.mock(NetworkTopology.class);
        HashMap pmap = new HashMap();
        StringWriter result = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)result, true);
        InetAddress remoteAddress = InetAddress.getLocalHost();
        FSNamesystem fsName = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        FSDirectory fsd = (FSDirectory)Mockito.mock(FSDirectory.class);
        BlockManager blockManager = (BlockManager)Mockito.mock(BlockManager.class);
        DatanodeManager dnManager = (DatanodeManager)Mockito.mock(DatanodeManager.class);
        INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
        Mockito.when((Object)namenode.getNamesystem()).thenReturn((Object)fsName);
        Mockito.when((Object)fsName.getBlockManager()).thenReturn((Object)blockManager);
        Mockito.when((Object)fsName.getFSDirectory()).thenReturn((Object)fsd);
        Mockito.when((Object)fsd.getFSNamesystem()).thenReturn((Object)fsName);
        Mockito.when((Object)fsd.resolvePath((FSPermissionChecker)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (FSDirectory.DirOp)ArgumentMatchers.any(FSDirectory.DirOp.class))).thenReturn((Object)iip);
        Mockito.when((Object)blockManager.getDatanodeManager()).thenReturn((Object)dnManager);
        NamenodeFsck fsck = new NamenodeFsck(this.conf, namenode, nettop, pmap, out, 1, remoteAddress);
        String pathString = "/tmp/testFile";
        HdfsFileStatus file = new HdfsFileStatus.Builder().length(123L).replication(1).blocksize(131072L).mtime(123123123L).atime(123123120L).perm(FsPermission.getDefault()).owner("foo").group("bar").path(DFSUtil.string2Bytes((String)pathString)).fileId(312321L).children(1).storagePolicy((byte)0).build();
        NamenodeFsck.ReplicationResult replRes = new NamenodeFsck.ReplicationResult(this.conf);
        NamenodeFsck.ErasureCodingResult ecRes = new NamenodeFsck.ErasureCodingResult(this.conf);
        try {
            fsck.check(pathString, file, (NamenodeFsck.Result)replRes, (NamenodeFsck.Result)ecRes);
        }
        catch (Exception e) {
            Assertions.fail((String)("Unexpected exception " + e.getMessage()));
        }
        Assertions.assertTrue((boolean)replRes.isHealthy());
    }

    @Test
    public void testFsckSymlink() throws Exception {
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        DistributedFileSystem fs = null;
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        fs = this.cluster.getFileSystem();
        String fileName = "/srcdat";
        util.createFiles((FileSystem)fs, "/srcdat");
        FileContext fc = FileContext.getFileContext((Configuration)this.cluster.getConfiguration(0));
        org.apache.hadoop.fs.Path file = new org.apache.hadoop.fs.Path("/srcdat");
        org.apache.hadoop.fs.Path symlink = new org.apache.hadoop.fs.Path("/srcdat-symlink");
        fc.createSymlink(file, symlink, false);
        util.waitReplication((FileSystem)fs, "/srcdat", (short)3);
        long aTime = fc.getFileStatus(symlink).getAccessTime();
        Thread.sleep(1L);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        this.verifyAuditLogs();
        Assertions.assertEquals((long)aTime, (long)fc.getFileStatus(symlink).getAccessTime());
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        Assertions.assertTrue((boolean)outStr.contains("Total symlinks:\t\t1"));
        util.cleanup((FileSystem)fs, "/srcdat");
    }

    @Test
    public void testFsckForSnapshotFiles() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(1).build();
        String runFsck = TestFsck.runFsck(this.conf, 0, true, "/", "-includeSnapshots", "-files");
        Assertions.assertTrue((boolean)runFsck.contains("HEALTHY"));
        String fileName = "/srcdat";
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        org.apache.hadoop.fs.Path file1 = new org.apache.hadoop.fs.Path("/srcdat");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 1000L);
        hdfs.allowSnapshot(new org.apache.hadoop.fs.Path("/"));
        hdfs.createSnapshot(new org.apache.hadoop.fs.Path("/"), "mySnapShot");
        runFsck = TestFsck.runFsck(this.conf, 0, true, "/", "-includeSnapshots", "-files");
        Assertions.assertTrue((boolean)runFsck.contains("/.snapshot/mySnapShot/srcdat"));
        runFsck = TestFsck.runFsck(this.conf, 0, true, "/", "-files");
        Assertions.assertFalse((boolean)runFsck.contains("mySnapShot"));
    }

    @Test
    public void testBlockIdCK() throws Exception {
        int replFactor = 2;
        int numDn = 2;
        long blockSize = 512L;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        DistributedFileSystem dfs = null;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String runFsckResult = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", "not_a_block_id");
        Assertions.assertTrue((boolean)runFsckResult.contains("Incorrect blockId format:"));
        runFsckResult = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", sb.toString());
        Assertions.assertTrue((boolean)runFsckResult.contains(bIds[0]));
        Assertions.assertTrue((boolean)runFsckResult.contains(bIds[1]));
        Assertions.assertTrue((boolean)runFsckResult.contains("Block replica on datanode/rack: host1/rack1 is HEALTHY"));
        Assertions.assertTrue((boolean)runFsckResult.contains("Block replica on datanode/rack: host2/rack2 is HEALTHY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdCKDecommission() throws Exception {
        String fsckOut;
        boolean replFactor = true;
        int numDn = 2;
        long blockSize = 512L;
        boolean checkDecommissionInProgress = false;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", bIds[0]);
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        ExtendedBlock eb = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
        INodeFile bc = null;
        try {
            fsn.writeLock(RwLockMode.GLOBAL);
            BlockInfo bi = bm.getStoredBlock(eb.getLocalBlock());
            bc = fsn.getBlockCollection(bi);
        }
        finally {
            fsn.writeUnlock(RwLockMode.GLOBAL, "testBlockIdCKDecommission");
        }
        DatanodeDescriptor dn = bc.getBlocks()[0].getDatanode(0);
        bm.getDatanodeManager().getDatanodeAdminManager().startDecommission(dn);
        String dnName = dn.getXferAddr();
        DatanodeInfo datanodeInfo = null;
        boolean count = false;
        do {
            Thread.sleep(2000L);
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!dnName.equals(info.getXferAddr())) continue;
                datanodeInfo = info;
            }
            if (checkDecommissionInProgress || datanodeInfo == null || !datanodeInfo.isDecommissionInProgress()) continue;
            fsckOut = TestFsck.runFsck(this.conf, 3, true, "/", "-blockId", bIds[0]);
            Assertions.assertTrue((boolean)fsckOut.contains("is DECOMMISSIONING"));
            checkDecommissionInProgress = true;
        } while (datanodeInfo != null && !datanodeInfo.isDecommissioned());
        fsckOut = TestFsck.runFsck(this.conf, 2, true, "/", "-blockId", bIds[0]);
        Assertions.assertTrue((boolean)fsckOut.contains("is DECOMMISSIONED"));
    }

    @Test
    @Timeout(value=90L)
    public void testBlockIdCKMaintenance() throws Exception {
        int replFactor = 2;
        int numDn = 2;
        long blockSize = 512L;
        String[] hosts = new String[]{"host1", "host2"};
        String[] racks = new String[]{"/rack1", "/rack2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        this.conf.setInt("dfs.namenode.replication.min", 2);
        this.conf.setInt("dfs.namenode.maintenance.replication.min", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        final DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        final String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-maintenance", "-blockId", bIds[0]);
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        DatanodeDescriptor dn = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        bm.getDatanodeManager().getDatanodeAdminManager().startMaintenance(dn, Long.MAX_VALUE);
        final String dnName = dn.getXferAddr();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isEnteringMaintenance()) {
                        String fsckOut = TestFsck.runFsck(TestFsck.this.conf, 5, false, "/", "-maintenance", "-blockId", bIds[0]);
                        Assertions.assertTrue((boolean)fsckOut.contains("is ENTERING MAINTENANCE"));
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception: " + e);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)30000L);
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack3"}, new String[]{"host3"}, null, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    DatanodeInfo datanodeInfo = null;
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isInMaintenance()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception: " + e);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)30000L);
        String fsckOut = TestFsck.runFsck(this.conf, 4, false, "/", "-maintenance", "-blockId", bIds[0]);
        Assertions.assertTrue((boolean)fsckOut.contains("is IN MAINTENANCE"));
        fsckOut = TestFsck.runFsck(this.conf, 4, false, "/", "-blockId", bIds[0]);
        Assertions.assertFalse((boolean)fsckOut.contains("is IN MAINTENANCE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockIdCKStaleness() throws Exception {
        boolean replFactor = true;
        long blockSize = 512L;
        Configuration configuration = new Configuration();
        configuration.setLong("dfs.namenode.stale.datanode.interval", 5000L);
        configuration.setLong("dfs.blocksize", 512L);
        configuration.setInt("dfs.replication", 1);
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        this.cluster = new MiniDFSCluster.Builder(configuration, builderBaseDir).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        final DistributedFileSystem fs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)fs, (String)"Failed to get FileSystem");
        try {
            DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
            String pathString = "/testfile";
            org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
            DFSTestUtil.createFile((FileSystem)fs, path, 1024L, (short)1, 1024L);
            DFSTestUtil.waitReplication((FileSystem)fs, path, (short)1);
            StringBuilder sb = new StringBuilder();
            for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)fs, path)) {
                sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
            }
            String[] bIds = sb.toString().split(" ");
            String outStr = TestFsck.runFsck(configuration, 0, true, "/", "-blockId", bIds[0]);
            Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
            FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
            BlockManager bm = fsn.getBlockManager();
            DatanodeManager dnm = bm.getDatanodeManager();
            DatanodeDescriptor dn = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
            final String dnName = dn.getXferAddr();
            this.cluster.stopDataNode(0);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        DatanodeInfo datanodeInfo = null;
                        for (DatanodeInfo info : fs.getDataNodeStats()) {
                            if (!dnName.equals(info.getXferAddr())) continue;
                            datanodeInfo = info;
                        }
                        if (datanodeInfo != null && datanodeInfo.isStale(5000L)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Unexpected exception: " + e);
                        return false;
                    }
                    return false;
                }
            }, (long)500L, (long)30000L);
            outStr = TestFsck.runFsck(configuration, 6, true, "/", "-blockId", bIds[0]);
            Assertions.assertTrue((boolean)outStr.contains("is STALE"));
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    @Test
    public void testBlockIdCKCorruption() throws Exception {
        int numDn = 1;
        long blockSize = 512L;
        Random random = new Random();
        short repFactor = 1;
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"host1"};
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        DistributedFileSystem dfs = null;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String pathString = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, repFactor, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, repFactor);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", bIds[0]);
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
        File blockFile = this.cluster.getBlockFile(0, block);
        if (blockFile != null && blockFile.exists()) {
            RandomAccessFile raFile = new RandomAccessFile(blockFile, "rw");
            FileChannel channel = raFile.getChannel();
            String badString = "BADBAD";
            int rand = random.nextInt((int)channel.size() / 2);
            raFile.seek(rand);
            raFile.write(badString.getBytes());
            raFile.close();
        }
        DFSTestUtil.waitCorruptReplicas((FileSystem)dfs, this.cluster.getNamesystem(), path, block, 1);
        outStr = TestFsck.runFsck(this.conf, 1, false, "/", "-blockId", block.getBlockName());
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
    }

    @Test
    public void testBlockIdCKExcess() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setLong("dfs.namenode.redundancy.interval.seconds", 5000L);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(configuration).numDataNodes(2).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            org.apache.hadoop.fs.Path file = new org.apache.hadoop.fs.Path("/test");
            long fileLength = 512L;
            DFSTestUtil.createFile((FileSystem)fs, file, fileLength, (short)2, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, (short)2);
            List<LocatedBlock> locatedBlocks = DFSTestUtil.getAllBlocks((FileSystem)fs, file);
            Assertions.assertEquals((int)1, (int)locatedBlocks.size());
            String blockName = locatedBlocks.get(0).getBlock().getBlockName();
            String outStr = TestFsck.runFsck(configuration, 0, true, "/", "-blockId", blockName);
            Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
            Assertions.assertTrue((boolean)outStr.contains("No. of Expected Replica: 2"));
            Assertions.assertTrue((boolean)outStr.contains("No. of live Replica: 2"));
            Assertions.assertTrue((boolean)outStr.contains("No. of excess Replica: 0"));
            fs.setReplication(file, (short)1);
            outStr = TestFsck.runFsck(configuration, 0, true, "/", "-blockId", blockName);
            Assertions.assertTrue((boolean)outStr.contains("is EXCESS"));
            Assertions.assertTrue((boolean)outStr.contains("No. of Expected Replica: 1"));
            Assertions.assertTrue((boolean)outStr.contains("No. of live Replica: 1"));
            Assertions.assertTrue((boolean)outStr.contains("No. of excess Replica: 1"));
        }
    }

    private void writeFile(DistributedFileSystem dfs, org.apache.hadoop.fs.Path dir, String fileName) throws IOException {
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(dir.toString() + "/" + fileName);
        FSDataOutputStream out = dfs.create(filePath);
        out.writeChars("teststring");
        out.close();
    }

    private void writeFile(DistributedFileSystem dfs, String dirName, String fileName, String storagePolicy) throws IOException {
        org.apache.hadoop.fs.Path dirPath = new org.apache.hadoop.fs.Path(dirName);
        dfs.mkdirs(dirPath);
        dfs.setStoragePolicy(dirPath, storagePolicy);
        this.writeFile(dfs, dirPath, fileName);
    }

    @Test
    public void testStoragePoliciesCK() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(3).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        this.cluster.waitActive();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        this.writeFile(dfs, "/testhot", "file", "HOT");
        this.writeFile(dfs, "/testwarm", "file", "WARM");
        this.writeFile(dfs, "/testcold", "file", "COLD");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-storagepolicies");
        Assertions.assertTrue((boolean)outStr.contains("DISK:3(HOT)"));
        Assertions.assertTrue((boolean)outStr.contains("DISK:1,ARCHIVE:2(WARM)"));
        Assertions.assertTrue((boolean)outStr.contains("ARCHIVE:3(COLD)"));
        Assertions.assertTrue((boolean)outStr.contains("All blocks satisfy specified storage policy."));
        dfs.setStoragePolicy(new org.apache.hadoop.fs.Path("/testhot"), "COLD");
        dfs.setStoragePolicy(new org.apache.hadoop.fs.Path("/testwarm"), "COLD");
        outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-storagepolicies");
        Assertions.assertTrue((boolean)outStr.contains("DISK:3(HOT)"));
        Assertions.assertTrue((boolean)outStr.contains("DISK:1,ARCHIVE:2(WARM)"));
        Assertions.assertTrue((boolean)outStr.contains("ARCHIVE:3(COLD)"));
        Assertions.assertFalse((boolean)outStr.contains("All blocks satisfy specified storage policy."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckWithDecommissionedReplicas() throws Exception {
        boolean replFactor = true;
        int numDn = 2;
        long blockSize = 512L;
        long fileSize = 1024L;
        boolean checkDecommissionInProgress = false;
        String[] racks = new String[]{"/rack1", "/rack2"};
        String[] hosts = new String[]{"host1", "host2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String testFile = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/testfile");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        ExtendedBlock eb = DFSTestUtil.getFirstBlock((FileSystem)dfs, path);
        INodeFile bc = null;
        try {
            fsn.writeLock(RwLockMode.GLOBAL);
            BlockInfo bi = bm.getStoredBlock(eb.getLocalBlock());
            bc = fsn.getBlockCollection(bi);
        }
        finally {
            fsn.writeUnlock(RwLockMode.GLOBAL, "testFsckWithDecommissionedReplicas");
        }
        DatanodeDescriptor dn = bc.getBlocks()[0].getDatanode(0);
        bm.getDatanodeManager().getDatanodeAdminManager().startDecommission(dn);
        String dnName = dn.getXferAddr();
        DatanodeInfo datanodeInfo = null;
        boolean count = false;
        do {
            Thread.sleep(2000L);
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!dnName.equals(info.getXferAddr())) continue;
                datanodeInfo = info;
            }
            if (checkDecommissionInProgress || datanodeInfo == null || !datanodeInfo.isDecommissionInProgress()) continue;
            String fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile");
            checkDecommissionInProgress = true;
        } while (datanodeInfo != null && !datanodeInfo.isDecommissioned());
        TestFsck.runFsck(this.conf, 0, true, "/testfile");
    }

    @Test
    @Timeout(value=90L)
    public void testFsckWithMaintenanceReplicas() throws Exception {
        int replFactor = 2;
        int numDn = 2;
        long blockSize = 512L;
        String[] hosts = new String[]{"host1", "host2"};
        String[] racks = new String[]{"/rack1", "/rack2"};
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 2);
        this.conf.setInt("dfs.namenode.replication.min", 2);
        this.conf.setInt("dfs.namenode.maintenance.replication.min", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(numDn).hosts(hosts).racks(racks).build();
        Assertions.assertNotNull((Object)this.cluster, (String)"Failed Cluster Creation");
        this.cluster.waitClusterUp();
        final DistributedFileSystem dfs = this.cluster.getFileSystem();
        Assertions.assertNotNull((Object)dfs, (String)"Failed to get FileSystem");
        DFSTestUtil util = new DFSTestUtil.Builder().setName(this.getClass().getSimpleName()).setNumFiles(1).build();
        String testFile = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)2, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)2);
        StringBuilder sb = new StringBuilder();
        for (LocatedBlock lb : DFSTestUtil.getAllBlocks((FileSystem)dfs, path)) {
            sb.append(lb.getBlock().getLocalBlock().getBlockName() + " ");
        }
        String[] bIds = sb.toString().split(" ");
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/testfile");
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        FSNamesystem fsn = this.cluster.getNameNode().getNamesystem();
        BlockManager bm = fsn.getBlockManager();
        DatanodeManager dnm = bm.getDatanodeManager();
        DatanodeDescriptor dn = dnm.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        bm.getDatanodeManager().getDatanodeAdminManager().startMaintenance(dn, Long.MAX_VALUE);
        final String dnName = dn.getXferAddr();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isEnteringMaintenance()) {
                        String fsckOut = TestFsck.runFsck(TestFsck.this.conf, 0, true, "/testfile", "-maintenance");
                        Assertions.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception: " + e);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)30000L);
        this.cluster.startDataNodes(this.conf, 1, true, null, new String[]{"/rack3"}, new String[]{"host3"}, null, false);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                DatanodeInfo datanodeInfo = null;
                try {
                    for (DatanodeInfo info : dfs.getDataNodeStats()) {
                        if (!dnName.equals(info.getXferAddr())) continue;
                        datanodeInfo = info;
                    }
                    if (datanodeInfo != null && datanodeInfo.isInMaintenance()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception: " + e);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)30000L);
        String fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-maintenance");
        Assertions.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
        fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile");
        Assertions.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
    }

    @Test
    public void testECFsck() throws Exception {
        String[] outLines;
        DistributedFileSystem fs = null;
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        int dataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
        int parityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
        int totalSize = dataBlocks + parityBlocks;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(totalSize).build();
        fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        org.apache.hadoop.fs.Path replDirPath = new org.apache.hadoop.fs.Path("/replicated");
        org.apache.hadoop.fs.Path replFilePath = new org.apache.hadoop.fs.Path(replDirPath, "replfile");
        int factor = 3;
        DFSTestUtil.createFile((FileSystem)fs, replFilePath, 1024L, (short)3, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, replFilePath, (short)3);
        org.apache.hadoop.fs.Path ecDirPath = new org.apache.hadoop.fs.Path("/striped");
        org.apache.hadoop.fs.Path largeFilePath = new org.apache.hadoop.fs.Path(ecDirPath, "largeFile");
        DFSTestUtil.createStripedFile(this.cluster, largeFilePath, ecDirPath, 1, 2, true);
        org.apache.hadoop.fs.Path smallFilePath = new org.apache.hadoop.fs.Path(ecDirPath, "smallFile");
        DFSTestUtil.writeFile((FileSystem)fs, smallFilePath, "hello world!");
        long replTime = fs.getFileStatus(replFilePath).getAccessTime();
        long ecTime = fs.getFileStatus(largeFilePath).getAccessTime();
        Thread.sleep(1L);
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/");
        this.verifyAuditLogs();
        Assertions.assertEquals((long)replTime, (long)fs.getFileStatus(replFilePath).getAccessTime());
        Assertions.assertEquals((long)ecTime, (long)fs.getFileStatus(largeFilePath).getAccessTime());
        System.out.println(outStr);
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        this.shutdownCluster();
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(0).format(false).build();
        outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-files", "-blocks");
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        for (String line : outLines = outStr.split("\\r?\\n")) {
            if (line.contains(largeFilePath.toString())) {
                HdfsFileStatus file = this.cluster.getNameNode().getRpcServer().getFileInfo(largeFilePath.toString());
                Assertions.assertTrue((boolean)line.contains("policy=" + file.getErasureCodingPolicy().getName()));
                continue;
            }
            if (!line.contains(replFilePath.toString())) continue;
            Assertions.assertTrue((boolean)line.contains("replication=" + this.cluster.getFileSystem().getFileStatus(replFilePath).getReplication()));
        }
        System.out.println(outStr);
    }

    @Test
    public void testFsckListCorruptSnapshotFiles() throws Exception {
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        DistributedFileSystem hdfs = null;
        boolean replFactor = true;
        int numFiles = 3;
        int numSnapshots = 0;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).build();
        this.cluster.waitActive();
        hdfs = this.cluster.getFileSystem();
        DFSTestUtil util = new DFSTestUtil.Builder().setName("testGetCorruptFiles").setNumFiles(numFiles).setMaxLevels(1).setMaxSize(1024).build();
        util.createFiles((FileSystem)hdfs, "/corruptData", (short)1);
        org.apache.hadoop.fs.Path fp = new org.apache.hadoop.fs.Path("/corruptData/file");
        DFSTestUtil.createFile((FileSystem)hdfs, fp, 1024L, (short)1, 1000L);
        util.waitReplication((FileSystem)hdfs, "/corruptData", (short)1);
        hdfs.allowSnapshot(new org.apache.hadoop.fs.Path("/corruptData"));
        hdfs.createSnapshot(new org.apache.hadoop.fs.Path("/corruptData"), "mySnapShot");
        numSnapshots = ++numFiles;
        String outStr = TestFsck.runFsck(this.conf, 0, false, "/corruptData", "-list-corruptfileblocks");
        System.out.println("1. good fsck out: " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("has 0 CORRUPT blocks"));
        String bpid = this.cluster.getNamesystem().getBlockPoolId();
        for (int i = 0; i < numFiles; ++i) {
            for (int j = 0; j <= 1; ++j) {
                File storageDir = this.cluster.getInstanceStorageDir(i, j);
                File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                List<File> metadataFiles = MiniDFSCluster.getAllBlockMetadataFiles(dataDir);
                if (metadataFiles == null) continue;
                for (File metadataFile : metadataFiles) {
                    File blockFile = Block.metaToBlockFile((File)metadataFile);
                    Assertions.assertTrue((boolean)blockFile.delete(), (String)"Cannot remove file.");
                    Assertions.assertTrue((boolean)metadataFile.delete(), (String)"Cannot remove file.");
                }
            }
        }
        hdfs.delete(fp, false);
        this.waitForCorruptionBlocks(numSnapshots, "/corruptData");
        outStr = TestFsck.runFsck(this.conf, -1, true, "/corruptData", "-list-corruptfileblocks", "-includeSnapshots");
        System.out.println("2. bad fsck include snapshot out: " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("has " + (--numFiles + numSnapshots) + " CORRUPT blocks"));
        Assertions.assertTrue((boolean)outStr.contains("/.snapshot/"));
        outStr = TestFsck.runFsck(this.conf, -1, true, "/corruptData", "-list-corruptfileblocks");
        System.out.println("3. bad fsck exclude snapshot out: " + outStr);
        Assertions.assertTrue((boolean)outStr.contains("has " + numFiles + " CORRUPT blocks"));
        Assertions.assertFalse((boolean)outStr.contains("/.snapshot/"));
    }

    private void waitForCorruptionBlocks(int corruptBlocks, String path) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                NamenodeProtocols namenode = this.cluster.getNameNodeRpc();
                CorruptFileBlocks corruptFileBlocks = namenode.listCorruptFileBlocks(path, null);
                int numCorrupt = corruptFileBlocks.getFiles().length;
                if (numCorrupt == corruptBlocks) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error("Exception while getting Corrupt file blocks", (Throwable)e);
            }
            return false;
        }, (long)100L, (long)10000L);
    }

    @Test
    @Timeout(value=300L)
    public void testFsckMoveAfterCorruption() throws Exception {
        int dfsBlockSize = 524288;
        boolean numDatanodes = true;
        boolean replication = true;
        this.conf.setLong("dfs.blocksize", 524288L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        this.conf.setInt("dfs.datanode.directoryscan.interval", 1);
        this.conf.setInt("dfs.replication", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).build();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        this.cluster.waitActive();
        String srcDir = "/srcdat";
        DFSTestUtil util = new DFSTestUtil.Builder().setName("TestFsck").setMinSize(0x100000).setMaxSize(0x180000).setNumFiles(1).build();
        util.createFiles((FileSystem)dfs, "/srcdat", (short)1);
        Object[] fileNames = util.getFileNames("/srcdat");
        LOG.info("Created files: " + Arrays.toString(fileNames));
        String outStr = TestFsck.runFsck(this.conf, 0, true, "/", "-files", "-blocks");
        Assertions.assertTrue((boolean)outStr.contains("is HEALTHY"));
        DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.conf);
        Object blockFileToCorrupt = fileNames[0];
        final CorruptedTestFile ctf = new CorruptedTestFile((String)blockFileToCorrupt, new HashSet<Integer>(Arrays.asList(0)), dfsClient, 1, 524288);
        ctf.corruptBlocks(this.cluster);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    String str = TestFsck.runFsck(TestFsck.this.conf, 1, false, "/");
                    String numCorrupt = null;
                    for (String line : str.split(LINE_SEPARATOR)) {
                        Matcher m = NUM_CORRUPT_BLOCKS_PATTERN.matcher(line);
                        if (!m.matches()) continue;
                        numCorrupt = m.group(1);
                        break;
                    }
                    if (numCorrupt == null) {
                        Assertions.fail((String)"Cannot find corrupt blocks count in fsck output.");
                    }
                    if (Integer.parseInt(numCorrupt) == ctf.getTotalMissingBlocks()) {
                        Assertions.assertTrue((boolean)str.contains("is CORRUPT"));
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception caught", (Throwable)e);
                    Assertions.fail((String)"Caught unexpected exception.");
                }
                return false;
            }
        }, (long)1000L, (long)60000L);
        TestFsck.runFsck(this.conf, 1, true, "/", "-files", "-blocks", "-racks");
        LOG.info("Moving blocks to lost+found");
        TestFsck.runFsck(this.conf, 1, false, "/", "-move");
        ArrayList<Object> retVal = new ArrayList<Object>();
        RemoteIterator iter = dfs.listFiles(new org.apache.hadoop.fs.Path("/lost+found"), true);
        while (iter.hasNext()) {
            retVal.add(iter.next());
        }
        LOG.info("Items in lost+found: " + retVal);
        long totalLength = 0L;
        for (LocatedFileStatus locatedFileStatus : retVal) {
            totalLength += locatedFileStatus.getLen();
        }
        Assertions.assertTrue((totalLength > 0L ? 1 : 0) != 0, (String)"Nothing is moved to lost+found!");
        util.cleanup((FileSystem)dfs, "/srcdat");
    }

    @Test
    @Timeout(value=60L)
    public void testFsckUpgradeDomain() throws Exception {
        this.testUpgradeDomain(false, false);
        this.testUpgradeDomain(false, true);
        this.testUpgradeDomain(true, false);
        this.testUpgradeDomain(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUpgradeDomain(boolean defineUpgradeDomain, boolean displayUpgradeDomain) throws Exception {
        boolean replFactor = true;
        boolean numDN = true;
        long blockSize = 512L;
        long fileSize = 1024L;
        String upgradeDomain = "ud1";
        String[] racks = new String[]{"/rack1"};
        String[] hosts = new String[]{"127.0.0.1"};
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.replication", 1);
        if (defineUpgradeDomain) {
            this.conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
            hostsFileWriter.initialize(this.conf, "temp/fsckupgradedomain");
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(1).hosts(hosts).racks(racks).build();
        this.cluster.waitClusterUp();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        if (defineUpgradeDomain) {
            DatanodeAdminProperties dnProp = new DatanodeAdminProperties();
            DatanodeID datanodeID = this.cluster.getDataNodes().get(0).getDatanodeId();
            dnProp.setHostName(datanodeID.getHostName());
            dnProp.setPort(datanodeID.getXferPort());
            dnProp.setUpgradeDomain("ud1");
            hostsFileWriter.initIncludeHosts(new DatanodeAdminProperties[]{dnProp});
            this.cluster.getNamesystem(0).getBlockManager().getDatanodeManager().refreshNodes(this.conf);
        }
        String testFile = "/testfile";
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path("/testfile");
        DFSTestUtil.createFile((FileSystem)dfs, path, 1024L, (short)1, 1000L);
        DFSTestUtil.waitReplication((FileSystem)dfs, path, (short)1);
        try {
            String fsckOut = TestFsck.runFsck(this.conf, 0, true, "/testfile", "-files", "-blocks", displayUpgradeDomain ? "-upgradedomains" : "-locations");
            Assertions.assertTrue((boolean)fsckOut.contains("is HEALTHY"));
            String udValue = defineUpgradeDomain ? "ud1" : "undefined";
            Assertions.assertEquals((Object)displayUpgradeDomain, (Object)fsckOut.contains("(ud=" + udValue + ")"));
        }
        finally {
            if (defineUpgradeDomain) {
                hostsFileWriter.cleanup();
            }
        }
    }

    @Test
    @Timeout(value=300L)
    public void testFsckCorruptECFile() throws Exception {
        DistributedFileSystem fs = null;
        int dataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
        int parityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
        int cellSize = StripedFileTestUtil.getDefaultECPolicy().getCellSize();
        int totalSize = dataBlocks + parityBlocks;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(totalSize).build();
        fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        HashMap<Integer, Integer> dnIndices = new HashMap<Integer, Integer>();
        ArrayList<DataNode> dnList = this.cluster.getDataNodes();
        for (int i = 0; i < totalSize; ++i) {
            dnIndices.put(dnList.get(i).getIpcPort(), i);
        }
        org.apache.hadoop.fs.Path ecDirPath = new org.apache.hadoop.fs.Path("/striped");
        fs.mkdir(ecDirPath, FsPermission.getDirDefault());
        fs.getClient().setErasureCodingPolicy(ecDirPath.toString(), StripedFileTestUtil.getDefaultECPolicy().getName());
        org.apache.hadoop.fs.Path file = new org.apache.hadoop.fs.Path(ecDirPath, "corrupted");
        int length = cellSize * dataBlocks;
        byte[] bytes = StripedFileTestUtil.generateBytes(length);
        DFSTestUtil.writeFile((FileSystem)fs, file, bytes);
        LocatedStripedBlock lsb = (LocatedStripedBlock)fs.getClient().getLocatedBlocks(file.toString(), 0L, (long)(cellSize * dataBlocks)).get(0);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lsb, (int)cellSize, (int)dataBlocks, (int)parityBlocks);
        for (int i = 0; i < parityBlocks + 1; ++i) {
            int ipcPort = blks[i].getLocations()[0].getIpcPort();
            int dnIndex = (Integer)dnIndices.get(ipcPort);
            File storageDir = this.cluster.getInstanceStorageDir(dnIndex, 0);
            File blkFile = MiniDFSCluster.getBlockFile(storageDir, blks[i].getBlock());
            Assertions.assertTrue((boolean)blkFile.exists(), (String)"Block file does not exist");
            FileOutputStream out = new FileOutputStream(blkFile);
            out.write("corruption".getBytes());
        }
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        try {
            IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)this.conf, (boolean)true);
        }
        catch (IOException ie) {
            Assertions.assertTrue((boolean)ie.getMessage().contains("missingChunksNum=" + (parityBlocks + 1)));
        }
        this.waitForUnrecoverableBlockGroup(this.conf);
        String outStr = TestFsck.runFsck(this.conf, 1, true, "/");
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        Assertions.assertTrue((boolean)outStr.contains("Under-erasure-coded block groups:\t0"));
        outStr = TestFsck.runFsck(this.conf, -1, true, "/", "-list-corruptfileblocks");
        Assertions.assertTrue((boolean)outStr.contains("has 1 CORRUPT blocks"));
    }

    @Test
    @Timeout(value=300L)
    public void testFsckMissingECFile() throws Exception {
        DistributedFileSystem fs = null;
        int dataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
        int parityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
        int cellSize = StripedFileTestUtil.getDefaultECPolicy().getCellSize();
        int totalSize = dataBlocks + parityBlocks;
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(totalSize).build();
        fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        org.apache.hadoop.fs.Path ecDirPath = new org.apache.hadoop.fs.Path("/striped");
        fs.mkdir(ecDirPath, FsPermission.getDirDefault());
        fs.getClient().setErasureCodingPolicy(ecDirPath.toString(), StripedFileTestUtil.getDefaultECPolicy().getName());
        org.apache.hadoop.fs.Path file = new org.apache.hadoop.fs.Path(ecDirPath, "missing");
        int length = cellSize * dataBlocks;
        byte[] bytes = StripedFileTestUtil.generateBytes(length);
        DFSTestUtil.writeFile((FileSystem)fs, file, bytes);
        ArrayList<DataNode> dns = this.cluster.getDataNodes();
        for (int i = 0; i < parityBlocks + 1; ++i) {
            DatanodeID dnId = dns.get(i).getDatanodeId();
            this.cluster.stopDataNode(dnId.getXferAddr());
            this.cluster.setDataNodeDead(dnId);
        }
        this.waitForUnrecoverableBlockGroup(this.conf);
        String outStr = TestFsck.runFsck(this.conf, 1, true, "/", "-files", "-blocks", "-locations");
        Assertions.assertTrue((boolean)outStr.contains("is CORRUPT"));
        Assertions.assertTrue((boolean)outStr.contains("Live_repl=" + (dataBlocks - 1)));
        Assertions.assertTrue((boolean)outStr.contains("Under-erasure-coded block groups:\t0"));
        outStr = TestFsck.runFsck(this.conf, -1, true, "/", "-list-corruptfileblocks");
        Assertions.assertTrue((boolean)outStr.contains("has 1 CORRUPT blocks"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckECBlockIdRedundantInternalBlocks() throws Exception {
        int dataBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumDataUnits();
        int parityBlocks = StripedFileTestUtil.getDefaultECPolicy().getNumParityUnits();
        int cellSize = StripedFileTestUtil.getDefaultECPolicy().getCellSize();
        short groupSize = (short)(dataBlocks + parityBlocks);
        File builderBaseDir = new File(GenericTestUtils.getRandomizedTempPath());
        org.apache.hadoop.fs.Path dirPath = new org.apache.hadoop.fs.Path("/ec_dir");
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path(dirPath, "file");
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf, builderBaseDir).numDataNodes(groupSize + 1).build();
        this.cluster.waitActive();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
        try {
            fs.mkdirs(dirPath);
            fs.setErasureCodingPolicy(dirPath, StripedFileTestUtil.getDefaultECPolicy().getName());
            DFSTestUtil.createFile((FileSystem)fs, filePath, cellSize * dataBlocks * 2, (short)1, 0L);
            LocatedBlocks blks = fs.getClient().getLocatedBlocks(filePath.toString(), 0L);
            LocatedStripedBlock block = (LocatedStripedBlock)blks.getLastLocatedBlock();
            Assertions.assertEquals((int)groupSize, (int)block.getLocations().length);
            String runFsckResult = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", block.getBlock().getBlockName());
            Assertions.assertTrue((boolean)runFsckResult.contains(block.getBlock().getBlockName()));
            Assertions.assertTrue((boolean)runFsckResult.contains("No. of Expected Replica: " + groupSize));
            Assertions.assertTrue((boolean)runFsckResult.contains("No. of live Replica: " + groupSize));
            Assertions.assertTrue((boolean)runFsckResult.contains("No. of redundant Replica: 0"));
            DatanodeInfoWithStorage dnToStop = block.getLocations()[0];
            MiniDFSCluster.DataNodeProperties dnProp = this.cluster.stopDataNode(dnToStop.getXferAddr());
            this.cluster.setDataNodeDead((DatanodeID)dnToStop);
            DFSTestUtil.waitForReplication(fs, filePath, groupSize, 15000);
            this.cluster.restartDataNode(dnProp);
            this.cluster.waitActive();
            blks = fs.getClient().getLocatedBlocks(filePath.toString(), 0L);
            block = (LocatedStripedBlock)blks.getLastLocatedBlock();
            Assertions.assertEquals((int)(groupSize + 1), (int)block.getLocations().length);
            runFsckResult = TestFsck.runFsck(this.conf, 0, true, "/", "-blockId", block.getBlock().getBlockName());
            Assertions.assertTrue((boolean)runFsckResult.contains(block.getBlock().getBlockName()));
            Assertions.assertTrue((boolean)runFsckResult.contains("No. of Expected Replica: " + groupSize));
            Assertions.assertTrue((boolean)runFsckResult.contains("No. of live Replica: " + groupSize));
            Assertions.assertTrue((boolean)runFsckResult.contains("No. of redundant Replica: 1"));
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private void waitForUnrecoverableBlockGroup(final Configuration configuration) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    ByteArrayOutputStream bStream = new ByteArrayOutputStream();
                    PrintStream out = new PrintStream(bStream, true);
                    ToolRunner.run((Tool)new DFSck(configuration, out), (String[])new String[]{"/"});
                    String outStr = bStream.toString();
                    if (outStr.contains("UNRECOVERABLE BLOCK GROUPS")) {
                        return true;
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception caught", (Throwable)e);
                    Assertions.fail((String)"Caught unexpected exception.");
                }
                return false;
            }
        }, (long)1000L, (long)60000L);
    }

    @Test
    @Timeout(value=300L)
    public void testFsckCorruptWhenOneReplicaIsCorrupt() throws Exception {
        try (final MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(2).build();){
            cluster.waitActive();
            DistributedFileSystem fs = HATestUtil.configureFailoverFs(cluster, this.conf);
            cluster.transitionToActive(0);
            String filePath = "/appendTest";
            org.apache.hadoop.fs.Path fileName = new org.apache.hadoop.fs.Path(filePath);
            DFSTestUtil.createFile((FileSystem)fs, fileName, 512L, (short)2, 0L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)2);
            Assertions.assertTrue((boolean)fs.exists(fileName), (String)"File not created");
            cluster.getDataNodes().get(1).shutdown();
            DFSTestUtil.appendFile((FileSystem)fs, fileName, "appendCorruptBlock");
            cluster.restartDataNode(1, true);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return cluster.getNameNode(0).getNamesystem().getCorruptReplicaBlocks() > 0L;
                }
            }, (long)100L, (long)5000L);
            DFSTestUtil.appendFile((FileSystem)fs, fileName, "appendCorruptBlock");
            TestFsck.runFsck(cluster.getConfiguration(0), 0, true, "/");
        }
    }

    @Test
    public void testFsckNonPrivilegedListCorrupt() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.toFile()).numDataNodes(4).build();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"systest", (String[])new String[]{""});
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String path = "/";
                String outStr = TestFsck.runFsck(TestFsck.this.conf, -1, true, path, "-list-corruptfileblocks");
                Assertions.assertFalse((boolean)outStr.contains("The list of corrupt blocks under path '" + path + "' are:"));
                Assertions.assertFalse((boolean)outStr.contains("The filesystem under path '" + path + "' has "));
                Assertions.assertTrue((boolean)outStr.contains("Failed to open path '" + path + "': Permission denied"));
                return null;
            }
        });
    }

    private static class CorruptedTestFile {
        private final String name;
        private final Set<Integer> blocksToCorrupt;
        private final DFSClient dfsClient;
        private final int numDataNodes;
        private final int blockSize;
        private final byte[] initialContents;

        CorruptedTestFile(String name, Set<Integer> blocksToCorrupt, DFSClient dfsClient, int numDataNodes, int blockSize) throws IOException {
            this.name = name;
            this.blocksToCorrupt = blocksToCorrupt;
            this.dfsClient = dfsClient;
            this.numDataNodes = numDataNodes;
            this.blockSize = blockSize;
            this.initialContents = this.cacheInitialContents();
        }

        public int getTotalMissingBlocks() {
            return this.blocksToCorrupt.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] cacheInitialContents() throws IOException {
            HdfsFileStatus status = this.dfsClient.getFileInfo(this.name);
            byte[] content = new byte[(int)status.getLen()];
            try (DFSInputStream in = null;){
                in = this.dfsClient.open(this.name);
                IOUtils.readFully((InputStream)in, (byte[])content, (int)0, (int)content.length);
            }
            return content;
        }

        public void removeBlocks(MiniDFSCluster cluster) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
            for (int corruptIdx : this.blocksToCorrupt) {
                ExtendedBlock block = this.dfsClient.getNamenode().getBlockLocations(this.name, (long)(this.blockSize * corruptIdx), Long.MAX_VALUE).get(0).getBlock();
                for (int i = 0; i < this.numDataNodes; ++i) {
                    File blockFile = cluster.getBlockFile(i, block);
                    if (blockFile == null || !blockFile.exists()) continue;
                    Assertions.assertTrue((boolean)blockFile.delete());
                }
            }
        }

        public void corruptBlocks(MiniDFSCluster cluster) throws IOException {
            for (int corruptIdx : this.blocksToCorrupt) {
                ExtendedBlock block = this.dfsClient.getNamenode().getBlockLocations(this.name, (long)(this.blockSize * corruptIdx), Long.MAX_VALUE).get(0).getBlock();
                for (int i = 0; i < this.numDataNodes; ++i) {
                    File blockFile = cluster.getBlockFile(i, block);
                    if (blockFile == null || !blockFile.exists()) continue;
                    FileOutputStream blockFileStream = new FileOutputStream(blockFile, false);
                    blockFileStream.write("corrupt".getBytes());
                    blockFileStream.close();
                    LOG.info("Corrupted block file " + blockFile);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkSalvagedRemains() throws IOException {
            int chainIdx = 0;
            HdfsFileStatus status = this.dfsClient.getFileInfo(this.name);
            long length = status.getLen();
            int numBlocks = (int)((length + (long)this.blockSize - 1L) / (long)this.blockSize);
            DFSInputStream in = null;
            byte[] blockBuffer = new byte[this.blockSize];
            try {
                for (int blockIdx = 0; blockIdx < numBlocks; ++blockIdx) {
                    if (this.blocksToCorrupt.contains(blockIdx)) {
                        if (in == null) continue;
                        in.close();
                        in = null;
                        continue;
                    }
                    if (in == null) {
                        in = this.dfsClient.open("/lost+found" + this.name + "/" + chainIdx);
                        ++chainIdx;
                    }
                    int len = blockBuffer.length;
                    if (blockIdx == numBlocks - 1 && (len = (int)(in.getFileLength() % (long)this.blockSize)) == 0) {
                        len = blockBuffer.length;
                    }
                    IOUtils.readFully(in, (byte[])blockBuffer, (int)0, (int)len);
                    int startIdx = blockIdx * this.blockSize;
                    for (int i = 0; i < len; ++i) {
                        if (this.initialContents[startIdx + i] == blockBuffer[i]) continue;
                        throw new IOException("salvaged file " + this.name + " differed from what we expected on block " + blockIdx);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{in});
        }
    }
}

