/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystemLock;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestFSNamesystemLock {
    @Test
    public void testFsLockFairness() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.fslock.fair", true);
        FSNamesystemLock fsnLock = new FSNamesystemLock(conf, "FSN", null);
        Assertions.assertTrue((boolean)fsnLock.coarseLock.isFair());
        conf.setBoolean("dfs.namenode.fslock.fair", false);
        fsnLock = new FSNamesystemLock(conf, "FSN", null);
        Assertions.assertFalse((boolean)fsnLock.coarseLock.isFair());
    }

    @Test
    public void testFSNamesystemLockCompatibility() {
        FSNamesystemLock rwLock = new FSNamesystemLock(new Configuration(), "FSN", null);
        Assertions.assertEquals((int)0, (int)rwLock.getReadHoldCount());
        rwLock.readLock();
        Assertions.assertEquals((int)1, (int)rwLock.getReadHoldCount());
        rwLock.readLock();
        Assertions.assertEquals((int)2, (int)rwLock.getReadHoldCount());
        rwLock.readUnlock();
        Assertions.assertEquals((int)1, (int)rwLock.getReadHoldCount());
        rwLock.readUnlock();
        Assertions.assertEquals((int)0, (int)rwLock.getReadHoldCount());
        Assertions.assertFalse((boolean)rwLock.isWriteLockedByCurrentThread());
        Assertions.assertEquals((int)0, (int)rwLock.getWriteHoldCount());
        rwLock.writeLock();
        Assertions.assertTrue((boolean)rwLock.isWriteLockedByCurrentThread());
        Assertions.assertEquals((int)1, (int)rwLock.getWriteHoldCount());
        rwLock.writeLock();
        Assertions.assertTrue((boolean)rwLock.isWriteLockedByCurrentThread());
        Assertions.assertEquals((int)2, (int)rwLock.getWriteHoldCount());
        rwLock.writeUnlock();
        Assertions.assertTrue((boolean)rwLock.isWriteLockedByCurrentThread());
        Assertions.assertEquals((int)1, (int)rwLock.getWriteHoldCount());
        rwLock.writeUnlock();
        Assertions.assertFalse((boolean)rwLock.isWriteLockedByCurrentThread());
        Assertions.assertEquals((int)0, (int)rwLock.getWriteHoldCount());
    }

    @Test
    public void testFSLockGetWaiterCount() throws InterruptedException {
        int threadCount = 3;
        final CountDownLatch latch = new CountDownLatch(3);
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.fslock.fair", true);
        final FSNamesystemLock rwLock = new FSNamesystemLock(conf, "FSN", null);
        rwLock.writeLock();
        ExecutorService helper = Executors.newFixedThreadPool(3);
        for (int x = 0; x < 3; ++x) {
            helper.execute(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                    rwLock.readLock();
                }
            });
        }
        latch.await();
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return 3 == rwLock.getQueueLength();
                }
            }, (long)10L, (long)1000L);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Expected number of blocked thread not found");
        }
    }

    @Test
    @Timeout(value=45L)
    public void testFSWriteLockLongHoldingReport() throws Exception {
        long writeLockReportingThreshold = 100L;
        long writeLockSuppressWarningInterval = 10000L;
        Configuration conf = new Configuration();
        conf.setLong("dfs.namenode.write-lock-reporting-threshold-ms", 100L);
        conf.setTimeDuration("dfs.lock.suppress.warning.interval", 10000L, TimeUnit.MILLISECONDS);
        FakeTimer timer = new FakeTimer();
        FSNamesystemLock fsnLock = new FSNamesystemLock(conf, "FSN", null, (Timer)timer);
        timer.advance(10000L);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.LOG);
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.INFO);
        fsnLock.writeLock();
        fsnLock.writeUnlock();
        Assertions.assertFalse((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        fsnLock.writeLock();
        timer.advance(110L);
        logs.clearOutput();
        fsnLock.writeUnlock();
        Assertions.assertTrue((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        fsnLock.writeLockInterruptibly();
        timer.advance(110L);
        logs.clearOutput();
        fsnLock.writeUnlock();
        Assertions.assertFalse((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        fsnLock.writeLock();
        timer.advance(51L);
        fsnLock.writeLockInterruptibly();
        timer.advance(51L);
        fsnLock.writeLock();
        timer.advance(50L);
        logs.clearOutput();
        fsnLock.writeUnlock();
        Assertions.assertFalse((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        logs.clearOutput();
        fsnLock.writeUnlock();
        Assertions.assertFalse((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        logs.clearOutput();
        fsnLock.writeUnlock();
        Assertions.assertFalse((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        timer.advance(10000L);
        fsnLock.writeLock();
        timer.advance(200L);
        logs.clearOutput();
        fsnLock.writeUnlock();
        Assertions.assertTrue((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        Pattern pattern = Pattern.compile(".*[\n].*\\d+ms(.*[\n].*){1,}");
        Assertions.assertTrue((boolean)pattern.matcher(logs.getOutput()).find());
        String startTimeStr = "held at " + Time.formatTime((long)timer.now()).substring(0, 10);
        Assertions.assertTrue((boolean)logs.getOutput().contains(startTimeStr));
        Assertions.assertTrue((boolean)logs.getOutput().contains("Number of suppressed write-lock reports of FSNLock is 2"));
    }

    @Test
    @Timeout(value=45L)
    public void testFSReadLockLongHoldingReport() throws Exception {
        long readLockReportingThreshold = 100L;
        long readLockSuppressWarningInterval = 10000L;
        String readLockLogStmt = "Number of suppressed read-lock reports";
        Configuration conf = new Configuration();
        conf.setLong("dfs.namenode.read-lock-reporting-threshold-ms", 100L);
        conf.setTimeDuration("dfs.lock.suppress.warning.interval", 10000L, TimeUnit.MILLISECONDS);
        final FakeTimer timer = new FakeTimer();
        final FSNamesystemLock fsnLock = new FSNamesystemLock(conf, "FSN", null, (Timer)timer);
        timer.advance(10000L);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.LOG);
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.INFO);
        fsnLock.readLock();
        fsnLock.readUnlock();
        Assertions.assertFalse((logs.getOutput().contains(GenericTestUtils.getMethodName()) && logs.getOutput().contains("Number of suppressed read-lock reports") ? 1 : 0) != 0);
        fsnLock.readLock();
        timer.advance(110L);
        logs.clearOutput();
        fsnLock.readUnlock();
        Assertions.assertTrue((logs.getOutput().contains(GenericTestUtils.getMethodName()) && logs.getOutput().contains("Number of suppressed read-lock reports") ? 1 : 0) != 0);
        fsnLock.readLock();
        timer.advance(110L);
        logs.clearOutput();
        fsnLock.readUnlock();
        Assertions.assertFalse((logs.getOutput().contains(GenericTestUtils.getMethodName()) && logs.getOutput().contains("Number of suppressed read-lock reports") ? 1 : 0) != 0);
        Thread tLong = new Thread(){

            @Override
            public void run() {
                fsnLock.readLock();
                timer.advance(120L);
                fsnLock.readUnlock();
            }
        };
        tLong.start();
        tLong.join();
        fsnLock.readLock();
        timer.advance(51L);
        fsnLock.readLock();
        timer.advance(51L);
        logs.clearOutput();
        fsnLock.readUnlock();
        Assertions.assertFalse((logs.getOutput().contains(GenericTestUtils.getMethodName()) || logs.getOutput().contains("Number of suppressed read-lock reports") ? 1 : 0) != 0);
        logs.clearOutput();
        fsnLock.readUnlock();
        Assertions.assertFalse((logs.getOutput().contains(GenericTestUtils.getMethodName()) && logs.getOutput().contains("Number of suppressed read-lock reports") ? 1 : 0) != 0);
        timer.advance(10000L);
        fsnLock.readLock();
        timer.advance(101L);
        fsnLock.readUnlock();
        String stackTracePatternString = String.format("INFO.+%s(.+\n){5}\\Q%%s\\E\\.run", "Number of suppressed read-lock reports");
        Pattern tLongPattern = Pattern.compile(String.format(stackTracePatternString, tLong.getClass().getName()));
        Assertions.assertTrue((boolean)tLongPattern.matcher(logs.getOutput()).find());
        String startTimeStr = "held at " + Time.formatTime((long)timer.now()).substring(0, 10);
        Assertions.assertTrue((boolean)logs.getOutput().contains(startTimeStr));
        Assertions.assertTrue((boolean)logs.getOutput().contains("Number of suppressed read-lock reports of FSNLock is 3"));
        timer.advance(10000L);
        logs.clearOutput();
        final CountDownLatch barrier = new CountDownLatch(1);
        final CountDownLatch barrier2 = new CountDownLatch(1);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    fsnLock.readLock();
                    timer.advance(101L);
                    barrier.countDown();
                    barrier2.await();
                    fsnLock.readUnlock();
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"Interrupted during testing");
                }
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    fsnLock.readLock();
                    barrier2.countDown();
                    fsnLock.readUnlock();
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)"Interrupted during testing");
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Pattern t1Pattern = Pattern.compile(String.format(stackTracePatternString, t1.getClass().getName()));
        Assertions.assertTrue((boolean)t1Pattern.matcher(logs.getOutput()).find());
        Pattern t2Pattern = Pattern.compile(String.format(stackTracePatternString, t2.getClass().getName()));
        Assertions.assertFalse((boolean)t2Pattern.matcher(logs.getOutput()).find());
        Pattern pattern = Pattern.compile(".*[\n].*\\d+ms(.*[\n].*){1,}");
        Assertions.assertTrue((boolean)pattern.matcher(logs.getOutput()).find());
    }

    @Test
    public void testDetailedHoldMetrics() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.lock.detailed-metrics.enabled", true);
        FakeTimer timer = new FakeTimer();
        MetricsRegistry registry = new MetricsRegistry("Test");
        MutableRatesWithAggregation rates = registry.newRatesWithAggregation("Test");
        FSNamesystemLock fsLock = new FSNamesystemLock(conf, "FSN", rates, (Timer)timer);
        fsLock.readLock();
        timer.advanceNanos(1300000L);
        fsLock.readUnlock("foo");
        fsLock.readLock();
        timer.advanceNanos(2400000L);
        fsLock.readUnlock("foo");
        fsLock.readLock();
        timer.advance(1L);
        fsLock.readLock();
        timer.advance(1L);
        fsLock.readUnlock("bar");
        fsLock.readUnlock("bar");
        fsLock.writeLock();
        timer.advance(1L);
        fsLock.writeUnlock("baz", false);
        MetricsRecordBuilder rb = MetricsAsserts.mockMetricsRecordBuilder();
        rates.snapshot(rb, true);
        MetricsAsserts.assertGauge((String)"FSNReadLockFooNanosAvgTime", (double)1850000.0, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FSNReadLockFooNanosNumOps", (long)2L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"FSNReadLockBarNanosAvgTime", (double)2000000.0, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FSNReadLockBarNanosNumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"FSNWriteLockBazNanosAvgTime", (double)1000000.0, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FSNWriteLockBazNanosNumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"FSNReadLockOverallNanosAvgTime", (double)1900000.0, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FSNReadLockOverallNanosNumOps", (long)3L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"FSNWriteLockOverallNanosAvgTime", (double)1000000.0, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FSNWriteLockOverallNanosNumOps", (long)1L, (MetricsRecordBuilder)rb);
    }

    @Test
    @Timeout(value=45L)
    public void testFSWriteLockReportSuppressed() throws Exception {
        long writeLockReportingThreshold = 1L;
        long writeLockSuppressWarningInterval = 10L;
        Configuration conf = new Configuration();
        conf.setLong("dfs.namenode.write-lock-reporting-threshold-ms", 1L);
        conf.setTimeDuration("dfs.lock.suppress.warning.interval", 10L, TimeUnit.MILLISECONDS);
        FakeTimer timer = new FakeTimer();
        FSNamesystemLock fsnLock = new FSNamesystemLock(conf, "FSN", null, (Timer)timer);
        timer.advance(10L);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.LOG);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger((String)FSNamesystem.class.getName()), (Level)Level.INFO);
        fsnLock.writeLock();
        timer.advance(101L);
        fsnLock.writeUnlock();
        Assertions.assertTrue((boolean)logs.getOutput().contains("Number of suppressed write-lock reports"));
        logs.clearOutput();
        fsnLock.writeLock();
        timer.advance(101L);
        fsnLock.writeUnlock("testFSWriteLockReportSuppressed", true);
        Assertions.assertFalse((boolean)logs.getOutput().contains(GenericTestUtils.getMethodName()));
        Assertions.assertFalse((boolean)logs.getOutput().contains("Number of suppressed write-lock reports:"));
    }
}

