/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSDirEncryptionZoneOp;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFSDirEncryptionZoneOp {
    @Test
    public void testWarmUpEdekCacheRetries() throws IOException {
        NameNode.initMetrics((Configuration)new Configuration(), (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        int initialDelay = 100;
        int retryInterval = 100;
        int maxRetries = 2;
        KeyProviderCryptoExtension kpMock = (KeyProviderCryptoExtension)Mockito.mock(KeyProviderCryptoExtension.class);
        ((KeyProviderCryptoExtension)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).doThrow(new Throwable[]{new IOException()}).doAnswer(invocation -> null).when((Object)kpMock)).warmUpEncryptedKeys((String[])ArgumentMatchers.any());
        FSDirEncryptionZoneOp.EDEKCacheLoader loader = new FSDirEncryptionZoneOp.EDEKCacheLoader(new String[]{"edek1", "edek2"}, kpMock, 100, 100, 2);
        loader.run();
        ((KeyProviderCryptoExtension)Mockito.verify((Object)kpMock, (VerificationMode)Mockito.times((int)2))).warmUpEncryptedKeys((String[])ArgumentMatchers.any());
    }
}

