/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;

public class TestEditsDoubleBuffer {
    @Test
    public void testDoubleBuffer() throws IOException {
        EditsDoubleBuffer buf = new EditsDoubleBuffer(1024);
        Assertions.assertTrue((boolean)buf.isFlushed());
        byte[] data = new byte[100];
        buf.writeRaw(data, 0, data.length);
        Assertions.assertEquals((int)data.length, (int)buf.countBufferedBytes(), (String)"Should count new data correctly");
        Assertions.assertTrue((boolean)buf.isFlushed(), (String)"Writing to current buffer should not affect flush state");
        buf.setReadyToFlush();
        Assertions.assertEquals((int)data.length, (int)buf.countBufferedBytes(), (String)"Swapping buffers should still count buffered bytes");
        Assertions.assertFalse((boolean)buf.isFlushed());
        DataOutputBuffer outBuf = new DataOutputBuffer();
        buf.flushTo((OutputStream)outBuf);
        Assertions.assertEquals((int)data.length, (int)outBuf.getLength());
        Assertions.assertTrue((boolean)buf.isFlushed());
        Assertions.assertEquals((int)0, (int)buf.countBufferedBytes());
        buf.writeRaw(data, 0, data.length);
        Assertions.assertEquals((int)data.length, (int)buf.countBufferedBytes(), (String)"Should count new data correctly");
        buf.setReadyToFlush();
        buf.flushTo((OutputStream)outBuf);
        Assertions.assertEquals((int)(data.length * 2), (int)outBuf.getLength());
        Assertions.assertEquals((int)0, (int)buf.countBufferedBytes());
        outBuf.close();
    }

    @Test
    public void shouldFailToCloseWhenUnflushed() throws IOException {
        block2: {
            EditsDoubleBuffer buf = new EditsDoubleBuffer(1024);
            buf.writeRaw(new byte[1], 0, 1);
            try {
                buf.close();
                Assertions.fail((String)"Did not fail to close with unflushed data");
            }
            catch (IOException ioe) {
                if (ioe.toString().contains("still to be flushed")) break block2;
                throw ioe;
            }
        }
    }

    @Test
    public void testDumpEdits() throws IOException {
        int defaultBufferSize = 256;
        int fakeLogVersion = NameNodeLayoutVersion.Feature.ROLLING_UPGRADE.getInfo().getLayoutVersion();
        EditsDoubleBuffer buffer = new EditsDoubleBuffer(256);
        FSEditLogOp.OpInstanceCache cache = new FSEditLogOp.OpInstanceCache();
        String src = "/testdumpedits";
        short replication = 1;
        FSEditLogOp.SetReplicationOp op = FSEditLogOp.SetReplicationOp.getInstance((FSEditLogOp.OpInstanceCache)cache.get()).setPath(src).setReplication(replication);
        op.setTransactionId(1L);
        buffer.writeOp((FSEditLogOp)op, fakeLogVersion);
        src = "/testdumpedits2";
        FSEditLogOp.DeleteOp op2 = FSEditLogOp.DeleteOp.getInstance((FSEditLogOp.OpInstanceCache)cache.get()).setPath(src).setTimestamp(0L);
        op2.setTransactionId(2L);
        buffer.writeOp((FSEditLogOp)op2, fakeLogVersion);
        FSEditLogOp.AllocateBlockIdOp op3 = FSEditLogOp.AllocateBlockIdOp.getInstance((FSEditLogOp.OpInstanceCache)cache.get()).setBlockId(0L);
        op3.setTransactionId(3L);
        buffer.writeOp((FSEditLogOp)op3, fakeLogVersion);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)EditsDoubleBuffer.LOG);
        try {
            buffer.close();
            Assertions.fail();
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"bytes still to be flushed and cannot be closed.", (Throwable)ioe);
            EditsDoubleBuffer.LOG.info("Exception expected: ", (Throwable)ioe);
        }
        logs.stopCapturing();
        Assertions.assertTrue((boolean)logs.getOutput().contains(op.toString()), (String)("expected " + op.toString() + " in the log"));
        Assertions.assertTrue((boolean)logs.getOutput().contains(op2.toString()), (String)("expected " + op2.toString() + " in the log"));
        Assertions.assertTrue((boolean)logs.getOutput().contains(op3.toString()), (String)("expected " + op3.toString() + " in the log"));
    }
}

