/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestCorrectnessOfQuotaAfterRenameOp {
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;

    @BeforeAll
    public static void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
    }

    @Test
    public void testQuotaUsageWhenRenameWithSameStoragePolicy() throws Exception {
        int fileLen = 1024;
        int replication = 3;
        long spaceQuota = dfs.getClient().getConf().getDefaultBlockSize() * 10L;
        Path root = new Path(PathUtils.getTestDir(this.getClass()).getPath(), GenericTestUtils.getMethodName());
        Assertions.assertTrue((boolean)dfs.mkdirs(root));
        Path testParentDir1 = new Path(root, "test1");
        Assertions.assertTrue((boolean)dfs.mkdirs(testParentDir1));
        Path testParentDir2 = new Path(root, "test2");
        Assertions.assertTrue((boolean)dfs.mkdirs(testParentDir2));
        Path testParentDir3 = new Path(root, "test3");
        Assertions.assertTrue((boolean)dfs.mkdirs(testParentDir3));
        dfs.setQuota(testParentDir1, Long.MAX_VALUE, spaceQuota);
        dfs.setQuota(testParentDir2, Long.MAX_VALUE, spaceQuota);
        dfs.setQuota(testParentDir3, Long.MAX_VALUE, spaceQuota);
        Path srcDir = new Path(testParentDir1, "src-dir");
        Path file = new Path(srcDir, "file1");
        DFSTestUtil.createFile((FileSystem)dfs, file, 1024L, (short)3, 0L);
        Path file2 = new Path(srcDir, "file2");
        DFSTestUtil.createFile((FileSystem)dfs, file2, 1024L, (short)3, 0L);
        Path dstDir1 = new Path(testParentDir2, "dst-dir");
        ContentSummary cs1 = dfs.getContentSummary(testParentDir1);
        boolean rename = dfs.rename(srcDir, dstDir1);
        Assertions.assertEquals((Object)true, (Object)rename);
        ContentSummary cs2 = dfs.getContentSummary(testParentDir2);
        Assertions.assertTrue((boolean)cs1.equals((Object)cs2));
        Path dstDir2 = new Path(testParentDir3, "dst-dir");
        Assertions.assertTrue((boolean)dfs.mkdirs(dstDir2));
        ContentSummary cs3 = dfs.getContentSummary(testParentDir2);
        dfs.rename(dstDir1, dstDir2, new Options.Rename[]{Options.Rename.OVERWRITE});
        ContentSummary cs4 = dfs.getContentSummary(testParentDir3);
        Assertions.assertTrue((boolean)cs3.equals((Object)cs4));
    }

    @Test
    public void testQuotaUsageWhenRenameWithDifferStoragePolicy() throws Exception {
        int fileLen = 1024;
        int replication = 3;
        long spaceQuota = dfs.getClient().getConf().getDefaultBlockSize() * 10L;
        Path root = new Path(PathUtils.getTestDir(this.getClass()).getPath(), GenericTestUtils.getMethodName());
        Assertions.assertTrue((boolean)dfs.mkdirs(root));
        Path testParentDir1 = new Path(root, "test1");
        Assertions.assertTrue((boolean)dfs.mkdirs(testParentDir1));
        Path testParentDir2 = new Path(root, "test2");
        Assertions.assertTrue((boolean)dfs.mkdirs(testParentDir2));
        Path srcDir = new Path(testParentDir1, "src-dir");
        Path file = new Path(srcDir, "file1");
        DFSTestUtil.createFile((FileSystem)dfs, file, 1024L, (short)3, 0L);
        Path file2 = new Path(srcDir, "file2");
        DFSTestUtil.createFile((FileSystem)dfs, file2, 1024L, (short)3, 0L);
        dfs.setStoragePolicy(testParentDir1, "HOT");
        dfs.setQuota(testParentDir1, Long.MAX_VALUE, spaceQuota);
        dfs.setStoragePolicy(testParentDir2, "ONE_SSD");
        dfs.setQuota(testParentDir2, Long.MAX_VALUE, spaceQuota);
        Path dstDir1 = new Path(testParentDir2, "dst-dir");
        Assertions.assertTrue((boolean)dfs.mkdirs(dstDir1));
        FSNamesystem namesystem = cluster.getNameNode().getNamesystem();
        BlockStoragePolicySuite bsps = namesystem.getBlockManager().getStoragePolicySuite();
        INodesInPath iipSrc = namesystem.getFSDirectory().resolvePath(null, srcDir.toString(), FSDirectory.DirOp.READ);
        INodesInPath iipDst = namesystem.getFSDirectory().resolvePath(null, dstDir1.toString(), FSDirectory.DirOp.READ);
        QuotaCounts srcCounts = iipSrc.getLastINode().computeQuotaUsage(bsps, iipDst.getLastINode().getStoragePolicyID(), false, 0x7FFFFFFE);
        QuotaCounts dstCountsBeforeRename = iipDst.getLastINode().computeQuotaUsage(bsps, iipDst.getLastINode().getStoragePolicyID(), false, 0x7FFFFFFE);
        boolean rename = dfs.rename(srcDir, dstDir1);
        Assertions.assertEquals((Object)true, (Object)rename);
        QuotaCounts dstCountsAfterRename = iipDst.getLastINode().computeQuotaUsage(bsps, iipDst.getLastINode().getStoragePolicyID(), false, 0x7FFFFFFE);
        QuotaCounts subtract = dstCountsAfterRename.subtract(dstCountsBeforeRename);
        Assertions.assertTrue((boolean)subtract.equals((Object)srcCounts));
    }
}

