/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Ints;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestCheckpoint {
    static final Logger LOG;
    static final String NN_METRICS = "NameNodeActivity";
    static final long seed = 3735928559L;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    static final int numDatanodes = 3;
    short replication = (short)3;
    static final FilenameFilter tmpEditsFilter;
    private CheckpointFaultInjector faultInjector;

    @BeforeEach
    public void setUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
        CheckpointFaultInjector.instance = this.faultInjector = (CheckpointFaultInjector)Mockito.mock(CheckpointFaultInjector.class);
    }

    @AfterEach
    public void checkForSNNThreads() {
        GenericTestUtils.assertNoThreadsMatching((String)".*SecondaryNameNode.*");
    }

    static void checkFile(FileSystem fileSys, Path name, int repl) throws IOException {
        Assertions.assertTrue((boolean)fileSys.exists(name));
        short replication = fileSys.getFileStatus(name).getReplication();
        Assertions.assertEquals((int)repl, (int)replication, (String)("replication for " + name));
    }

    static void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assertions.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assertions.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameDirError() throws IOException {
        LOG.info("Starting testNameDirError");
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        Collection<URI> nameDirs = cluster.getNameDirs(0);
        cluster.shutdown();
        cluster = null;
        for (URI nameDirUri : nameDirs) {
            File dir = new File(nameDirUri.getPath());
            try {
                FileUtil.setWritable((File)dir, (boolean)false);
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
                Assertions.fail((String)("NN should have failed to start with " + dir + " set unreadable"));
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"storage directory does not exist or is not accessible", (Throwable)ioe);
            }
            finally {
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                FileUtil.setWritable((File)dir, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteTransactionIdHandlesIOE() throws Exception {
        LOG.info("Check IOException handled correctly by writeTransactionIdFile");
        ArrayList<URI> fsImageDirs = new ArrayList<URI>();
        ArrayList<URI> editsDirs = new ArrayList<URI>();
        File filePath = new File(PathUtils.getTestDir(this.getClass()), "storageDirToCheck");
        Assertions.assertTrue((filePath.exists() || filePath.mkdirs() ? 1 : 0) != 0, (String)"Couldn't create directory storageDirToCheck");
        fsImageDirs.add(filePath.toURI());
        editsDirs.add(filePath.toURI());
        NNStorage nnStorage = new NNStorage((Configuration)new HdfsConfiguration(), fsImageDirs, editsDirs);
        try {
            Assertions.assertTrue((((URI)nnStorage.getEditsDirectories().iterator().next()).toString().indexOf("storageDirToCheck") != -1 ? 1 : 0) != 0, (String)"List of storage directories didn't have storageDirToCheck.");
            Assertions.assertTrue((boolean)nnStorage.getRemovedStorageDirs().isEmpty(), (String)"List of removed storage directories wasn't empty");
        }
        finally {
            Assertions.assertTrue((boolean)filePath.delete(), (String)("Couldn't remove directory " + filePath.getAbsolutePath()));
        }
        nnStorage.writeTransactionIdFileToStorage(1L);
        List listRsd = nnStorage.getRemovedStorageDirs();
        Assertions.assertTrue((listRsd.size() > 0 && ((Storage.StorageDirectory)listRsd.get(listRsd.size() - 1)).getRoot().toString().indexOf("storageDirToCheck") != -1 ? 1 : 0) != 0, (String)"Removed directory wasn't what was expected");
        nnStorage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    @Timeout(value=30L)
    public void testReloadOnEditReplayFailure() throws IOException {
        MiniDFSCluster cluster;
        SecondaryNameNode secondary;
        block5: {
            HdfsConfiguration conf = new HdfsConfiguration();
            FSDataOutputStream fos = null;
            secondary = null;
            cluster = null;
            DistributedFileSystem fs = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                fos = fs.create(new Path("tmpfile0"));
                fos.write(new byte[]{0, 1, 2, 3});
                secondary.doCheckpoint();
                fos.write(new byte[]{0, 1, 2, 3});
                fos.hsync();
                ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure during merge")}).when((Object)this.faultInjector)).duringMerge();
                try {
                    secondary.doCheckpoint();
                    Assertions.fail((String)"Fault injection failed.");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                fos.write(new byte[]{0, 1, 2, 3});
                fos.hsync();
                Assertions.assertTrue((boolean)secondary.doCheckpoint(), (String)"Another checkpoint should have reloaded image");
                if (fs == null) break block5;
            }
            catch (Throwable throwable) {
                if (fs != null) {
                    fs.close();
                }
                TestCheckpoint.cleanup(secondary);
                secondary = null;
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                throw throwable;
            }
            fs.close();
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testTooManyEditReplayFailures() throws IOException {
        MiniDFSCluster cluster;
        SecondaryNameNode secondary;
        block5: {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.namenode.checkpoint.max-retries", 1);
            conf.setInt("dfs.namenode.checkpoint.period", 1);
            FSDataOutputStream fos = null;
            secondary = null;
            cluster = null;
            DistributedFileSystem fs = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).checkExitOnShutdown(false).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                fos = fs.create(new Path("tmpfile0"));
                fos.write(new byte[]{0, 1, 2, 3});
                ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure during merge")}).when((Object)this.faultInjector)).duringMerge();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                secondary.doWork();
                Assertions.fail((String)"2NN did not exit.");
                if (fs == null) break block5;
            }
            catch (ExitUtil.ExitException ee) {
                block6: {
                    try {
                        ExitUtil.resetFirstExitException();
                        Assertions.assertEquals((int)1, (int)(secondary.getMergeErrorCount() - 1), (String)"Max retries");
                        if (fs == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (fs != null) {
                            fs.close();
                        }
                        TestCheckpoint.cleanup(secondary);
                        secondary = null;
                        TestCheckpoint.cleanup(cluster);
                        cluster = null;
                        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                        throw throwable;
                    }
                    fs.close();
                }
                TestCheckpoint.cleanup(secondary);
                secondary = null;
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            }
            fs.close();
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryNamenodeError1() throws IOException {
        LOG.info("Starting testSecondaryNamenodeError1");
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file1 = new Path("checkpointxx.dat");
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure after rolling edit logs")}).when((Object)this.faultInjector)).afterSecondaryCallsRollEditLog();
            try {
                secondary.doCheckpoint();
                Assertions.assertTrue((boolean)false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
            TestCheckpoint.cleanupFile((FileSystem)fileSys, file1);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryNamenodeError2() throws IOException {
        LOG.info("Starting testSecondaryNamenodeError2");
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file1 = new Path("checkpointyy.dat");
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure after uploading new image")}).when((Object)this.faultInjector)).afterSecondaryUploadsNewImage();
            try {
                secondary.doCheckpoint();
                Assertions.assertTrue((boolean)false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
            TestCheckpoint.cleanupFile((FileSystem)fileSys, file1);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryNamenodeError3() throws IOException {
        LOG.info("Starting testSecondaryNamenodeError3");
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file1 = new Path("checkpointzz.dat");
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure after rolling edit logs")}).when((Object)this.faultInjector)).afterSecondaryCallsRollEditLog();
            try {
                secondary.doCheckpoint();
                Assertions.assertTrue((boolean)false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            secondary.shutdown();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
            TestCheckpoint.cleanupFile((FileSystem)fileSys, file1);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            secondary.shutdown();
        }
        finally {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
        }
    }

    @Test
    public void testSecondaryFailsWithErrorBeforeSettingHeaders() throws IOException {
        ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new Error("If this exception is not caught by the name-node, fs image will be truncated.")}).when((Object)this.faultInjector)).beforeGetImageSetsHeaders();
        this.doSecondaryFailsToReturnImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSecondaryFailsToReturnImage() throws IOException {
        LOG.info("Starting testSecondaryFailsToReturnImage");
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file1 = new Path("checkpointRI.dat");
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        FSImage image = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            image = cluster.getNameNode().getFSImage();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Storage.StorageDirectory sd = image.getStorage().getStorageDir(0);
            File latestImageBeforeCheckpoint = FSImageTestUtil.findLatestImageFile(sd);
            long fsimageLength = latestImageBeforeCheckpoint.length();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            try {
                secondary.doCheckpoint();
                Assertions.fail((String)"Checkpoint succeeded even though we injected an error!");
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)"If this exception is not caught", (Throwable)e);
            }
            Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            for (Storage.StorageDirectory sd2 : image.getStorage().dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE)) {
                File thisNewestImage = FSImageTestUtil.findLatestImageFile(sd2);
                long len = thisNewestImage.length();
                Assertions.assertEquals((long)fsimageLength, (long)len);
            }
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    private File filePathContaining(String substring) {
        return (File)Mockito.argThat(arg -> arg.getAbsolutePath().contains(substring));
    }

    private void checkTempImages(NNStorage storage) throws IOException {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(storage.getStorageDir(0).getCurrentDir());
        dirs.add(storage.getStorageDir(1).getCurrentDir());
        for (File dir : dirs) {
            File[] list;
            for (File f : list = dir.listFiles()) {
                if (!f.getName().contains(NNStorage.NameNodeFile.IMAGE_NEW.getName())) continue;
                throw new IOException("Found " + f);
            }
        }
    }

    @Test
    public void testNameNodeImageSendFailWrongSize() throws IOException {
        LOG.info("Starting testNameNodeImageSendFailWrongSize");
        ((CheckpointFaultInjector)Mockito.doReturn((Object)true).when((Object)this.faultInjector)).shouldSendShortFile(this.filePathContaining("fsimage"));
        this.doSendFailTest("is not of the advertised size");
    }

    @Test
    public void testNameNodeImageSendFailWrongDigest() throws IOException {
        LOG.info("Starting testNameNodeImageSendFailWrongDigest");
        ((CheckpointFaultInjector)Mockito.doReturn((Object)true).when((Object)this.faultInjector)).shouldCorruptAByte((File)Mockito.any(File.class));
        this.doSendFailTest("does not match advertised digest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendFailTest(String exceptionSubstring) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file1 = new Path("checkpoint-doSendFailTest-doSendFailTest.dat");
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            try {
                secondary.doCheckpoint();
                Assertions.fail((String)"Did not get expected exception");
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains((String)exceptionSubstring, (Throwable)e);
            }
            Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            this.checkTempImages(cluster.getNameNode().getFSImage().getStorage());
            this.checkTempImages(secondary.getFSImage().getStorage());
            secondary.shutdown();
            secondary = null;
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameDirLocking() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        Storage.StorageDirectory savedSd = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
            for (Storage.StorageDirectory sd : storage.dirIterable(null)) {
                TestCheckpoint.assertLockFails(sd);
                savedSd = sd;
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        Assertions.assertNotNull(savedSd);
        TestCheckpoint.assertClusterStartFailsWhenDirLocked((Configuration)conf, savedSd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeparateEditsDirLocking() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        File editsDir = new File(MiniDFSCluster.getBaseDirectory(), "testSeparateEditsDirLocking");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        conf.set("dfs.namenode.edits.dir", editsDir.getAbsolutePath());
        MiniDFSCluster cluster = null;
        Storage.StorageDirectory savedSd = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).manageNameDfsDirs(false).numDataNodes(0).build();
            NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
            for (Storage.StorageDirectory sd : storage.dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                Assertions.assertEquals((Object)editsDir.getAbsoluteFile(), (Object)sd.getRoot());
                TestCheckpoint.assertLockFails(sd);
                savedSd = sd;
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        Assertions.assertNotNull(savedSd);
        TestCheckpoint.assertClusterStartFailsWhenDirLocked((Configuration)conf, savedSd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryNameNodeLocking() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            Storage.StorageDirectory savedSd = null;
            secondary = this.startSecondaryNameNode((Configuration)conf);
            NNStorage storage = secondary.getFSImage().getStorage();
            for (Storage.StorageDirectory sd : storage.dirIterable(null)) {
                TestCheckpoint.assertLockFails(sd);
                savedSd = sd;
            }
            LOG.info("===> Shutting down first 2NN");
            secondary.shutdown();
            secondary = null;
            LOG.info("===> Locking a dir, starting second 2NN");
            LOG.info("Trying to lock" + savedSd);
            savedSd.lock();
            try {
                secondary = this.startSecondaryNameNode((Configuration)conf);
                Assertions.assertFalse((boolean)savedSd.isLockSupported(), (String)("Should fail to start 2NN when " + savedSd + " is locked"));
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"already locked", (Throwable)ioe);
            }
            finally {
                savedSd.unlock();
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStorageAlreadyLockedErrorMessage() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        Storage.StorageDirectory savedSd = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
            for (Storage.StorageDirectory sd : storage.dirIterable(null)) {
                TestCheckpoint.assertLockFails(sd);
                savedSd = sd;
            }
            GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(Storage.class));
            try {
                savedSd.lock();
                Assertions.fail((String)"Namenode should not be able to lock a storage that is already locked");
            }
            catch (IOException ioe) {
                String lockingJvmName = Path.WINDOWS ? "" : " " + ManagementFactory.getRuntimeMXBean().getName();
                String expectedLogMessage = "It appears that another node " + lockingJvmName + " has already locked the storage directory";
                Assertions.assertTrue((boolean)logs.getOutput().contains(expectedLogMessage), (String)("Log output does not contain expected log message: " + expectedLogMessage));
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    private static void assertLockFails(Storage.StorageDirectory sd) {
        try {
            sd.lock();
            Assertions.assertFalse((boolean)sd.isLockSupported());
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"already locked", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertClusterStartFailsWhenDirLocked(Configuration conf, Storage.StorageDirectory sdToLock) throws IOException {
        block5: {
            sdToLock.lock();
            MiniDFSCluster cluster = null;
            try {
                cluster = new MiniDFSCluster.Builder(conf).format(false).manageNameDfsDirs(false).numDataNodes(0).build();
                Assertions.assertFalse((boolean)sdToLock.isLockSupported(), (String)("cluster should fail to start after locking " + sdToLock));
                TestCheckpoint.cleanup(cluster);
                cluster = null;
            }
            catch (IOException ioe) {
                GenericTestUtils.assertExceptionContains((String)"already locked", (Throwable)ioe);
                break block5;
            }
            finally {
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                sdToLock.unlock();
            }
            sdToLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportCheckpoint() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path testPath = new Path("/testfile");
        SecondaryNameNode snn = null;
        MiniDFSCluster cluster = null;
        Collection<URI> nameDirs = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            nameDirs = cluster.getNameDirs(0);
            cluster.getFileSystem().mkdirs(testPath);
            snn = this.startSecondaryNameNode((Configuration)conf);
            snn.doCheckpoint();
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(snn);
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(snn);
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        LOG.info("Trying to import checkpoint when the NameNode already contains an image. This should fail.");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).startupOption(HdfsServerConstants.StartupOption.IMPORT).build();
            Assertions.fail((String)"NameNode did not fail to start when it already contained an image");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"NameNode already contains an image", (Throwable)ioe);
        }
        finally {
            TestCheckpoint.cleanup(cluster);
            cluster = null;
        }
        LOG.info("Removing NN storage contents");
        for (URI uri : nameDirs) {
            File dir = new File(uri.getPath());
            LOG.info("Cleaning " + dir);
            TestCheckpoint.removeAndRecreateDir(dir);
        }
        LOG.info("Trying to import checkpoint");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).numDataNodes(0).startupOption(HdfsServerConstants.StartupOption.IMPORT).build();
            Assertions.assertTrue((boolean)cluster.getFileSystem().exists(testPath), (String)"Path from checkpoint should exist after import");
            FSImageTestUtil.assertNNHasCheckpoints(cluster, Ints.asList((int[])new int[]{3}));
        }
        finally {
            TestCheckpoint.cleanup(cluster);
            cluster = null;
        }
    }

    private static void removeAndRecreateDir(File dir) throws IOException {
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
    }

    SecondaryNameNode startSecondaryNameNode(Configuration conf) throws IOException {
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        return new SecondaryNameNode(conf);
    }

    SecondaryNameNode startSecondaryNameNode(Configuration conf, int index) throws IOException {
        Configuration snnConf = new Configuration(conf);
        snnConf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        snnConf.set("dfs.namenode.checkpoint.dir", MiniDFSCluster.getBaseDirectory() + "/2nn-" + index);
        return new SecondaryNameNode(snnConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpoint() throws IOException {
        Path tmpDir = new Path("/tmp_tmp");
        Path file1 = new Path("checkpoint.dat");
        Path file2 = new Path("checkpoint2.dat");
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        this.replication = (short)conf.getInt("dfs.replication", 3);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Assertions.assertTrue((!fileSys.exists(file2) ? 1 : 0) != 0);
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, this.replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
            for (int i = 0; i < 1000; ++i) {
                fileSys.mkdirs(tmpDir);
                fileSys.delete(tmpDir, true);
            }
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
            MetricsAsserts.assertCounterGt((String)"GetImageNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounterGt((String)"GetEditNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounterGt((String)"PutImageNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertGaugeGt((String)"GetImageAvgTime", (double)0.0, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertGaugeGt((String)"GetEditAvgTime", (double)0.0, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertGaugeGt((String)"PutImageAvgTime", (double)0.0, (MetricsRecordBuilder)rb);
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            TestCheckpoint.checkFile((FileSystem)fileSys, file1, this.replication);
            TestCheckpoint.cleanupFile((FileSystem)fileSys, file1);
            DFSTestUtil.createFile((FileSystem)fileSys, file2, 8192, 8192L, 4096L, this.replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file2, this.replication);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            FSDirectory secondaryFsDir = secondary.getFSNamesystem().dir;
            INode rootInMap = secondaryFsDir.getInode(secondaryFsDir.rootDir.getId());
            Assertions.assertSame((Object)rootInMap, (Object)secondaryFsDir.rootDir);
            fileSys.delete(tmpDir, true);
            fileSys.mkdirs(tmpDir);
            secondary.doCheckpoint();
        }
        finally {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
        }
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        Assertions.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)fileSys.exists(tmpDir));
        try {
            TestCheckpoint.checkFile((FileSystem)fileSys, file2, this.replication);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
            cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testSaveNamespace() throws IOException {
        MiniDFSCluster cluster;
        block10: {
            cluster = null;
            DistributedFileSystem fs = null;
            try {
                HdfsConfiguration conf = new HdfsConfiguration();
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                FileContext fc = FileContext.getFileContext((URI)cluster.getURI(0));
                DFSAdmin admin = new DFSAdmin((Configuration)conf);
                String[] args = new String[]{"-saveNamespace"};
                try {
                    admin.run(args);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                Path file = new Path("namespace.dat");
                DFSTestUtil.createFile((FileSystem)fs, file, 8192, 8192L, 4096L, this.replication, 3735928559L);
                TestCheckpoint.checkFile((FileSystem)fs, file, this.replication);
                Path symlink = new Path("file.link");
                fc.createSymlink(file, symlink, false);
                Assertions.assertTrue((boolean)fc.getFileLinkStatus(symlink).isSymlink());
                Collection<URI> editsDirs = cluster.getNameEditsDirs(0);
                for (URI uRI : editsDirs) {
                    File ed = new File(uRI.getPath());
                    Assertions.assertTrue((new File(ed, "current/" + NNStorage.getInProgressEditsFileName((long)1L)).length() > 4L ? 1 : 0) != 0);
                }
                fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
                try {
                    admin.run(args);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                int EXPECTED_TXNS_FIRST_SEG = 13;
                for (URI uri : editsDirs) {
                    File ed = new File(uri.getPath());
                    File curDir = new File(ed, "current");
                    LOG.info("Files in " + curDir + ":\n  " + Joiner.on((String)"\n  ").join((Object[])curDir.list()));
                    File originalEdits = new File(curDir, NNStorage.getInProgressEditsFileName((long)1L));
                    Assertions.assertFalse((boolean)originalEdits.exists());
                    File finalizedEdits = new File(curDir, NNStorage.getFinalizedEditsFileName((long)1L, (long)13L));
                    GenericTestUtils.assertExists((File)finalizedEdits);
                    Assertions.assertTrue((finalizedEdits.length() > 4L ? 1 : 0) != 0);
                    GenericTestUtils.assertExists((File)new File(ed, "current/" + NNStorage.getInProgressEditsFileName((long)14L)));
                }
                Collection<URI> collection = cluster.getNameDirs(0);
                for (URI uri : collection) {
                    File imageDir = new File(uri.getPath());
                    File savedImage = new File(imageDir, "current/" + NNStorage.getImageFileName((long)13L));
                    Assertions.assertTrue((boolean)savedImage.exists(), (String)("Should have saved image at " + savedImage));
                }
                cluster.shutdown();
                cluster = null;
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(false).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                TestCheckpoint.checkFile((FileSystem)fs, file, this.replication);
                fc = FileContext.getFileContext((URI)cluster.getURI(0));
                Assertions.assertTrue((boolean)fc.getFileLinkStatus(symlink).isSymlink());
                if (fs == null) break block10;
            }
            catch (Throwable throwable) {
                if (fs != null) {
                    fs.close();
                }
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                throw throwable;
            }
            fs.close();
        }
        TestCheckpoint.cleanup(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointSignature() throws IOException {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
            NameNode nn = cluster.getNameNode();
            NamenodeProtocols nnRpc = nn.getRpcServer();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            CheckpointSignature sig = nnRpc.rollEditLog();
            sig.setBlockpoolID("somerandomebpid");
            sig.clusterID = "somerandomcid";
            try {
                sig.validateStorageInfo(nn.getFSImage());
                Assertions.assertTrue((boolean)false, (String)"This test is expected to fail.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointAfterTwoFailedUploads() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure after rolling edit logs")}).when((Object)this.faultInjector)).afterSecondaryCallsRollEditLog();
            try {
                secondary.doCheckpoint();
                Assertions.fail((String)"Should have failed upload");
            }
            catch (IOException ioe) {
                LOG.info("Got expected failure", (Throwable)ioe);
                Assertions.assertTrue((boolean)ioe.toString().contains("Injecting failure"));
            }
            try {
                secondary.doCheckpoint();
                Assertions.fail((String)"Should have failed upload");
            }
            catch (IOException ioe) {
                try {
                    LOG.info("Got expected failure", (Throwable)ioe);
                    Assertions.assertTrue((boolean)ioe.toString().contains("Injecting failure"));
                }
                catch (Throwable throwable) {
                    Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                    throw throwable;
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            }
            Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
            secondary.doCheckpoint();
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSecondaryNamenodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nameserviceId1 = "ns1";
        String nameserviceId2 = "ns2";
        conf.set("dfs.nameservices", nameserviceId1 + "," + nameserviceId2);
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary1 = null;
        SecondaryNameNode secondary2 = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(conf.get("dfs.nameservices"))).build();
            HdfsConfiguration snConf1 = new HdfsConfiguration(cluster.getConfiguration(0));
            HdfsConfiguration snConf2 = new HdfsConfiguration(cluster.getConfiguration(1));
            InetSocketAddress nn1RpcAddress = cluster.getNameNode(0).getNameNodeAddress();
            InetSocketAddress nn2RpcAddress = cluster.getNameNode(1).getNameNodeAddress();
            String nn1 = nn1RpcAddress.getHostName() + ":" + nn1RpcAddress.getPort();
            String nn2 = nn2RpcAddress.getHostName() + ":" + nn2RpcAddress.getPort();
            snConf1.set("dfs.namenode.servicerpc-address", "");
            snConf2.set("dfs.namenode.servicerpc-address", "");
            snConf1.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{nameserviceId1}), nn1);
            snConf2.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.servicerpc-address", (String[])new String[]{nameserviceId2}), nn2);
            secondary1 = this.startSecondaryNameNode((Configuration)snConf1);
            secondary2 = this.startSecondaryNameNode((Configuration)snConf2);
            Assertions.assertEquals((int)secondary1.getNameNodeAddress().getPort(), (int)nn1RpcAddress.getPort());
            Assertions.assertEquals((int)secondary2.getNameNodeAddress().getPort(), (int)nn2RpcAddress.getPort());
            Assertions.assertTrue((secondary1.getNameNodeAddress().getPort() != secondary2.getNameNodeAddress().getPort() ? 1 : 0) != 0);
            secondary1.doCheckpoint();
            secondary2.doCheckpoint();
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary1);
            secondary1 = null;
            TestCheckpoint.cleanup(secondary2);
            secondary2 = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary1);
        secondary1 = null;
        TestCheckpoint.cleanup(secondary2);
        secondary2 = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryImageDownload() throws IOException {
        LOG.info("Starting testSecondaryImageDownload");
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        Path dir = new Path("/checkpoint");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
        cluster.waitActive();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        FSImage image = cluster.getNameNode().getFSImage();
        SecondaryNameNode secondary = null;
        try {
            Assertions.assertTrue((!fileSys.exists(dir) ? 1 : 0) != 0);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            File secondaryDir = MiniDFSCluster.getCheckpointDirectory(MiniDFSCluster.getBaseDirectory(), 0, 0)[0];
            File secondaryCurrent = new File(secondaryDir, "current");
            long expectedTxIdToDownload = cluster.getNameNode().getFSImage().getStorage().getMostRecentCheckpointTxId();
            File secondaryFsImageBefore = new File(secondaryCurrent, NNStorage.getImageFileName((long)expectedTxIdToDownload));
            File secondaryFsImageAfter = new File(secondaryCurrent, NNStorage.getImageFileName((long)(expectedTxIdToDownload + 2L)));
            Assertions.assertFalse((boolean)secondaryFsImageBefore.exists(), (String)("Secondary should start with empty current/ dir but " + secondaryFsImageBefore + " exists"));
            Assertions.assertTrue((boolean)secondary.doCheckpoint(), (String)"Secondary should have loaded an image");
            Assertions.assertTrue((boolean)secondaryFsImageBefore.exists(), (String)"Secondary should have downloaded original image");
            Assertions.assertTrue((boolean)secondaryFsImageAfter.exists(), (String)"Secondary should have created a new image");
            long fsimageLength = secondaryFsImageBefore.length();
            Assertions.assertEquals((long)fsimageLength, (long)secondaryFsImageAfter.length(), (String)"Image size should not have changed");
            fileSys.mkdirs(dir);
            Assertions.assertFalse((boolean)secondary.doCheckpoint(), (String)"Another checkpoint should not have to re-load image");
            for (Storage.StorageDirectory sd : image.getStorage().dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE)) {
                File imageFile = NNStorage.getImageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.IMAGE, (long)(expectedTxIdToDownload + 5L));
                Assertions.assertTrue((imageFile.length() > fsimageLength ? 1 : 0) != 0, (String)"Image size increased");
            }
        }
        catch (Throwable throwable) {
            fileSys.close();
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        fileSys.close();
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    @Timeout(value=30L)
    public void testFailureBeforeRename() throws IOException {
        MiniDFSCluster cluster;
        SecondaryNameNode secondary;
        block5: {
            HdfsConfiguration conf = new HdfsConfiguration();
            FSDataOutputStream fos = null;
            secondary = null;
            cluster = null;
            DistributedFileSystem fs = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                fos = fs.create(new Path("tmpfile0"));
                fos.write(new byte[]{0, 1, 2, 3});
                secondary.doCheckpoint();
                fos.write(new byte[]{0, 1, 2, 3});
                fos.hsync();
                ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure after MD5Rename")}).when((Object)this.faultInjector)).afterMD5Rename();
                try {
                    secondary.doCheckpoint();
                    Assertions.fail((String)"Fault injection failed.");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                cluster.restartNameNode(new String[0]);
                if (fs == null) break block5;
            }
            catch (Throwable throwable) {
                if (fs != null) {
                    fs.close();
                }
                TestCheckpoint.cleanup(secondary);
                secondary = null;
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                throw throwable;
            }
            fs.close();
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testEditFailureBeforeRename() throws IOException {
        DistributedFileSystem fs;
        MiniDFSCluster cluster;
        block10: {
            HdfsConfiguration conf = new HdfsConfiguration();
            SecondaryNameNode secondary = null;
            cluster = null;
            fs = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                DFSTestUtil.createFile((FileSystem)fs, new Path("tmpfile0"), 1024L, (short)1, 0L);
                secondary.doCheckpoint();
                ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure before edit rename")}).when((Object)this.faultInjector)).beforeEditsRename();
                DFSTestUtil.createFile((FileSystem)fs, new Path("tmpfile1"), 1024L, (short)1, 0L);
                try {
                    secondary.doCheckpoint();
                    Assertions.fail((String)"Fault injection failed.");
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains((String)"Injecting failure before edit rename", (Throwable)ioe);
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                for (Storage.StorageDirectory sd : secondary.getFSImage().getStorage().dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                    File[] tmpEdits = sd.getCurrentDir().listFiles(tmpEditsFilter);
                    Assertions.assertTrue((tmpEdits.length == 1 ? 1 : 0) != 0, (String)("Expected a single tmp edits file in directory " + sd.toString()));
                    RandomAccessFile randFile = new RandomAccessFile(tmpEdits[0], "rw");
                    randFile.setLength(0L);
                    randFile.close();
                }
                secondary.doCheckpoint();
                if (secondary == null) break block10;
            }
            catch (Throwable throwable) {
                if (secondary != null) {
                    secondary.shutdown();
                }
                if (fs != null) {
                    fs.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                throw throwable;
            }
            secondary.shutdown();
        }
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testEditFailureOnFirstCheckpoint() throws IOException {
        DistributedFileSystem fs;
        MiniDFSCluster cluster;
        block9: {
            HdfsConfiguration conf = new HdfsConfiguration();
            SecondaryNameNode secondary = null;
            cluster = null;
            fs = null;
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                fs.mkdirs(new Path("test-file-1"));
                FSNamesystem fsns = cluster.getNamesystem();
                fsns.enterSafeMode(false);
                fsns.saveNamespace(0L, 0L);
                fsns.leaveSafeMode(false);
                secondary = this.startSecondaryNameNode((Configuration)conf);
                ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure before edit rename")}).when((Object)this.faultInjector)).beforeEditsRename();
                try {
                    secondary.doCheckpoint();
                    Assertions.fail((String)"Fault injection failed.");
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains((String)"Injecting failure before edit rename", (Throwable)ioe);
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                secondary.doCheckpoint();
                if (secondary == null) break block9;
            }
            catch (Throwable throwable) {
                if (secondary != null) {
                    secondary.shutdown();
                }
                if (fs != null) {
                    fs.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                throw throwable;
            }
            secondary.shutdown();
        }
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testDeleteTemporaryEditsOnStartup() throws IOException {
        DistributedFileSystem fs;
        MiniDFSCluster cluster;
        block11: {
            HdfsConfiguration conf = new HdfsConfiguration();
            SecondaryNameNode secondary = null;
            cluster = null;
            fs = null;
            try {
                File[] tmpEdits;
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
                cluster.waitActive();
                fs = cluster.getFileSystem();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                DFSTestUtil.createFile((FileSystem)fs, new Path("tmpfile0"), 1024L, (short)1, 0L);
                secondary.doCheckpoint();
                ((CheckpointFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Injecting failure before edit rename")}).when((Object)this.faultInjector)).beforeEditsRename();
                DFSTestUtil.createFile((FileSystem)fs, new Path("tmpfile1"), 1024L, (short)1, 0L);
                try {
                    secondary.doCheckpoint();
                    Assertions.fail((String)"Fault injection failed.");
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains((String)"Injecting failure before edit rename", (Throwable)ioe);
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                for (Storage.StorageDirectory sd : secondary.getFSImage().getStorage().dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                    tmpEdits = sd.getCurrentDir().listFiles(tmpEditsFilter);
                    Assertions.assertTrue((tmpEdits.length == 1 ? 1 : 0) != 0, (String)("Expected a single tmp edits file in directory " + sd.toString()));
                }
                secondary.shutdown();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                for (Storage.StorageDirectory sd : secondary.getFSImage().getStorage().dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                    tmpEdits = sd.getCurrentDir().listFiles(tmpEditsFilter);
                    Assertions.assertTrue((tmpEdits.length == 0 ? 1 : 0) != 0, (String)("Did not expect a tmp edits file in directory " + sd.toString()));
                }
                secondary.doCheckpoint();
                if (secondary == null) break block11;
            }
            catch (Throwable throwable) {
                if (secondary != null) {
                    secondary.shutdown();
                }
                if (fs != null) {
                    fs.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
                throw throwable;
            }
            secondary.shutdown();
        }
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
        Mockito.reset((Object[])new CheckpointFaultInjector[]{this.faultInjector});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSecondaryNNsAgainstSameNN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary1 = null;
        SecondaryNameNode secondary2 = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            secondary1 = this.startSecondaryNameNode((Configuration)conf, 1);
            secondary2 = this.startSecondaryNameNode((Configuration)conf, 2);
            SecondaryNameNode.CheckpointStorage spyImage1 = TestCheckpoint.spyOnSecondaryImage(secondary1);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
            ((SecondaryNameNode.CheckpointStorage)Mockito.doAnswer((Answer)delayer).when((Object)spyImage1)).saveFSImageInAllDirs((FSNamesystem)Mockito.any(), Mockito.anyLong());
            DoCheckpointThread checkpointThread = new DoCheckpointThread(secondary1);
            checkpointThread.start();
            delayer.waitForCall();
            secondary2.doCheckpoint();
            delayer.proceed();
            checkpointThread.join();
            checkpointThread.propagateExceptions();
            NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
            Assertions.assertEquals((long)4L, (long)storage.getMostRecentCheckpointTxId());
            FSImageTestUtil.assertNNHasCheckpoints(cluster, (List<Integer>)ImmutableList.of((Object)2, (Object)4));
            secondary2.doCheckpoint();
            Assertions.assertEquals((long)6L, (long)storage.getMostRecentCheckpointTxId());
            this.assertParallelFilesInvariant(cluster, (ImmutableList<SecondaryNameNode>)ImmutableList.of((Object)secondary1, (Object)secondary2));
            FSImageTestUtil.assertNNHasCheckpoints(cluster, (List<Integer>)ImmutableList.of((Object)4, (Object)6));
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary1);
            secondary1 = null;
            TestCheckpoint.cleanup(secondary2);
            secondary2 = null;
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary1);
        secondary1 = null;
        TestCheckpoint.cleanup(secondary2);
        secondary2 = null;
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSecondaryNNsAgainstSameNN2() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary1 = null;
        SecondaryNameNode secondary2 = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            secondary1 = this.startSecondaryNameNode((Configuration)conf, 1);
            secondary2 = this.startSecondaryNameNode((Configuration)conf, 2);
            NamenodeProtocol origNN = secondary1.getNameNode();
            GenericTestUtils.DelegateAnswer delegator = new GenericTestUtils.DelegateAnswer((Object)origNN);
            NamenodeProtocol spyNN = (NamenodeProtocol)Mockito.mock(NamenodeProtocol.class, (Answer)delegator);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG, (Answer)delegator){
                final /* synthetic */ Answer val$delegator;
                {
                    this.val$delegator = answer;
                    super(x0);
                }

                protected Object passThrough(InvocationOnMock invocation) throws Throwable {
                    return this.val$delegator.answer(invocation);
                }
            };
            secondary1.setNameNode(spyNN);
            ((NamenodeProtocol)Mockito.doAnswer((Answer)delayer).when((Object)spyNN)).getEditLogManifest(Mockito.anyLong());
            DoCheckpointThread checkpointThread = new DoCheckpointThread(secondary1);
            checkpointThread.start();
            delayer.waitForCall();
            secondary2.doCheckpoint();
            NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
            Assertions.assertEquals((long)4L, (long)storage.getMostRecentCheckpointTxId());
            delayer.proceed();
            checkpointThread.join();
            checkpointThread.propagateExceptions();
            Assertions.assertEquals((long)4L, (long)storage.getMostRecentCheckpointTxId());
            secondary2.doCheckpoint();
            Assertions.assertEquals((long)6L, (long)storage.getMostRecentCheckpointTxId());
            FSImageTestUtil.assertNNHasCheckpoints(cluster, (List<Integer>)ImmutableList.of((Object)4, (Object)6));
            secondary1.setNameNode(origNN);
            secondary1.doCheckpoint();
            Assertions.assertEquals((long)8L, (long)storage.getMostRecentCheckpointTxId());
            this.assertParallelFilesInvariant(cluster, (ImmutableList<SecondaryNameNode>)ImmutableList.of((Object)secondary1, (Object)secondary2));
            FSImageTestUtil.assertNNHasCheckpoints(cluster, (List<Integer>)ImmutableList.of((Object)6, (Object)8));
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary1);
            secondary1 = null;
            TestCheckpoint.cleanup(secondary2);
            secondary2 = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary1);
        secondary1 = null;
        TestCheckpoint.cleanup(secondary2);
        secondary2 = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReformatNNBetweenCheckpoints() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 1);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            int origPort = cluster.getNameNodePort();
            int origHttpPort = cluster.getNameNode().getHttpAddress().getPort();
            Configuration snnConf = new Configuration((Configuration)conf);
            File checkpointDir = new File(MiniDFSCluster.getBaseDirectory(), "namesecondary");
            snnConf.set("dfs.namenode.checkpoint.dir", checkpointDir.getAbsolutePath());
            secondary = this.startSecondaryNameNode(snnConf);
            secondary.doCheckpoint();
            cluster.shutdown();
            cluster = null;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).nameNodePort(origPort).nameNodeHttpPort(origHttpPort).format(true).build();
            try {
                secondary.doCheckpoint();
                Assertions.fail((String)"Should have failed checkpoint against a different namespace");
            }
            catch (IOException ioe) {
                LOG.info("Got expected failure", (Throwable)ioe);
                Assertions.assertTrue((boolean)ioe.toString().contains("Inconsistent checkpoint"));
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamespaceVerifiedOnFileTransfer() throws IOException {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            String msg;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            NamenodeProtocols nn = cluster.getNameNodeRpc();
            URL fsName = DFSUtil.getInfoServer((InetSocketAddress)cluster.getNameNode().getServiceRpcAddress(), (Configuration)conf, (String)DFSUtil.getHttpClientScheme((Configuration)conf)).toURL();
            nn.rollEditLog();
            RemoteEditLogManifest manifest = nn.getEditLogManifest(1L);
            RemoteEditLog log = (RemoteEditLog)manifest.getLogs().get(0);
            NNStorage dstImage = (NNStorage)Mockito.mock(NNStorage.class);
            ((NNStorage)Mockito.doReturn((Object)Lists.newArrayList((Object[])new File[]{new File("/wont-be-written")})).when((Object)dstImage)).getFiles((Storage.StorageDirType)Mockito.any(), Mockito.anyString());
            File mockImageFile = File.createTempFile("image", "");
            FileOutputStream imageFile = new FileOutputStream(mockImageFile);
            imageFile.write("data".getBytes());
            imageFile.close();
            ((NNStorage)Mockito.doReturn((Object)mockImageFile).when((Object)dstImage)).findImageFile((NNStorage.NameNodeFile)Mockito.any(NNStorage.NameNodeFile.class), Mockito.anyLong());
            ((NNStorage)Mockito.doReturn((Object)new StorageInfo(1, 1, "X", 1L, HdfsServerConstants.NodeType.NAME_NODE).toColonSeparatedString()).when((Object)dstImage)).toColonSeparatedString();
            try {
                TransferFsImage.downloadImageToStorage((URL)fsName, (long)0L, (Storage)dstImage, (boolean)false, (boolean)false);
                Assertions.fail((String)"Storage info was not verified");
            }
            catch (IOException ioe) {
                msg = StringUtils.stringifyException((Throwable)ioe);
                Assertions.assertTrue((boolean)msg.contains("but the secondary expected"), (String)msg);
            }
            try {
                TransferFsImage.downloadEditsToStorage((URL)fsName, (RemoteEditLog)log, (NNStorage)dstImage);
                Assertions.fail((String)"Storage info was not verified");
            }
            catch (IOException ioe) {
                msg = StringUtils.stringifyException((Throwable)ioe);
                Assertions.assertTrue((boolean)msg.contains("but the secondary expected"), (String)msg);
            }
            try {
                TransferFsImage.uploadImageFromStorage((URL)fsName, (Configuration)conf, (NNStorage)dstImage, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.IMAGE, (long)0L);
                Assertions.fail((String)"Storage info was not verified");
            }
            catch (IOException ioe) {
                msg = StringUtils.stringifyException((Throwable)ioe);
                Assertions.assertTrue((boolean)msg.contains("but the secondary expected"), (String)msg);
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testCheckpointWithFailedStorageDir() throws Exception {
        SecondaryNameNode secondary;
        MiniDFSCluster cluster;
        block3: {
            cluster = null;
            secondary = null;
            File currentDir = null;
            HdfsConfiguration conf = new HdfsConfiguration();
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                secondary.doCheckpoint();
                NamenodeProtocols nn = cluster.getNameNodeRpc();
                NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
                Storage.StorageDirectory sd0 = storage.getStorageDir(0);
                Storage.StorageDirectory sd1 = storage.getStorageDir(1);
                currentDir = sd0.getCurrentDir();
                FileUtil.setExecutable((File)currentDir, (boolean)false);
                secondary.doCheckpoint();
                GenericTestUtils.assertExists((File)new File(sd1.getCurrentDir(), NNStorage.getImageFileName((long)2L)));
                FileUtil.setExecutable((File)currentDir, (boolean)true);
                nn.restoreFailedStorage("true");
                nn.rollEditLog();
                secondary.doCheckpoint();
                FSImageTestUtil.assertNNHasCheckpoints(cluster, (List<Integer>)ImmutableList.of((Object)8));
                this.assertParallelFilesInvariant(cluster, (ImmutableList<SecondaryNameNode>)ImmutableList.of((Object)secondary));
                if (currentDir == null) break block3;
            }
            catch (Throwable throwable) {
                if (currentDir != null) {
                    FileUtil.setExecutable(currentDir, (boolean)true);
                }
                TestCheckpoint.cleanup(secondary);
                secondary = null;
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                throw throwable;
            }
            FileUtil.setExecutable((File)currentDir, (boolean)true);
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testCheckpointWithSeparateDirsAfterNameFails() throws Exception {
        SecondaryNameNode secondary;
        MiniDFSCluster cluster;
        block5: {
            cluster = null;
            secondary = null;
            File currentDir = null;
            HdfsConfiguration conf = new HdfsConfiguration();
            File base_dir = new File(MiniDFSCluster.getBaseDirectory());
            conf.setBoolean("dfs.namenode.name.dir.restore", true);
            conf.set("dfs.namenode.name.dir", MiniDFSCluster.getBaseDirectory() + "/name-only");
            conf.set("dfs.namenode.edits.dir", MiniDFSCluster.getBaseDirectory() + "/edits-only");
            conf.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(base_dir, "namesecondary1")).toString());
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).manageNameDfsDirs(false).build();
                secondary = this.startSecondaryNameNode((Configuration)conf);
                secondary.doCheckpoint();
                NamenodeProtocols nn = cluster.getNameNodeRpc();
                NNStorage storage = cluster.getNameNode().getFSImage().getStorage();
                Storage.StorageDirectory sd0 = storage.getStorageDir(0);
                Assertions.assertEquals((Object)NNStorage.NameNodeDirType.IMAGE, (Object)sd0.getStorageDirType());
                currentDir = sd0.getCurrentDir();
                Assertions.assertEquals((int)0, (int)FileUtil.chmod((String)currentDir.getAbsolutePath(), (String)"000"));
                try {
                    secondary.doCheckpoint();
                    Assertions.fail((String)"Did not fail to checkpoint when there are no valid storage dirs");
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains((String)"No targets in destination storage", (Throwable)ioe);
                }
                Assertions.assertEquals((int)0, (int)FileUtil.chmod((String)currentDir.getAbsolutePath(), (String)"755"));
                nn.restoreFailedStorage("true");
                nn.rollEditLog();
                secondary.doCheckpoint();
                FSImageTestUtil.assertNNHasCheckpoints(cluster, (List<Integer>)ImmutableList.of((Object)8));
                this.assertParallelFilesInvariant(cluster, (ImmutableList<SecondaryNameNode>)ImmutableList.of((Object)secondary));
                if (currentDir == null) break block5;
            }
            catch (Throwable throwable) {
                if (currentDir != null) {
                    FileUtil.chmod((String)currentDir.getAbsolutePath(), (String)"755");
                }
                TestCheckpoint.cleanup(secondary);
                secondary = null;
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                throw throwable;
            }
            FileUtil.chmod((String)currentDir.getAbsolutePath(), (String)"755");
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testCheckpointTriggerOnTxnCount() throws Exception {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.checkpoint.txns", 10);
        conf.setInt("dfs.namenode.checkpoint.check.period", 1);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.startCheckpointThread();
            final NNStorage storage = secondary.getFSImage().getStorage();
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    LOG.info("Waiting for checkpoint txn id to go to 2");
                    return storage.getMostRecentCheckpointTxId() == 2L;
                }
            }, (long)200L, (long)15000L);
            for (int i = 0; i < 10; ++i) {
                fs.mkdirs(new Path("/test" + i));
            }
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    LOG.info("Waiting for checkpoint txn id to go > 2");
                    return storage.getMostRecentCheckpointTxId() > 2L;
                }
            }, (long)200L, (long)15000L);
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryHasVeryOutOfDateImage() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            NamenodeProtocols nn = cluster.getNameNodeRpc();
            nn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            for (int i = 0; i < 3; ++i) {
                nn.saveNamespace(0L, 0L);
            }
            nn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            secondary.doCheckpoint();
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryPurgesEditLogs() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.num.extra.edits.retained", 0);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.mkdirs(new Path("/foo"));
            secondary = this.startSecondaryNameNode((Configuration)conf);
            for (int i = 0; i < 5; ++i) {
                secondary.doCheckpoint();
            }
            List<File> checkpointDirs = TestCheckpoint.getCheckpointCurrentDirs(secondary);
            for (File checkpointDir : checkpointDirs) {
                List editsFiles = FileJournalManager.matchEditLogs((File)checkpointDir);
                Assertions.assertEquals((int)1, (int)editsFiles.size(), (String)"Edit log files were not purged from 2NN");
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecondaryNameNodeWithDelegationTokens() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
            Assertions.assertNotNull((Object)cluster.getNamesystem().getDelegationToken(new Text("atm")));
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            cluster.getNameNodeRpc().saveNamespace(0L, 0L);
            cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            secondary.doCheckpoint();
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            secondary = null;
            TestCheckpoint.cleanup(cluster);
            cluster = null;
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
        cluster = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testSecondaryNameNodeWithSavedLeases() throws IOException {
        SecondaryNameNode secondary;
        MiniDFSCluster cluster;
        block3: {
            cluster = null;
            secondary = null;
            FSDataOutputStream fos = null;
            HdfsConfiguration conf = new HdfsConfiguration();
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).format(true).build();
                DistributedFileSystem fs = cluster.getFileSystem();
                fos = fs.create(new Path("tmpfile"));
                fos.write(new byte[]{0, 1, 2, 3});
                fos.hflush();
                Assertions.assertEquals((int)1, (int)cluster.getNamesystem().getLeaseManager().countLease());
                secondary = this.startSecondaryNameNode((Configuration)conf);
                Assertions.assertEquals((int)0, (int)secondary.getFSNamesystem().getLeaseManager().countLease());
                secondary.doCheckpoint();
                Assertions.assertEquals((int)1, (int)secondary.getFSNamesystem().getLeaseManager().countLease());
                fos.close();
                fos = null;
                cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
                cluster.getNameNodeRpc().saveNamespace(0L, 0L);
                cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
                secondary.doCheckpoint();
                Assertions.assertEquals((int)0, (int)secondary.getFSNamesystem().getLeaseManager().countLease());
                if (fos == null) break block3;
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    fos.close();
                }
                TestCheckpoint.cleanup(secondary);
                secondary = null;
                TestCheckpoint.cleanup(cluster);
                cluster = null;
                throw throwable;
            }
            fos.close();
        }
        TestCheckpoint.cleanup(secondary);
        secondary = null;
        TestCheckpoint.cleanup(cluster);
    }

    @Test
    public void testCommandLineParsing() throws ParseException {
        SecondaryNameNode.CommandLineOpts opts = new SecondaryNameNode.CommandLineOpts();
        opts.parse(new String[0]);
        Assertions.assertNull((Object)opts.getCommand());
        opts.parse(new String[]{"-checkpoint"});
        Assertions.assertEquals((Object)SecondaryNameNode.CommandLineOpts.Command.CHECKPOINT, (Object)opts.getCommand());
        Assertions.assertFalse((boolean)opts.shouldForceCheckpoint());
        opts.parse(new String[]{"-checkpoint", "force"});
        Assertions.assertEquals((Object)SecondaryNameNode.CommandLineOpts.Command.CHECKPOINT, (Object)opts.getCommand());
        Assertions.assertTrue((boolean)opts.shouldForceCheckpoint());
        opts.parse(new String[]{"-geteditsize"});
        Assertions.assertEquals((Object)SecondaryNameNode.CommandLineOpts.Command.GETEDITSIZE, (Object)opts.getCommand());
        opts.parse(new String[]{"-format"});
        Assertions.assertTrue((boolean)opts.shouldFormat());
        try {
            opts.parse(new String[]{"-geteditsize", "-checkpoint"});
            Assertions.fail((String)"Should have failed bad parsing for two actions");
        }
        catch (ParseException e) {
            LOG.warn("Encountered ", (Throwable)e);
        }
        try {
            opts.parse(new String[]{"-checkpoint", "xx"});
            Assertions.fail((String)"Should have failed for bad checkpoint arg");
        }
        catch (ParseException e) {
            LOG.warn("Encountered ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLegacyOivImage() throws Exception {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        File tmpDir = GenericTestUtils.getTestDir((String)"testLegacyOivImage");
        tmpDir.mkdirs();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.legacy-oiv-image.dir", tmpDir.getAbsolutePath());
        conf.set("dfs.namenode.num.checkpoints.retained", "2");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            secondary = this.startSecondaryNameNode((Configuration)conf);
            secondary.doCheckpoint();
            String[] files1 = tmpDir.list();
            Assertions.assertEquals((int)1, (int)files1.length, (String)"Only one file is expected");
            secondary.doCheckpoint();
            secondary.doCheckpoint();
            String[] files2 = tmpDir.list();
            Assertions.assertEquals((int)2, (int)files2.length, (String)"Two files are expected");
            for (String fName : files2) {
                Assertions.assertFalse((boolean)fName.equals(files1[0]));
            }
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            TestCheckpoint.cleanup(cluster);
            tmpDir.delete();
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        TestCheckpoint.cleanup(cluster);
        tmpDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=300L)
    public void testActiveRejectSmallerTxidDeltaImage() throws Exception {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.checkpoint.txns", 10);
        conf.setInt("dfs.namenode.checkpoint.period", 900000);
        SecondaryNameNode secondary = null;
        try {
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            NameNode active = cluster.getNameNode();
            active.httpServer.getHttpServer().setAttribute("recent.image.check.enabled", (Object)true);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            DistributedFileSystem fs = cluster.getFileSystem();
            Assertions.assertEquals((long)0L, (long)active.getNamesystem().getFSImage().getMostRecentCheckpointTxId());
            for (i = 0; i < 5; ++i) {
                fs.mkdirs(new Path("dir-" + i));
            }
            secondary.doCheckpoint();
            Assertions.assertEquals((long)0L, (long)active.getNamesystem().getFSImage().getMostRecentCheckpointTxId());
            for (i = 0; i < 10; ++i) {
                fs.mkdirs(new Path("dir2-" + i));
            }
            secondary.doCheckpoint();
            Assertions.assertEquals((long)21L, (long)active.getNamesystem().getFSImage().getMostRecentCheckpointTxId());
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            TestCheckpoint.cleanup(cluster);
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
        TestCheckpoint.cleanup(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActiveImageWithTimeDeltaRelaxation() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.checkpoint.txns", 1000000);
        conf.setInt("dfs.namenode.checkpoint.period", 900000);
        ImageServlet.setRecentImageCheckTimePrecision((double)0.0);
        SecondaryNameNode secondary = null;
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();){
            NameNode active = cluster.getNameNode();
            active.httpServer.getHttpServer().setAttribute("recent.image.check.enabled", (Object)true);
            secondary = this.startSecondaryNameNode((Configuration)conf);
            DistributedFileSystem fs = cluster.getFileSystem();
            Assertions.assertEquals((long)0L, (long)active.getNamesystem().getFSImage().getMostRecentCheckpointTxId());
            for (int i = 0; i < 5; ++i) {
                fs.mkdirs(new Path("dir-" + i));
            }
            secondary.doCheckpoint();
            Assertions.assertEquals((long)9L, (long)active.getNamesystem().getFSImage().getMostRecentCheckpointTxId());
        }
        catch (Throwable throwable) {
            TestCheckpoint.cleanup(secondary);
            throw throwable;
        }
        TestCheckpoint.cleanup(secondary);
    }

    private static void cleanup(SecondaryNameNode snn) {
        if (snn != null) {
            try {
                snn.shutdown();
            }
            catch (Exception e) {
                LOG.warn("Could not shut down secondary namenode", (Throwable)e);
            }
        }
    }

    private static void cleanup(MiniDFSCluster cluster) {
        if (cluster != null) {
            try {
                cluster.shutdown();
            }
            catch (Exception e) {
                LOG.warn("Could not shutdown MiniDFSCluster ", (Throwable)e);
            }
        }
    }

    private void assertParallelFilesInvariant(MiniDFSCluster cluster, ImmutableList<SecondaryNameNode> secondaries) throws Exception {
        ArrayList allCurrentDirs = Lists.newArrayList();
        allCurrentDirs.addAll(FSImageTestUtil.getNameNodeCurrentDirs(cluster, 0));
        for (SecondaryNameNode snn : secondaries) {
            allCurrentDirs.addAll(TestCheckpoint.getCheckpointCurrentDirs(snn));
        }
        FSImageTestUtil.assertParallelFilesAreIdentical(allCurrentDirs, (Set<String>)ImmutableSet.of((Object)"VERSION"));
    }

    private static List<File> getCheckpointCurrentDirs(SecondaryNameNode secondary) {
        ArrayList ret = Lists.newArrayList();
        for (String u : secondary.getCheckpointDirectories()) {
            File checkpointDir = new File(URI.create(u).getPath());
            ret.add(new File(checkpointDir, "current"));
        }
        return ret;
    }

    private static SecondaryNameNode.CheckpointStorage spyOnSecondaryImage(SecondaryNameNode secondary1) {
        SecondaryNameNode.CheckpointStorage spy = (SecondaryNameNode.CheckpointStorage)Mockito.spy((Object)((SecondaryNameNode.CheckpointStorage)secondary1.getFSImage()));
        secondary1.setFSImage(spy);
        return spy;
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSImage.LOG, (Level)Level.TRACE);
        LOG = LoggerFactory.getLogger(TestCheckpoint.class);
        tmpEditsFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.NameNodeFile.EDITS_TMP.getName());
            }
        };
    }

    private static class DoCheckpointThread
    extends Thread {
        private final SecondaryNameNode snn;
        private volatile Throwable thrown = null;

        DoCheckpointThread(SecondaryNameNode snn) {
            this.snn = snn;
        }

        @Override
        public void run() {
            try {
                this.snn.doCheckpoint();
            }
            catch (Throwable t) {
                this.thrown = t;
            }
        }

        void propagateExceptions() {
            if (this.thrown != null) {
                throw new RuntimeException(this.thrown);
            }
        }
    }
}

