/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.CacheDirective;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveIterator;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveStats;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolStats;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.util.GSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCacheDirectives {
    static final Logger LOG = LoggerFactory.getLogger(TestCacheDirectives.class);
    private static final UserGroupInformation unprivilegedUser = UserGroupInformation.createRemoteUser((String)"unprivilegedUser");
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static NamenodeProtocols proto;
    private static NameNode namenode;
    private static NativeIO.POSIX.CacheManipulator prevCacheManipulator;
    private static final long BLOCK_SIZE = 4096L;
    private static final int NUM_DATANODES = 4;
    private static final long CACHE_CAPACITY = 16384L;

    private static HdfsConfiguration createCachingConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 4096L);
        conf.setLong("dfs.datanode.max.locked.memory", 16384L);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.cachereport.intervalMsec", 1000L);
        conf.setLong("dfs.namenode.path.based.cache.refresh.interval.ms", 1000L);
        conf.setInt("dfs.namenode.list.cache.pools.num.responses", 2);
        conf.setInt("dfs.namenode.list.cache.directives.num.responses", 2);
        return conf;
    }

    Configuration getConf() {
        return conf;
    }

    @BeforeEach
    public void setup() throws Exception {
        conf = TestCacheDirectives.createCachingConf();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).build();
        cluster.waitActive();
        dfs = this.getDFS();
        proto = cluster.getNameNodeRpc();
        namenode = cluster.getNameNode();
        prevCacheManipulator = NativeIO.POSIX.getCacheManipulator();
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.NoMlockCacheManipulator());
        BlockReaderTestUtil.enableHdfsCachingTracing();
    }

    DistributedFileSystem getDFS() throws IOException {
        return (DistributedFileSystem)FileSystem.get((Configuration)conf);
    }

    @AfterEach
    public void teardown() throws Exception {
        RemoteIterator iter = dfs.listCacheDirectives(null);
        while (iter.hasNext()) {
            dfs.removeCacheDirective(((CacheDirectiveEntry)iter.next()).getInfo().getId().longValue());
        }
        TestCacheDirectives.waitForCachedBlocks(cluster.getNameNode(), 0, 0, "teardown");
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)prevCacheManipulator);
    }

    @Test
    @Timeout(value=60L)
    public void testBasicPoolOperations() throws Exception {
        String poolName = "pool1";
        CachePoolInfo info = new CachePoolInfo("pool1").setOwnerName("bob").setGroupName("bobgroup").setMode(new FsPermission(493)).setLimit(Long.valueOf(150L));
        dfs.addCachePool(info);
        try {
            dfs.addCachePool(info);
            Assertions.fail((String)"added the pool with the same name twice");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"pool1 already exists", (Throwable)ioe);
        }
        try {
            dfs.addCachePool(new CachePoolInfo(""));
            Assertions.fail((String)"added empty pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            dfs.addCachePool(null);
            Assertions.fail((String)"added null pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"CachePoolInfo is null", (Throwable)ioe);
        }
        try {
            proto.addCachePool(new CachePoolInfo(""));
            Assertions.fail((String)"added empty pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            proto.addCachePool(null);
            Assertions.fail((String)"added null pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"CachePoolInfo is null", (Throwable)ioe);
        }
        info.setOwnerName("jane").setGroupName("janegroup").setMode(new FsPermission(448)).setLimit(Long.valueOf(314L));
        dfs.modifyCachePool(info);
        try {
            dfs.modifyCachePool(new CachePoolInfo("fool"));
            Assertions.fail((String)"modified non-existent cache pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"fool does not exist", (Throwable)ioe);
        }
        try {
            dfs.modifyCachePool(new CachePoolInfo(""));
            Assertions.fail((String)"modified empty pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            dfs.modifyCachePool(null);
            Assertions.fail((String)"modified null pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"CachePoolInfo is null", (Throwable)ioe);
        }
        try {
            proto.modifyCachePool(new CachePoolInfo(""));
            Assertions.fail((String)"modified empty pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            proto.modifyCachePool(null);
            Assertions.fail((String)"modified null pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"CachePoolInfo is null", (Throwable)ioe);
        }
        dfs.removeCachePool("pool1");
        try {
            dfs.removeCachePool("pool99");
            Assertions.fail((String)"expected to get an exception when removing a non-existent pool.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot remove non-existent cache pool", (Throwable)ioe);
        }
        try {
            dfs.removeCachePool("pool1");
            Assertions.fail((String)"expected to get an exception when removing a non-existent pool.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot remove non-existent cache pool", (Throwable)ioe);
        }
        try {
            dfs.removeCachePool("");
            Assertions.fail((String)"removed empty pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            dfs.removeCachePool(null);
            Assertions.fail((String)"removed null pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            proto.removeCachePool("");
            Assertions.fail((String)"removed empty pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        try {
            proto.removeCachePool(null);
            Assertions.fail((String)"removed null pool");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"invalid empty cache pool name", (Throwable)ioe);
        }
        info = new CachePoolInfo("pool2");
        dfs.addCachePool(info);
        DistributedFileSystem dfs1 = (DistributedFileSystem)cluster.getNewFileSystemInstance(0);
        dfs1.close();
        try {
            dfs1.listCachePools();
            Assertions.fail((String)"listCachePools using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfs1.addCachePool(info);
            Assertions.fail((String)"addCachePool using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfs1.modifyCachePool(info);
            Assertions.fail((String)"modifyCachePool using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfs1.removeCachePool("pool1");
            Assertions.fail((String)"removeCachePool using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testCreateAndModifyPools() throws Exception {
        String poolName = "pool1";
        String ownerName = "abc";
        String groupName = "123";
        FsPermission mode = new FsPermission(493);
        long limit = 150L;
        dfs.addCachePool(new CachePoolInfo(poolName).setOwnerName(ownerName).setGroupName(groupName).setMode(mode).setLimit(Long.valueOf(limit)));
        RemoteIterator iter = dfs.listCachePools();
        CachePoolInfo info = ((CachePoolEntry)iter.next()).getInfo();
        Assertions.assertEquals((Object)poolName, (Object)info.getPoolName());
        Assertions.assertEquals((Object)ownerName, (Object)info.getOwnerName());
        Assertions.assertEquals((Object)groupName, (Object)info.getGroupName());
        ownerName = "def";
        groupName = "456";
        mode = new FsPermission(448);
        limit = 151L;
        dfs.modifyCachePool(new CachePoolInfo(poolName).setOwnerName(ownerName).setGroupName(groupName).setMode(mode).setLimit(Long.valueOf(limit)));
        iter = dfs.listCachePools();
        info = ((CachePoolEntry)iter.next()).getInfo();
        Assertions.assertEquals((Object)poolName, (Object)info.getPoolName());
        Assertions.assertEquals((Object)ownerName, (Object)info.getOwnerName());
        Assertions.assertEquals((Object)groupName, (Object)info.getGroupName());
        Assertions.assertEquals((Object)mode, (Object)info.getMode());
        Assertions.assertEquals((long)limit, (long)info.getLimit());
        dfs.removeCachePool(poolName);
        iter = dfs.listCachePools();
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"expected no cache pools after deleting pool");
        proto.listCachePools(null);
        try {
            proto.removeCachePool("pool99");
            Assertions.fail((String)"expected to get an exception when removing a non-existent pool.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot remove non-existent", (Throwable)ioe);
        }
        try {
            proto.removeCachePool(poolName);
            Assertions.fail((String)"expected to get an exception when removing a non-existent pool.");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot remove non-existent", (Throwable)ioe);
        }
        iter = dfs.listCachePools();
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"expected no cache pools after deleting pool");
    }

    private static void validateListAll(RemoteIterator<CacheDirectiveEntry> iter, Long ... ids) throws Exception {
        for (Long id : ids) {
            Assertions.assertTrue((boolean)iter.hasNext(), (String)"Unexpectedly few elements");
            Assertions.assertEquals((Long)id, (Long)((CacheDirectiveEntry)iter.next()).getInfo().getId(), (String)"Unexpected directive ID");
        }
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"Unexpectedly many list elements");
    }

    private static long addAsUnprivileged(final CacheDirectiveInfo directive) throws Exception {
        return (Long)unprivilegedUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws IOException {
                DistributedFileSystem myDfs = (DistributedFileSystem)FileSystem.get((Configuration)conf);
                return myDfs.addCacheDirective(directive);
            }
        });
    }

    @Test
    @Timeout(value=60L)
    public void testAddRemoveDirectives() throws Exception {
        proto.addCachePool(new CachePoolInfo("pool1").setMode(new FsPermission(511)));
        proto.addCachePool(new CachePoolInfo("pool2").setMode(new FsPermission(511)));
        proto.addCachePool(new CachePoolInfo("pool3").setMode(new FsPermission(511)));
        proto.addCachePool(new CachePoolInfo("pool4").setMode(new FsPermission(0)));
        proto.addCachePool(new CachePoolInfo("pool5").setMode(new FsPermission(7)).setOwnerName(unprivilegedUser.getShortUserName()));
        CacheDirectiveInfo alpha = new CacheDirectiveInfo.Builder().setPath(new Path("/alpha")).setPool("pool1").build();
        CacheDirectiveInfo beta = new CacheDirectiveInfo.Builder().setPath(new Path("/beta")).setPool("pool2").build();
        CacheDirectiveInfo delta = new CacheDirectiveInfo.Builder().setPath(new Path("/delta")).setPool("pool1").build();
        long alphaId = TestCacheDirectives.addAsUnprivileged(alpha);
        long alphaId2 = TestCacheDirectives.addAsUnprivileged(alpha);
        Assertions.assertFalse((alphaId == alphaId2 ? 1 : 0) != 0, (String)"Expected to get unique directives when re-adding an existing CacheDirectiveInfo");
        long betaId = TestCacheDirectives.addAsUnprivileged(beta);
        try {
            TestCacheDirectives.addAsUnprivileged(new CacheDirectiveInfo.Builder().setPath(new Path("/unicorn")).setPool("no_such_pool").build());
            Assertions.fail((String)"expected an error when adding to a non-existent pool.");
        }
        catch (InvalidRequestException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Unknown pool", (Throwable)ioe);
        }
        try {
            TestCacheDirectives.addAsUnprivileged(new CacheDirectiveInfo.Builder().setPath(new Path("/blackhole")).setPool("pool4").build());
            Assertions.fail((String)"expected an error when adding to a pool with mode 0 (no permissions for anyone).");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied while accessing pool", (Throwable)e);
        }
        try {
            TestCacheDirectives.addAsUnprivileged(new CacheDirectiveInfo.Builder().setPath(new Path("/illegal:path/")).setPool("pool1").build());
            Assertions.fail((String)"expected an error when adding a malformed path to the cache directives.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"is not a valid DFS filename", (Throwable)e);
        }
        try {
            TestCacheDirectives.addAsUnprivileged(new CacheDirectiveInfo.Builder().setPath(new Path("/emptypoolname")).setReplication(Short.valueOf((short)1)).setPool("").build());
            Assertions.fail((String)"expected an error when adding a cache directive with an empty pool name.");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid empty pool name", (Throwable)e);
        }
        long deltaId = TestCacheDirectives.addAsUnprivileged(delta);
        try {
            TestCacheDirectives.addAsUnprivileged(new CacheDirectiveInfo.Builder().setPath(new Path("/epsilon")).setPool("pool5").build());
            Assertions.fail((String)"expected an error when adding to a pool with mode 007 (no permissions for pool owner).");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied while accessing pool", (Throwable)e);
        }
        long relativeId = TestCacheDirectives.addAsUnprivileged(new CacheDirectiveInfo.Builder().setPath(new Path("relative")).setPool("pool1").build());
        RemoteIterator iter = dfs.listCacheDirectives(null);
        TestCacheDirectives.validateListAll((RemoteIterator<CacheDirectiveEntry>)iter, alphaId, alphaId2, betaId, deltaId, relativeId);
        iter = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool("pool3").build());
        Assertions.assertFalse((boolean)iter.hasNext());
        iter = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool("pool1").build());
        TestCacheDirectives.validateListAll((RemoteIterator<CacheDirectiveEntry>)iter, alphaId, alphaId2, deltaId, relativeId);
        iter = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool("pool2").build());
        TestCacheDirectives.validateListAll((RemoteIterator<CacheDirectiveEntry>)iter, betaId);
        iter = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setId(Long.valueOf(alphaId2)).build());
        TestCacheDirectives.validateListAll((RemoteIterator<CacheDirectiveEntry>)iter, alphaId2);
        iter = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setId(Long.valueOf(relativeId)).build());
        TestCacheDirectives.validateListAll((RemoteIterator<CacheDirectiveEntry>)iter, relativeId);
        dfs.removeCacheDirective(betaId);
        iter = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool("pool2").build());
        Assertions.assertFalse((boolean)iter.hasNext());
        try {
            dfs.removeCacheDirective(betaId);
            Assertions.fail((String)"expected an error when removing a non-existent ID");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"No directive with ID", (Throwable)e);
        }
        try {
            proto.removeCacheDirective(-42L);
            Assertions.fail((String)"expected an error when removing a negative ID");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid negative ID", (Throwable)e);
        }
        try {
            proto.removeCacheDirective(43L);
            Assertions.fail((String)"expected an error when removing a non-existent ID");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"No directive with ID", (Throwable)e);
        }
        dfs.removeCacheDirective(alphaId);
        dfs.removeCacheDirective(alphaId2);
        dfs.removeCacheDirective(deltaId);
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(relativeId)).setReplication(Short.valueOf((short)555)).build());
        iter = dfs.listCacheDirectives(null);
        Assertions.assertTrue((boolean)iter.hasNext());
        CacheDirectiveInfo modified = ((CacheDirectiveEntry)iter.next()).getInfo();
        Assertions.assertEquals((long)relativeId, (long)modified.getId());
        Assertions.assertEquals((short)555, (short)modified.getReplication());
        dfs.removeCacheDirective(relativeId);
        iter = dfs.listCacheDirectives(null);
        Assertions.assertFalse((boolean)iter.hasNext());
        CacheDirectiveInfo directive = new CacheDirectiveInfo.Builder().setPath(new Path(".")).setPool("pool1").build();
        long id = dfs.addCacheDirective(directive);
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(directive).setId(Long.valueOf(id)).setReplication(Short.valueOf((short)2)).build());
        dfs.removeCacheDirective(id);
        DistributedFileSystem dfs1 = (DistributedFileSystem)cluster.getNewFileSystemInstance(0);
        dfs1.close();
        try {
            dfs1.listCacheDirectives(null);
            Assertions.fail((String)"listCacheDirectives using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfs1.addCacheDirective(alpha);
            Assertions.fail((String)"addCacheDirective using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfs1.modifyCacheDirective(alpha);
            Assertions.fail((String)"modifyCacheDirective using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
        try {
            dfs1.removeCacheDirective(alphaId);
            Assertions.fail((String)"removeCacheDirective using a closed filesystem!");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Filesystem closed", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testCacheManagerRestart() throws Exception {
        SecondaryNameNode secondary = null;
        try {
            conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
            secondary = new SecondaryNameNode(conf);
            String pool = "poolparty";
            String groupName = "partygroup";
            FsPermission mode = new FsPermission(511);
            long limit = 747L;
            long maxExpiry = 1234567890L;
            dfs.addCachePool(new CachePoolInfo("poolparty").setGroupName(groupName).setMode(mode).setLimit(Long.valueOf(limit)).setMaxRelativeExpiryMs(Long.valueOf(maxExpiry)));
            RemoteIterator pit = dfs.listCachePools();
            Assertions.assertTrue((boolean)pit.hasNext(), (String)"No cache pools found");
            CachePoolInfo info = ((CachePoolEntry)pit.next()).getInfo();
            Assertions.assertEquals((Object)"poolparty", (Object)info.getPoolName());
            Assertions.assertEquals((Object)groupName, (Object)info.getGroupName());
            Assertions.assertEquals((Object)mode, (Object)info.getMode());
            Assertions.assertEquals((long)limit, (long)info.getLimit());
            Assertions.assertEquals((long)maxExpiry, (long)info.getMaxRelativeExpiryMs());
            Assertions.assertFalse((boolean)pit.hasNext(), (String)"Unexpected # of cache pools found");
            int numEntries = 10;
            String entryPrefix = "/party-";
            long prevId = -1L;
            Date expiry = new Date();
            for (int i = 0; i < numEntries; ++i) {
                prevId = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path(entryPrefix + i)).setPool("poolparty").setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((long)expiry.getTime())).build());
            }
            RemoteIterator dit = dfs.listCacheDirectives(null);
            for (int i = 0; i < numEntries; ++i) {
                Assertions.assertTrue((boolean)dit.hasNext(), (String)("Unexpected # of cache entries: " + i));
                CacheDirectiveInfo cd = ((CacheDirectiveEntry)dit.next()).getInfo();
                Assertions.assertEquals((long)(i + 1), (long)cd.getId());
                Assertions.assertEquals((Object)(entryPrefix + i), (Object)cd.getPath().toUri().getPath());
                Assertions.assertEquals((Object)"poolparty", (Object)cd.getPool());
            }
            Assertions.assertFalse((boolean)dit.hasNext(), (String)"Unexpected # of cache directives found");
            secondary.doCheckpoint();
            String imagePool = "imagePool";
            dfs.addCachePool(new CachePoolInfo("imagePool"));
            prevId = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path("/image")).setPool("imagePool").build());
            dfs.setSafeMode(SafeModeAction.ENTER);
            dfs.saveNamespace();
            dfs.setSafeMode(SafeModeAction.LEAVE);
            boolean fetchImage = secondary.doCheckpoint();
            Assertions.assertTrue((boolean)fetchImage, (String)"Secondary should have fetched a new fsimage from NameNode");
            dfs.removeCachePool("imagePool");
            cluster.restartNameNode(new String[0]);
            pit = dfs.listCachePools();
            Assertions.assertTrue((boolean)pit.hasNext(), (String)"No cache pools found");
            info = ((CachePoolEntry)pit.next()).getInfo();
            Assertions.assertEquals((Object)"poolparty", (Object)info.getPoolName());
            Assertions.assertEquals((Object)"poolparty", (Object)info.getPoolName());
            Assertions.assertEquals((Object)groupName, (Object)info.getGroupName());
            Assertions.assertEquals((Object)mode, (Object)info.getMode());
            Assertions.assertEquals((long)limit, (long)info.getLimit());
            Assertions.assertEquals((long)maxExpiry, (long)info.getMaxRelativeExpiryMs());
            Assertions.assertFalse((boolean)pit.hasNext(), (String)"Unexpected # of cache pools found");
            dit = dfs.listCacheDirectives(null);
            for (int i = 0; i < numEntries; ++i) {
                Assertions.assertTrue((boolean)dit.hasNext(), (String)("Unexpected # of cache entries: " + i));
                CacheDirectiveInfo cd = ((CacheDirectiveEntry)dit.next()).getInfo();
                Assertions.assertEquals((long)(i + 1), (long)cd.getId());
                Assertions.assertEquals((Object)(entryPrefix + i), (Object)cd.getPath().toUri().getPath());
                Assertions.assertEquals((Object)"poolparty", (Object)cd.getPool());
                Assertions.assertEquals((long)expiry.getTime(), (long)cd.getExpiration().getMillis());
            }
            Assertions.assertFalse((boolean)dit.hasNext(), (String)"Unexpected # of cache directives found");
            long nextId = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path("/foobar")).setPool("poolparty").build());
            Assertions.assertEquals((long)(prevId + 1L), (long)nextId);
        }
        finally {
            if (secondary != null) {
                secondary.shutdown();
            }
        }
    }

    private static void waitForCachedBlocks(NameNode nn, final int expectedCachedBlocks, final int expectedCachedReplicas, final String logString) throws Exception {
        String bpid = nn.getNamesystem().getBlockPoolId();
        NamenodeProtocols nnRpc = nn.getRpcServer();
        Thread.sleep(5000L);
        for (DataNode dn : cluster.getDataNodes()) {
            if (dn.getFSDataset() == null || dn.getFSDataset().getCacheUsed() != 0L) continue;
            nnRpc.cacheReport(dn.getDNRegistrationForBP(bpid), bpid, Collections.emptyList());
        }
        final FSNamesystem namesystem = nn.getNamesystem();
        final CacheManager cacheManager = namesystem.getCacheManager();
        LOG.info("Waiting for " + expectedCachedBlocks + " blocks with " + expectedCachedReplicas + " replicas.");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean get() {
                int numCachedBlocks = 0;
                int numCachedReplicas = 0;
                namesystem.readLock(RwLockMode.BM);
                try {
                    GSet cachedBlocks = cacheManager.getCachedBlocks();
                    if (cachedBlocks != null) {
                        for (CachedBlock cachedBlock : cachedBlocks) {
                            ++numCachedBlocks;
                            numCachedReplicas += cachedBlock.getDatanodes(DatanodeDescriptor.CachedBlocksList.Type.CACHED).size();
                        }
                    }
                }
                finally {
                    namesystem.readUnlock(RwLockMode.BM, "checkBlocks");
                }
                LOG.info(logString + " cached blocks: have " + numCachedBlocks + " / " + expectedCachedBlocks + ".  cached replicas: have " + numCachedReplicas + " / " + expectedCachedReplicas);
                if (!(expectedCachedBlocks != -1 && numCachedBlocks != expectedCachedBlocks || expectedCachedReplicas != -1 && numCachedReplicas != expectedCachedReplicas)) {
                    return true;
                }
                return false;
            }
        }, (long)500L, (long)60000L);
    }

    private static void waitForCacheDirectiveStats(final DistributedFileSystem dfs, final long targetBytesNeeded, final long targetBytesCached, final long targetFilesNeeded, final long targetFilesCached, final CacheDirectiveInfo filter, final String infoString) throws Exception {
        LOG.info("Polling listCacheDirectives " + (filter == null ? "ALL" : filter.toString()) + " for " + targetBytesNeeded + " targetBytesNeeded, " + targetBytesCached + " targetBytesCached, " + targetFilesNeeded + " targetFilesNeeded, " + targetFilesCached + " targetFilesCached");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                RemoteIterator iter = null;
                CacheDirectiveEntry entry = null;
                try {
                    iter = dfs.listCacheDirectives(filter);
                    entry = (CacheDirectiveEntry)iter.next();
                }
                catch (IOException e) {
                    Assertions.fail((String)("got IOException while calling listCacheDirectives: " + e.getMessage()));
                }
                Assertions.assertNotNull((Object)entry);
                CacheDirectiveStats stats = entry.getStats();
                if (targetBytesNeeded == stats.getBytesNeeded() && targetBytesCached == stats.getBytesCached() && targetFilesNeeded == stats.getFilesNeeded() && targetFilesCached == stats.getFilesCached()) {
                    return true;
                }
                LOG.info(infoString + ": filesNeeded: " + stats.getFilesNeeded() + "/" + targetFilesNeeded + ", filesCached: " + stats.getFilesCached() + "/" + targetFilesCached + ", bytesNeeded: " + stats.getBytesNeeded() + "/" + targetBytesNeeded + ", bytesCached: " + stats.getBytesCached() + "/" + targetBytesCached);
                return false;
            }
        }, (long)500L, (long)60000L);
    }

    private static void waitForCachePoolStats(final DistributedFileSystem dfs, final long targetBytesNeeded, final long targetBytesCached, final long targetFilesNeeded, final long targetFilesCached, final CachePoolInfo pool, final String infoString) throws Exception {
        LOG.info("Polling listCachePools " + pool.toString() + " for " + targetBytesNeeded + " targetBytesNeeded, " + targetBytesCached + " targetBytesCached, " + targetFilesNeeded + " targetFilesNeeded, " + targetFilesCached + " targetFilesCached");
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                block6: {
                    CachePoolEntry entry;
                    RemoteIterator iter = null;
                    try {
                        iter = dfs.listCachePools();
                    }
                    catch (IOException e) {
                        Assertions.fail((String)("got IOException while calling listCachePools: " + e.getMessage()));
                    }
                    do {
                        entry = null;
                        try {
                            if (!iter.hasNext()) break block6;
                            entry = (CachePoolEntry)iter.next();
                        }
                        catch (IOException e) {
                            Assertions.fail((String)("got IOException while iterating through listCachePools: " + e.getMessage()));
                        }
                        if (entry == null) break block6;
                    } while (!entry.getInfo().getPoolName().equals(pool.getPoolName()));
                    CachePoolStats stats = entry.getStats();
                    if (targetBytesNeeded == stats.getBytesNeeded() && targetBytesCached == stats.getBytesCached() && targetFilesNeeded == stats.getFilesNeeded() && targetFilesCached == stats.getFilesCached()) {
                        return true;
                    }
                    LOG.info(infoString + ": filesNeeded: " + stats.getFilesNeeded() + "/" + targetFilesNeeded + ", filesCached: " + stats.getFilesCached() + "/" + targetFilesCached + ", bytesNeeded: " + stats.getBytesNeeded() + "/" + targetBytesNeeded + ", bytesCached: " + stats.getBytesCached() + "/" + targetBytesCached);
                    return false;
                }
                return false;
            }
        }, (long)500L, (long)60000L);
    }

    private static void checkNumCachedReplicas(DistributedFileSystem dfs, List<Path> paths, int expectedBlocks, int expectedReplicas) throws Exception {
        int numCachedBlocks = 0;
        int numCachedReplicas = 0;
        for (Path p : paths) {
            FileStatus f = dfs.getFileStatus(p);
            long len = f.getLen();
            long blockSize = f.getBlockSize();
            long numBlocks = (len + blockSize - 1L) / blockSize;
            BlockLocation[] locs = dfs.getFileBlockLocations(p, 0L, len);
            Assertions.assertEquals((long)numBlocks, (long)locs.length, (String)("Unexpected number of block locations for path " + p));
            for (BlockLocation l : locs) {
                if (l.getCachedHosts().length > 0) {
                    ++numCachedBlocks;
                }
                numCachedReplicas += l.getCachedHosts().length;
            }
        }
        LOG.info("Found " + numCachedBlocks + " of " + expectedBlocks + " blocks");
        LOG.info("Found " + numCachedReplicas + " of " + expectedReplicas + " replicas");
        Assertions.assertEquals((int)expectedBlocks, (int)numCachedBlocks, (String)"Unexpected number of cached blocks");
        Assertions.assertEquals((int)expectedReplicas, (int)numCachedReplicas, (String)"Unexpected number of cached replicas");
    }

    @Test
    @Timeout(value=120L)
    public void testWaitForCachedReplicas() throws Exception {
        FileSystemTestHelper helper = new FileSystemTestHelper();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return namenode.getNamesystem().getCacheCapacity() == 65536L && namenode.getNamesystem().getCacheUsed() == 0L;
            }
        }, (long)500L, (long)60000L);
        NamenodeProtocols nnRpc = namenode.getRpcServer();
        DataNode dn0 = cluster.getDataNodes().get(0);
        String bpid = cluster.getNamesystem().getBlockPoolId();
        LinkedList<Long> bogusBlockIds = new LinkedList<Long>();
        bogusBlockIds.add(999999L);
        nnRpc.cacheReport(dn0.getDNRegistrationForBP(bpid), bpid, bogusBlockIds);
        Path rootDir = helper.getDefaultWorkingDirectory((FileSystem)dfs);
        String pool = "friendlyPool";
        nnRpc.addCachePool(new CachePoolInfo("friendlyPool"));
        int numFiles = 2;
        int numBlocksPerFile = 2;
        ArrayList<String> paths = new ArrayList<String>(2);
        for (int i = 0; i < 2; ++i) {
            Path p = new Path(rootDir, "testCachePaths-" + i);
            FileSystemTestHelper.createFile((FileSystem)dfs, (Path)p, (int)2, (int)4096);
            paths.add(p.toUri().getPath());
        }
        TestCacheDirectives.waitForCachedBlocks(namenode, 0, 0, "testWaitForCachedReplicas:0");
        int expected = 0;
        for (int i = 0; i < 2; ++i) {
            CacheDirectiveInfo directive = new CacheDirectiveInfo.Builder().setPath(new Path((String)paths.get(i))).setPool("friendlyPool").build();
            nnRpc.addCacheDirective(directive, EnumSet.noneOf(CacheFlag.class));
            TestCacheDirectives.waitForCachedBlocks(namenode, expected += 2, expected, "testWaitForCachedReplicas:1");
        }
        DatanodeInfo[] live = dfs.getDataNodeStats(HdfsConstants.DatanodeReportType.LIVE);
        Assertions.assertEquals((int)4, (int)live.length, (String)"Unexpected number of live nodes");
        long totalUsed = 0L;
        for (DatanodeInfo dn : live) {
            long cacheCapacity = dn.getCacheCapacity();
            long cacheUsed = dn.getCacheUsed();
            long cacheRemaining = dn.getCacheRemaining();
            Assertions.assertEquals((long)16384L, (long)cacheCapacity, (String)"Unexpected cache capacity");
            Assertions.assertEquals((long)cacheCapacity, (long)(cacheUsed + cacheRemaining), (String)"Capacity not equal to used + remaining");
            Assertions.assertEquals((long)(cacheCapacity - cacheUsed), (long)cacheRemaining, (String)"Remaining not equal to capacity - used");
            totalUsed += cacheUsed;
        }
        Assertions.assertEquals((long)((long)expected * 4096L), (long)totalUsed);
        CacheDirectiveIterator entries = new CacheDirectiveIterator((ClientProtocol)nnRpc, null, FsTracer.get((Configuration)conf));
        for (int i = 0; i < 2; ++i) {
            CacheDirectiveEntry entry = (CacheDirectiveEntry)entries.next();
            nnRpc.removeCacheDirective(entry.getInfo().getId().longValue());
            TestCacheDirectives.waitForCachedBlocks(namenode, expected -= 2, expected, "testWaitForCachedReplicas:2");
        }
    }

    @Test
    @Timeout(value=120L)
    public void testWaitForCachedReplicasInDirectory() throws Exception {
        String pool = "friendlyPool";
        CachePoolInfo poolInfo = new CachePoolInfo("friendlyPool");
        dfs.addCachePool(poolInfo);
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.add(new Path("/foo/bar"));
        paths.add(new Path("/foo/baz"));
        paths.add(new Path("/foo2/bar2"));
        paths.add(new Path("/foo2/baz2"));
        dfs.mkdir(new Path("/foo"), FsPermission.getDirDefault());
        dfs.mkdir(new Path("/foo2"), FsPermission.getDirDefault());
        int numBlocksPerFile = 2;
        for (Path path : paths) {
            FileSystemTestHelper.createFile((FileSystem)dfs, (Path)path, (int)2, (int)4096, (short)3, (boolean)false);
        }
        TestCacheDirectives.waitForCachedBlocks(namenode, 0, 0, "testWaitForCachedReplicasInDirectory:0");
        long id = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path("/foo")).setReplication(Short.valueOf((short)2)).setPool("friendlyPool").build());
        TestCacheDirectives.waitForCachedBlocks(namenode, 4, 8, "testWaitForCachedReplicasInDirectory:1:blocks");
        TestCacheDirectives.waitForCacheDirectiveStats(dfs, 32768L, 32768L, 2L, 2L, new CacheDirectiveInfo.Builder().setPath(new Path("/foo")).build(), "testWaitForCachedReplicasInDirectory:1:directive");
        TestCacheDirectives.waitForCachePoolStats(dfs, 32768L, 32768L, 2L, 2L, poolInfo, "testWaitForCachedReplicasInDirectory:1:pool");
        long id2 = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path("/foo/bar")).setReplication(Short.valueOf((short)4)).setPool("friendlyPool").build());
        TestCacheDirectives.waitForCachedBlocks(namenode, 4, 10, "testWaitForCachedReplicasInDirectory:2:blocks");
        TestCacheDirectives.waitForCacheDirectiveStats(dfs, 32768L, 32768L, 2L, 2L, new CacheDirectiveInfo.Builder().setPath(new Path("/foo")).build(), "testWaitForCachedReplicasInDirectory:2:directive-1");
        TestCacheDirectives.waitForCacheDirectiveStats(dfs, 32768L, 24576L, 1L, 0L, new CacheDirectiveInfo.Builder().setPath(new Path("/foo/bar")).build(), "testWaitForCachedReplicasInDirectory:2:directive-2");
        TestCacheDirectives.waitForCachePoolStats(dfs, 65536L, 57344L, 3L, 2L, poolInfo, "testWaitForCachedReplicasInDirectory:2:pool");
        dfs.removeCacheDirective(id);
        dfs.removeCacheDirective(id2);
        TestCacheDirectives.waitForCachedBlocks(namenode, 0, 0, "testWaitForCachedReplicasInDirectory:3:blocks");
        TestCacheDirectives.waitForCachePoolStats(dfs, 0L, 0L, 0L, 0L, poolInfo, "testWaitForCachedReplicasInDirectory:3:pool");
    }

    @Test
    @Timeout(value=120L)
    public void testReplicationFactor() throws Exception {
        int i;
        String pool = "friendlyPool";
        dfs.addCachePool(new CachePoolInfo("friendlyPool"));
        LinkedList<Path> paths = new LinkedList<Path>();
        paths.add(new Path("/foo/bar"));
        paths.add(new Path("/foo/baz"));
        paths.add(new Path("/foo2/bar2"));
        paths.add(new Path("/foo2/baz2"));
        dfs.mkdir(new Path("/foo"), FsPermission.getDirDefault());
        dfs.mkdir(new Path("/foo2"), FsPermission.getDirDefault());
        int numBlocksPerFile = 2;
        for (Path path : paths) {
            FileSystemTestHelper.createFile((FileSystem)dfs, (Path)path, (int)2, (int)4096, (short)3, (boolean)false);
        }
        TestCacheDirectives.waitForCachedBlocks(namenode, 0, 0, "testReplicationFactor:0");
        TestCacheDirectives.checkNumCachedReplicas(dfs, paths, 0, 0);
        long id = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(new Path("/foo")).setReplication(Short.valueOf((short)1)).setPool("friendlyPool").build());
        TestCacheDirectives.waitForCachedBlocks(namenode, 4, 4, "testReplicationFactor:1");
        TestCacheDirectives.checkNumCachedReplicas(dfs, paths, 4, 4);
        for (i = 2; i <= 3; ++i) {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setReplication(Short.valueOf((short)i)).build());
            TestCacheDirectives.waitForCachedBlocks(namenode, 4, 4 * i, "testReplicationFactor:2");
            TestCacheDirectives.checkNumCachedReplicas(dfs, paths, 4, 4 * i);
        }
        for (i = 2; i >= 1; --i) {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setReplication(Short.valueOf((short)i)).build());
            TestCacheDirectives.waitForCachedBlocks(namenode, 4, 4 * i, "testReplicationFactor:3");
            TestCacheDirectives.checkNumCachedReplicas(dfs, paths, 4, 4 * i);
        }
        dfs.removeCacheDirective(id);
        TestCacheDirectives.waitForCachedBlocks(namenode, 0, 0, "testReplicationFactor:4");
        TestCacheDirectives.checkNumCachedReplicas(dfs, paths, 0, 0);
    }

    @Test
    @Timeout(value=60L)
    public void testListCachePoolPermissions() throws Exception {
        UserGroupInformation myUser = UserGroupInformation.createRemoteUser((String)"myuser");
        DistributedFileSystem myDfs = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(myUser, conf);
        String poolName = "poolparty";
        dfs.addCachePool(new CachePoolInfo("poolparty").setMode(new FsPermission(448)));
        RemoteIterator it = myDfs.listCachePools();
        CachePoolInfo info = ((CachePoolEntry)it.next()).getInfo();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((Object)"poolparty", (Object)info.getPoolName(), (String)"Expected pool name");
        Assertions.assertNull((Object)info.getOwnerName(), (String)"Unexpected owner name");
        Assertions.assertNull((Object)info.getGroupName(), (String)"Unexpected group name");
        Assertions.assertNull((Object)info.getMode(), (String)"Unexpected mode");
        Assertions.assertNull((Object)info.getLimit(), (String)"Unexpected limit");
        long limit = 99L;
        dfs.modifyCachePool(new CachePoolInfo("poolparty").setOwnerName(myUser.getShortUserName()).setLimit(Long.valueOf(99L)));
        it = myDfs.listCachePools();
        info = ((CachePoolEntry)it.next()).getInfo();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((Object)"poolparty", (Object)info.getPoolName(), (String)"Expected pool name");
        Assertions.assertEquals((Object)myUser.getShortUserName(), (Object)info.getOwnerName(), (String)"Mismatched owner name");
        Assertions.assertNotNull((Object)info.getGroupName(), (String)"Expected group name");
        Assertions.assertEquals((short)448, (short)info.getMode().toShort(), (String)"Mismatched mode");
        Assertions.assertEquals((long)99L, (long)info.getLimit(), (String)"Mismatched limit");
    }

    @Test
    @Timeout(value=120L)
    public void testExpiry() throws Exception {
        String pool = "pool1";
        dfs.addCachePool(new CachePoolInfo(pool));
        Path p = new Path("/mypath");
        DFSTestUtil.createFile((FileSystem)dfs, p, 8192L, (short)2, 2457L);
        Date start = new Date();
        Date expiry = DateUtils.addSeconds((Date)start, (int)120);
        long id = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPath(p).setPool(pool).setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((Date)expiry)).setReplication(Short.valueOf((short)2)).build());
        TestCacheDirectives.waitForCachedBlocks(cluster.getNameNode(), 2, 4, "testExpiry:1");
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)0L)).build());
        TestCacheDirectives.waitForCachedBlocks(cluster.getNameNode(), 0, 0, "testExpiry:2");
        RemoteIterator it = dfs.listCacheDirectives(null);
        CacheDirectiveEntry ent = (CacheDirectiveEntry)it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        Date entryExpiry = new Date(ent.getInfo().getExpiration().getMillis());
        Assertions.assertTrue((boolean)entryExpiry.before(new Date()), (String)"Directive should have expired");
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)120000L)).build());
        TestCacheDirectives.waitForCachedBlocks(cluster.getNameNode(), 2, 4, "testExpiry:3");
        it = dfs.listCacheDirectives(null);
        ent = (CacheDirectiveEntry)it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        entryExpiry = new Date(ent.getInfo().getExpiration().getMillis());
        Assertions.assertTrue((boolean)entryExpiry.after(new Date()), (String)"Directive should not have expired");
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)-1L)).build());
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot set a negative expiration", (Throwable)e);
        }
    }

    @Test
    @Timeout(value=120L)
    public void testLimit() throws Exception {
        try {
            dfs.addCachePool(new CachePoolInfo("poolofnegativity").setLimit(Long.valueOf(-99L)));
            Assertions.fail((String)"Should not be able to set a negative limit");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"negative", (Throwable)e);
        }
        String destiny = "poolofdestiny";
        Path path1 = new Path("/destiny");
        DFSTestUtil.createFile((FileSystem)dfs, path1, 8192L, (short)1, 38036L);
        CachePoolInfo poolInfo = new CachePoolInfo("poolofdestiny").setLimit(Long.valueOf(8191L));
        dfs.addCachePool(poolInfo);
        CacheDirectiveInfo info1 = new CacheDirectiveInfo.Builder().setPool("poolofdestiny").setPath(path1).build();
        try {
            dfs.addCacheDirective(info1);
            Assertions.fail((String)"Should not be able to cache when there is no more limit");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"remaining capacity", (Throwable)e);
        }
        poolInfo.setLimit(Long.valueOf(8192L));
        dfs.modifyCachePool(poolInfo);
        long id1 = dfs.addCacheDirective(info1);
        TestCacheDirectives.waitForCachePoolStats(dfs, 8192L, 8192L, 1L, 1L, poolInfo, "testLimit:1");
        Path path2 = new Path("/failure");
        DFSTestUtil.createFile((FileSystem)dfs, path2, 4096L, (short)1, 38037L);
        try {
            dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("poolofdestiny").setPath(path2).build(), EnumSet.noneOf(CacheFlag.class));
            Assertions.fail((String)"Should not be able to add another cached file");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"remaining capacity", (Throwable)e);
        }
        poolInfo.setLimit(Long.valueOf(4096L));
        dfs.modifyCachePool(poolInfo);
        TestCacheDirectives.waitForCachePoolStats(dfs, 8192L, 0L, 1L, 0L, poolInfo, "testLimit:2");
        RemoteIterator it = dfs.listCachePools();
        Assertions.assertTrue((boolean)it.hasNext(), (String)"Expected a cache pool");
        CachePoolStats stats = ((CachePoolEntry)it.next()).getStats();
        Assertions.assertEquals((long)4096L, (long)stats.getBytesOverlimit(), (String)"Overlimit bytes should be difference of needed and limit");
        CachePoolInfo inadequate = new CachePoolInfo("poolofinadequacy").setLimit(Long.valueOf(4096L));
        dfs.addCachePool(inadequate);
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(info1).setId(Long.valueOf(id1)).setPool(inadequate.getPoolName()).build(), EnumSet.noneOf(CacheFlag.class));
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"remaining capacity", (Throwable)e);
        }
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(info1).setId(Long.valueOf(id1)).setPool(inadequate.getPoolName()).build(), EnumSet.of(CacheFlag.FORCE));
        dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool(inadequate.getPoolName()).setPath(path1).build(), EnumSet.of(CacheFlag.FORCE));
    }

    @Test
    @Timeout(value=30L)
    public void testMaxRelativeExpiry() throws Exception {
        try {
            dfs.addCachePool(new CachePoolInfo("failpool").setMaxRelativeExpiryMs(Long.valueOf(-1L)));
            Assertions.fail((String)"Added a pool with a negative max expiry.");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"negative", (Throwable)e);
        }
        try {
            dfs.addCachePool(new CachePoolInfo("failpool").setMaxRelativeExpiryMs(Long.valueOf(0x7FFFFFFFFFFFFFFEL)));
            Assertions.fail((String)"Added a pool with too big of a max expiry.");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"too big", (Throwable)e);
        }
        CachePoolInfo coolPool = new CachePoolInfo("coolPool");
        long poolExpiration = 600000L;
        dfs.addCachePool(coolPool.setMaxRelativeExpiryMs(Long.valueOf(600000L)));
        RemoteIterator poolIt = dfs.listCachePools();
        CachePoolInfo listPool = ((CachePoolEntry)poolIt.next()).getInfo();
        Assertions.assertFalse((boolean)poolIt.hasNext(), (String)"Should only be one pool");
        Assertions.assertEquals((long)600000L, (long)listPool.getMaxRelativeExpiryMs(), (String)"Expected max relative expiry to match set value");
        try {
            dfs.addCachePool(coolPool.setMaxRelativeExpiryMs(Long.valueOf(-1L)));
            Assertions.fail((String)"Added a pool with a negative max expiry.");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"negative", (Throwable)e);
        }
        try {
            dfs.modifyCachePool(coolPool.setMaxRelativeExpiryMs(Long.valueOf(0x2000000000000000L)));
            Assertions.fail((String)"Added a pool with too big of a max expiry.");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"too big", (Throwable)e);
        }
        CacheDirectiveInfo defaultExpiry = new CacheDirectiveInfo.Builder().setPath(new Path("/blah")).setPool(coolPool.getPoolName()).build();
        dfs.addCacheDirective(defaultExpiry);
        RemoteIterator dirIt = dfs.listCacheDirectives(defaultExpiry);
        CacheDirectiveInfo listInfo = ((CacheDirectiveEntry)dirIt.next()).getInfo();
        Assertions.assertFalse((boolean)dirIt.hasNext(), (String)"Should only have one entry in listing");
        long listExpiration = listInfo.getExpiration().getAbsoluteMillis() - new Date().getTime();
        Assertions.assertTrue((Math.abs(listExpiration - 600000L) < 10000L ? 1 : 0) != 0, (String)"Directive expiry should be approximately the pool's max expiry");
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder().setPath(new Path("/lolcat")).setPool(coolPool.getPoolName());
        try {
            dfs.addCacheDirective(builder.setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)600001L)).build());
            Assertions.fail((String)"Added a directive that exceeds pool's max relative expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"exceeds the max relative expiration", (Throwable)e);
        }
        try {
            dfs.addCacheDirective(builder.setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((long)(new Date().getTime() + 600000L + 10000L))).build());
            Assertions.fail((String)"Added a directive that exceeds pool's max relative expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"exceeds the max relative expiration", (Throwable)e);
        }
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(defaultExpiry).setId(listInfo.getId()).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)600001L)).build());
            Assertions.fail((String)"Modified a directive to exceed pool's max relative expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"exceeds the max relative expiration", (Throwable)e);
        }
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(defaultExpiry).setId(listInfo.getId()).setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((long)(new Date().getTime() + 600000L + 10000L))).build());
            Assertions.fail((String)"Modified a directive to exceed pool's max relative expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"exceeds the max relative expiration", (Throwable)e);
        }
        try {
            dfs.addCacheDirective(builder.setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)Long.MAX_VALUE)).build());
            Assertions.fail((String)"Added a directive with a gigantic max value");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"is too far in the future", (Throwable)e);
        }
        try {
            dfs.addCacheDirective(builder.setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((long)Long.MAX_VALUE)).build());
            Assertions.fail((String)"Added a directive with a gigantic max value");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"is too far in the future", (Throwable)e);
        }
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(defaultExpiry).setId(listInfo.getId()).setExpiration(CacheDirectiveInfo.Expiration.NEVER).build());
            Assertions.fail((String)"Modified a directive to exceed pool's max relative expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"exceeds the max relative expiration", (Throwable)e);
        }
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(defaultExpiry).setId(listInfo.getId()).setExpiration(CacheDirectiveInfo.Expiration.newAbsolute((long)Long.MAX_VALUE)).build());
            Assertions.fail((String)"Modified a directive to exceed pool's max relative expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"is too far in the future", (Throwable)e);
        }
        CachePoolInfo destPool = new CachePoolInfo("destPool");
        dfs.addCachePool(destPool.setMaxRelativeExpiryMs(Long.valueOf(300000L)));
        try {
            dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(defaultExpiry).setId(listInfo.getId()).setPool(destPool.getPoolName()).build());
            Assertions.fail((String)"Modified a directive to a pool with a lower max expiration");
        }
        catch (InvalidRequestException e) {
            GenericTestUtils.assertExceptionContains((String)"exceeds the max relative expiration", (Throwable)e);
        }
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder(defaultExpiry).setId(listInfo.getId()).setPool(destPool.getPoolName()).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)300000L)).build());
        dirIt = dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool(destPool.getPoolName()).build());
        listInfo = ((CacheDirectiveEntry)dirIt.next()).getInfo();
        listExpiration = listInfo.getExpiration().getAbsoluteMillis() - new Date().getTime();
        Assertions.assertTrue((Math.abs(300000L - listExpiration) < 10000L ? 1 : 0) != 0, (String)("Unexpected relative expiry " + listExpiration + " expected approximately " + 300000L));
        dfs.modifyCachePool(destPool.setMaxRelativeExpiryMs(Long.valueOf(0x1FFFFFFFFFFFFFFFL)));
        poolIt = dfs.listCachePools();
        listPool = ((CachePoolEntry)poolIt.next()).getInfo();
        while (!listPool.getPoolName().equals(destPool.getPoolName())) {
            listPool = ((CachePoolEntry)poolIt.next()).getInfo();
        }
        Assertions.assertEquals((long)0x1FFFFFFFFFFFFFFFL, (long)listPool.getMaxRelativeExpiryMs(), (String)"Expected max relative expiry to match set value");
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(listInfo.getId()).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)0x1FFFFFFFFFFFFFFFL)).build());
        dfs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(listInfo.getId()).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)0x1FFFFFFFFFFFFFFEL)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingCachedEmpty(MiniDFSCluster cluster) throws Exception {
        Thread.sleep(1000L);
        cluster.getNamesystem().readLock(RwLockMode.BM);
        try {
            DatanodeManager datanodeManager = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            for (DataNode dn : cluster.getDataNodes()) {
                DatanodeDescriptor descriptor = datanodeManager.getDatanode(dn.getDatanodeId());
                Assertions.assertTrue((boolean)descriptor.getPendingCached().isEmpty(), (String)("Pending cached list of " + descriptor + " is not empty, " + Arrays.toString(descriptor.getPendingCached().toArray())));
            }
        }
        finally {
            cluster.getNamesystem().readUnlock(RwLockMode.BM, "checkPendingCachedEmpty");
        }
    }

    @Test
    @Timeout(value=60L)
    public void testExceedsCapacity() throws Exception {
        Path fileName = new Path("/exceeds");
        long fileLen = 131072L;
        int numCachedReplicas = 16;
        DFSTestUtil.createFile((FileSystem)dfs, fileName, 131072L, (short)4, 1027565L);
        dfs.addCachePool(new CachePoolInfo("pool"));
        dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("pool").setPath(fileName).setReplication(Short.valueOf((short)1)).build());
        TestCacheDirectives.waitForCachedBlocks(namenode, -1, numCachedReplicas, "testExceeds:1");
        this.checkPendingCachedEmpty(cluster);
        this.checkPendingCachedEmpty(cluster);
        dfs.delete(fileName, false);
        DFSTestUtil.createFile((FileSystem)dfs, fileName, 4096, 131072L, 32768L, (short)1, 1027565L);
        this.checkPendingCachedEmpty(cluster);
        this.checkPendingCachedEmpty(cluster);
    }

    @Test
    @Timeout(value=60L)
    public void testNoBackingReplica() throws Exception {
        Path filename = new Path("/noback");
        int replication = 3;
        DFSTestUtil.createFile((FileSystem)dfs, filename, 1L, (short)3, 2988L);
        dfs.addCachePool(new CachePoolInfo("pool"));
        dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("pool").setPath(filename).setReplication(Short.valueOf((short)3)).build());
        TestCacheDirectives.waitForCachedBlocks(namenode, 1, 3, "testNoBackingReplica:1");
        DataNodeTestUtils.setCacheReportsDisabledForTests(cluster, true);
        try {
            dfs.setReplication(filename, (short)1);
            DFSTestUtil.waitForReplication(dfs, filename, (short)1, 30000);
            TestCacheDirectives.waitForCachedBlocks(namenode, 1, 1, "testNoBackingReplica:2");
        }
        finally {
            DataNodeTestUtils.setCacheReportsDisabledForTests(cluster, false);
        }
    }

    @Test
    public void testNoLookupsWhenNotUsed() throws Exception {
        CacheManager cm = cluster.getNamesystem().getCacheManager();
        LocatedBlocks locations = (LocatedBlocks)Mockito.mock(LocatedBlocks.class);
        cm.setCachedLocations(locations);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{locations});
    }

    @Test
    @Timeout(value=120L)
    public void testAddingCacheDirectiveInfosWhenCachingIsDisabled() throws Exception {
        cluster.shutdown();
        HdfsConfiguration config = TestCacheDirectives.createCachingConf();
        config.setBoolean("dfs.namenode.caching.enabled", false);
        cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(4).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
        namenode = cluster.getNameNode();
        CacheManager cacheManager = namenode.getNamesystem().getCacheManager();
        Assertions.assertFalse((boolean)cacheManager.isEnabled());
        Assertions.assertNull((Object)cacheManager.getCacheReplicationMonitor());
        String pool = "pool1";
        namenode.getRpcServer().addCachePool(new CachePoolInfo(pool));
        int numFiles = 2;
        int numBlocksPerFile = 2;
        ArrayList<String> paths = new ArrayList<String>(2);
        for (int i = 0; i < 2; ++i) {
            Path p = new Path("/testCachePaths-" + i);
            FileSystemTestHelper.createFile((FileSystem)dfs, (Path)p, (int)2, (int)4096);
            paths.add(p.toUri().getPath());
        }
        TestCacheDirectives.waitForCachedBlocks(namenode, 0, 0, "testAddingCacheDirectiveInfosWhenCachingIsDisabled:0");
        int expected = 0;
        for (int i = 0; i < 2; ++i) {
            CacheDirectiveInfo directive = new CacheDirectiveInfo.Builder().setPath(new Path((String)paths.get(i))).setPool(pool).build();
            dfs.addCacheDirective(directive);
            TestCacheDirectives.waitForCachedBlocks(namenode, expected, 0, "testAddingCacheDirectiveInfosWhenCachingIsDisabled:1");
        }
        Thread.sleep(20000L);
        TestCacheDirectives.waitForCachedBlocks(namenode, expected, 0, "testAddingCacheDirectiveInfosWhenCachingIsDisabled:2");
    }

    DistributedFileSystem getDFS(MiniDFSCluster cluster, int nnIdx) throws IOException {
        return cluster.getFileSystem(0);
    }

    @Test
    @Timeout(value=120L)
    public void testExpiryTimeConsistency() throws Exception {
        conf.setInt("dfs.ha.log-roll.period", 1);
        conf.setInt("dfs.ha.tail-edits.period", 1);
        MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        dfsCluster.transitionToActive(0);
        DistributedFileSystem fs = this.getDFS(dfsCluster, 0);
        NameNode ann = dfsCluster.getNameNode(0);
        Path filename = new Path("/file");
        int replication = 3;
        DFSTestUtil.createFile((FileSystem)fs, filename, 1L, (short)3, 2988L);
        fs.addCachePool(new CachePoolInfo("pool"));
        long id = fs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("pool").setPath(filename).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)86400000L)).setReplication(Short.valueOf((short)3)).build());
        fs.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(id)).setExpiration(CacheDirectiveInfo.Expiration.newRelative((long)172800000L)).build());
        NameNode sbn = dfsCluster.getNameNode(1);
        CacheManager annCachemanager = ann.getNamesystem().getCacheManager();
        CacheManager sbnCachemanager = sbn.getNamesystem().getCacheManager();
        HATestUtil.waitForStandbyToCatchUp(ann, sbn);
        GenericTestUtils.waitFor(() -> {
            boolean isConsistence = false;
            ann.getNamesystem().readLock(RwLockMode.FS);
            try {
                sbn.getNamesystem().readLock(RwLockMode.FS);
                try {
                    Iterator annDirectivesIt = annCachemanager.getCacheDirectives().iterator();
                    Iterator sbnDirectivesIt = sbnCachemanager.getCacheDirectives().iterator();
                    if (annDirectivesIt.hasNext() && sbnDirectivesIt.hasNext()) {
                        CacheDirective annDirective = (CacheDirective)annDirectivesIt.next();
                        CacheDirective sbnDirective = (CacheDirective)sbnDirectivesIt.next();
                        if (annDirective.getExpiryTimeString().equals(sbnDirective.getExpiryTimeString())) {
                            isConsistence = true;
                        }
                    }
                }
                finally {
                    sbn.getNamesystem().readUnlock(RwLockMode.FS, "expiryTimeConsistency");
                }
            }
            finally {
                ann.getNamesystem().readUnlock(RwLockMode.FS, "expiryTimeConsistency");
            }
            if (!isConsistence) {
                LOG.info("testEexpiryTimeConsistency:ANN CacheDirective Status is inconsistent with SBN");
            }
            return isConsistence;
        }, (long)500L, (long)120000L);
    }

    static {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.NoMlockCacheManipulator());
    }
}

