/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoStriped;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.Whitebox;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=300L)
public class TestAddStripedBlockInFBR {
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final short groupSize = (short)(this.dataBlocks + this.parityBlocks);
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;

    @BeforeEach
    public void setup() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.groupSize).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        this.dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testAddBlockInFullBlockReport() throws Exception {
        final BlockManager spy = (BlockManager)Mockito.spy((Object)this.cluster.getNamesystem().getBlockManager());
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeID datanodeID = dn.getDatanodeId();
        ((BlockManager)Mockito.doNothing().when((Object)spy)).processIncrementalBlockReport((DatanodeID)Mockito.eq((Object)datanodeID), (StorageReceivedDeletedBlocks)Mockito.any());
        Whitebox.setInternalState((Object)this.cluster.getNamesystem(), (String)"blockManager", (Object)spy);
        Path ecDir = new Path("/ec");
        Path repDir = new Path("/rep");
        this.dfs.mkdirs(ecDir);
        this.dfs.mkdirs(repDir);
        this.dfs.getClient().setErasureCodingPolicy(ecDir.toString(), StripedFileTestUtil.getDefaultECPolicy().getName());
        Path[] repFiles = new Path[this.groupSize];
        for (int i = 0; i < this.groupSize; ++i) {
            repFiles[i] = new Path(repDir, "f" + i);
            DFSTestUtil.createFile((FileSystem)this.dfs, repFiles[i], 1L, (short)3, 0L);
        }
        final Path ecFile = new Path(ecDir, "f");
        DFSTestUtil.createFile((FileSystem)this.dfs, ecFile, this.cellSize * this.dataBlocks, (short)1, 0L);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    TestAddStripedBlockInFBR.this.cluster.triggerBlockReports();
                    BlockInfoStriped blockInfo = (BlockInfoStriped)TestAddStripedBlockInFBR.this.cluster.getNamesystem().getFSDirectory().getINode(ecFile.toString()).asFile().getLastBlock();
                    NumberReplicas nr = spy.countNodes((BlockInfo)blockInfo);
                    return nr.excessReplicas() == 0 && nr.liveReplicas() == TestAddStripedBlockInFBR.this.groupSize;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }, (long)3000L, (long)60000L);
    }
}

