/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.balancer.TestBalancer;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancer;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkItem;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Time;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDiskBalancer {
    private static final String PLAN_FILE = "/system/current.plan.json";
    static final Logger LOG = LoggerFactory.getLogger(TestDiskBalancer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerNameNodeConnectivity() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int numDatanodes = 2;
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            cluster.waitActive();
            ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)cluster.getFileSystem(0).getUri(), (Configuration)conf);
            DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
            diskBalancerCluster.readClusterInfo();
            org.junit.jupiter.api.Assertions.assertEquals((int)diskBalancerCluster.getNodes().size(), (int)2);
            DataNode dnNode = cluster.getDataNodes().get(0);
            DiskBalancerDataNode dbDnNode = diskBalancerCluster.getNodeByUUID(dnNode.getDatanodeUuid());
            org.junit.jupiter.api.Assertions.assertEquals((Object)dnNode.getDatanodeUuid(), (Object)dbDnNode.getDataNodeUUID());
            org.junit.jupiter.api.Assertions.assertEquals((Object)dnNode.getDatanodeId().getIpAddr(), (Object)dbDnNode.getDataNodeIP());
            org.junit.jupiter.api.Assertions.assertEquals((Object)dnNode.getDatanodeId().getHostName(), (Object)dbDnNode.getDataNodeName());
            try (FsDatasetSpi.FsVolumeReferences ref = dnNode.getFSDataset().getFsVolumeReferences();){
                org.junit.jupiter.api.Assertions.assertEquals((int)ref.size(), (int)dbDnNode.getVolumeCount());
            }
            dnNode.shutdown();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)dnNode.getDiskBalancerStatus());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerEndToEnd() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int blockCount = 100;
        int blockSize = 1024;
        int diskCount = 2;
        boolean dataNodeCount = true;
        boolean dataNodeIndex = false;
        boolean sourceDiskIndex = false;
        long cap = 204800L;
        MiniDFSCluster cluster = new ClusterBuilder().setBlockCount(100).setBlockSize(1024).setDiskCount(2).setNumDatanodes(1).setConf((Configuration)conf).setCapacities(new long[]{204800L, 204800L}).build();
        try {
            DataMover dataMover = new DataMover(cluster, 0, 0, (Configuration)conf, 1024, 100);
            dataMover.moveDataToSourceDisk();
            NodePlan plan = dataMover.generatePlan();
            dataMover.executePlan(plan);
            dataMover.verifyPlanExectionDone();
            dataMover.verifyAllVolumesHaveData(true);
            dataMover.verifyTolerance(plan, 0, 0, 10);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerWithFederatedCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int blockCount = 100;
        int blockSize = 1024;
        int diskCount = 2;
        boolean dataNodeCount = true;
        boolean dataNodeIndex = false;
        boolean sourceDiskIndex = false;
        long cap = 307200L;
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.bytes-per-checksum", 1024);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(1).storagesPerDatanode(2).storageCapacities(new long[]{307200L, 307200L}).build();
        cluster.waitActive();
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        String fileName = "/tmp.txt";
        Path filePath = new Path("/tmp.txt");
        long fileLen = 102400L;
        DistributedFileSystem fs = cluster.getFileSystem(0);
        TestBalancer.createFile(cluster, filePath, fileLen, (short)1, 0);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        fs = cluster.getFileSystem(1);
        TestBalancer.createFile(cluster, filePath, fileLen, (short)1, 1);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        try {
            DataMover dataMover = new DataMover(cluster, 0, 0, (Configuration)conf, 1024, 100);
            dataMover.moveDataToSourceDisk();
            NodePlan plan = dataMover.generatePlan();
            dataMover.executePlan(plan);
            dataMover.verifyPlanExectionDone();
            dataMover.verifyAllVolumesHaveData(true);
            dataMover.verifyTolerance(plan, 0, 0, 10);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerComputeDelay() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int blockCount = 100;
        int blockSize = 0xB00000;
        int diskCount = 2;
        boolean dataNodeCount = true;
        boolean dataNodeIndex = false;
        long cap = 0x89800000L;
        conf.setInt("dfs.blocksize", 0xB00000);
        conf.setInt("dfs.bytes-per-checksum", 0xB00000);
        MiniDFSCluster cluster = new ClusterBuilder().setBlockCount(100).setBlockSize(0xB00000).setDiskCount(2).setNumDatanodes(1).setConf((Configuration)conf).setCapacities(new long[]{0x89800000L, 0x89800000L}).build();
        try {
            final DataNode node = cluster.getDataNodes().get(0);
            FsDatasetSpi fsDatasetSpy = (FsDatasetSpi)Mockito.spy((Object)node.getFSDataset());
            DiskBalancerWorkItem item = (DiskBalancerWorkItem)Mockito.spy((Object)new DiskBalancerWorkItem());
            ((DiskBalancerWorkItem)Mockito.doReturn((Object)10L).when((Object)item)).getBandwidth();
            ((FsDatasetSpi)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    try {
                        node.getFSDataset().moveBlockAcrossVolumes((ExtendedBlock)invocation.getArguments()[0], (FsVolumeSpi)invocation.getArguments()[1]);
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage());
                    }
                    return null;
                }
            }).when((Object)fsDatasetSpy)).moveBlockAcrossVolumes((ExtendedBlock)ArgumentMatchers.any(ExtendedBlock.class), (FsVolumeSpi)ArgumentMatchers.any(FsVolumeSpi.class));
            DiskBalancer.DiskBalancerMover diskBalancerMover = new DiskBalancer.DiskBalancerMover(fsDatasetSpy, (Configuration)conf);
            diskBalancerMover.setRunnable();
            long val = diskBalancerMover.computeDelay(0x1400000L, 1200L, item);
            org.junit.jupiter.api.Assertions.assertEquals((long)val, (long)800L);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("Unexpected exception: " + e));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerWithFedClusterWithOneNameServiceEmpty() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int blockCount = 100;
        int blockSize = 1024;
        int diskCount = 2;
        boolean dataNodeCount = true;
        boolean dataNodeIndex = false;
        boolean sourceDiskIndex = false;
        long cap = 307200L;
        conf.setInt("dfs.blocksize", 1024);
        conf.setInt("dfs.bytes-per-checksum", 1024);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(1).storagesPerDatanode(2).storageCapacities(new long[]{307200L, 307200L}).build();
        cluster.waitActive();
        DFSTestUtil.setFederatedConfiguration(cluster, (Configuration)conf);
        String fileName = "/tmp.txt";
        Path filePath = new Path("/tmp.txt");
        long fileLen = 102400L;
        DistributedFileSystem fs = cluster.getFileSystem(0);
        TestBalancer.createFile(cluster, filePath, fileLen, (short)1, 0);
        DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)DiskBalancer.LOG);
        try {
            DataMover dataMover = new DataMover(cluster, 0, 0, (Configuration)conf, 1024, 100);
            dataMover.moveDataToSourceDisk();
            NodePlan plan = dataMover.generatePlan();
            dataMover.executePlan(plan);
            dataMover.verifyPlanExectionDone();
            dataMover.verifyAllVolumesHaveData(false);
        }
        finally {
            String logOut = logCapturer.getOutput();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)logOut.contains("NextBlock call returned null. No valid block to copy."), (String)("Wrong log: " + logOut));
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBalanceDataBetweenMultiplePairsOfVolumes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int blockCount = 1000;
        int blockSize = 1024;
        int diskCount = 3;
        boolean dataNodeCount = true;
        boolean dataNodeIndex = false;
        boolean sourceDiskIndex = false;
        long cap = 2048000L;
        MiniDFSCluster cluster = new ClusterBuilder().setBlockCount(1000).setBlockSize(1024).setDiskCount(3).setNumDatanodes(1).setConf((Configuration)conf).setCapacities(new long[]{2048000L, 2048000L, 2048000L}).build();
        try {
            DataMover dataMover = new DataMover(cluster, 0, 0, (Configuration)conf, 1024, 1000);
            dataMover.moveDataToSourceDisk();
            NodePlan plan = dataMover.generatePlan();
            org.junit.jupiter.api.Assertions.assertEquals((int)plan.getVolumeSetPlans().size(), (int)2);
            dataMover.executePlan(plan);
            dataMover.verifyPlanExectionDone();
            dataMover.verifyAllVolumesHaveData(true);
            dataMover.verifyTolerance(plan, 0, 0, 10);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiskBalancerWhenRemovingVolumes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        int blockCount = 100;
        int blockSize = 1024;
        int diskCount = 2;
        boolean dataNodeCount = true;
        boolean dataNodeIndex = false;
        boolean sourceDiskIndex = false;
        long cap = 204800L;
        MiniDFSCluster cluster = new ClusterBuilder().setBlockCount(100).setBlockSize(1024).setDiskCount(2).setNumDatanodes(1).setConf((Configuration)conf).setCapacities(new long[]{204800L, 204800L}).build();
        try {
            DataMover dataMover = new DataMover(cluster, 0, 0, (Configuration)conf, 1024, 100);
            dataMover.moveDataToSourceDisk();
            NodePlan plan = dataMover.generatePlan();
            dataMover.executePlanDuringDiskRemove(plan);
            dataMover.verifyAllVolumesHaveData(true);
            dataMover.verifyTolerance(plan, 0, 0, 10);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("Unexpected exception: " + e));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    class DataMover {
        private final MiniDFSCluster cluster;
        private final int sourceDiskIndex;
        private final int dataNodeIndex;
        private final Configuration conf;
        private final int blockCount;
        private final int blockSize;
        private DataNode node;

        public DataMover(MiniDFSCluster cluster, int dataNodeIndex, int sourceDiskIndex, Configuration conf, int blockSize, int blockCount) {
            this.cluster = cluster;
            this.dataNodeIndex = dataNodeIndex;
            this.node = cluster.getDataNodes().get(dataNodeIndex);
            this.sourceDiskIndex = sourceDiskIndex;
            this.conf = conf;
            this.blockCount = blockCount;
            this.blockSize = blockSize;
        }

        public void moveDataToSourceDisk() throws IOException {
            this.moveAllDataToDestDisk(this.node, this.sourceDiskIndex);
            this.cluster.restartDataNodes();
            this.cluster.waitActive();
        }

        private void moveAllDataToDestDisk(DataNode dataNode, int destDiskindex) throws IOException {
            Preconditions.checkNotNull((Object)dataNode);
            Preconditions.checkState((destDiskindex >= 0 ? 1 : 0) != 0);
            try (FsDatasetSpi.FsVolumeReferences refs = dataNode.getFSDataset().getFsVolumeReferences();){
                if (refs.size() <= destDiskindex) {
                    throw new IllegalArgumentException("Invalid Disk index.");
                }
                FsVolumeImpl dest = (FsVolumeImpl)refs.get(destDiskindex);
                for (int x = 0; x < refs.size(); ++x) {
                    if (x == destDiskindex) continue;
                    FsVolumeImpl source = (FsVolumeImpl)refs.get(x);
                    DiskBalancerTestUtil.moveAllDataToDestVolume(dataNode.getFSDataset(), (FsVolumeSpi)source, (FsVolumeSpi)dest);
                }
            }
        }

        public NodePlan generatePlan() throws Exception {
            this.node = this.cluster.getDataNodes().get(this.dataNodeIndex);
            ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)this.cluster.getFileSystem(this.dataNodeIndex).getUri(), (Configuration)this.conf);
            DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
            diskBalancerCluster.readClusterInfo();
            LinkedList<DiskBalancerDataNode> nodesToProcess = new LinkedList<DiskBalancerDataNode>();
            nodesToProcess.add(diskBalancerCluster.getNodeByUUID(this.node.getDatanodeUuid()));
            diskBalancerCluster.setNodesToProcess(nodesToProcess);
            List clusterplan = diskBalancerCluster.computePlan(0.0);
            org.junit.jupiter.api.Assertions.assertTrue((clusterplan.size() == 1 ? 1 : 0) != 0);
            NodePlan plan = (NodePlan)clusterplan.get(0);
            plan.setNodeUUID(this.node.getDatanodeUuid());
            plan.setTimeStamp(Time.now());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)plan.getVolumeSetPlans());
            org.junit.jupiter.api.Assertions.assertTrue((plan.getVolumeSetPlans().size() > 0 ? 1 : 0) != 0);
            ((Step)plan.getVolumeSetPlans().get(0)).setTolerancePercent(10L);
            return plan;
        }

        public void executePlan(NodePlan plan) throws IOException, TimeoutException, InterruptedException {
            this.node = this.cluster.getDataNodes().get(this.dataNodeIndex);
            String planJson = plan.toJson();
            String planID = DigestUtils.sha1Hex((String)planJson);
            this.node.submitDiskBalancerPlan(planID, 1L, TestDiskBalancer.PLAN_FILE, planJson, false);
            String jmxString = this.node.getDiskBalancerStatus();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)jmxString);
            DiskBalancerWorkStatus status = DiskBalancerWorkStatus.parseJson((String)jmxString);
            DiskBalancerWorkStatus realStatus = this.node.queryDiskBalancerPlan();
            org.junit.jupiter.api.Assertions.assertEquals((Object)realStatus.getPlanID(), (Object)status.getPlanID());
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        return DataMover.this.node.queryDiskBalancerPlan().getResult() == DiskBalancerWorkStatus.Result.PLAN_DONE;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
            }, (long)1000L, (long)100000L);
        }

        public void executePlanDuringDiskRemove(NodePlan plan) throws IOException, TimeoutException, InterruptedException {
            final CountDownLatch createWorkPlanLatch = new CountDownLatch(1);
            final CountDownLatch removeDiskLatch = new CountDownLatch(1);
            final AtomicInteger errorCount = new AtomicInteger(0);
            LOG.info("FSDataSet: " + this.node.getFSDataset());
            FsDatasetSpi fsDatasetSpy = (FsDatasetSpi)Mockito.spy((Object)this.node.getFSDataset());
            ((FsDatasetSpi)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    try {
                        DataMover.this.node.getFSDataset().moveBlockAcrossVolumes((ExtendedBlock)invocation.getArguments()[0], (FsVolumeSpi)invocation.getArguments()[1]);
                    }
                    catch (Exception e) {
                        errorCount.incrementAndGet();
                    }
                    return null;
                }
            }).when((Object)fsDatasetSpy)).moveBlockAcrossVolumes((ExtendedBlock)ArgumentMatchers.any(ExtendedBlock.class), (FsVolumeSpi)ArgumentMatchers.any(FsVolumeSpi.class));
            final DiskBalancer.DiskBalancerMover diskBalancerMover = new DiskBalancer.DiskBalancerMover(fsDatasetSpy, this.conf);
            diskBalancerMover.setRunnable();
            DiskBalancer.DiskBalancerMover diskBalancerMoverSpy = (DiskBalancer.DiskBalancerMover)Mockito.spy((Object)diskBalancerMover);
            ((DiskBalancer.DiskBalancerMover)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    createWorkPlanLatch.countDown();
                    LOG.info("Waiting for the disk removal!");
                    try {
                        removeDiskLatch.await();
                    }
                    catch (InterruptedException e) {
                        LOG.info("Encountered " + e);
                    }
                    LOG.info("Got disk removal notification, resuming copyBlocks!");
                    diskBalancerMover.copyBlocks((DiskBalancer.VolumePair)invocation.getArguments()[0], (DiskBalancerWorkItem)invocation.getArguments()[1]);
                    return null;
                }
            }).when((Object)diskBalancerMoverSpy)).copyBlocks((DiskBalancer.VolumePair)ArgumentMatchers.any(DiskBalancer.VolumePair.class), (DiskBalancerWorkItem)ArgumentMatchers.any(DiskBalancerWorkItem.class));
            final DiskBalancer diskBalancer = new DiskBalancer(this.node.getDatanodeUuid(), this.conf, (DiskBalancer.BlockMover)diskBalancerMoverSpy);
            ArrayList oldDirs = new ArrayList(this.node.getConf().getTrimmedStringCollection("dfs.datanode.data.dir"));
            final String newDirs = (String)oldDirs.get(0);
            LOG.info("Reconfigure newDirs:" + newDirs);
            Thread reconfigThread = new Thread(){

                @Override
                public void run() {
                    try {
                        LOG.info("Waiting for work plan creation!");
                        createWorkPlanLatch.await();
                        LOG.info("Work plan created. Removing disk!");
                        ((AbstractStringAssert)Assertions.assertThat((String)DataMover.this.node.reconfigurePropertyImpl("dfs.datanode.data.dir", newDirs)).as("DN did not update its own config", new Object[0])).isEqualTo((Object)DataMover.this.node.getConf().get("dfs.datanode.data.dir"));
                        Thread.sleep(1000L);
                        LOG.info("Removed disk!");
                        removeDiskLatch.countDown();
                    }
                    catch (InterruptedException | ReconfigurationException e) {
                        org.junit.jupiter.api.Assertions.fail((String)("Unexpected error while reconfiguring: " + e));
                    }
                }
            };
            reconfigThread.start();
            String planJson = plan.toJson();
            String planID = DigestUtils.sha1Hex((String)planJson);
            diskBalancer.submitPlan(planID, 1L, TestDiskBalancer.PLAN_FILE, planJson, false);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    try {
                        LOG.info("Work Status: " + diskBalancer.queryWorkStatus().toJsonString());
                        DiskBalancerWorkStatus.Result result = diskBalancer.queryWorkStatus().getResult();
                        return result == DiskBalancerWorkStatus.Result.PLAN_DONE;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }, (long)1000L, (long)100000L);
            org.junit.jupiter.api.Assertions.assertTrue((errorCount.get() <= 5 ? 1 : 0) != 0, (String)"Disk balancer operation hit max errors!");
            createWorkPlanLatch.await();
            removeDiskLatch.await();
        }

        public void verifyPlanExectionDone() throws IOException {
            this.node = this.cluster.getDataNodes().get(this.dataNodeIndex);
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.node.queryDiskBalancerPlan().getResult(), (Object)DiskBalancerWorkStatus.Result.PLAN_DONE);
        }

        public void verifyAllVolumesHaveData(boolean checkblockPoolCount) throws IOException {
            this.node = this.cluster.getDataNodes().get(this.dataNodeIndex);
            try (FsDatasetSpi.FsVolumeReferences refs = this.node.getFSDataset().getFsVolumeReferences();){
                for (FsVolumeSpi volume : refs) {
                    org.junit.jupiter.api.Assertions.assertTrue((DiskBalancerTestUtil.getBlockCount(volume, checkblockPoolCount) > 0 ? 1 : 0) != 0);
                    LOG.info("{} : Block Count : {}", (Object)refs, (Object)DiskBalancerTestUtil.getBlockCount(volume, checkblockPoolCount));
                }
            }
        }

        public void verifyTolerance(NodePlan plan, int planIndex, int sourceDiskIndex, int tolerance) throws IOException {
            long delta = ((Step)plan.getVolumeSetPlans().get(planIndex)).getBytesToMove() * (long)tolerance / 100L;
            FsVolumeImpl volume = null;
            try (FsDatasetSpi.FsVolumeReferences refs = this.node.getFSDataset().getFsVolumeReferences();){
                volume = (FsVolumeImpl)refs.get(sourceDiskIndex);
                org.junit.jupiter.api.Assertions.assertTrue((DiskBalancerTestUtil.getBlockCount((FsVolumeSpi)volume, true) > 0 ? 1 : 0) != 0);
                org.junit.jupiter.api.Assertions.assertTrue(((long)DiskBalancerTestUtil.getBlockCount((FsVolumeSpi)volume, true) * ((long)this.blockSize + delta) >= ((Step)plan.getVolumeSetPlans().get(0)).getBytesToMove() ? 1 : 0) != 0);
            }
        }
    }

    static class ClusterBuilder {
        private Configuration conf;
        private int blockSize;
        private int numDatanodes;
        private int fileLen;
        private int blockCount;
        private int diskCount;
        private long[] capacities;

        ClusterBuilder() {
        }

        public ClusterBuilder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ClusterBuilder setBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public ClusterBuilder setNumDatanodes(int datanodeCount) {
            this.numDatanodes = datanodeCount;
            return this;
        }

        public ClusterBuilder setBlockCount(int blockCount) {
            this.blockCount = blockCount;
            return this;
        }

        public ClusterBuilder setDiskCount(int diskCount) {
            this.diskCount = diskCount;
            return this;
        }

        private ClusterBuilder setCapacities(long[] caps) {
            this.capacities = caps;
            return this;
        }

        private StorageType[] getStorageTypes(int diskCount) {
            Preconditions.checkState((diskCount > 0 ? 1 : 0) != 0);
            StorageType[] array = new StorageType[diskCount];
            for (int x = 0; x < diskCount; ++x) {
                array[x] = StorageType.DISK;
            }
            return array;
        }

        public MiniDFSCluster build() throws IOException, TimeoutException, InterruptedException {
            Preconditions.checkNotNull((Object)this.conf);
            Preconditions.checkState((this.blockSize > 0 ? 1 : 0) != 0);
            Preconditions.checkState((this.numDatanodes > 0 ? 1 : 0) != 0);
            this.fileLen = this.blockCount * this.blockSize;
            Preconditions.checkState((this.fileLen > 0 ? 1 : 0) != 0);
            this.conf.setBoolean("dfs.disk.balancer.enabled", true);
            this.conf.setLong("dfs.blocksize", (long)this.blockSize);
            this.conf.setInt("dfs.bytes-per-checksum", this.blockSize);
            this.conf.setLong("dfs.heartbeat.interval", 1L);
            String fileName = "/tmp.txt";
            Path filePath = new Path("/tmp.txt");
            this.fileLen = this.blockCount * this.blockSize;
            MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDatanodes).storageCapacities(this.capacities).storageTypes(this.getStorageTypes(this.diskCount)).storagesPerDatanode(this.diskCount).build();
            this.generateData(filePath, cluster);
            cluster.restartDataNodes();
            cluster.waitActive();
            return cluster;
        }

        private void generateData(Path filePath, MiniDFSCluster cluster) throws IOException, InterruptedException, TimeoutException {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem(0);
            TestBalancer.createFile(cluster, filePath, this.fileLen, (short)1, this.numDatanodes - 1);
            DFSTestUtil.waitReplication((FileSystem)fs, filePath, (short)1);
            cluster.restartDataNodes();
            cluster.waitActive();
        }
    }
}

