/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HostRestrictingAuthorizationFilter;
import org.apache.hadoop.hdfs.server.datanode.web.HostRestrictingAuthorizationFilterHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHostRestrictingAuthorizationFilterHandler {
    static final String CONFNAME = "dfs.web.authentication.host.allow.rules";

    @Test
    public void testRejectAll() {
        CustomEmbeddedChannel channel = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler()});
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/user/myName/fooFile?op=OPEN");
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{httpRequest}), (String)"Should get error back from handler for rejected request");
        DefaultHttpResponse channelResponse = (DefaultHttpResponse)channel.outboundMessages().poll();
        Assertions.assertNotNull((Object)channelResponse, (String)"Expected response to exist.");
        Assertions.assertEquals((Object)HttpResponseStatus.FORBIDDEN, (Object)channelResponse.status());
        Assertions.assertFalse((boolean)channel.isOpen());
    }

    @Test
    public void testMultipleAcceptedGETsOneChannel() {
        Configuration conf = new Configuration();
        conf.set(CONFNAME, "*,*,/allowed");
        HostRestrictingAuthorizationFilter filter = HostRestrictingAuthorizationFilterHandler.initializeState((Configuration)conf);
        CustomEmbeddedChannel channel = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        DefaultFullHttpRequest allowedHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_one?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_two?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest3 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_three?op=OPEN");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{allowedHttpRequest}), (String)"Should successfully accept request");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{allowedHttpRequest2}), (String)"Should successfully accept request, second time");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{allowedHttpRequest3}), (String)"Should successfully accept request, third time");
    }

    @Test
    public void testMultipleChannels() {
        Configuration conf = new Configuration();
        conf.set(CONFNAME, "*,*,/allowed");
        HostRestrictingAuthorizationFilter filter = HostRestrictingAuthorizationFilterHandler.initializeState((Configuration)conf);
        CustomEmbeddedChannel channel1 = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        CustomEmbeddedChannel channel2 = new CustomEmbeddedChannel("127.0.0.2", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        CustomEmbeddedChannel channel3 = new CustomEmbeddedChannel("127.0.0.3", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler(filter)});
        DefaultFullHttpRequest allowedHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_one?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_two?op=OPEN");
        DefaultFullHttpRequest allowedHttpRequest3 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/allowed/file_three?op=OPEN");
        Assertions.assertTrue((boolean)channel1.writeInbound(new Object[]{allowedHttpRequest}), (String)"Should successfully accept request");
        Assertions.assertTrue((boolean)channel2.writeInbound(new Object[]{allowedHttpRequest2}), (String)"Should successfully accept request, second time");
        channel1.close();
        Assertions.assertTrue((boolean)channel3.writeInbound(new Object[]{allowedHttpRequest3}), (String)"Should successfully accept request, third time");
    }

    @Test
    public void testAcceptGETFILECHECKSUM() {
        CustomEmbeddedChannel channel = new CustomEmbeddedChannel("127.0.0.1", 1006, new ChannelHandler[]{new HostRestrictingAuthorizationFilterHandler()});
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/webhdfs/v1/user/myName/fooFile?op=GETFILECHECKSUM");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{httpRequest}), (String)"Should successfully accept request");
    }

    protected static class CustomEmbeddedChannel
    extends EmbeddedChannel {
        private final InetSocketAddress socketAddress;

        public CustomEmbeddedChannel(String host, int port, ChannelHandler ... handlers) {
            super(handlers);
            this.socketAddress = new InetSocketAddress(host, port);
        }

        protected SocketAddress remoteAddress0() {
            return this.socketAddress;
        }
    }
}

