/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@ParameterizedClass
@MethodSource(value={"policy"})
public class TestDatanodeHttpServer {
    private static final String BASEDIR = GenericTestUtils.getTempPath((String)TestDatanodeHttpServer.class.getSimpleName());
    private static String keystoresDir;
    private static String sslConfDir;
    private static Configuration conf;
    private static URLConnectionFactory connectionFactory;
    private final HttpConfig.Policy policy;

    public static Collection<Object[]> policy() {
        Object[][] params = new Object[][]{{HttpConfig.Policy.HTTP_ONLY}, {HttpConfig.Policy.HTTPS_ONLY}, {HttpConfig.Policy.HTTP_AND_HTTPS}};
        return Arrays.asList(params);
    }

    public TestDatanodeHttpServer(HttpConfig.Policy policy) {
        this.policy = policy;
    }

    @BeforeAll
    public static void setUp() throws Exception {
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        conf = new Configuration();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestDatanodeHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
    }

    @AfterAll
    public static void tearDown() throws Exception {
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    @Test
    public void testHttpPolicy() throws Exception {
        conf.set("dfs.http.policy", this.policy.name());
        conf.set("dfs.datanode.http.address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        try (DatanodeHttpServer server = null;){
            server = new DatanodeHttpServer(conf, null, null);
            server.start();
            Assertions.assertTrue((boolean)TestDatanodeHttpServer.implies(this.policy.isHttpEnabled(), TestDatanodeHttpServer.canAccess("http", server.getHttpAddress())));
            Assertions.assertTrue((boolean)TestDatanodeHttpServer.implies(!this.policy.isHttpEnabled(), server.getHttpAddress() == null));
            Assertions.assertTrue((boolean)TestDatanodeHttpServer.implies(this.policy.isHttpsEnabled(), TestDatanodeHttpServer.canAccess("https", server.getHttpsAddress())));
            Assertions.assertTrue((boolean)TestDatanodeHttpServer.implies(!this.policy.isHttpsEnabled(), server.getHttpsAddress() == null));
        }
    }

    private static boolean canAccess(String scheme, InetSocketAddress addr) {
        if (addr == null) {
            return false;
        }
        try {
            URL url = new URL(scheme + "://" + NetUtils.getHostPortString((InetSocketAddress)addr));
            URLConnection conn = connectionFactory.openConnection(url);
            conn.connect();
            Assertions.assertTrue((boolean)(conn instanceof HttpURLConnection));
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            if (httpConn.getResponseCode() != 200) {
                return false;
            }
            StringBuilder builder = new StringBuilder();
            InputStreamReader responseReader = new InputStreamReader(conn.getInputStream());
            try (BufferedReader reader = new BufferedReader(responseReader);){
                String output;
                while ((output = reader.readLine()) != null) {
                    builder.append(output);
                }
            }
            return builder.toString().contains("Hadoop Administration");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean implies(boolean a, boolean b) {
        return !a || b;
    }
}

