/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestScrLazyPersistFiles
extends LazyPersistTestCase {
    @BeforeAll
    public static void init() {
        DomainSocket.disableBindPathValidation();
    }

    @BeforeEach
    public void before() {
        org.junit.jupiter.api.Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        PlatformAssumptions.assumeNotWindows();
        Assumptions.assumeThat((String)DomainSocket.getLoadingFailureReason()).isNull();
        long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();
        Preconditions.checkState((0x500000L >= osPageSize ? 1 : 0) != 0);
        Preconditions.checkState((0x500000L % osPageSize == 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRamDiskShortCircuitRead() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        int SEED = 1027565;
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeRandomTestFile(path, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        HdfsDataInputStream fis = (HdfsDataInputStream)this.fs.open(path);
        try {
            byte[] buf = new byte[4096];
            fis.read(0L, buf, 0, 4096);
            org.junit.jupiter.api.Assertions.assertEquals((long)4096L, (long)fis.getReadStatistics().getTotalBytesRead());
            org.junit.jupiter.api.Assertions.assertEquals((long)4096L, (long)fis.getReadStatistics().getTotalShortCircuitBytesRead());
        }
        finally {
            fis.close();
            fis = null;
        }
    }

    @Test
    public void tesScrDuringEviction() throws Exception {
        this.getClusterBuilder().setUseScr(true).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        try (HdfsDataInputStream fis = (HdfsDataInputStream)this.fs.open(path1);){
            byte[] buf = new byte[4096];
            fis.read(0L, buf, 0, 4096);
            this.triggerEviction(this.cluster.getDataNodes().get(0));
            fis.read(0L, buf, 0, 4096);
            Assertions.assertThat((long)fis.getReadStatistics().getTotalBytesRead()).isEqualTo(8192L);
            Assertions.assertThat((long)fis.getReadStatistics().getTotalShortCircuitBytesRead()).isEqualTo(8192L);
        }
    }

    @Test
    public void testScrAfterEviction() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(false).build();
        this.doShortCircuitReadAfterEvictionTest();
    }

    @Test
    public void testLegacyScrAfterEviction() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(true).build();
        this.doShortCircuitReadAfterEvictionTest();
        ClientContext clientContext = this.client.getClientContext();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)clientContext.getDisableLegacyBlockReaderLocal());
    }

    private void doShortCircuitReadAfterEvictionTest() throws IOException, InterruptedException, TimeoutException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        int SEED = 1027565;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        File metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        org.junit.jupiter.api.Assertions.assertTrue((metaFile.length() <= (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
        this.triggerEviction(this.cluster.getDataNodes().get(0));
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        metaFile = this.cluster.getBlockMetadataFile(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        org.junit.jupiter.api.Assertions.assertTrue((metaFile.length() > (long)BlockMetadataHeader.getHeaderSize() ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
    }

    @Test
    public void testScrBlockFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(false).build();
        this.doShortCircuitReadBlockFileCorruptionTest();
    }

    @Test
    public void testLegacyScrBlockFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(true).build();
        this.doShortCircuitReadBlockFileCorruptionTest();
    }

    public void doShortCircuitReadBlockFileCorruptionTest() throws IOException, InterruptedException, TimeoutException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        this.triggerEviction(this.cluster.getDataNodes().get(0));
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        this.cluster.corruptReplica(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        org.junit.jupiter.api.Assertions.assertThrows(ChecksumException.class, () -> DFSTestUtil.readFileBuffer((FileSystem)this.fs, path1));
    }

    @Test
    public void testScrMetaFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(false).build();
        this.doShortCircuitReadMetaFileCorruptionTest();
    }

    @Test
    public void testLegacyScrMetaFileCorruption() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setUseScr(true).setUseLegacyBlockReaderLocal(true).build();
        this.doShortCircuitReadMetaFileCorruptionTest();
    }

    public void doShortCircuitReadMetaFileCorruptionTest() throws IOException, InterruptedException, TimeoutException {
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        this.triggerEviction(this.cluster.getDataNodes().get(0));
        this.ensureFileReplicasOnStorageType(path1, StorageType.DEFAULT);
        this.cluster.corruptMeta(0, DFSTestUtil.getFirstBlock((FileSystem)this.fs, path1));
        org.junit.jupiter.api.Assertions.assertThrows(ChecksumException.class, () -> DFSTestUtil.readFileBuffer((FileSystem)this.fs, path1));
    }
}

