/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestReplicaMap {
    private final ReplicaMap map = new ReplicaMap();
    private final String bpid = "BP-TEST";
    private final Block block = new Block(1234L, 1234L, 1234L);

    @BeforeEach
    public void setup() {
        this.map.add("BP-TEST", (ReplicaInfo)new FinalizedReplica(this.block, null, null));
    }

    @Test
    public void testGet() {
        try {
            this.map.get("BP-TEST", null);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)this.map.get("BP-TEST", this.block));
        Block b = new Block(this.block);
        b.setGenerationStamp(0L);
        Assertions.assertNull((Object)this.map.get("BP-TEST", b));
        b.setGenerationStamp(this.block.getGenerationStamp());
        b.setBlockId(0L);
        Assertions.assertNull((Object)this.map.get("BP-TEST", b));
        Assertions.assertNotNull((Object)this.map.get("BP-TEST", this.block.getBlockId()));
        Assertions.assertNull((Object)this.map.get("BP-TEST", 0L));
    }

    @Test
    public void testAdd() {
        try {
            this.map.add("BP-TEST", null);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() {
        try {
            this.map.remove("BP-TEST", null);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Block b = new Block(this.block);
        b.setGenerationStamp(0L);
        Assertions.assertNull((Object)this.map.remove("BP-TEST", b));
        b.setGenerationStamp(this.block.getGenerationStamp());
        b.setBlockId(0L);
        Assertions.assertNull((Object)this.map.remove("BP-TEST", b));
        Assertions.assertNotNull((Object)this.map.remove("BP-TEST", this.block));
        Assertions.assertNull((Object)this.map.remove("BP-TEST", 0L));
        this.map.add("BP-TEST", (ReplicaInfo)new FinalizedReplica(this.block, null, null));
        Assertions.assertNotNull((Object)this.map.remove("BP-TEST", this.block.getBlockId()));
    }

    @Test
    public void testMergeAll() {
        ReplicaMap temReplicaMap = new ReplicaMap();
        Block tmpBlock = new Block(5678L, 5678L, 5678L);
        temReplicaMap.add("BP-TEST", (ReplicaInfo)new FinalizedReplica(tmpBlock, null, null));
        this.map.mergeAll(temReplicaMap);
        Assertions.assertNotNull((Object)this.map.get("BP-TEST", 1234L));
        Assertions.assertNotNull((Object)this.map.get("BP-TEST", 5678L));
    }

    @Test
    public void testAddAll() {
        ReplicaMap temReplicaMap = new ReplicaMap();
        Block tmpBlock = new Block(5678L, 5678L, 5678L);
        temReplicaMap.add("BP-TEST", (ReplicaInfo)new FinalizedReplica(tmpBlock, null, null));
        this.map.addAll(temReplicaMap);
        Assertions.assertNull((Object)this.map.get("BP-TEST", 1234L));
        Assertions.assertNotNull((Object)this.map.get("BP-TEST", 5678L));
    }
}

