/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLazyWriter
extends LazyPersistTestCase {
    @Test
    public void testLazyPersistBlocksAreSaved() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().build();
        int NUM_BLOCKS = 10;
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x3200000L, true);
        LocatedBlocks locatedBlocks = this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 10);
        LOG.info("Verifying copy was saved to lazyPersist/");
        this.ensureLazyPersistBlocksAreSaved(locatedBlocks);
    }

    @Test
    public void testSynchronousEviction() throws Exception {
        this.getClusterBuilder().setMaxLockedMemory(0x500000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        this.makeTestFile(path2, 0x500000L, true);
        this.waitForMetric("RamDiskBlocksEvicted", 1);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvicted", 1L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvictedWithoutRead", 1L);
    }

    @Test
    public void testRamDiskEvictionBeforePersist() throws Exception {
        this.getClusterBuilder().setMaxLockedMemory(0x500000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        Path path2 = new Path("/" + METHOD_NAME + ".02.dat");
        int SEED = 1027565;
        FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.makeTestFile(path2, 0x500000L, true);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvicted", 0L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.ensureFileReplicasOnStorageType(path2, StorageType.DEFAULT);
        assert (this.fs.exists(path1));
        assert (this.fs.exists(path2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.verifyReadRandomFile(path1, 0x500000, 1027565));
    }

    @Test
    public void testRamDiskEvictionIsLru() throws Exception {
        int i;
        int i2;
        int NUM_PATHS = 5;
        this.getClusterBuilder().setMaxLockedMemory(0x1900000L).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path[] paths = new Path[10];
        for (i2 = 0; i2 < paths.length; ++i2) {
            paths[i2] = new Path("/" + METHOD_NAME + "." + i2 + ".dat");
        }
        for (i2 = 0; i2 < 5; ++i2) {
            this.makeTestFile(paths[i2], 0x500000L, true);
        }
        this.waitForMetric("RamDiskBlocksLazyPersisted", 5);
        for (i2 = 0; i2 < 5; ++i2) {
            this.ensureFileReplicasOnStorageType(paths[i2], StorageType.RAM_DISK);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(5);
        for (i = 0; i < 5; ++i) {
            indexes.add(i);
        }
        Collections.shuffle(indexes);
        for (i = 0; i < 5; ++i) {
            LOG.info("Touching file " + paths[(Integer)indexes.get(i)]);
            DFSTestUtil.readFile((FileSystem)this.fs, paths[(Integer)indexes.get(i)]);
        }
        for (i = 0; i < 5; ++i) {
            this.makeTestFile(paths[i + 5], 0x500000L, true);
            this.triggerBlockReport();
            this.ensureFileReplicasOnStorageType(paths[i + 5], StorageType.RAM_DISK);
            this.ensureFileReplicasOnStorageType(paths[(Integer)indexes.get(i)], StorageType.DEFAULT);
            for (int j = i + 1; j < 5; ++j) {
                this.ensureFileReplicasOnStorageType(paths[(Integer)indexes.get(j)], StorageType.RAM_DISK);
            }
        }
        this.verifyRamDiskJMXMetric("RamDiskBlocksWrite", 10L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksWriteFallback", 0L);
        this.verifyRamDiskJMXMetric("RamDiskBytesWrite", 0x3200000L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksReadHits", 5L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvicted", 5L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksEvictedWithoutRead", 0L);
        this.verifyRamDiskJMXMetric("RamDiskBlocksDeletedBeforeLazyPersisted", 0L);
    }

    @Test
    public void testDeleteBeforePersist() throws Exception {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        DataNode dn = this.cluster.getDataNodes().get(0);
        FsDatasetTestUtil.stopLazyWriter(dn);
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        LocatedBlocks locatedBlocks = this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        this.client.delete(path.toString(), false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.exists(path));
        Assertions.assertThat((boolean)this.verifyDeletedBlocks(locatedBlocks)).isEqualTo(true);
        this.verifyRamDiskJMXMetric("RamDiskBlocksDeletedBeforeLazyPersisted", 1L);
    }

    @Test
    public void testDeleteAfterPersist() throws Exception {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        LocatedBlocks locatedBlocks = this.ensureFileReplicasOnStorageType(path, StorageType.RAM_DISK);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        this.client.delete(path.toString(), false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.exists(path));
        Assertions.assertThat((boolean)this.verifyDeletedBlocks(locatedBlocks)).isEqualTo(true);
        this.verifyRamDiskJMXMetric("RamDiskBlocksLazyPersisted", 1L);
        this.verifyRamDiskJMXMetric("RamDiskBytesLazyPersisted", 0x500000L);
    }

    @Test
    public void testDfsUsageCreateDelete() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setRamDiskReplicaCapacity(4).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        long usedBeforeCreate = this.fs.getUsed();
        this.makeTestFile(path, 0x500000L, true);
        long usedAfterCreate = this.fs.getUsed();
        Assertions.assertThat((long)usedAfterCreate).isEqualTo(0x500000L);
        this.waitForMetric("RamDiskBlocksLazyPersisted", 1);
        long usedAfterPersist = this.fs.getUsed();
        Assertions.assertThat((long)usedAfterPersist).isEqualTo(0x500000L);
        this.client.delete(path.toString(), false);
        long usedAfterDelete = this.fs.getUsed();
        Assertions.assertThat((long)usedBeforeCreate).isEqualTo(usedAfterDelete);
    }
}

