/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ThreadUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestLazyPersistFiles
extends LazyPersistTestCase {
    private static final int THREADPOOL_SIZE = 10;

    @Test
    public void testAppendIsDenied() throws IOException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        try {
            this.client.append(path.toString(), 4096, EnumSet.of(CreateFlag.APPEND), null, null).close();
            org.junit.jupiter.api.Assertions.fail((String)"Append to LazyPersist file did not fail as expected");
        }
        catch (Throwable t) {
            LOG.info("Got expected exception ", t);
        }
    }

    @Test
    public void testTruncateIsDenied() throws IOException {
        this.getClusterBuilder().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path = new Path("/" + METHOD_NAME + ".dat");
        this.makeTestFile(path, 0x500000L, true);
        try {
            this.client.truncate(path.toString(), 0x280000L);
            org.junit.jupiter.api.Assertions.fail((String)"Truncate to LazyPersist file did not fail as expected");
        }
        catch (Throwable t) {
            LOG.info("Got expected exception ", t);
        }
    }

    @Test
    public void testCorruptFilesAreDiscarded() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setRamDiskReplicaCapacity(2).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.shutdownDataNodes();
        Assertions.assertThat((int)this.cluster.getNamesystem().getNumDeadDataNodes()).isEqualTo(1);
        this.waitForRedundancyMonitorCycle();
        this.waitForScrubberCycle();
        this.waitForFile(path1, false);
        this.waitForLowRedundancyCount(0L);
    }

    @Test
    public void testDisableLazyPersistFileScrubber() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setRamDiskReplicaCapacity(2).disableScrubber().build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.shutdownDataNodes();
        this.waitForCorruptBlock(1L);
        this.waitForScrubberCycle();
        this.waitForFile(path1, true);
    }

    @Test
    @Timeout(value=20L)
    public void testFileShouldNotDiscardedIfNNRestarted() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setRamDiskReplicaCapacity(2).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        Path path1 = new Path("/" + METHOD_NAME + ".01.dat");
        this.makeTestFile(path1, 0x500000L, true);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        this.shutdownDataNodes();
        this.cluster.restartNameNodes();
        this.waitForCorruptBlock(1L);
        this.waitForFile(path1, true);
    }

    @Test
    public void testConcurrentRead() throws Exception {
        int i;
        this.getClusterBuilder().setRamDiskReplicaCapacity(2).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        final Path path1 = new Path("/" + METHOD_NAME + ".dat");
        int SEED = 1027565;
        int NUM_TASKS = 5;
        this.makeRandomTestFile(path1, 0x500000L, true, 1027565L);
        this.ensureFileReplicasOnStorageType(path1, StorageType.RAM_DISK);
        final CountDownLatch latch = new CountDownLatch(5);
        final AtomicBoolean testFailed = new AtomicBoolean(false);
        Runnable readerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)TestLazyPersistFiles.this.verifyReadRandomFile(path1, 0x500000, 1027565));
                }
                catch (Throwable e) {
                    LazyPersistTestCase.LOG.error("readerRunnable error", e);
                    testFailed.set(true);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        Thread[] threads = new Thread[5];
        for (i = 0; i < 5; ++i) {
            threads[i] = new Thread(readerRunnable);
            threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            ThreadUtil.joinUninterruptibly((Thread)threads[i]);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testFailed.get());
    }

    @Test
    public void testConcurrentWrites() throws IOException, InterruptedException, TimeoutException {
        this.getClusterBuilder().setRamDiskReplicaCapacity(9).build();
        String METHOD_NAME = GenericTestUtils.getMethodName();
        int SEED = 1027565;
        int NUM_WRITERS = 4;
        int NUM_WRITER_PATHS = 5;
        Path[][] paths = new Path[4][5];
        for (int i = 0; i < 4; ++i) {
            paths[i] = new Path[5];
            for (int j = 0; j < 5; ++j) {
                paths[i][j] = new Path("/" + METHOD_NAME + ".Writer" + i + ".File." + j + ".dat");
            }
        }
        CountDownLatch latch = new CountDownLatch(4);
        AtomicBoolean testFailed = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 4; ++i) {
            WriterRunnable writer = new WriterRunnable(i, paths[i], 1027565, latch, testFailed);
            executor.execute(writer);
        }
        Thread.sleep(3000L);
        this.triggerBlockReport();
        latch.await();
        Assertions.assertThat((boolean)testFailed.get()).isEqualTo(false);
    }

    @Test
    @Timeout(value=20L)
    public void testReleaseVolumeRefIfExceptionThrown() throws IOException, InterruptedException {
        int i;
        this.getClusterBuilder().setRamDiskReplicaCapacity(2).build();
        String methodName = GenericTestUtils.getMethodName();
        int seed = 1027565;
        Path path = new Path("/" + methodName + ".Writer.File.dat");
        DataNode dn = this.cluster.getDataNodes().get(0);
        FsDatasetSpi.FsVolumeReferences volumes = DataNodeTestUtils.getFSDataset(dn).getFsVolumeReferences();
        int[] beforeCnts = new int[volumes.size()];
        FsDatasetImpl ds = (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
        ds.asyncLazyPersistService.shutdown();
        for (i = 0; i < volumes.size(); ++i) {
            beforeCnts[i] = ((FsVolumeImpl)volumes.get(i)).getReferenceCount();
        }
        this.makeRandomTestFile(path, 0x500000L, true, 1027565L);
        Thread.sleep(3000L);
        for (i = 0; i < volumes.size(); ++i) {
            int afterCnt = ((FsVolumeImpl)volumes.get(i)).getReferenceCount();
            org.junit.jupiter.api.Assertions.assertTrue((beforeCnts[i] == afterCnt || beforeCnts[i] == afterCnt - 1 ? 1 : 0) != 0);
        }
    }

    class WriterRunnable
    implements Runnable {
        private final int id;
        private final Path[] paths;
        private final int seed;
        private CountDownLatch latch;
        private AtomicBoolean bFail;

        public WriterRunnable(int threadIndex, Path[] paths, int seed, CountDownLatch latch, AtomicBoolean bFail) {
            this.id = threadIndex;
            this.paths = paths;
            this.seed = seed;
            this.latch = latch;
            this.bFail = bFail;
            LazyPersistTestCase.LOG.info("Creating Writer: {}", (Object)this.id);
        }

        @Override
        public void run() {
            LazyPersistTestCase.LOG.info("Writer {} starting... ", (Object)this.id);
            int i = 0;
            try {
                for (i = 0; i < this.paths.length; ++i) {
                    TestLazyPersistFiles.this.makeRandomTestFile(this.paths[i], 0x500000L, true, this.seed);
                }
            }
            catch (IOException e) {
                this.bFail.set(true);
                LazyPersistTestCase.LOG.error("Writer exception: writer id:{} testfile: {}", new Object[]{this.id, this.paths[i].toString(), e});
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

