/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.DatasetVolumeChecker;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.test.TestName;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDatasetVolumeCheckerTimeout {
    public static final Logger LOG = LoggerFactory.getLogger(TestDatasetVolumeCheckerTimeout.class);
    @RegisterExtension
    public TestName testName = new TestName();
    static Configuration conf;
    private static final long DISK_CHECK_TIMEOUT = 10L;
    private static final long DISK_CHECK_TIME = 100L;
    static ReentrantLock lock;

    static FsVolumeSpi makeSlowVolume() throws Exception {
        FsVolumeSpi volume = (FsVolumeSpi)Mockito.mock(FsVolumeSpi.class);
        FsVolumeReference reference = (FsVolumeReference)Mockito.mock(FsVolumeReference.class);
        StorageLocation location = (StorageLocation)Mockito.mock(StorageLocation.class);
        Mockito.when((Object)reference.getVolume()).thenReturn((Object)volume);
        Mockito.when((Object)volume.obtainReference()).thenReturn((Object)reference);
        Mockito.when((Object)volume.getStorageLocation()).thenReturn((Object)location);
        Mockito.when((Object)volume.check(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            lock.lock();
            lock.unlock();
            return VolumeCheckResult.HEALTHY;
        });
        return volume;
    }

    @Test
    @Timeout(value=300L)
    public void testDiskCheckTimeout() throws Exception {
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        FsVolumeSpi volume = TestDatasetVolumeCheckerTimeout.makeSlowVolume();
        DatasetVolumeChecker checker = new DatasetVolumeChecker(conf, (Timer)new FakeTimer());
        final AtomicLong numCallbackInvocations = new AtomicLong(0L);
        lock.lock();
        boolean result = checker.checkVolume(volume, new DatasetVolumeChecker.Callback(){

            public void call(Set<FsVolumeSpi> healthyVolumes, Set<FsVolumeSpi> failedVolumes) {
                numCallbackInvocations.incrementAndGet();
                Assertions.assertThat((int)healthyVolumes.size()).isEqualTo(0);
                Assertions.assertThat((int)failedVolumes.size()).isEqualTo(1);
            }
        });
        Thread.sleep(100L);
        lock.unlock();
        ((FsVolumeSpi)Mockito.verify((Object)volume, (VerificationMode)Mockito.times((int)1))).check(ArgumentMatchers.any());
        Assertions.assertThat((long)numCallbackInvocations.get()).isEqualTo(1L);
    }

    static {
        lock = new ReentrantLock();
        conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.datanode.disk.check.timeout", 10L, TimeUnit.MILLISECONDS);
    }
}

