/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetFactory;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.util.DataChecksum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSimulatedFSDataset {
    Configuration conf = null;
    static final String bpid = "BP-TEST";
    static final int NUMBLOCKS = 20;
    static final int BLOCK_LENGTH_MULTIPLIER = 79;
    static final long FIRST_BLK_ID = 1L;
    private int storageCount = 1;

    protected void pTestSimulatedFSDataset(int pStorageCount) {
        this.storageCount = pStorageCount;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory(this.conf);
    }

    static long blockIdToLen(long blkid) {
        return blkid * 79L;
    }

    static int addSomeBlocks(SimulatedFSDataset fsdataset) throws IOException {
        return TestSimulatedFSDataset.addSomeBlocks(fsdataset, false);
    }

    static int addSomeBlocks(SimulatedFSDataset fsdataset, boolean negativeBlkID) throws IOException {
        return TestSimulatedFSDataset.addSomeBlocks(fsdataset, 1L, negativeBlkID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int addSomeBlocks(SimulatedFSDataset fsdataset, long startingBlockId, boolean negativeBlkID) throws IOException {
        int bytesAdded = 0;
        for (long i = startingBlockId; i < startingBlockId + 20L; ++i) {
            long blkID = negativeBlkID ? i * -1L : i;
            ExtendedBlock b = new ExtendedBlock(bpid, blkID, 0L, 0L);
            ReplicaInPipeline bInfo = fsdataset.createRbw(StorageType.DEFAULT, null, b, false).getReplica();
            try (ReplicaOutputStreams out = bInfo.createStreams(true, DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.CRC32, (int)512));){
                OutputStream dataOut = out.getDataOut();
                Assertions.assertEquals((long)0L, (long)fsdataset.getLength(b));
                int j = 1;
                while ((long)j <= TestSimulatedFSDataset.blockIdToLen(i)) {
                    dataOut.write(j);
                    Assertions.assertEquals((long)j, (long)bInfo.getBytesOnDisk());
                    ++bytesAdded;
                    ++j;
                }
            }
            b.setNumBytes(TestSimulatedFSDataset.blockIdToLen(i));
            fsdataset.finalizeBlock(b, false);
            Assertions.assertEquals((long)TestSimulatedFSDataset.blockIdToLen(i), (long)fsdataset.getLength(b));
        }
        return bytesAdded;
    }

    static void readSomeBlocks(SimulatedFSDataset fsdataset, boolean negativeBlkID) throws IOException {
        for (long i = 1L; i <= 20L; ++i) {
            long blkID = negativeBlkID ? i * -1L : i;
            ExtendedBlock b = new ExtendedBlock(bpid, blkID, 0L, 0L);
            Assertions.assertTrue((boolean)fsdataset.isValidBlock(b));
            Assertions.assertEquals((long)TestSimulatedFSDataset.blockIdToLen(i), (long)fsdataset.getLength(b));
            TestSimulatedFSDataset.checkBlockDataAndSize(fsdataset, b, TestSimulatedFSDataset.blockIdToLen(i));
        }
    }

    @Test
    public void testFSDatasetFactory() {
        Configuration conf = new Configuration();
        FsDatasetSpi.Factory f = FsDatasetSpi.Factory.getFactory((Configuration)conf);
        Assertions.assertEquals(FsDatasetFactory.class, f.getClass());
        Assertions.assertFalse((boolean)f.isSimulated());
        SimulatedFSDataset.setFactory(conf);
        FsDatasetSpi.Factory s = FsDatasetSpi.Factory.getFactory((Configuration)conf);
        Assertions.assertEquals(SimulatedFSDataset.Factory.class, s.getClass());
        Assertions.assertTrue((boolean)s.isSimulated());
    }

    @Test
    public void testGetMetaData() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        ExtendedBlock b = new ExtendedBlock(bpid, 1L, 5L, 0L);
        try {
            Assertions.assertTrue((fsdataset.getMetaDataInputStream(b) == null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)false, (String)"Expected an IO exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        b = new ExtendedBlock(bpid, 1L, 0L, 0L);
        LengthInputStream metaInput = fsdataset.getMetaDataInputStream(b);
        DataInputStream metaDataInput = new DataInputStream((InputStream)metaInput);
        short version = metaDataInput.readShort();
        Assertions.assertEquals((short)1, (short)version);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataInputStream)metaDataInput);
        Assertions.assertEquals((Object)DataChecksum.Type.NULL, (Object)checksum.getChecksumType());
        Assertions.assertEquals((int)0, (int)checksum.getChecksumSize());
    }

    @Test
    public void testStorageUsage() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        Assertions.assertEquals((long)fsdataset.getDfsUsed(), (long)0L);
        Assertions.assertEquals((long)fsdataset.getRemaining(), (long)fsdataset.getCapacity());
        int bytesAdded = TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        Assertions.assertEquals((long)bytesAdded, (long)fsdataset.getDfsUsed());
        Assertions.assertEquals((long)(fsdataset.getCapacity() - (long)bytesAdded), (long)fsdataset.getRemaining());
    }

    static void checkBlockDataAndSize(SimulatedFSDataset fsdataset, ExtendedBlock b, long expectedLen) throws IOException {
        int data;
        InputStream input = fsdataset.getBlockInputStream(b);
        long lengthRead = 0L;
        while ((data = input.read()) != -1) {
            Assertions.assertEquals((byte)SimulatedFSDataset.simulatedByte(b.getLocalBlock(), lengthRead), (byte)((byte)(data & 0xFF)));
            ++lengthRead;
        }
        Assertions.assertEquals((long)expectedLen, (long)lengthRead);
    }

    @Test
    public void testWriteRead() throws IOException {
        this.testWriteRead(false);
        this.testWriteRead(true);
    }

    private void testWriteRead(boolean negativeBlkID) throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        TestSimulatedFSDataset.addSomeBlocks(fsdataset, negativeBlkID);
        TestSimulatedFSDataset.readSomeBlocks(fsdataset, negativeBlkID);
    }

    @Test
    public void testGetBlockReport() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        this.assertBlockReportCountAndSize(fsdataset, 0);
        TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        this.assertBlockReportCountAndSize(fsdataset, 20);
        this.assertBlockLengthInBlockReports(fsdataset);
    }

    @Test
    public void testInjectionEmpty() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        this.assertBlockReportCountAndSize(fsdataset, 0);
        int bytesAdded = TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        this.assertBlockReportCountAndSize(fsdataset, 20);
        this.assertBlockLengthInBlockReports(fsdataset);
        SimulatedFSDataset sfsdataset = this.getSimulatedFSDataset();
        this.injectBlocksFromBlockReport(fsdataset, sfsdataset);
        this.assertBlockReportCountAndSize(fsdataset, 20);
        this.assertBlockLengthInBlockReports(fsdataset, sfsdataset);
        Assertions.assertEquals((long)bytesAdded, (long)sfsdataset.getDfsUsed());
        Assertions.assertEquals((long)(sfsdataset.getCapacity() - (long)bytesAdded), (long)sfsdataset.getRemaining());
    }

    @Test
    public void testInjectionNonEmpty() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        this.assertBlockReportCountAndSize(fsdataset, 0);
        int bytesAdded = TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        this.assertBlockReportCountAndSize(fsdataset, 20);
        this.assertBlockLengthInBlockReports(fsdataset);
        SimulatedFSDataset sfsdataset = this.getSimulatedFSDataset();
        this.assertBlockReportCountAndSize(sfsdataset, 20);
        this.injectBlocksFromBlockReport(fsdataset, sfsdataset);
        this.assertBlockReportCountAndSize(sfsdataset, 40);
        this.assertBlockLengthInBlockReports(fsdataset, sfsdataset);
        Assertions.assertEquals((long)(bytesAdded += TestSimulatedFSDataset.addSomeBlocks(sfsdataset, 21L, false)), (long)sfsdataset.getDfsUsed());
        Assertions.assertEquals((long)(sfsdataset.getCapacity() - (long)bytesAdded), (long)sfsdataset.getRemaining());
        this.conf.setLong("dfs.datanode.simulateddatastorage.capacity", 10L);
        try {
            sfsdataset = this.getSimulatedFSDataset();
            sfsdataset.addBlockPool(bpid, this.conf);
            this.injectBlocksFromBlockReport(fsdataset, sfsdataset);
            Assertions.assertTrue((boolean)false, (String)"Expected an IO exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkInvalidBlock(ExtendedBlock b) {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        Assertions.assertFalse((boolean)fsdataset.isValidBlock(b));
        try {
            fsdataset.getLength(b);
            Assertions.assertTrue((boolean)false, (String)"Expected an IO exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsdataset.getBlockInputStream(b);
            Assertions.assertTrue((boolean)false, (String)"Expected an IO exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsdataset.finalizeBlock(b, false);
            Assertions.assertTrue((boolean)false, (String)"Expected an IO exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInValidBlocks() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        ExtendedBlock b = new ExtendedBlock(bpid, 1L, 5L, 0L);
        this.checkInvalidBlock(b);
        TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        b = new ExtendedBlock(bpid, 119L, 5L, 0L);
        this.checkInvalidBlock(b);
    }

    @Test
    public void testInvalidate() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        int bytesAdded = TestSimulatedFSDataset.addSomeBlocks(fsdataset);
        Block[] deleteBlocks = new Block[]{new Block(1L, 0L, 0L), new Block(2L, 0L, 0L)};
        fsdataset.invalidate(bpid, deleteBlocks);
        this.checkInvalidBlock(new ExtendedBlock(bpid, deleteBlocks[0]));
        this.checkInvalidBlock(new ExtendedBlock(bpid, deleteBlocks[1]));
        long sizeDeleted = TestSimulatedFSDataset.blockIdToLen(1L) + TestSimulatedFSDataset.blockIdToLen(2L);
        Assertions.assertEquals((long)((long)bytesAdded - sizeDeleted), (long)fsdataset.getDfsUsed());
        Assertions.assertEquals((long)(fsdataset.getCapacity() - (long)bytesAdded + sizeDeleted), (long)fsdataset.getRemaining());
        for (int i = 3; i <= 20; ++i) {
            Block b = new Block((long)i, 0L, 0L);
            Assertions.assertTrue((boolean)fsdataset.isValidBlock(new ExtendedBlock(bpid, b)));
        }
    }

    private void injectBlocksFromBlockReport(SimulatedFSDataset sourceFSDataset, SimulatedFSDataset destinationFSDataset) throws IOException {
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> ent : sourceFSDataset.getBlockReports(bpid).entrySet()) {
            destinationFSDataset.injectBlocks(bpid, (Iterable)ent.getValue());
        }
    }

    private void assertBlockReportCountAndSize(SimulatedFSDataset fsdataset, int expectedBlockCount) {
        Map<DatanodeStorage, BlockListAsLongs> blockReportMap = fsdataset.getBlockReports(bpid);
        Assertions.assertEquals((int)this.storageCount, (int)blockReportMap.size());
        int totalCount = 0;
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> ent : blockReportMap.entrySet()) {
            totalCount += ent.getValue().getNumberOfBlocks();
        }
        Assertions.assertEquals((int)expectedBlockCount, (int)totalCount);
    }

    private void assertBlockLengthInBlockReports(SimulatedFSDataset fsdataset) throws IOException {
        this.assertBlockLengthInBlockReports(fsdataset, null);
    }

    private void assertBlockLengthInBlockReports(SimulatedFSDataset fsdataset, SimulatedFSDataset otherFSDataset) throws IOException {
        for (Map.Entry<DatanodeStorage, BlockListAsLongs> ent : fsdataset.getBlockReports(bpid).entrySet()) {
            for (Block b : ent.getValue()) {
                Assertions.assertNotNull((Object)b);
                Assertions.assertEquals((long)TestSimulatedFSDataset.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
                if (otherFSDataset == null) continue;
                Assertions.assertEquals((long)TestSimulatedFSDataset.blockIdToLen(b.getBlockId()), (long)otherFSDataset.getLength(new ExtendedBlock(bpid, b)));
            }
        }
    }

    protected SimulatedFSDataset getSimulatedFSDataset() {
        SimulatedFSDataset fsdataset = new SimulatedFSDataset(null, this.conf);
        fsdataset.addBlockPool(bpid, this.conf);
        return fsdataset;
    }

    @Test
    public void testConcurrentAddBlockPool() throws InterruptedException, IOException {
        final String[] bpids = new String[]{"BP-TEST1-", "BP-TEST2-"};
        final SimulatedFSDataset fsdataset = new SimulatedFSDataset(null, this.conf);
        class AddBlockPoolThread
        extends Thread {
            private int id;
            private IOException ioe;

            public AddBlockPoolThread(int id) {
                this.id = id;
            }

            public void test() throws InterruptedException, IOException {
                this.join();
                if (this.ioe != null) {
                    throw this.ioe;
                }
            }

            @Override
            public void run() {
                for (int i = 0; i < 10000; ++i) {
                    String newbpid = bpids[this.id] + i;
                    fsdataset.addBlockPool(newbpid, TestSimulatedFSDataset.this.conf);
                    ExtendedBlock block = new ExtendedBlock(newbpid, 1L);
                    try {
                        fsdataset.createTemporary(StorageType.DEFAULT, null, block, false);
                    }
                    catch (IOException ioe) {
                        this.ioe = ioe;
                    }
                    assert (fsdataset.getReplicaString(newbpid, 1L) != "null");
                }
            }
        }
        AddBlockPoolThread t1 = new AddBlockPoolThread(0);
        AddBlockPoolThread t2 = new AddBlockPoolThread(1);
        t1.start();
        t2.start();
        t1.test();
        t2.test();
    }
}

