/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReadOnlySharedStorage {
    public static final Logger LOG = LoggerFactory.getLogger(TestReadOnlySharedStorage.class);
    private static final short NUM_DATANODES = 3;
    private static final int RO_NODE_INDEX = 0;
    private static final int BLOCK_SIZE = 1024;
    private static final long seed = 464384013L;
    private static final Path PATH = new Path("/" + TestReadOnlySharedStorage.class.getName() + ".dat");
    private static final int RETRIES = 10;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DFSClient client;
    private BlockManager blockManager;
    private DatanodeManager datanodeManager;
    private DatanodeInfo normalDataNode;
    private DatanodeInfo readOnlyDataNode;
    private Block block;
    private BlockInfo storedBlock;
    private ExtendedBlock extendedBlock;

    @BeforeEach
    public void setup() throws IOException, InterruptedException {
        int i;
        this.conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory(this.conf);
        Configuration[] overlays = new Configuration[3];
        for (i = 0; i < overlays.length; ++i) {
            overlays[i] = new Configuration();
            if (i != 0) continue;
            overlays[i].setEnum("dfs.datanode.simulateddatastorage.state", (Enum)(i == 0 ? DatanodeStorage.State.READ_ONLY_SHARED : DatanodeStorage.State.NORMAL));
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).dataNodeConfOverlays(overlays).build();
        this.fs = this.cluster.getFileSystem();
        this.blockManager = this.cluster.getNameNode().getNamesystem().getBlockManager();
        this.datanodeManager = this.blockManager.getDatanodeManager();
        this.client = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.cluster.getConfiguration(0));
        for (i = 0; i < 3; ++i) {
            DataNode dataNode = this.cluster.getDataNodes().get(i);
            this.validateStorageState(BlockManagerTestUtil.getStorageReportsForDatanode(this.datanodeManager.getDatanode(dataNode.getDatanodeId())), i == 0 ? DatanodeStorage.State.READ_ONLY_SHARED : DatanodeStorage.State.NORMAL);
        }
        DFSTestUtil.createFile((FileSystem)this.fs, PATH, 1024, 1024L, 1024L, (short)1, 464384013L);
        LocatedBlock locatedBlock = this.getLocatedBlock();
        this.extendedBlock = locatedBlock.getBlock();
        this.block = this.extendedBlock.getLocalBlock();
        this.storedBlock = this.blockManager.getStoredBlock(this.block);
        Assertions.assertThat((int)locatedBlock.getLocations().length).isEqualTo(1);
        this.normalDataNode = locatedBlock.getLocations()[0];
        this.readOnlyDataNode = this.datanodeManager.getDatanode(this.cluster.getDataNodes().get(0).getDatanodeId());
        Assertions.assertThat((Comparable)this.normalDataNode).isNotEqualTo((Object)this.readOnlyDataNode);
        this.validateNumberReplicas(1);
        this.cluster.injectBlocks(0, 0, Collections.singleton(this.block));
        this.waitForLocations(2);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.fs.delete(PATH, false);
        if (this.cluster != null) {
            this.fs.close();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void waitForLocations(int locations) throws IOException, InterruptedException {
        int tries = 0;
        while (tries < 10) {
            try {
                LocatedBlock locatedBlock = this.getLocatedBlock();
                Assertions.assertThat((int)locatedBlock.getLocations().length).isEqualTo(locations);
                break;
            }
            catch (AssertionError e) {
                if (++tries < 10) {
                    Thread.sleep(1000L);
                    continue;
                }
                throw e;
            }
        }
    }

    private LocatedBlock getLocatedBlock() throws IOException {
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(PATH.toString(), 0L, 1024L);
        Assertions.assertThat((int)locatedBlocks.getLocatedBlocks().size()).isEqualTo(1);
        return (LocatedBlock)Iterables.getOnlyElement((Iterable)locatedBlocks.getLocatedBlocks());
    }

    private void validateStorageState(StorageReport[] storageReports, DatanodeStorage.State state) {
        for (StorageReport storageReport : storageReports) {
            DatanodeStorage storage = storageReport.getStorage();
            Assertions.assertThat((Comparable)storage.getState()).isEqualTo((Object)state);
        }
    }

    private void validateNumberReplicas(int expectedReplicas) throws IOException {
        NumberReplicas numberReplicas = this.blockManager.countNodes(this.storedBlock);
        Assertions.assertThat((int)numberReplicas.liveReplicas()).isEqualTo(expectedReplicas);
        Assertions.assertThat((int)numberReplicas.excessReplicas()).isEqualTo(0);
        Assertions.assertThat((int)numberReplicas.corruptReplicas()).isEqualTo(0);
        Assertions.assertThat((int)numberReplicas.decommissionedAndDecommissioning()).isEqualTo(0);
        Assertions.assertThat((int)numberReplicas.replicasOnStaleNodes()).isEqualTo(0);
        BlockManagerTestUtil.updateState(this.blockManager);
        Assertions.assertThat((long)this.blockManager.getLowRedundancyBlocksCount()).isEqualTo(0L);
        Assertions.assertThat((long)this.blockManager.getExcessBlocksCount()).isEqualTo(0L);
    }

    @Test
    public void testReplicaCounting() throws Exception {
        this.validateNumberReplicas(1);
        this.fs.setReplication(PATH, (short)2);
        this.waitForLocations(3);
        this.validateNumberReplicas(2);
    }

    @Test
    public void testNormalReplicaOffline() throws Exception {
        this.cluster.stopDataNode(this.normalDataNode.getXferAddr());
        BlockManagerTestUtil.noticeDeadDatanode(this.cluster.getNameNode(), this.normalDataNode.getXferAddr());
        NumberReplicas numberReplicas = this.blockManager.countNodes(this.storedBlock);
        Assertions.assertThat((int)numberReplicas.liveReplicas()).isEqualTo(0);
        BlockManagerTestUtil.updateState(this.blockManager);
        Assertions.assertThat((long)this.blockManager.getLowRedundancyBlocksCount()).isEqualTo(1L);
        BlockManagerTestUtil.computeAllPendingWork(this.blockManager);
        DFSTestUtil.waitForReplication(this.cluster, this.extendedBlock, 1, 1, 0);
        Assertions.assertThat((int)this.getLocatedBlock().getLocations().length).isEqualTo(2);
        this.validateNumberReplicas(1);
    }

    @Test
    public void testReadOnlyReplicaCorrupt() throws Exception {
        this.client.reportBadBlocks(new LocatedBlock[]{new LocatedBlock(this.extendedBlock, new DatanodeInfo[]{this.readOnlyDataNode})});
        this.waitForLocations(1);
        NumberReplicas numberReplicas = this.blockManager.countNodes(this.storedBlock);
        Assertions.assertThat((int)numberReplicas.corruptReplicas()).isEqualTo(0);
    }
}

