/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsDatasetCacheRevocation {
    private static final Logger LOG = LoggerFactory.getLogger(TestFsDatasetCacheRevocation.class);
    private static NativeIO.POSIX.CacheManipulator prevCacheManipulator;
    private static TemporarySocketDirectory sockDir;
    private static final int BLOCK_SIZE = 4096;

    @BeforeEach
    public void setUp() throws Exception {
        prevCacheManipulator = NativeIO.POSIX.getCacheManipulator();
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.NoMlockCacheManipulator());
        DomainSocket.disableBindPathValidation();
        sockDir = new TemporarySocketDirectory();
    }

    @AfterEach
    public void tearDown() throws Exception {
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)prevCacheManipulator);
        sockDir.close();
    }

    private static Configuration getDefaultConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.path.based.cache.refresh.interval.ms", 50L);
        conf.setLong("dfs.cachereport.intervalMsec", 250L);
        conf.setLong("dfs.blocksize", 4096L);
        conf.setLong("dfs.datanode.max.locked.memory", 65536L);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "sock").getAbsolutePath());
        return conf;
    }

    @Test
    @Timeout(value=120L)
    public void testPinning() throws Exception {
        Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        PlatformAssumptions.assumeNotWindows();
        Configuration conf = TestFsDatasetCacheRevocation.getDefaultConf();
        conf.setLong("dfs.datanode.cache.revocation.timeout.ms", 1800000L);
        conf.setLong("dfs.datanode.cache.revocation.polling.ms", 2L);
        MiniDFSCluster cluster = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        String testFile = "/test_file";
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/test_file"), 4096L, (short)1, 51966L);
        dfs.addCachePool(new CachePoolInfo("pool"));
        long cacheDirectiveId = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("pool").setPath(new Path("/test_file")).setReplication(Short.valueOf((short)1)).build());
        FsDatasetSpi fsd = cluster.getDataNodes().get(0).getFSDataset();
        DFSTestUtil.verifyExpectedCacheUsage(4096L, 1L, fsd);
        FSDataInputStream in = dfs.open(new Path("/test_file"));
        ByteBuffer buf = in.read(null, 4096, EnumSet.noneOf(ReadOption.class));
        dfs.removeCacheDirective(cacheDirectiveId);
        Thread.sleep(500L);
        DFSTestUtil.verifyExpectedCacheUsage(4096L, 1L, fsd);
        in.releaseBuffer(buf);
        DFSTestUtil.verifyExpectedCacheUsage(0L, 0L, fsd);
        in.close();
        cluster.shutdown();
    }

    @Test
    @Timeout(value=120L)
    public void testRevocation() throws Exception {
        Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        PlatformAssumptions.assumeNotWindows();
        BlockReaderTestUtil.enableHdfsCachingTracing();
        BlockReaderTestUtil.enableShortCircuitShmTracing();
        Configuration conf = TestFsDatasetCacheRevocation.getDefaultConf();
        conf.setLong("dfs.datanode.cache.revocation.timeout.ms", 250L);
        conf.setLong("dfs.datanode.cache.revocation.polling.ms", 2L);
        MiniDFSCluster cluster = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        String testFile = "/test_file2";
        DFSTestUtil.createFile((FileSystem)dfs, new Path("/test_file2"), 4096L, (short)1, 51966L);
        dfs.addCachePool(new CachePoolInfo("pool"));
        long cacheDirectiveId = dfs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("pool").setPath(new Path("/test_file2")).setReplication(Short.valueOf((short)1)).build());
        FsDatasetSpi fsd = cluster.getDataNodes().get(0).getFSDataset();
        DFSTestUtil.verifyExpectedCacheUsage(4096L, 1L, fsd);
        FSDataInputStream in = dfs.open(new Path("/test_file2"));
        ByteBuffer buf = in.read(null, 4096, EnumSet.noneOf(ReadOption.class));
        LOG.info("removing cache directive {}", (Object)cacheDirectiveId);
        dfs.removeCacheDirective(cacheDirectiveId);
        LOG.info("finished removing cache directive {}", (Object)cacheDirectiveId);
        Thread.sleep(1000L);
        DFSTestUtil.verifyExpectedCacheUsage(0L, 0L, fsd);
        in.releaseBuffer(buf);
        in.close();
        cluster.shutdown();
    }
}

