/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeleteBlockPool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteBlockPool() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.nameservices", "namesServerId1,namesServerId2");
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(conf.get("dfs.nameservices"))).numDataNodes(2).build();
            cluster.waitActive();
            DistributedFileSystem fs1 = cluster.getFileSystem(0);
            DistributedFileSystem fs2 = cluster.getFileSystem(1);
            DFSTestUtil.createFile((FileSystem)fs1, new Path("/alpha"), 1024L, (short)2, 54L);
            DFSTestUtil.createFile((FileSystem)fs2, new Path("/beta"), 1024L, (short)2, 54L);
            DataNode dn1 = cluster.getDataNodes().get(0);
            DataNode dn2 = cluster.getDataNodes().get(1);
            String bpid1 = cluster.getNamesystem(0).getBlockPoolId();
            String bpid2 = cluster.getNamesystem(1).getBlockPoolId();
            try {
                dn1.deleteBlockPool(bpid1, true);
                Assertions.fail((String)"Must not delete a running block pool");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Configuration nn1Conf = cluster.getConfiguration(1);
            nn1Conf.set("dfs.nameservices", "namesServerId2");
            dn1.refreshNamenodes(nn1Conf);
            Assertions.assertEquals((int)1, (int)dn1.getAllBpOs().size());
            try {
                dn1.deleteBlockPool(bpid1, false);
                Assertions.fail((String)"Must not delete if any block files exist unless force is true");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            cluster.getFsDatasetTestUtils(0).verifyBlockPoolExists(bpid1);
            dn1.deleteBlockPool(bpid1, true);
            cluster.getFsDatasetTestUtils(0).verifyBlockPoolMissing(bpid1);
            fs1.delete(new Path("/alpha"), true);
            while (cluster.getFsDatasetTestUtils(1).getStoredReplicas(bpid1).hasNext()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
            cluster.shutdownNameNode(0);
            try {
                dn2.deleteBlockPool(bpid1, true);
                Assertions.fail((String)"Must not delete a running block pool");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dn2.refreshNamenodes(nn1Conf);
            Assertions.assertEquals((int)1, (int)dn2.getAllBpOs().size());
            cluster.getFsDatasetTestUtils(1).verifyBlockPoolExists(bpid1);
            dn2.deleteBlockPool(bpid1, false);
            cluster.getFsDatasetTestUtils(1).verifyBlockPoolMissing(bpid1);
            cluster.getFsDatasetTestUtils(0).verifyBlockPoolExists(bpid2);
            cluster.getFsDatasetTestUtils(1).verifyBlockPoolExists(bpid2);
            Path gammaFile = new Path("/gamma");
            DFSTestUtil.createFile((FileSystem)fs2, gammaFile, 1024L, (short)1, 55L);
            fs2.setReplication(gammaFile, (short)2);
            DFSTestUtil.waitReplication((FileSystem)fs2, gammaFile, (short)2);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDfsAdminDeleteBlockPool() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.nameservices", "namesServerId1,namesServerId2");
            cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(conf.get("dfs.nameservices"))).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs1 = cluster.getFileSystem(0);
            DistributedFileSystem fs2 = cluster.getFileSystem(1);
            DFSTestUtil.createFile((FileSystem)fs1, new Path("/alpha"), 1024L, (short)1, 54L);
            DFSTestUtil.createFile((FileSystem)fs2, new Path("/beta"), 1024L, (short)1, 54L);
            DataNode dn1 = cluster.getDataNodes().get(0);
            String bpid1 = cluster.getNamesystem(0).getBlockPoolId();
            String bpid2 = cluster.getNamesystem(1).getBlockPoolId();
            Configuration nn1Conf = cluster.getConfiguration(0);
            nn1Conf.set("dfs.nameservices", "namesServerId1");
            dn1.refreshNamenodes(nn1Conf);
            Assertions.assertEquals((int)1, (int)dn1.getAllBpOs().size());
            DFSAdmin admin = new DFSAdmin(nn1Conf);
            String dn1Address = dn1.getDatanodeId().getIpAddr() + ":" + dn1.getIpcPort();
            String[] args = new String[]{"-deleteBlockPool", dn1Address, bpid2};
            int ret = admin.run(args);
            Assertions.assertFalse((0 == ret ? 1 : 0) != 0);
            cluster.getFsDatasetTestUtils(0).verifyBlockPoolExists(bpid2);
            String[] forceArgs = new String[]{"-deleteBlockPool", dn1Address, bpid2, "force"};
            ret = admin.run(forceArgs);
            Assertions.assertEquals((int)0, (int)ret);
            cluster.getFsDatasetTestUtils(0).verifyBlockPoolMissing(bpid2);
            cluster.getFsDatasetTestUtils(0).verifyBlockPoolExists(bpid1);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

