/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestDatanodeProtocolRetryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TestDatanodeProtocolRetryPolicy.class);
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private DataNode dn;
    private Configuration conf;
    private boolean tearDownDone;
    ArrayList<StorageLocation> locations = new ArrayList();
    private static final String CLUSTER_ID = "testClusterID";
    private static final String POOL_ID = "BP-TEST";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private static DatanodeRegistration datanodeRegistration = DFSTestUtil.getLocalDatanodeRegistration();

    @BeforeEach
    public void startUp() throws IOException, URISyntaxException {
        this.tearDownDone = false;
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.datanode.data.dir", DATA_DIR);
        this.conf.set("dfs.datanode.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        this.conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        this.conf.setInt("ipc.client.connect.max.retries", 0);
        FileSystem.setDefaultUri((Configuration)this.conf, (String)("hdfs://" + NN_ADDR.getHostName() + ":" + NN_ADDR.getPort()));
        File dataDir = new File(DATA_DIR);
        FileUtil.fullyDelete((File)dataDir);
        dataDir.mkdirs();
        StorageLocation location = StorageLocation.parse((String)dataDir.getPath());
        this.locations.add(location);
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (!this.tearDownDone && this.dn != null) {
            try {
                this.dn.shutdown();
            }
            catch (Exception e) {
                LOG.error("Cannot close: ", (Throwable)e);
            }
            finally {
                File dir = new File(DATA_DIR);
                if (dir.exists()) {
                    Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)dir), (String)"Cannot delete data-node dirs");
                }
            }
            this.tearDownDone = true;
        }
    }

    private void waitForBlockReport(final DatanodeProtocolClientSideTranslatorPB mockNN) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)mockNN)).blockReport((DatanodeRegistration)Mockito.eq((Object)datanodeRegistration), (String)Mockito.eq((Object)TestDatanodeProtocolRetryPolicy.POOL_ID), (StorageBlockReport[])Mockito.any(), (BlockReportContext)Mockito.any());
                    return true;
                }
                catch (Throwable t) {
                    LOG.info("waiting on block report: " + t.getMessage());
                    return false;
                }
            }
        }, (long)500L, (long)100000L);
    }

    @Test
    @Timeout(value=60L)
    public void testDatanodeRegistrationRetry() throws Exception {
        final DatanodeProtocolClientSideTranslatorPB namenode = (DatanodeProtocolClientSideTranslatorPB)Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new Answer<DatanodeRegistration>(){
            int i = 0;

            public DatanodeRegistration answer(InvocationOnMock invocation) throws Throwable {
                ++this.i;
                if (this.i > 1 && this.i < 5) {
                    LOG.info("mockito exception " + this.i);
                    throw new EOFException("TestDatanodeProtocolRetryPolicy");
                }
                DatanodeRegistration dr = (DatanodeRegistration)invocation.getArguments()[0];
                datanodeRegistration = new DatanodeRegistration(dr.getDatanodeUuid(), dr);
                LOG.info("mockito succeeded " + datanodeRegistration);
                return datanodeRegistration;
            }
        }).when((Object)namenode)).registerDatanode((DatanodeRegistration)Mockito.any(DatanodeRegistration.class));
        Mockito.when((Object)namenode.versionRequest()).thenReturn((Object)new NamespaceInfo(1, CLUSTER_ID, POOL_ID, 1L));
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)new Answer<HeartbeatResponse>(){
            int i = 0;

            public HeartbeatResponse answer(InvocationOnMock invocation) throws Throwable {
                HeartbeatResponse heartbeatResponse;
                ++this.i;
                if (this.i == 1) {
                    LOG.info("mockito heartbeatResponse registration " + this.i);
                    heartbeatResponse = new HeartbeatResponse(new DatanodeCommand[]{RegisterCommand.REGISTER}, new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L), null, ThreadLocalRandom.current().nextLong() | 1L);
                } else {
                    LOG.info("mockito heartbeatResponse " + this.i);
                    heartbeatResponse = new HeartbeatResponse(new DatanodeCommand[0], new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L), null, ThreadLocalRandom.current().nextLong() | 1L);
                }
                return heartbeatResponse;
            }
        }).when((Object)namenode)).sendHeartbeat((DatanodeRegistration)Mockito.any(), (StorageReport[])Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(), (SlowDiskReports)Mockito.any());
        this.dn = new DataNode(this.conf, this.locations, null, null){

            DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
                Assertions.assertEquals((Object)NN_ADDR, (Object)nnAddr);
                return namenode;
            }
        };
        ((BPOfferService)this.dn.getAllBpOs().get(0)).triggerHeartbeatForTests();
        this.waitForBlockReport(namenode);
    }

    static {
        GenericTestUtils.setLogLevel((Logger)LOG, (Level)Level.TRACE);
    }
}

