/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDataStorage {
    private static final String DEFAULT_BPID = "bp-0";
    private static final String CLUSTER_ID = "cluster0";
    private static final String CLUSTER_ID2 = "cluster1";
    private static final String BUILD_VERSION = "2.0";
    private static final String SOFTWARE_VERSION = "2.0";
    private static final long CTIME = 1L;
    private static final File TEST_DIR = GenericTestUtils.getTestDir((String)"dstest");
    private static final HdfsServerConstants.StartupOption START_OPT = HdfsServerConstants.StartupOption.REGULAR;
    private DataNode mockDN = (DataNode)Mockito.mock(DataNode.class);
    private NamespaceInfo nsInfo;
    private DataStorage storage;

    @BeforeEach
    public void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.storage = new DataStorage();
        this.nsInfo = new NamespaceInfo(0, CLUSTER_ID, DEFAULT_BPID, 1L, "2.0", "2.0");
        FileUtil.fullyDelete((File)TEST_DIR);
        Assertions.assertTrue((boolean)TEST_DIR.mkdirs(), (String)"Failed to make test dir.");
        Mockito.when((Object)this.mockDN.getConf()).thenReturn((Object)conf);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.storage.unlockAll();
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    private static List<StorageLocation> createStorageLocations(int numLocs) throws IOException {
        return TestDataStorage.createStorageLocations(numLocs, false);
    }

    private static List<StorageLocation> createStorageLocations(int numLocs, boolean asFile) throws IOException {
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        for (int i = 0; i < numLocs; ++i) {
            String uri = TEST_DIR + "/data" + i;
            File file = new File(uri);
            if (asFile) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            } else {
                file.mkdirs();
            }
            StorageLocation loc = StorageLocation.parse((String)uri);
            locations.add(loc);
        }
        return locations;
    }

    private static List<NamespaceInfo> createNamespaceInfos(int num) {
        ArrayList<NamespaceInfo> nsInfos = new ArrayList<NamespaceInfo>();
        for (int i = 0; i < num; ++i) {
            String bpid = "bp-" + i;
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L, "2.0", "2.0"));
        }
        return nsInfos;
    }

    private static void checkDir(File dataDir) {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(dataDir);
        Assertions.assertTrue((boolean)sd.getRoot().isDirectory());
        Assertions.assertTrue((boolean)sd.getCurrentDir().isDirectory());
        Assertions.assertTrue((boolean)sd.getVersionFile().isFile());
    }

    private static void checkDir(File root, String bpid) {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(root);
        File bpRoot = new File(sd.getCurrentDir(), bpid);
        Storage.StorageDirectory bpSd = new Storage.StorageDirectory(bpRoot);
        Assertions.assertTrue((boolean)bpSd.getRoot().isDirectory());
        Assertions.assertTrue((boolean)bpSd.getCurrentDir().isDirectory());
        Assertions.assertTrue((boolean)bpSd.getVersionFile().isFile());
    }

    @Test
    public void testAddStorageDirectories() throws IOException, URISyntaxException {
        int numLocations = 3;
        int numNamespace = 3;
        List<StorageLocation> locations = TestDataStorage.createStorageLocations(3);
        List<NamespaceInfo> namespaceInfos = TestDataStorage.createNamespaceInfos(3);
        for (NamespaceInfo ni : namespaceInfos) {
            this.storage.addStorageLocations(this.mockDN, ni, locations, START_OPT);
            for (StorageLocation sl : locations) {
                TestDataStorage.checkDir(new File(sl.getUri()));
                TestDataStorage.checkDir(new File(sl.getUri()), ni.getBlockPoolID());
            }
        }
        Assertions.assertEquals((int)3, (int)this.storage.getNumStorageDirs());
        locations = TestDataStorage.createStorageLocations(3);
        List addedLocation = this.storage.addStorageLocations(this.mockDN, namespaceInfos.get(0), locations, START_OPT);
        Assertions.assertTrue((boolean)addedLocation.isEmpty());
        Assertions.assertEquals((int)3, (int)this.storage.getNumStorageDirs());
        locations = TestDataStorage.createStorageLocations(6);
        this.storage.addStorageLocations(this.mockDN, this.nsInfo, locations, START_OPT);
        Assertions.assertEquals((int)6, (int)this.storage.getNumStorageDirs());
    }

    @Test
    public void testAddStorageDirectoriesFailure() throws IOException {
        boolean numLocations = true;
        List<StorageLocation> locations = TestDataStorage.createStorageLocations(1);
        Assertions.assertEquals((int)1, (int)locations.size());
        NamespaceInfo namespaceInfo = new NamespaceInfo(0, CLUSTER_ID, DEFAULT_BPID, 1L, "2.0", "2.0");
        List successLocations = this.storage.addStorageLocations(this.mockDN, namespaceInfo, locations, START_OPT);
        Assertions.assertEquals((int)1, (int)successLocations.size());
        this.storage.unlockAll();
        DataNode newMockDN = (DataNode)Mockito.mock(DataNode.class);
        Mockito.when((Object)newMockDN.getConf()).thenReturn((Object)new HdfsConfiguration());
        DataStorage newStorage = new DataStorage();
        NamespaceInfo newNamespaceInfo = new NamespaceInfo(0, CLUSTER_ID2, DEFAULT_BPID, 1L, "2.0", "2.0");
        successLocations = newStorage.addStorageLocations(newMockDN, newNamespaceInfo, locations, START_OPT);
        Assertions.assertEquals((int)0, (int)successLocations.size());
        newStorage.unlockAll();
        newMockDN.shutdown();
    }

    @Test
    public void testMissingVersion() throws IOException, URISyntaxException {
        boolean numLocations = true;
        boolean numNamespace = true;
        List<StorageLocation> locations = TestDataStorage.createStorageLocations(1);
        StorageLocation firstStorage = locations.get(0);
        Storage.StorageDirectory sd = new Storage.StorageDirectory(firstStorage);
        File currentDir = new File(sd.getCurrentDir(), "BP-787466439-172.26.24.43-1462305406642");
        Assertions.assertTrue((boolean)currentDir.mkdirs(), (String)("unable to mkdir " + currentDir.getName()));
        List<NamespaceInfo> namespaceInfos = TestDataStorage.createNamespaceInfos(1);
        for (NamespaceInfo ni : namespaceInfos) {
            this.storage.addStorageLocations(this.mockDN, ni, locations, START_OPT);
        }
        Assertions.assertTrue((boolean)currentDir.exists(), (String)"Storage directory was formatted");
    }

    @Test
    public void testRecoverTransitionReadFailure() throws IOException {
        int numLocations = 3;
        List<StorageLocation> locations = TestDataStorage.createStorageLocations(3, true);
        try {
            this.storage.recoverTransitionRead(this.mockDN, this.nsInfo, locations, START_OPT);
            Assertions.fail((String)"An IOException should throw: all StorageLocations are NON_EXISTENT");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"All specified directories have failed to load.", (Throwable)e);
        }
        Assertions.assertEquals((int)0, (int)this.storage.getNumStorageDirs());
    }

    @Test
    public void testRecoverTransitionReadDoTransitionFailure() throws IOException {
        int numLocations = 3;
        List<StorageLocation> locations = TestDataStorage.createStorageLocations(3);
        this.storage.recoverTransitionRead(this.mockDN, this.nsInfo, locations, START_OPT);
        Assertions.assertEquals((int)3, (int)this.storage.getNumStorageDirs());
        this.storage.unlockAll();
        this.storage = new DataStorage();
        this.nsInfo.clusterID = CLUSTER_ID2;
        try {
            this.storage.recoverTransitionRead(this.mockDN, this.nsInfo, locations, START_OPT);
            Assertions.fail((String)"Expect to throw an exception from doTransition()");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"All specified directories", (Throwable)e);
        }
        Assertions.assertEquals((int)0, (int)this.storage.getNumStorageDirs());
    }
}

