/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.hdfs.server.common.AutoCloseDataSetLock;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.apache.hadoop.hdfs.server.datanode.DataSetLockManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestDataSetLockManager {
    private DataSetLockManager manager;

    @BeforeEach
    public void init() {
        this.manager = new DataSetLockManager();
    }

    @Test
    @Timeout(value=5L)
    public void testBaseFunc() {
        this.manager.addLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"BPtest"});
        this.manager.addLock(DataNodeLockManager.LockLevel.VOLUME, new String[]{"BPtest", "Volumetest"});
        this.manager.addLock(DataNodeLockManager.LockLevel.DIR, new String[]{"BPtest", "Volumetest", "SubDirtest"});
        AutoCloseDataSetLock lock = this.manager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"BPtest"});
        AutoCloseDataSetLock lock1 = this.manager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"BPtest"});
        lock1.close();
        lock.close();
        this.manager.lockLeakCheck();
        Assertions.assertNull((Object)this.manager.getLastException());
        AutoCloseDataSetLock lock2 = this.manager.writeLock(DataNodeLockManager.LockLevel.VOLUME, new String[]{"BPtest", "Volumetest"});
        AutoCloseDataSetLock lock3 = this.manager.readLock(DataNodeLockManager.LockLevel.VOLUME, new String[]{"BPtest", "Volumetest"});
        lock3.close();
        lock2.close();
        this.manager.lockLeakCheck();
        Assertions.assertNull((Object)this.manager.getLastException());
        AutoCloseDataSetLock lock4 = this.manager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"BPtest"});
        AutoCloseDataSetLock lock5 = this.manager.readLock(DataNodeLockManager.LockLevel.VOLUME, new String[]{"BPtest", "Volumetest"});
        lock5.close();
        lock4.close();
        this.manager.lockLeakCheck();
        Assertions.assertNull((Object)this.manager.getLastException());
        AutoCloseDataSetLock lock6 = this.manager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"BPtest"});
        AutoCloseDataSetLock lock7 = this.manager.readLock(DataNodeLockManager.LockLevel.VOLUME, new String[]{"BPtest", "Volumetest"});
        AutoCloseDataSetLock lock8 = this.manager.readLock(DataNodeLockManager.LockLevel.DIR, new String[]{"BPtest", "Volumetest", "SubDirtest"});
        lock8.close();
        lock7.close();
        lock6.close();
        this.manager.lockLeakCheck();
        Assertions.assertNull((Object)this.manager.getLastException());
        this.manager.writeLock(DataNodeLockManager.LockLevel.VOLUME, new String[]{"BPtest", "Volumetest"});
        this.manager.lockLeakCheck();
        Exception lastException = this.manager.getLastException();
        Assertions.assertEquals((Object)lastException.getMessage(), (Object)"lock Leak");
    }

    @Test
    @Timeout(value=5L)
    public void testAcquireWriteLockError() throws InterruptedException {
        Thread t = new Thread(() -> {
            this.manager.readLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"test"});
            this.manager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"test"});
        });
        t.start();
        Thread.sleep(1000L);
        this.manager.lockLeakCheck();
        Exception lastException = this.manager.getLastException();
        Assertions.assertEquals((Object)lastException.getMessage(), (Object)"lock Leak");
    }

    @Test
    @Timeout(value=5L)
    public void testLockLeakCheck() {
        this.manager.writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{"test"});
        this.manager.lockLeakCheck();
        Exception lastException = this.manager.getLastException();
        Assertions.assertEquals((Object)lastException.getMessage(), (Object)"lock Leak");
    }
}

