/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDataNodeReconfiguration {
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private final int NUM_NAME_NODE = 1;
    private final int NUM_DATA_NODE = 10;
    private MiniDFSCluster cluster;
    private static long counter = 0L;

    @BeforeEach
    public void Setup() throws IOException {
        this.startDFSCluster(1, 10);
    }

    @AfterEach
    public void tearDown() throws Exception {
        File dir;
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if ((dir = new File(DATA_DIR)).exists()) {
            Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)dir), (String)"Cannot delete data-node dirs");
        }
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.datanode.peer.stats.enabled", true);
        MiniDFSNNTopology nnTopology = MiniDFSNNTopology.simpleFederatedTopology(numNameNodes);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(nnTopology).numDataNodes(numDataNodes).build();
        this.cluster.waitActive();
    }

    public DataNode[] createDNsForTest(int numDateNode) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.data.dir", DATA_DIR);
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        conf.setInt("ipc.client.connect.max.retries", 0);
        DataNode[] result = new DataNode[numDateNode];
        for (int i = 0; i < numDateNode; ++i) {
            result[i] = InternalDataNodeTestUtils.startDNWithMockNN((Configuration)conf, NN_ADDR, DATA_DIR);
        }
        return result;
    }

    @Test
    public void testMaxConcurrentMoversReconfiguration() throws ReconfigurationException, IOException {
        int maxConcurrentMovers = 10;
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", "text");
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(-1));
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(0));
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
            }
            dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(maxConcurrentMovers));
            Assertions.assertEquals((int)maxConcurrentMovers, (int)dn.xserver.balanceThrottler.getMaxConcurrentMovers(), (String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"));
            Assertions.assertEquals((int)maxConcurrentMovers, (int)Integer.parseInt(dn.getConf().get("dfs.datanode.balance.max.concurrent.moves")), (String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"));
            dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", null);
            Assertions.assertEquals((int)100, (int)dn.xserver.balanceThrottler.getMaxConcurrentMovers(), (String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"));
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.balance.max.concurrent.moves"), (String)String.format("expect %s is not configured", "dfs.datanode.balance.max.concurrent.moves"));
        }
    }

    @Test
    public void testAcquireWithMaxConcurrentMoversGreaterThanDefault() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        try {
            this.testAcquireOnMaxConcurrentMoversReconfiguration(dns[0], 10);
        }
        finally {
            dns[0].shutdown();
        }
    }

    @Test
    public void testAcquireWithMaxConcurrentMoversLessThanDefault() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        try {
            this.testAcquireOnMaxConcurrentMoversReconfiguration(dns[0], 3);
        }
        finally {
            dns[0].shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedDecreaseConcurrentMovers() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        DataNode dataNode = dns[0];
        try {
            dataNode.xserver.updateBalancerMaxConcurrentMovers(2);
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.setMaxReconfigureWaitTime(1);
            boolean success = dataNode.xserver.updateBalancerMaxConcurrentMovers(1);
            Assertions.assertFalse((boolean)success);
        }
        finally {
            dataNode.shutdown();
        }
    }

    @Test
    public void testFailedDecreaseConcurrentMoversReconfiguration() throws IOException, ReconfigurationException {
        Assertions.assertThrows(ReconfigurationException.class, () -> {
            DataNode[] dns = this.createDNsForTest(1);
            DataNode dataNode = dns[0];
            try {
                dataNode.xserver.updateBalancerMaxConcurrentMovers(2);
                dataNode.xserver.balanceThrottler.acquire();
                dataNode.xserver.balanceThrottler.acquire();
                dataNode.xserver.setMaxReconfigureWaitTime(1);
                dataNode.reconfigurePropertyImpl("dfs.datanode.balance.max.concurrent.moves", "1");
            }
            catch (ReconfigurationException e) {
                Assertions.assertEquals((Object)"dfs.datanode.balance.max.concurrent.moves", (Object)e.getProperty());
                Assertions.assertEquals((Object)"1", (Object)e.getNewValue());
                throw e;
            }
            finally {
                dataNode.shutdown();
            }
        });
    }

    private void testAcquireOnMaxConcurrentMoversReconfiguration(DataNode dataNode, int maxConcurrentMovers) throws IOException, ReconfigurationException {
        int i;
        int defaultMaxThreads = dataNode.getConf().getInt("dfs.datanode.balance.max.concurrent.moves", 100);
        for (i = 0; i < defaultMaxThreads; ++i) {
            Assertions.assertEquals((Object)true, (Object)dataNode.xserver.balanceThrottler.acquire(), (String)"should be able to get thread quota");
        }
        Assertions.assertEquals((Object)false, (Object)dataNode.xserver.balanceThrottler.acquire(), (String)"should not be able to get thread quota");
        for (i = 0; i < defaultMaxThreads; ++i) {
            dataNode.xserver.balanceThrottler.release();
        }
        dataNode.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(maxConcurrentMovers));
        Assertions.assertEquals((int)maxConcurrentMovers, (int)dataNode.xserver.balanceThrottler.getMaxConcurrentMovers(), (String)"thread quota is wrong");
        for (i = 0; i < maxConcurrentMovers; ++i) {
            Assertions.assertEquals((Object)true, (Object)dataNode.xserver.balanceThrottler.acquire(), (String)"should be able to get thread quota");
        }
        Assertions.assertEquals((Object)false, (Object)dataNode.xserver.balanceThrottler.acquire(), (String)"should not be able to get thread quota");
    }

    @Test
    public void testBlockReportIntervalReconfiguration() throws ReconfigurationException {
        int blockReportInterval = 300000;
        String[] blockReportParameters = new String[]{"dfs.blockreport.intervalMsec", "dfs.blockreport.split.threshold", "dfs.blockreport.initialDelay"};
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            BlockPoolManager blockPoolManager = dn.getBlockPoolManager();
            for (String blockReportParameter : blockReportParameters) {
                try {
                    dn.reconfigureProperty(blockReportParameter, "text");
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
                }
            }
            try {
                dn.reconfigureProperty("dfs.blockreport.intervalMsec", String.valueOf(-1));
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
            }
            try {
                dn.reconfigureProperty("dfs.blockreport.split.threshold", String.valueOf(-1));
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
            }
            dn.reconfigureProperty("dfs.blockreport.initialDelay", String.valueOf(-1));
            Assertions.assertEquals((long)0L, (long)dn.getDnConf().initialBlockReportDelayMs);
            dn.reconfigureProperty("dfs.blockreport.intervalMsec", String.valueOf(blockReportInterval));
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    Assertions.assertEquals((long)blockReportInterval, (long)actor.getScheduler().getBlockReportIntervalMs(), (String)String.format("%s has wrong value", "dfs.blockreport.intervalMsec"));
                }
            }
            dn.reconfigureProperty("dfs.blockreport.split.threshold", String.valueOf(123));
            Assertions.assertEquals((long)123L, (long)dn.getDnConf().blockReportSplitThreshold);
            dn.reconfigureProperty("dfs.blockreport.initialDelay", "123");
            Assertions.assertEquals((long)123000L, (long)dn.getDnConf().initialBlockReportDelayMs);
            dn.reconfigureProperty("dfs.blockreport.intervalMsec", null);
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    Assertions.assertEquals((long)21600000L, (long)actor.getScheduler().getBlockReportIntervalMs(), (String)String.format("%s has wrong value", "dfs.blockreport.intervalMsec"));
                }
            }
            Assertions.assertNull((Object)dn.getConf().get("dfs.blockreport.intervalMsec"), (String)String.format("expect %s is not configured", "dfs.blockreport.intervalMsec"));
            dn.reconfigureProperty("dfs.blockreport.split.threshold", null);
            Assertions.assertNull((Object)dn.getConf().get("dfs.blockreport.split.threshold"), (String)String.format("expect %s is not configured", "dfs.blockreport.split.threshold"));
            dn.reconfigureProperty("dfs.blockreport.initialDelay", null);
            Assertions.assertNull((Object)dn.getConf().get("dfs.blockreport.initialDelay"), (String)String.format("expect %s is not configured", "dfs.blockreport.initialDelay"));
        }
    }

    @Test
    public void testDataXceiverReconfiguration() throws ReconfigurationException {
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.max.transfer.threads", "text");
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.max.transfer.threads", String.valueOf(-1));
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.data.transfer.bandwidthPerSec", "text");
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.data.write.bandwidthPerSec", "text");
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.data.read.bandwidthPerSec", "text");
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            dn.reconfigureProperty("dfs.datanode.max.transfer.threads", String.valueOf(123));
            Assertions.assertEquals((int)123, (int)dn.getXferServer().getMaxXceiverCount(), (String)String.format("%s has wrong value", "dfs.datanode.max.transfer.threads"));
            dn.reconfigureProperty("dfs.datanode.data.transfer.bandwidthPerSec", String.valueOf(1000));
            Assertions.assertEquals((long)1000L, (long)dn.getXferServer().getTransferThrottler().getBandwidth(), (String)String.format("%s has wrong value", "dfs.datanode.data.transfer.bandwidthPerSec"));
            dn.reconfigureProperty("dfs.datanode.data.write.bandwidthPerSec", String.valueOf(1000));
            Assertions.assertEquals((long)1000L, (long)dn.getXferServer().getWriteThrottler().getBandwidth(), (String)String.format("%s has wrong value", "dfs.datanode.data.write.bandwidthPerSec"));
            dn.reconfigureProperty("dfs.datanode.data.read.bandwidthPerSec", String.valueOf(1000));
            Assertions.assertEquals((long)1000L, (long)dn.getXferServer().getReadThrottler().getBandwidth(), (String)String.format("%s has wrong value", "dfs.datanode.data.read.bandwidthPerSec"));
            dn.reconfigureProperty("dfs.datanode.max.transfer.threads", null);
            Assertions.assertEquals((int)4096, (int)dn.getXferServer().getMaxXceiverCount(), (String)String.format("%s has wrong value", "dfs.datanode.max.transfer.threads"));
            Assertions.assertNull((Object)dn.getConf().get("dfs.datanode.max.transfer.threads"), (String)String.format("expect %s is not configured", "dfs.datanode.max.transfer.threads"));
            dn.reconfigureProperty("dfs.datanode.data.transfer.bandwidthPerSec", null);
            Assertions.assertEquals(null, (Object)dn.getXferServer().getTransferThrottler(), (String)String.format("%s has wrong value", "dfs.datanode.data.transfer.bandwidthPerSec"));
            Assertions.assertNull((Object)dn.getConf().get("dfs.datanode.data.transfer.bandwidthPerSec"), (String)String.format("expect %s is not configured", "dfs.datanode.data.transfer.bandwidthPerSec"));
            dn.reconfigureProperty("dfs.datanode.data.write.bandwidthPerSec", null);
            Assertions.assertEquals(null, (Object)dn.getXferServer().getWriteThrottler(), (String)String.format("%s has wrong value", "dfs.datanode.data.write.bandwidthPerSec"));
            Assertions.assertNull((Object)dn.getConf().get("dfs.datanode.data.write.bandwidthPerSec"), (String)String.format("expect %s is not configured", "dfs.datanode.data.write.bandwidthPerSec"));
            dn.reconfigureProperty("dfs.datanode.data.read.bandwidthPerSec", null);
            Assertions.assertEquals(null, (Object)dn.getXferServer().getReadThrottler(), (String)String.format("%s has wrong value", "dfs.datanode.data.read.bandwidthPerSec"));
            Assertions.assertNull((Object)dn.getConf().get("dfs.datanode.data.read.bandwidthPerSec"), (String)String.format("expect %s is not configured", "dfs.datanode.data.read.bandwidthPerSec"));
        }
    }

    @Test
    public void testCacheReportReconfiguration() throws ReconfigurationException {
        int cacheReportInterval = 300000;
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.cachereport.intervalMsec", "text");
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            try {
                dn.reconfigureProperty("dfs.cachereport.intervalMsec", String.valueOf(-1));
                Assertions.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
            }
            dn.reconfigureProperty("dfs.cachereport.intervalMsec", String.valueOf(cacheReportInterval));
            Assertions.assertEquals((long)cacheReportInterval, (long)dn.getDnConf().getCacheReportInterval(), (String)String.format("%s has wrong value", "dfs.cachereport.intervalMsec"));
            dn.reconfigureProperty("dfs.cachereport.intervalMsec", null);
            Assertions.assertEquals((long)10000L, (long)dn.getDnConf().getCacheReportInterval(), (String)String.format("%s has wrong value", "dfs.cachereport.intervalMsec"));
            Assertions.assertNull((Object)dn.getConf().get("dfs.cachereport.intervalMsec"), (String)String.format("expect %s is not configured", "dfs.cachereport.intervalMsec"));
        }
    }

    @Test
    public void testSlowPeerParameters() throws Exception {
        String[] slowPeersParameters = new String[]{"dfs.datanode.min.outlier.detection.nodes", "dfs.datanode.slowpeer.low.threshold.ms", "dfs.datanode.peer.metrics.min.outlier.detection.samples"};
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            LambdaTestUtils.intercept(ReconfigurationException.class, (String)"Could not change property dfs.datanode.peer.stats.enabled from 'true' to 'text'", () -> dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "text"));
            for (String parameter : slowPeersParameters) {
                try {
                    dn.reconfigureProperty(parameter, "text");
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
                }
                try {
                    dn.reconfigureProperty(parameter, String.valueOf(-1));
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
                }
            }
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "false");
            Assertions.assertFalse((boolean)dn.getDnConf().peerStatsEnabled);
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "true");
            for (String parameter : slowPeersParameters) {
                dn.reconfigureProperty(parameter, "123");
            }
            Assertions.assertEquals((long)123L, (long)dn.getPeerMetrics().getMinOutlierDetectionNodes());
            Assertions.assertEquals((long)123L, (long)dn.getPeerMetrics().getLowThresholdMs());
            Assertions.assertEquals((long)123L, (long)dn.getPeerMetrics().getMinOutlierDetectionSamples());
            Assertions.assertEquals((long)123L, (long)dn.getPeerMetrics().getSlowNodeDetector().getMinOutlierDetectionNodes());
            Assertions.assertEquals((long)123L, (long)dn.getPeerMetrics().getSlowNodeDetector().getLowThresholdMs());
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", null);
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.peer.stats.enabled"), (String)String.format("expect %s is not configured", "dfs.datanode.peer.stats.enabled"));
            dn.reconfigureProperty("dfs.datanode.peer.stats.enabled", "true");
            for (String parameter : slowPeersParameters) {
                dn.reconfigureProperty(parameter, null);
            }
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.min.outlier.detection.nodes"), (String)String.format("expect %s is not configured", "dfs.datanode.min.outlier.detection.nodes"));
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.slowpeer.low.threshold.ms"), (String)String.format("expect %s is not configured", "dfs.datanode.slowpeer.low.threshold.ms"));
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.peer.metrics.min.outlier.detection.samples"), (String)String.format("expect %s is not configured", "dfs.datanode.peer.metrics.min.outlier.detection.samples"));
            Assertions.assertEquals((long)dn.getPeerMetrics().getSlowNodeDetector().getMinOutlierDetectionNodes(), (long)10L);
            Assertions.assertEquals((long)dn.getPeerMetrics().getSlowNodeDetector().getLowThresholdMs(), (long)5L);
        }
    }

    @Test
    public void testSlowDiskParameters() throws ReconfigurationException, IOException {
        String[] slowDisksParameters1 = new String[]{"dfs.datanode.min.outlier.detection.disks", "dfs.datanode.slowdisk.low.threshold.ms"};
        for (int i = 0; i < 10; ++i) {
            String[] slowDisksParameters2;
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.outliers.report.interval", "text");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            try {
                dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", "text");
            }
            catch (ReconfigurationException expected) {
                Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
            }
            dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", "1");
            for (String parameter : slowDisksParameters1) {
                try {
                    dn.reconfigureProperty(parameter, "text");
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
                }
                try {
                    dn.reconfigureProperty(parameter, String.valueOf(-1));
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
                }
            }
            dn.reconfigureProperty("dfs.datanode.outliers.report.interval", "1ms");
            Assertions.assertEquals((long)1L, (long)dn.getDnConf().outliersReportIntervalMs);
            BlockPoolManager blockPoolManager = new BlockPoolManager(dn);
            blockPoolManager.refreshNamenodes(dn.getConf());
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    Assertions.assertEquals((long)1L, (long)actor.getScheduler().getOutliersReportIntervalMs(), (String)String.format("%s has wrong value", "dfs.datanode.outliers.report.interval"));
                }
            }
            for (String parameter : slowDisksParameters2 = new String[]{"dfs.datanode.fileio.profiling.sampling.percentage", "dfs.datanode.min.outlier.detection.disks", "dfs.datanode.slowdisk.low.threshold.ms", "dfs.datanode.max.slowdisks.to.exclude"}) {
                dn.reconfigureProperty(parameter, "99");
            }
            Assertions.assertEquals((long)99L, (long)dn.getDiskMetrics().getMinOutlierDetectionDisks());
            Assertions.assertEquals((long)99L, (long)dn.getDiskMetrics().getLowThresholdMs());
            Assertions.assertEquals((int)99, (int)dn.getDiskMetrics().getMaxSlowDisksToExclude());
            Assertions.assertTrue((boolean)dn.getDnConf().diskStatsEnabled);
            Assertions.assertTrue((boolean)dn.getFileIoProvider().getProfilingEventHook().getDiskStatsEnabled());
            Assertions.assertEquals((int)2126008810, (int)dn.getFileIoProvider().getProfilingEventHook().getSampleRangeMax());
            Assertions.assertEquals((long)99L, (long)dn.getDiskMetrics().getSlowDiskDetector().getMinOutlierDetectionNodes());
            Assertions.assertEquals((long)99L, (long)dn.getDiskMetrics().getSlowDiskDetector().getLowThresholdMs());
            dn.reconfigureProperty("dfs.datanode.outliers.report.interval", null);
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.outliers.report.interval"), (String)String.format("expect %s is not configured", "dfs.datanode.outliers.report.interval"));
            dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", null);
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.fileio.profiling.sampling.percentage"), (String)String.format("expect %s is not configured", "dfs.datanode.fileio.profiling.sampling.percentage"));
            Assertions.assertFalse((boolean)dn.getFileIoProvider().getProfilingEventHook().getDiskStatsEnabled());
            Assertions.assertEquals((int)0, (int)dn.getFileIoProvider().getProfilingEventHook().getSampleRangeMax());
            dn.reconfigureProperty("dfs.datanode.fileio.profiling.sampling.percentage", "1");
            dn.reconfigureProperty("dfs.datanode.min.outlier.detection.disks", null);
            dn.reconfigureProperty("dfs.datanode.slowdisk.low.threshold.ms", null);
            dn.reconfigureProperty("dfs.datanode.max.slowdisks.to.exclude", null);
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.min.outlier.detection.disks"), (String)String.format("expect %s is not configured", "dfs.datanode.min.outlier.detection.disks"));
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.slowdisk.low.threshold.ms"), (String)String.format("expect %s is not configured", "dfs.datanode.slowdisk.low.threshold.ms"));
            Assertions.assertEquals(null, (Object)dn.getConf().get("dfs.datanode.max.slowdisks.to.exclude"), (String)String.format("expect %s is not configured", "dfs.datanode.max.slowdisks.to.exclude"));
            Assertions.assertEquals((long)5L, (long)dn.getDiskMetrics().getSlowDiskDetector().getMinOutlierDetectionNodes());
            Assertions.assertEquals((long)20L, (long)dn.getDiskMetrics().getSlowDiskDetector().getLowThresholdMs());
        }
    }

    @Test
    public void testDfsUsageParameters() throws ReconfigurationException {
        String[] dfsUsageParameters = new String[]{"fs.du.interval", "fs.getspaceused.jitterMillis"};
        for (int i = 0; i < 10; ++i) {
            GetSpaceUsed dfsUsage;
            DataNode dn = this.cluster.getDataNodes().get(i);
            for (String parameter : dfsUsageParameters) {
                try {
                    dn.reconfigureProperty(parameter, "text");
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException), (String)"expecting NumberFormatException");
                }
                try {
                    dn.reconfigureProperty(parameter, String.valueOf(-1));
                    Assertions.fail((String)"ReconfigurationException expected");
                }
                catch (ReconfigurationException expected) {
                    Assertions.assertTrue((boolean)(expected.getCause() instanceof IllegalArgumentException), (String)"expecting IllegalArgumentException");
                }
            }
            for (String parameter : dfsUsageParameters) {
                dn.reconfigureProperty(parameter, "99");
            }
            List volumeList = dn.data.getVolumeList();
            for (FsVolumeImpl fsVolume : volumeList) {
                Map blockPoolSlices = fsVolume.getBlockPoolSlices();
                for (Map.Entry entry : blockPoolSlices.entrySet()) {
                    dfsUsage = ((BlockPoolSlice)entry.getValue()).getDfsUsage();
                    if (!(dfsUsage instanceof CachingGetSpaceUsed)) continue;
                    Assertions.assertEquals((long)99L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getRefreshInterval());
                    Assertions.assertEquals((long)99L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getJitter());
                }
            }
            for (String parameter : dfsUsageParameters) {
                dn.reconfigureProperty(parameter, null);
            }
            for (FsVolumeImpl fsVolume : volumeList) {
                Map blockPoolSlices = fsVolume.getBlockPoolSlices();
                for (Map.Entry entry : blockPoolSlices.entrySet()) {
                    dfsUsage = ((BlockPoolSlice)entry.getValue()).getDfsUsage();
                    if (dfsUsage instanceof CachingGetSpaceUsed) {
                        Assertions.assertEquals((long)600000L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getRefreshInterval(), (String)String.format("expect %s is not configured", "fs.du.interval"));
                        Assertions.assertEquals((long)60000L, (long)((CachingGetSpaceUsed)((BlockPoolSlice)entry.getValue()).getDfsUsage()).getJitter(), (String)String.format("expect %s is not configured", "fs.getspaceused.jitterMillis"));
                    }
                    Assertions.assertEquals(null, (Object)dn.getConf().get("fs.du.interval"), (String)String.format("expect %s is not configured", "fs.du.interval"));
                    Assertions.assertEquals(null, (Object)dn.getConf().get("fs.getspaceused.jitterMillis"), (String)String.format("expect %s is not configured", "fs.getspaceused.jitterMillis"));
                }
            }
        }
    }

    @Test
    public void testDfsUsageKlass() throws ReconfigurationException, InterruptedException {
        long lastCounter = counter;
        Thread.sleep(5000L);
        Assertions.assertEquals((long)lastCounter, (long)counter);
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            dn.reconfigurePropertyImpl("fs.getspaceused.classname", DummyCachingGetSpaceUsed.class.getName());
        }
        lastCounter = counter;
        Thread.sleep(5000L);
        Assertions.assertTrue((counter > lastCounter ? 1 : 0) != 0);
    }

    @Test
    public void testDiskBalancerParameters() throws Exception {
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            LambdaTestUtils.intercept(ReconfigurationException.class, (String)"Could not change property dfs.disk.balancer.enabled from 'true' to 'text'", () -> dn.reconfigureProperty("dfs.disk.balancer.enabled", "text"));
            dn.reconfigureProperty("dfs.disk.balancer.enabled", null);
            Assertions.assertEquals((Object)dn.getConf().getBoolean("dfs.disk.balancer.enabled", true), (Object)dn.getDiskBalancer().isDiskBalancerEnabled());
            dn.reconfigureProperty("dfs.disk.balancer.enabled", "false");
            Assertions.assertFalse((boolean)dn.getDiskBalancer().isDiskBalancerEnabled());
            dn.reconfigureProperty("dfs.disk.balancer.enabled", "true");
            Assertions.assertTrue((boolean)dn.getDiskBalancer().isDiskBalancerEnabled());
            LambdaTestUtils.intercept(ReconfigurationException.class, (String)"Could not change property dfs.disk.balancer.plan.valid.interval from '1d' to 'text'", () -> dn.reconfigureProperty("dfs.disk.balancer.plan.valid.interval", "text"));
            dn.reconfigureProperty("dfs.disk.balancer.plan.valid.interval", null);
            Assertions.assertEquals((long)dn.getConf().getTimeDuration("dfs.disk.balancer.plan.valid.interval", "1d", TimeUnit.MILLISECONDS), (long)dn.getDiskBalancer().getPlanValidityInterval());
            Assertions.assertEquals((long)dn.getConf().getTimeDuration("dfs.disk.balancer.plan.valid.interval", "1d", TimeUnit.MILLISECONDS), (long)dn.getDiskBalancer().getPlanValidityIntervalInConfig());
            dn.reconfigureProperty("dfs.disk.balancer.plan.valid.interval", "6");
            Assertions.assertEquals((long)6L, (long)dn.getDiskBalancer().getPlanValidityInterval());
            Assertions.assertEquals((long)6L, (long)dn.getDiskBalancer().getPlanValidityIntervalInConfig());
            dn.reconfigureProperty("dfs.disk.balancer.plan.valid.interval", "1m");
            Assertions.assertEquals((long)60000L, (long)dn.getDiskBalancer().getPlanValidityInterval());
            Assertions.assertEquals((long)60000L, (long)dn.getDiskBalancer().getPlanValidityIntervalInConfig());
        }
    }

    @Test
    public void testSlowIoWarningThresholdReconfiguration() throws Exception {
        int slowIoWarningThreshold = 500;
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            LambdaTestUtils.intercept(ReconfigurationException.class, (String)"Could not change property dfs.datanode.slow.io.warning.threshold.ms from '300' to 'text'", () -> dn.reconfigureProperty("dfs.datanode.slow.io.warning.threshold.ms", "text"));
            LambdaTestUtils.intercept(ReconfigurationException.class, (String)"Could not change property dfs.datanode.slow.io.warning.threshold.ms from '300' to '-1'", () -> dn.reconfigureProperty("dfs.datanode.slow.io.warning.threshold.ms", "-1"));
            dn.reconfigureProperty("dfs.datanode.slow.io.warning.threshold.ms", String.valueOf(slowIoWarningThreshold));
            Assertions.assertEquals((long)slowIoWarningThreshold, (long)dn.getDnConf().getSlowIoWarningThresholdMs());
            dn.reconfigureProperty("dfs.datanode.slow.io.warning.threshold.ms", null);
            Assertions.assertEquals((long)300L, (long)dn.getDnConf().getSlowIoWarningThresholdMs());
        }
    }

    public static class DummyCachingGetSpaceUsed
    extends CachingGetSpaceUsed {
        public DummyCachingGetSpaceUsed(GetSpaceUsed.Builder builder) throws IOException {
            super(builder.setInterval(1000L).setJitter(Long.valueOf(0L)));
        }

        protected void refresh() {
            counter++;
        }
    }
}

