/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerFaultInjector;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Timeout(value=60L)
public class TestDataNodeLifeline {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeLifeline.class);
    private MiniDFSCluster cluster;
    private HdfsConfiguration conf;
    private DatanodeLifelineProtocolClientSideTranslatorPB lifelineNamenode;
    private DataNodeMetrics metrics;
    private DatanodeProtocolClientSideTranslatorPB namenode;
    private FSNamesystem namesystem;
    private DataNode dn;
    private BPServiceActor bpsa;
    private final BlockManagerFaultInjector injector = new BlockManagerFaultInjector(){

        public void mockAnException() {
            throw new UnknownError("Unknown exception");
        }
    };

    @BeforeEach
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.datanode.lifeline.interval.seconds", 2);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        this.conf.set("dfs.namenode.lifeline.rpc-address", "0.0.0.0:0");
        this.conf.setInt("dfs.namenode.stale.datanode.interval", 6000);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(1).build();
        this.namesystem = this.cluster.getNameNode().getNamesystem();
        this.dn = this.cluster.getDataNodes().get(0);
        this.metrics = this.dn.getMetrics();
        Assertions.assertNotNull((Object)this.metrics);
        List allBpos = this.dn.getAllBpOs();
        Assertions.assertNotNull((Object)allBpos);
        Assertions.assertEquals((int)1, (int)allBpos.size());
        BPOfferService bpos = (BPOfferService)allBpos.get(0);
        List allBpsa = bpos.getBPServiceActors();
        Assertions.assertNotNull((Object)allBpsa);
        Assertions.assertEquals((int)1, (int)allBpsa.size());
        this.bpsa = (BPServiceActor)allBpsa.get(0);
        Assertions.assertNotNull((Object)this.bpsa);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                if (TestDataNodeLifeline.this.bpsa.getLifelineNameNodeProxy() != null) {
                    TestDataNodeLifeline.this.lifelineNamenode = (DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.spy((Object)TestDataNodeLifeline.this.bpsa.getLifelineNameNodeProxy());
                    TestDataNodeLifeline.this.bpsa.setLifelineNameNode(TestDataNodeLifeline.this.lifelineNamenode);
                }
                return TestDataNodeLifeline.this.lifelineNamenode != null;
            }
        }, (long)100L, (long)10000L);
        Assertions.assertNotNull((Object)this.bpsa.getNameNodeProxy());
        this.namenode = (DatanodeProtocolClientSideTranslatorPB)Mockito.spy((Object)this.bpsa.getNameNodeProxy());
        this.bpsa.setNameNode(this.namenode);
    }

    @AfterEach
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            GenericTestUtils.assertNoThreadsMatching((String)".*lifeline.*");
        }
    }

    @Test
    public void testSendLifelineIfHeartbeatBlocked() throws Exception {
        int numLifelines = 10;
        CountDownLatch lifelinesSent = new CountDownLatch(numLifelines);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer(new LatchAwaitingAnswer(lifelinesSent)).when((Object)this.namenode)).sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(SlowPeerReports.class), (SlowDiskReports)Mockito.any(SlowDiskReports.class));
        ((DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.doAnswer(new LatchCountingAnswer(lifelinesSent)).when((Object)this.lifelineNamenode)).sendLifeline((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any());
        while (!lifelinesSent.await(1L, TimeUnit.SECONDS)) {
            Assertions.assertEquals((int)1, (int)this.namesystem.getNumLiveDataNodes(), (String)"Expect DataNode to be kept alive by lifeline.");
            Assertions.assertEquals((int)0, (int)this.namesystem.getNumDeadDataNodes(), (String)"Expect DataNode not marked dead due to lifeline.");
            Assertions.assertEquals((int)0, (int)this.namesystem.getNumStaleDataNodes(), (String)"Expect DataNode not marked stale due to lifeline.");
            this.cluster.getDataNodes().get(0).reconfigurePropertyImpl("dfs.datanode.data.dir", this.cluster.getDataDirectory().concat("/data-new"));
        }
        ((DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.verify((Object)this.lifelineNamenode, (VerificationMode)Mockito.atLeastOnce())).sendLifeline((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any());
        Assertions.assertTrue((MetricsAsserts.getLongCounter((String)"LifelinesNumOps", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)this.metrics.name())) >= (long)numLifelines ? 1 : 0) != 0, (String)("Expect metrics to count at least " + numLifelines + " calls."));
    }

    @Test
    public void testNoLifelineSentIfHeartbeatsOnTime() throws Exception {
        int numHeartbeats = 10;
        CountDownLatch heartbeatsSent = new CountDownLatch(numHeartbeats);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer(new LatchCountingAnswer(heartbeatsSent)).when((Object)this.namenode)).sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(SlowPeerReports.class), (SlowDiskReports)Mockito.any(SlowDiskReports.class));
        while (!heartbeatsSent.await(1L, TimeUnit.SECONDS)) {
            Assertions.assertEquals((int)1, (int)this.namesystem.getNumLiveDataNodes(), (String)"Expect DataNode to be kept alive by lifeline.");
            Assertions.assertEquals((int)0, (int)this.namesystem.getNumDeadDataNodes(), (String)"Expect DataNode not marked dead due to lifeline.");
            Assertions.assertEquals((int)0, (int)this.namesystem.getNumStaleDataNodes(), (String)"Expect DataNode not marked stale due to lifeline.");
        }
        ((DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.verify((Object)this.lifelineNamenode, (VerificationMode)Mockito.never())).sendLifeline((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any());
        Assertions.assertEquals((long)0L, (long)MetricsAsserts.getLongCounter((String)"LifelinesNumOps", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)this.metrics.name())), (String)"Expect metrics to count no lifeline calls.");
    }

    @Test
    public void testLifelineForDeadNode() throws Exception {
        long initialCapacity = this.cluster.getNamesystem(0).getCapacityTotal();
        Assertions.assertTrue((initialCapacity > 0L ? 1 : 0) != 0);
        this.dn.setHeartbeatsDisabledForTests(true);
        this.cluster.setDataNodesDead();
        Assertions.assertEquals((long)0L, (long)this.cluster.getNamesystem(0).getCapacityTotal(), (String)"Capacity should be 0 after all DNs dead");
        this.bpsa.sendLifelineForTests();
        Assertions.assertEquals((long)0L, (long)this.cluster.getNamesystem(0).getCapacityTotal(), (String)"Lifeline should be ignored for dead node");
        this.dn.setHeartbeatsDisabledForTests(false);
        final DatanodeDescriptor dnDesc = (DatanodeDescriptor)this.cluster.getNamesystem(0).getBlockManager().getDatanodeManager().getDatanodes().iterator().next();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return dnDesc.isAlive() && dnDesc.isHeartbeatedSinceRegistration();
            }
        }, (long)100L, (long)5000L);
        Assertions.assertEquals((long)initialCapacity, (long)this.cluster.getNamesystem(0).getCapacityTotal(), (String)"Capacity should include only live capacity");
    }

    @Test
    public void testHeartbeatAndLifelineOnError() throws Exception {
        HdfsConfiguration config = new HdfsConfiguration();
        config.set("dfs.namenode.lifeline.rpc-address", "0.0.0.0:0");
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();){
            cluster.waitActive();
            FSNamesystem fsNamesystem = cluster.getNamesystem();
            DatanodeStatistics datanodeStatistics = fsNamesystem.getBlockManager().getDatanodeManager().getDatanodeStatistics();
            long capacityTotalBefore = datanodeStatistics.getCapacityTotal();
            BlockManagerFaultInjector.instance = this.injector;
            DataNode dataNode = cluster.getDataNodes().get(0);
            BlockPoolManager blockPoolManager = dataNode.getBlockPoolManager();
            for (BPOfferService bpos : blockPoolManager.getAllNamenodeThreads()) {
                if (bpos == null) continue;
                for (BPServiceActor actor : bpos.getBPServiceActors()) {
                    try {
                        actor.triggerHeartbeatForTests();
                        actor.sendLifelineForTests();
                    }
                    catch (Throwable e) {
                        Assertions.assertTrue((boolean)e.getMessage().contains("Unknown exception"));
                    }
                }
            }
            long capacityTotalAfter = datanodeStatistics.getCapacityTotal();
            Assertions.assertEquals((long)capacityTotalBefore, (long)capacityTotalAfter);
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.TRACE);
    }

    private final class LatchCountingAnswer<T>
    implements Answer<T> {
        private final CountDownLatch latch;

        public LatchCountingAnswer(CountDownLatch latch) {
            this.latch = latch;
        }

        public T answer(InvocationOnMock invocation) throws Throwable {
            Object result = invocation.callRealMethod();
            this.latch.countDown();
            LOG.info("Countdown, remaining latch count is {}.", (Object)this.latch.getCount());
            return (T)result;
        }
    }

    private final class LatchAwaitingAnswer<T>
    implements Answer<T> {
        private final CountDownLatch latch;

        public LatchAwaitingAnswer(CountDownLatch latch) {
            this.latch = latch;
        }

        public T answer(InvocationOnMock invocation) throws Throwable {
            LOG.info("Awaiting, remaining latch count is {}.", (Object)this.latch.getCount());
            this.latch.await();
            return (T)invocation.callRealMethod();
        }
    }
}

