/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeErasureCodingMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(TestDataNodeErasureCodingMetrics.class);
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final int dataBlocks = this.ecPolicy.getNumDataUnits();
    private final int parityBlocks = this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int blockSize = this.cellSize * 2;
    private final int groupSize = this.dataBlocks + this.parityBlocks;
    private final int blockGroupSize = this.blockSize * this.dataBlocks;
    private final int numDNs = this.groupSize + 1;
    private MiniDFSCluster cluster;
    private Configuration conf;
    private DistributedFileSystem fs;

    @BeforeEach
    public void setup() throws IOException {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.cluster.waitActive();
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=120L)
    public void testFullBlock() throws Exception {
        Assertions.assertEquals((long)0L, (long)this.getLongMetric("EcReconstructionReadTimeMillis"));
        Assertions.assertEquals((long)0L, (long)this.getLongMetric("EcReconstructionDecodingTimeMillis"));
        Assertions.assertEquals((long)0L, (long)this.getLongMetric("EcReconstructionWriteTimeMillis"));
        this.doTest("/testEcMetrics", this.blockGroupSize, 0);
        Assertions.assertEquals((long)1L, (long)this.getLongMetric("EcReconstructionTasks"), (String)"EcReconstructionTasks should be ");
        Assertions.assertEquals((long)0L, (long)this.getLongMetric("EcFailedReconstructionTasks"), (String)"EcFailedReconstructionTasks should be ");
        Assertions.assertTrue((this.getLongMetric("EcDecodingTimeNanos") > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)this.blockGroupSize, (long)this.getLongMetric("EcReconstructionBytesRead"), (String)"EcReconstructionBytesRead should be ");
        Assertions.assertEquals((long)this.blockSize, (long)this.getLongMetric("EcReconstructionBytesWritten"), (String)"EcReconstructionBytesWritten should be ");
        Assertions.assertEquals((long)0L, (long)this.getLongMetricWithoutCheck("EcReconstructionRemoteBytesRead"), (String)"EcReconstructionRemoteBytesRead should be ");
        Assertions.assertTrue((this.getLongMetric("EcReconstructionReadTimeMillis") > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.getLongMetric("EcReconstructionDecodingTimeMillis") > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.getLongMetric("EcReconstructionWriteTimeMillis") > 0L ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=120L)
    public void testReconstructionBytesPartialGroup1() throws Exception {
        int fileLen = this.blockSize / 10;
        this.doTest("/testEcBytes", fileLen, 0);
        Assertions.assertEquals((long)fileLen, (long)this.getLongMetric("EcReconstructionBytesRead"), (String)"EcReconstructionBytesRead should be ");
        Assertions.assertEquals((long)fileLen, (long)this.getLongMetric("EcReconstructionBytesWritten"), (String)"EcReconstructionBytesWritten should be ");
        Assertions.assertEquals((long)0L, (long)this.getLongMetricWithoutCheck("EcReconstructionRemoteBytesRead"), (String)"EcReconstructionRemoteBytesRead should be ");
    }

    @Test
    @Timeout(value=120L)
    public void testReconstructionBytesPartialGroup2() throws Exception {
        int fileLen = this.cellSize * this.dataBlocks + this.cellSize + this.cellSize / 10;
        this.doTest("/testEcBytes", fileLen, 0);
        Assertions.assertEquals((long)(this.cellSize * this.dataBlocks + this.cellSize + this.cellSize / 10), (long)this.getLongMetric("EcReconstructionBytesRead"), (String)"ecReconstructionBytesRead should be ");
        Assertions.assertEquals((long)this.blockSize, (long)this.getLongMetric("EcReconstructionBytesWritten"), (String)"EcReconstructionBytesWritten should be ");
        Assertions.assertEquals((long)0L, (long)this.getLongMetricWithoutCheck("EcReconstructionRemoteBytesRead"), (String)"EcReconstructionRemoteBytesRead should be ");
    }

    @Test
    @Timeout(value=120L)
    public void testReconstructionBytesPartialGroup3() throws Exception {
        int fileLen = this.cellSize * this.dataBlocks + this.cellSize + this.cellSize / 10;
        this.doTest("/testEcBytes", fileLen, 1);
        Assertions.assertEquals((long)(this.cellSize * this.dataBlocks + this.cellSize / 10 * 2), (long)this.getLongMetric("EcReconstructionBytesRead"), (String)"ecReconstructionBytesRead should be ");
        Assertions.assertEquals((long)(this.cellSize + this.cellSize / 10), (long)this.getLongMetric("EcReconstructionBytesWritten"), (String)"ecReconstructionBytesWritten should be ");
        Assertions.assertEquals((long)0L, (long)this.getLongMetricWithoutCheck("EcReconstructionRemoteBytesRead"), (String)"EcReconstructionRemoteBytesRead should be ");
    }

    private long getLongMetric(String metricName) {
        long metricValue = 0L;
        for (DataNode dn : this.cluster.getDataNodes()) {
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
            metricValue += MetricsAsserts.getLongCounter((String)metricName, (MetricsRecordBuilder)rb);
        }
        return metricValue;
    }

    private long getLongMetricWithoutCheck(String metricName) {
        long metricValue = 0L;
        for (DataNode dn : this.cluster.getDataNodes()) {
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
            metricValue += MetricsAsserts.getLongCounterWithoutCheck((String)metricName, (MetricsRecordBuilder)rb);
        }
        return metricValue;
    }

    private void doTest(String fileName, int fileLen, int deadNodeIndex) throws Exception {
        Assertions.assertTrue((fileLen > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((deadNodeIndex >= 0 && deadNodeIndex < this.numDNs ? 1 : 0) != 0);
        Path file = new Path(fileName);
        byte[] data = StripedFileTestUtil.generateBytes(fileLen);
        DFSTestUtil.writeFile((FileSystem)this.fs, file, data);
        StripedFileTestUtil.waitBlockGroupsReported(this.fs, fileName);
        LocatedBlocks locatedBlocks = StripedFileTestUtil.getLocatedBlocks(file, this.fs);
        LocatedStripedBlock lastBlock = (LocatedStripedBlock)locatedBlocks.getLastLocatedBlock();
        Assertions.assertTrue((lastBlock.getLocations().length > deadNodeIndex ? 1 : 0) != 0);
        DataNode toCorruptDn = this.cluster.getDataNode(lastBlock.getLocations()[deadNodeIndex].getIpcPort());
        LOG.info("Datanode to be corrupted: " + toCorruptDn);
        Assertions.assertNotNull((Object)toCorruptDn, (String)"Failed to find a datanode to be corrupted");
        toCorruptDn.shutdown();
        this.setDataNodeDead(toCorruptDn.getDatanodeId());
        DFSTestUtil.waitForDatanodeState(this.cluster, toCorruptDn.getDatanodeUuid(), false, 10000);
        int workCount = this.getComputedDatanodeWork();
        Assertions.assertTrue((workCount > 0 ? 1 : 0) != 0, (String)"Wrongly computed block reconstruction work");
        this.cluster.triggerHeartbeats();
        int totalBlocks = fileLen / this.blockGroupSize * this.groupSize;
        int remainder = fileLen % this.blockGroupSize;
        StripedFileTestUtil.waitForAllReconstructionFinished(file, this.fs, totalBlocks += remainder == 0 ? 0 : (remainder % this.blockSize == 0 ? remainder / this.blockSize + this.parityBlocks : remainder / this.blockSize + 1 + this.parityBlocks));
    }

    private int getComputedDatanodeWork() throws IOException, InterruptedException {
        int retries;
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        int workCount = 0;
        for (retries = 20; retries > 0 && (workCount = BlockManagerTestUtil.getComputedDatanodeWork(bm)) <= 0; --retries) {
            Thread.sleep(500L);
        }
        LOG.info("Computed datanode work: " + workCount + ", retries: " + retries);
        return workCount;
    }

    private void setDataNodeDead(DatanodeID dnID) throws IOException {
        DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(), dnID);
        DFSTestUtil.setDatanodeDead((DatanodeInfo)dnd);
        BlockManagerTestUtil.checkHeartbeat(this.cluster.getNamesystem().getBlockManager());
    }
}

