/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.util.Shell;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.opentest4j.TestAbortedException;

public class TestDataDirs {
    @Test
    @Timeout(value=30L)
    public void testDataDirParsing() throws Throwable {
        Configuration conf = new Configuration();
        File dir0 = new File("/dir0");
        File dir1 = new File("/dir1");
        File dir2 = new File("/dir2");
        File dir3 = new File("/dir3");
        File dir4 = new File("/dir4");
        File dir5 = new File("/dir5");
        File dir6 = new File("/dir6");
        File dir7 = new File("/dir7");
        String locations1 = "[disk]/dir0,[DISK]/dir1,[sSd]/dir2,[disK]/dir3,[ram_disk]/dir4,[disk]/dir5, [disk] /dir6, [disk] , [nvdimm]/dir7";
        conf.set("dfs.datanode.data.dir", locations1);
        List locations = DataNode.getStorageLocations((Configuration)conf);
        Assertions.assertThat((int)locations.size()).isEqualTo(9);
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(0)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(0)).getUri()).isEqualTo((Object)dir0.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(1)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(1)).getUri()).isEqualTo((Object)dir1.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(2)).getStorageType()).isEqualTo((Object)StorageType.SSD);
        Assertions.assertThat((URI)((StorageLocation)locations.get(2)).getUri()).isEqualTo((Object)dir2.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(3)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(3)).getUri()).isEqualTo((Object)dir3.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(4)).getStorageType()).isEqualTo((Object)StorageType.RAM_DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(4)).getUri()).isEqualTo((Object)dir4.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(5)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(5)).getUri()).isEqualTo((Object)dir5.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(6)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(6)).getUri()).isEqualTo((Object)dir6.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(7)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(8)).getStorageType()).isEqualTo((Object)StorageType.NVDIMM);
        Assertions.assertThat((URI)((StorageLocation)locations.get(8)).getUri()).isEqualTo((Object)dir7.toURI());
        String locations2 = "[BadMediaType]/dir0,[ssd]/dir1,[disk]/dir2";
        conf.set("dfs.datanode.data.dir", locations2);
        try {
            locations = DataNode.getStorageLocations((Configuration)conf);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException iae) {
            DataNode.LOG.info("The exception is expected.", (Throwable)iae);
        }
        String locations3 = "/dir0,/dir1";
        conf.set("dfs.datanode.data.dir", locations3);
        locations = DataNode.getStorageLocations((Configuration)conf);
        Assertions.assertThat((int)locations.size()).isEqualTo(2);
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(0)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(0)).getUri()).isEqualTo((Object)dir0.toURI());
        Assertions.assertThat((Comparable)((StorageLocation)locations.get(1)).getStorageType()).isEqualTo((Object)StorageType.DISK);
        Assertions.assertThat((URI)((StorageLocation)locations.get(1)).getUri()).isEqualTo((Object)dir1.toURI());
    }

    @Test
    public void testDataDirFileSystem() throws Exception {
        if (Shell.MAC) {
            throw new TestAbortedException("Not supported on MAC OS");
        }
        Configuration conf = new Configuration();
        String archiveDir = "/home";
        String location = "[DISK]/dir1,[ARCHIVE]" + archiveDir;
        conf.set("dfs.datanode.data.dir", location);
        List locations = DataNode.getStorageLocations((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)locations.size());
        conf.set("dfs.datanode.storagetype.ARCHIVE.filesystem", "nothis_filesystem");
        locations = DataNode.getStorageLocations((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)locations.size());
        DF df = new DF(new File(archiveDir), conf);
        String fsInfo = df.getFilesystem();
        conf.set("dfs.datanode.storagetype.ARCHIVE.filesystem", fsInfo);
        locations = DataNode.getStorageLocations((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)locations.size());
    }

    @Test
    public void testCapacityRatioForDataDir() {
        String config = "[0.9 ]/disk /2, [0.1]/disk2/1";
        Map map = StorageLocation.parseCapacityRatio((String)config);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.9, (double)((Double)map.get(new Path("/disk/2").toUri())), (double)0.0);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.1, (double)((Double)map.get(new Path("/disk2/1").toUri())), (double)0.0);
        config = "[0.9 ]/disk /2, /disk2/1";
        try {
            StorageLocation.parseCapacityRatio((String)config);
            org.junit.jupiter.api.Assertions.fail((String)"Should fail parsing");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("Capacity ratio config is not with correct form"));
        }
        config = "[11.1]/disk /2";
        try {
            StorageLocation.parseCapacityRatio((String)config);
            org.junit.jupiter.api.Assertions.fail((String)"Should fail parsing");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("is not between 0 to 1"));
        }
    }
}

