/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.BlockReceiver;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCachingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TestCachingStrategy.class);
    private static final int MAX_TEST_FILE_LEN = 0x100000;
    private static final int WRITE_PACKET_SIZE = 65536;
    private static final TestRecordingCacheTracker tracker = new TestRecordingCacheTracker();

    @BeforeAll
    public static void setupTest() {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)tracker);
        BlockSender.CACHE_DROP_INTERVAL_BYTES = 4096L;
        BlockReceiver.CACHE_DROP_LAG_BYTES = 4096L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createHdfsFile(FileSystem fs, Path p, long length, Boolean dropBehind) throws Exception {
        try (FSDataOutputStream fos = null;){
            fos = fs.create(p, (short)1);
            if (dropBehind != null) {
                fos.setDropBehind(dropBehind);
            }
            byte[] buf = new byte[8196];
            while (length > 0L) {
                int amt = length > (long)buf.length ? buf.length : (int)length;
                fos.write(buf, 0, amt);
                length -= (long)amt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readHdfsFile(FileSystem fs, Path p, long length, Boolean dropBehind) throws Exception {
        long totalRead = 0L;
        try (FSDataInputStream fis = null;){
            fis = fs.open(p);
            if (dropBehind != null) {
                fis.setDropBehind(dropBehind);
            }
            byte[] buf = new byte[8196];
            while (length > 0L) {
                int amt = length > (long)buf.length ? buf.length : (int)length;
                int ret = fis.read(buf, 0, amt);
                if (ret == -1) {
                    long l = totalRead;
                    return l;
                }
                totalRead += (long)ret;
                length -= (long)ret;
            }
        }
        throw new RuntimeException("unreachable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testFadviseAfterWriteThenRead() throws Exception {
        LOG.info("testFadviseAfterWriteThenRead");
        tracker.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        String TEST_PATH = "/test";
        int TEST_PATH_LEN = 0x100000;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestCachingStrategy.createHdfsFile((FileSystem)fs, new Path(TEST_PATH), TEST_PATH_LEN, true);
            ExtendedBlock block = cluster.getNameNode().getRpcServer().getBlockLocations(TEST_PATH, 0L, Long.MAX_VALUE).get(0).getBlock();
            String fadvisedFileName = cluster.getBlockFile(0, block).getName();
            Stats stats = tracker.getStats(fadvisedFileName);
            stats.assertDroppedInRange(0, TEST_PATH_LEN - 65536);
            stats.clear();
            TestCachingStrategy.readHdfsFile((FileSystem)fs, new Path(TEST_PATH), Long.MAX_VALUE, true);
            Assertions.assertNotNull((Object)stats);
            stats.assertDroppedInRange(0, TEST_PATH_LEN - 65536);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testClientDefaults() throws Exception {
        LOG.info("testClientDefaults");
        tracker.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.drop.cache.behind.reads", false);
        conf.setBoolean("dfs.datanode.drop.cache.behind.writes", false);
        conf.setBoolean("dfs.client.cache.drop.behind.reads", true);
        conf.setBoolean("dfs.client.cache.drop.behind.writes", true);
        MiniDFSCluster cluster = null;
        String TEST_PATH = "/test";
        int TEST_PATH_LEN = 0x100000;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestCachingStrategy.createHdfsFile((FileSystem)fs, new Path(TEST_PATH), TEST_PATH_LEN, null);
            ExtendedBlock block = cluster.getNameNode().getRpcServer().getBlockLocations(TEST_PATH, 0L, Long.MAX_VALUE).get(0).getBlock();
            String fadvisedFileName = cluster.getBlockFile(0, block).getName();
            Stats stats = tracker.getStats(fadvisedFileName);
            stats.assertDroppedInRange(0, TEST_PATH_LEN - 65536);
            stats.clear();
            TestCachingStrategy.readHdfsFile((FileSystem)fs, new Path(TEST_PATH), Long.MAX_VALUE, null);
            Assertions.assertNotNull((Object)stats);
            stats.assertDroppedInRange(0, TEST_PATH_LEN - 65536);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testFadviseSkippedForSmallReads() throws Exception {
        LOG.info("testFadviseSkippedForSmallReads");
        tracker.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.drop.cache.behind.reads", true);
        conf.setBoolean("dfs.datanode.drop.cache.behind.writes", true);
        MiniDFSCluster cluster = null;
        String TEST_PATH = "/test";
        int TEST_PATH_LEN = 0x100000;
        FSDataInputStream fis = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestCachingStrategy.createHdfsFile((FileSystem)fs, new Path(TEST_PATH), TEST_PATH_LEN, null);
            ExtendedBlock block = cluster.getNameNode().getRpcServer().getBlockLocations(TEST_PATH, 0L, Long.MAX_VALUE).get(0).getBlock();
            String fadvisedFileName = cluster.getBlockFile(0, block).getName();
            Stats stats = tracker.getStats(fadvisedFileName);
            stats.assertDroppedInRange(0, TEST_PATH_LEN - 65536);
            stats.clear();
            stats.assertNotDroppedInRange(0, TEST_PATH_LEN);
            fis = fs.open(new Path(TEST_PATH));
            byte[] buf = new byte[17];
            fis.readFully(4096L, buf, 0, buf.length);
            stats = tracker.getStats(fadvisedFileName);
            stats.assertNotDroppedInRange(0, TEST_PATH_LEN - 65536);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fis});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{fis});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testNoFadviseAfterWriteThenRead() throws Exception {
        LOG.info("testNoFadviseAfterWriteThenRead");
        tracker.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        String TEST_PATH = "/test";
        int TEST_PATH_LEN = 0x100000;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestCachingStrategy.createHdfsFile((FileSystem)fs, new Path(TEST_PATH), TEST_PATH_LEN, false);
            ExtendedBlock block = cluster.getNameNode().getRpcServer().getBlockLocations(TEST_PATH, 0L, Long.MAX_VALUE).get(0).getBlock();
            String fadvisedFileName = cluster.getBlockFile(0, block).getName();
            Stats stats = tracker.getStats(fadvisedFileName);
            Assertions.assertNull((Object)stats);
            TestCachingStrategy.readHdfsFile((FileSystem)fs, new Path(TEST_PATH), Long.MAX_VALUE, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testSeekAfterSetDropBehind() throws Exception {
        LOG.info("testSeekAfterSetDropBehind");
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        String TEST_PATH = "/test";
        int TEST_PATH_LEN = 0x100000;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            TestCachingStrategy.createHdfsFile((FileSystem)fs, new Path(TEST_PATH), TEST_PATH_LEN, false);
            try (FSDataInputStream fis = fs.open(new Path(TEST_PATH));){
                Assertions.assertTrue((fis.read() != -1 ? 1 : 0) != 0);
                fis.setDropBehind(Boolean.valueOf(false));
                fis.seek(2L);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class TestRecordingCacheTracker
    extends NativeIO.POSIX.CacheManipulator {
        private final Map<String, Stats> map = new TreeMap<String, Stats>();

        private TestRecordingCacheTracker() {
        }

        public void posixFadviseIfPossible(String name, FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
            if (len < 0L || len > Integer.MAX_VALUE) {
                throw new RuntimeException("invalid length of " + len + " passed to posixFadviseIfPossible");
            }
            if (offset < 0L || offset > Integer.MAX_VALUE) {
                throw new RuntimeException("invalid offset of " + offset + " passed to posixFadviseIfPossible");
            }
            Stats stats = this.map.get(name);
            if (stats == null) {
                stats = new Stats(name);
                this.map.put(name, stats);
            }
            stats.fadvise((int)offset, (int)len, flags);
            super.posixFadviseIfPossible(name, fd, offset, len, flags);
        }

        synchronized void clear() {
            this.map.clear();
        }

        synchronized Stats getStats(String fileName) {
            return this.map.get(fileName);
        }

        public synchronized String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("TestRecordingCacheManipulator{");
            String prefix = "";
            for (String fileName : this.map.keySet()) {
                bld.append(prefix);
                prefix = ", ";
                bld.append(fileName);
            }
            bld.append("}");
            return bld.toString();
        }
    }

    private static class Stats {
        private final String fileName;
        private final boolean[] dropped = new boolean[0x100000];

        Stats(String fileName) {
            this.fileName = fileName;
        }

        synchronized void fadvise(int offset, int len, int flags) {
            LOG.debug("got fadvise(offset={}, len={}, flags={})", new Object[]{offset, len, flags});
            if (flags == NativeIO.POSIX.POSIX_FADV_DONTNEED) {
                for (int i = 0; i < len; ++i) {
                    this.dropped[offset + i] = true;
                }
            }
        }

        synchronized void assertNotDroppedInRange(int start, int end) {
            for (int i = start; i < end; ++i) {
                if (!this.dropped[i]) continue;
                throw new RuntimeException("in file " + this.fileName + ", we dropped the cache at offset " + i);
            }
        }

        synchronized void assertDroppedInRange(int start, int end) {
            for (int i = start; i < end; ++i) {
                if (this.dropped[i]) continue;
                throw new RuntimeException("in file " + this.fileName + ", we did not drop the cache at offset " + i);
            }
        }

        synchronized void clear() {
            Arrays.fill(this.dropped, false);
        }
    }
}

