/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.util.Time;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestBpServiceActorScheduler {
    protected static final Logger LOG = LoggerFactory.getLogger(TestBpServiceActorScheduler.class);
    private static final long HEARTBEAT_INTERVAL_MS = 5000L;
    private static final long LIFELINE_INTERVAL_MS = 15000L;
    private static final long BLOCK_REPORT_INTERVAL_MS = 10000L;
    private static final long OUTLIER_REPORT_INTERVAL_MS = 10000L;
    private final Random random = new Random(System.nanoTime());

    @Test
    public void testInit() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.isHeartbeatDue(now));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.isBlockReportDue(scheduler.monotonicNow()));
        }
    }

    @Test
    public void testScheduleBlockReportImmediate() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleBlockReport(0L, true);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.resetBlockReportTime);
            Assertions.assertThat((long)scheduler.getNextBlockReportTime()).isEqualTo(now);
        }
    }

    @Test
    public void testScheduleBlockReportDelayed() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            long delayMs = 10L;
            scheduler.scheduleBlockReport(10L, true);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.resetBlockReportTime);
            org.junit.jupiter.api.Assertions.assertTrue((scheduler.getNextBlockReportTime() - now >= 0L ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((scheduler.getNextBlockReportTime() - (now + 10L) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleNextBlockReport() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.resetBlockReportTime);
            scheduler.scheduleNextBlockReport();
            org.junit.jupiter.api.Assertions.assertTrue((scheduler.getNextBlockReportTime() - (now + 10000L) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleNextBlockReport2() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.resetBlockReportTime = false;
            scheduler.scheduleNextBlockReport();
            Assertions.assertThat((long)scheduler.getNextBlockReportTime()).isEqualTo(now + 10000L);
        }
    }

    @Test
    public void testScheduleNextBlockReport3() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.resetBlockReportTime = false;
            long blockReportDelay = 10000L + (long)this.random.nextInt(20000);
            long origBlockReportTime = now - blockReportDelay;
            scheduler.setNextBlockReportTime(origBlockReportTime);
            scheduler.scheduleNextBlockReport();
            org.junit.jupiter.api.Assertions.assertTrue((scheduler.getNextBlockReportTime() - now < 10000L ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)((scheduler.getNextBlockReportTime() - origBlockReportTime) % 10000L));
        }
    }

    @Test
    public void testScheduleNextBlockReport4() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            for (int i = 0; i < this.getTimestamps().size(); ++i) {
                scheduler.forceFullBlockReportNow();
                scheduler.scheduleNextBlockReport();
            }
            org.junit.jupiter.api.Assertions.assertTrue((scheduler.getNextBlockReportTime() - now >= 0L ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((scheduler.getNextBlockReportTime() - now <= 10000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleHeartbeat() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextHeartbeat();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scheduler.isHeartbeatDue(now));
            scheduler.scheduleHeartbeat();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    @Test
    public void testScheduleDelayedHeartbeat() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextHeartbeat();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scheduler.isHeartbeatDue(now));
            scheduler.nextHeartbeatTime = now - 50000L;
            scheduler.scheduleNextHeartbeat();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    @Test
    public void testScheduleLifeline() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextLifeline(now);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scheduler.isLifelineDue(now));
            Assertions.assertThat((long)scheduler.getLifelineWaitTime()).isEqualTo(15000L);
            scheduler.scheduleNextLifeline(now - 15000L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.isLifelineDue(now));
            Assertions.assertThat((long)scheduler.getLifelineWaitTime()).isEqualTo(0L);
        }
    }

    @Test
    public void testScheduleLifelineScheduleTime() {
        BPServiceActor.Scheduler mockScheduler = (BPServiceActor.Scheduler)Mockito.spy((Object)new BPServiceActor.Scheduler(5000L, 15000L, 10000L, 10000L));
        long now = Time.monotonicNow();
        mockScheduler.scheduleNextLifeline(now);
        long mockMonotonicNow = now + 30000L;
        ((BPServiceActor.Scheduler)Mockito.doReturn((Object)mockMonotonicNow).when((Object)mockScheduler)).monotonicNow();
        org.junit.jupiter.api.Assertions.assertTrue((mockScheduler.getLifelineWaitTime() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testOutlierReportScheduling() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.isOutliersReportDue(now));
            scheduler.scheduleNextOutlierReport();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scheduler.isOutliersReportDue(now));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)scheduler.isOutliersReportDue(now + 1L));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)scheduler.isOutliersReportDue(now + 10000L));
        }
    }

    private BPServiceActor.Scheduler makeMockScheduler(long now) {
        LOG.info("Using now = " + now);
        BPServiceActor.Scheduler mockScheduler = (BPServiceActor.Scheduler)Mockito.spy((Object)new BPServiceActor.Scheduler(5000L, 15000L, 10000L, 10000L));
        ((BPServiceActor.Scheduler)Mockito.doReturn((Object)now).when((Object)mockScheduler)).monotonicNow();
        mockScheduler.setNextBlockReportTime(now);
        mockScheduler.nextHeartbeatTime = now;
        mockScheduler.nextOutliersReportTime = now;
        return mockScheduler;
    }

    List<Long> getTimestamps() {
        return Arrays.asList(0L, Long.MIN_VALUE, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, Math.abs(this.random.nextLong()), -Math.abs(this.random.nextLong()));
    }
}

