/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockReplacement {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestBlockReplacement");
    MiniDFSCluster cluster;

    @Test
    public void testThrottler() throws IOException {
        long TOTAL_BYTES;
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        long bandwidthPerSec = 0x100000L;
        long bytesToSend = TOTAL_BYTES = 6L * bandwidthPerSec;
        long start = Time.monotonicNow();
        DataTransferThrottler throttler = new DataTransferThrottler(bandwidthPerSec);
        long bytesSent = 524288L;
        throttler.throttle(bytesSent);
        bytesToSend -= bytesSent;
        bytesSent = 786432L;
        throttler.throttle(bytesSent);
        bytesToSend -= bytesSent;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throttler.throttle(bytesToSend);
        long end = Time.monotonicNow();
        Assertions.assertTrue((TOTAL_BYTES * 1000L / (end - start) <= bandwidthPerSec ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockReplacement() throws Exception {
        HdfsConfiguration CONF = new HdfsConfiguration();
        String[] INITIAL_RACKS = new String[]{"/RACK0", "/RACK1", "/RACK2"};
        String[] NEW_RACKS = new String[]{"/RACK2"};
        int REPLICATION_FACTOR = 3;
        int DEFAULT_BLOCK_SIZE = 1024;
        Random r = new Random();
        CONF.setLong("dfs.blocksize", 1024L);
        CONF.setInt("dfs.bytes-per-checksum", 512);
        CONF.setLong("dfs.blockreport.intervalMsec", 500L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(3).racks(INITIAL_RACKS).build();
        try {
            this.cluster.waitActive();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path fileName = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 1024L, (short)3, r.nextLong());
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)3);
            InetSocketAddress addr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)CONF);
            List locatedBlocks = client.getNamenode().getBlockLocations("/tmp.txt", 0L, 1024L).getLocatedBlocks();
            Assertions.assertEquals((int)1, (int)locatedBlocks.size());
            LocatedBlock block = (LocatedBlock)locatedBlocks.get(0);
            DatanodeInfoWithStorage[] oldNodes = block.getLocations();
            Assertions.assertEquals((int)oldNodes.length, (int)3);
            ExtendedBlock b = block.getBlock();
            this.cluster.startDataNodes((Configuration)CONF, 1, true, null, NEW_RACKS);
            this.cluster.waitActive();
            DatanodeInfo[] datanodes = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            DatanodeInfo newNode = null;
            for (DatanodeInfo node : datanodes) {
                Boolean isNewNode = true;
                for (DatanodeInfoWithStorage oldNode : oldNodes) {
                    if (!node.equals((Object)oldNode)) continue;
                    isNewNode = false;
                    break;
                }
                if (!isNewNode.booleanValue()) continue;
                newNode = node;
                break;
            }
            Assertions.assertTrue((newNode != null ? 1 : 0) != 0);
            DatanodeInfo source = null;
            ArrayList<DatanodeInfo> proxies = new ArrayList<DatanodeInfo>(2);
            for (DatanodeInfo node : datanodes) {
                if (node == newNode) continue;
                if (node.getNetworkLocation().equals(newNode.getNetworkLocation())) {
                    source = node;
                    continue;
                }
                proxies.add(node);
            }
            Assertions.assertTrue((source != null && proxies.size() == 2 ? 1 : 0) != 0);
            LOG.info("Testcase 1: Proxy " + newNode + " does not contain the block " + b);
            Assertions.assertFalse((boolean)this.replaceBlock(b, source, newNode, (DatanodeInfo)proxies.get(0)));
            LOG.info("Testcase 2: Destination " + proxies.get(1) + " contains the block " + b);
            Assertions.assertFalse((boolean)this.replaceBlock(b, source, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1)));
            LOG.info("Testcase 3: Source=" + source + " Proxy=" + proxies.get(0) + " Destination=" + newNode);
            Assertions.assertTrue((boolean)this.replaceBlock(b, source, (DatanodeInfo)proxies.get(0), newNode));
            this.checkBlocks(new DatanodeInfo[]{newNode, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1)}, fileName.toString(), 1024L, (short)3, client);
            LOG.info("Testcase 4: invalid del hint " + proxies.get(0));
            Assertions.assertTrue((boolean)this.replaceBlock(b, (DatanodeInfo)proxies.get(0), (DatanodeInfo)proxies.get(1), source));
            this.checkBlocks(new DatanodeInfo[0], fileName.toString(), 1024L, (short)3, client);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=90L)
    public void testBlockReplacementWithPinnedBlocks() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        try {
            this.cluster.waitActive();
            DistributedFileSystem dfs = this.cluster.getFileSystem();
            String fileName = "/testBlockReplacementWithPinnedBlocks/file";
            Path file = new Path(fileName);
            DFSTestUtil.createFile((FileSystem)dfs, file, 1024L, (short)1, 1024L);
            LocatedBlock lb = dfs.getClient().getLocatedBlocks(fileName, 0L).get(0);
            DatanodeInfoWithStorage[] oldNodes = lb.getLocations();
            Assertions.assertEquals((int)oldNodes.length, (int)1, (String)"Wrong block locations");
            DatanodeInfoWithStorage source = oldNodes[0];
            ExtendedBlock b = lb.getBlock();
            DatanodeInfo[] datanodes = dfs.getDataNodeStats();
            DatanodeInfo destin = null;
            for (DatanodeInfo datanodeInfo : datanodes) {
                if (oldNodes[0].equals((Object)datanodeInfo)) continue;
                destin = datanodeInfo;
                break;
            }
            Assertions.assertNotNull(destin, (String)"Failed to choose destination datanode!");
            Assertions.assertFalse((boolean)source.equals(destin), (String)"Source and destin datanode should be different");
            for (int i = 0; i < this.cluster.getDataNodes().size(); ++i) {
                DataNode dn = this.cluster.getDataNodes().get(i);
                LOG.info("Simulate block pinning in datanode " + dn);
                InternalDataNodeTestUtils.mockDatanodeBlkPinning(dn, true);
            }
            Assertions.assertTrue((boolean)this.replaceBlock(b, (DatanodeInfo)source, (DatanodeInfo)source, destin, StorageType.ARCHIVE, DataTransferProtos.Status.ERROR_BLOCK_PINNED), (String)"Status code mismatches!");
        }
        finally {
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockMoveAcrossStorageInSameNode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).storageTypes(new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path file = new Path("/testBlockMoveAcrossStorageInSameNode/file");
            DFSTestUtil.createFile((FileSystem)dfs, file, 1024L, (short)1, 1024L);
            LocatedBlocks locatedBlocks = dfs.getClient().getLocatedBlocks(file.toString(), 0L);
            LocatedBlock locatedBlock = locatedBlocks.get(0);
            ExtendedBlock block = locatedBlock.getBlock();
            DatanodeInfoWithStorage[] locations = locatedBlock.getLocations();
            Assertions.assertEquals((int)1, (int)locations.length);
            StorageType[] storageTypes = locatedBlock.getStorageTypes();
            Assertions.assertTrue((storageTypes[0] == StorageType.DISK ? 1 : 0) != 0);
            DatanodeInfoWithStorage source = locations[0];
            Assertions.assertTrue((boolean)this.replaceBlock(block, (DatanodeInfo)source, (DatanodeInfo)source, (DatanodeInfo)source, StorageType.ARCHIVE, DataTransferProtos.Status.SUCCESS));
            Thread.sleep(3000L);
            locatedBlocks = dfs.getClient().getLocatedBlocks(file.toString(), 0L);
            locatedBlock = locatedBlocks.get(0);
            Assertions.assertEquals((int)1, (int)locatedBlock.getLocations().length, (String)"Storage should be only one");
            Assertions.assertTrue((locatedBlock.getStorageTypes()[0] == StorageType.ARCHIVE ? 1 : 0) != 0, (String)"Block should be moved to ARCHIVE");
        }
        finally {
            cluster.shutdown();
        }
    }

    private void checkBlocks(DatanodeInfo[] includeNodes, String fileName, long fileLen, short replFactor, DFSClient client) throws IOException, TimeoutException {
        boolean notDone;
        long TIMEOUT = 20000L;
        long starttime = Time.monotonicNow();
        long failtime = starttime + 20000L;
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List blocks = client.getNamenode().getBlockLocations(fileName, 0L, fileLen).getLocatedBlocks();
            Assertions.assertEquals((int)1, (int)blocks.size());
            DatanodeInfoWithStorage[] nodes = ((LocatedBlock)blocks.get(0)).getLocations();
            boolean bl = notDone = nodes.length != replFactor;
            if (notDone) {
                LOG.info("Expected replication factor is " + replFactor + " but the real replication factor is " + nodes.length);
            } else {
                List<DatanodeInfoWithStorage> nodeLocations = Arrays.asList(nodes);
                for (DatanodeInfo node : includeNodes) {
                    if (nodeLocations.contains(node)) continue;
                    notDone = true;
                    LOG.info("Block is not located at " + node);
                    break;
                }
            }
            if (Time.monotonicNow() <= failtime) continue;
            String expectedNodesList = "";
            String currentNodesList = "";
            for (DatanodeInfo datanodeInfo : includeNodes) {
                expectedNodesList = expectedNodesList + datanodeInfo + ", ";
            }
            for (DatanodeInfo datanodeInfo : nodes) {
                currentNodesList = currentNodesList + datanodeInfo + ", ";
            }
            LOG.info("Expected replica nodes are: " + expectedNodesList);
            LOG.info("Current actual replica nodes are: " + currentNodesList);
            throw new TimeoutException("Did not achieve expected replication to expected nodes after more than 20000 msec.  See logs for details.");
        } while (notDone);
        LOG.info("Achieved expected replication values in " + (Time.now() - starttime) + " msec.");
    }

    private boolean replaceBlock(ExtendedBlock block, DatanodeInfo source, DatanodeInfo sourceProxy, DatanodeInfo destination) throws IOException {
        return DFSTestUtil.replaceBlock(block, source, sourceProxy, destination, StorageType.DEFAULT, DataTransferProtos.Status.SUCCESS);
    }

    private boolean replaceBlock(ExtendedBlock block, DatanodeInfo source, DatanodeInfo sourceProxy, DatanodeInfo destination, StorageType targetStorageType, DataTransferProtos.Status opStatus) throws IOException, SocketException {
        return DFSTestUtil.replaceBlock(block, source, sourceProxy, destination, targetStorageType, opStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeletedBlockWhenAddBlockIsInEdit() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(1).build();
        DFSClient client = null;
        try {
            this.cluster.waitActive();
            Assertions.assertEquals((int)2, (int)this.cluster.getNumNameNodes(), (String)"Number of namenodes is not 2");
            this.cluster.transitionToActive(0);
            Assertions.assertTrue((boolean)this.cluster.getNameNode(0).isActiveState(), (String)"Namenode 0 should be in active state");
            Assertions.assertTrue((boolean)this.cluster.getNameNode(1).isStandbyState(), (String)"Namenode 1 should be in standby state");
            DataNodeTestUtils.triggerHeartbeat(this.cluster.getDataNodes().get(0));
            DistributedFileSystem fs = this.cluster.getFileSystem(0);
            this.cluster.getDataNodes().get(0).triggerBlockReport(new BlockReportOptions.Factory().setIncremental(false).build());
            Path fileName = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, fileName, 10L, (short)1, 1234L);
            DFSTestUtil.waitReplication((FileSystem)fs, fileName, (short)1);
            client = new DFSClient(this.cluster.getFileSystem(0).getUri(), (Configuration)conf);
            List locatedBlocks = client.getNamenode().getBlockLocations("/tmp.txt", 0L, 10L).getLocatedBlocks();
            Assertions.assertTrue((locatedBlocks.size() == 1 ? 1 : 0) != 0);
            Assertions.assertTrue((((LocatedBlock)locatedBlocks.get(0)).getLocations().length == 1 ? 1 : 0) != 0);
            this.cluster.startDataNodes((Configuration)conf, 1, true, null, null, null, null);
            Assertions.assertEquals((int)2, (int)this.cluster.getDataNodes().size(), (String)"Number of datanodes should be 2");
            DataNode dn0 = this.cluster.getDataNodes().get(0);
            DataNode dn1 = this.cluster.getDataNodes().get(1);
            String activeNNBPId = this.cluster.getNamesystem(0).getBlockPoolId();
            DatanodeDescriptor sourceDnDesc = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(0), (DatanodeID)dn0.getDNRegistrationForBP(activeNNBPId));
            DatanodeDescriptor destDnDesc = NameNodeAdapter.getDatanode(this.cluster.getNamesystem(0), (DatanodeID)dn1.getDNRegistrationForBP(activeNNBPId));
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, fileName);
            LOG.info("replaceBlock:  " + this.replaceBlock(block, (DatanodeInfo)sourceDnDesc, (DatanodeInfo)sourceDnDesc, (DatanodeInfo)destDnDesc));
            for (int tries = 0; tries < 20; ++tries) {
                Thread.sleep(1000L);
                DataNodeTestUtils.triggerDeletionReport(this.cluster.getDataNodes().get(0));
                locatedBlocks = client.getNamenode().getBlockLocations("/tmp.txt", 0L, 10L).getLocatedBlocks();
                if (((LocatedBlock)locatedBlocks.get(0)).getLocations().length == 1) break;
            }
            this.cluster.transitionToStandby(0);
            this.cluster.transitionToActive(1);
            Assertions.assertTrue((boolean)this.cluster.getNameNode(1).isActiveState(), (String)"Namenode 1 should be in active state");
            Assertions.assertTrue((boolean)this.cluster.getNameNode(0).isStandbyState(), (String)"Namenode 0 should be in standby state");
            client.close();
            client = new DFSClient(this.cluster.getFileSystem(1).getUri(), (Configuration)conf);
            List locatedBlocks1 = client.getNamenode().getBlockLocations("/tmp.txt", 0L, 10L).getLocatedBlocks();
            Assertions.assertEquals((int)1, (int)locatedBlocks1.size());
            Assertions.assertEquals((int)1, (int)((LocatedBlock)locatedBlocks1.get(0)).getLocations().length, (String)"The block should be only on 1 datanode ");
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{client});
            this.cluster.shutdown();
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{client});
        this.cluster.shutdown();
    }

    public static void main(String[] args) throws Exception {
        new TestBlockReplacement().testBlockReplacement();
    }
}

