/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockPoolSliceStorage {
    public static final Logger LOG = LoggerFactory.getLogger(TestBlockPoolSliceStorage.class);
    final Random rand = new Random();
    BlockPoolSliceStorage storage;

    private String makeRandomIpAddress() {
        return this.rand.nextInt(256) + "." + this.rand.nextInt(256) + "." + this.rand.nextInt(256) + "." + this.rand.nextInt(256);
    }

    private String makeRandomBlockpoolId() {
        return "BP-" + this.rand.nextInt(Integer.MAX_VALUE) + "-" + this.makeRandomIpAddress() + "-" + this.rand.nextInt(Integer.MAX_VALUE);
    }

    private BlockPoolSliceStorage makeBlockPoolStorage() {
        return new StubBlockPoolSliceStorage(this.rand.nextInt(Integer.MAX_VALUE), this.makeRandomBlockpoolId(), this.rand.nextInt(Integer.MAX_VALUE), UUID.randomUUID().toString());
    }

    private String makeRandomBlockFileSubdir(int nestingLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(File.separator);
        for (int i = 0; i < nestingLevel; ++i) {
            sb.append("subdir" + this.rand.nextInt(64) + File.separator);
        }
        return sb.toString();
    }

    public void getTrashDirectoryForBlockFile(String fileName, int nestingLevel) {
        String blockFileSubdir = this.makeRandomBlockFileSubdir(nestingLevel);
        String blockFileName = fileName;
        String testFilePath = this.storage.getSingularStorageDir().getRoot() + File.separator + "current" + blockFileSubdir + blockFileName;
        String expectedTrashPath = this.storage.getSingularStorageDir().getRoot() + File.separator + "trash" + blockFileSubdir.substring(0, blockFileSubdir.length() - 1);
        LOG.info("Got subdir {}", (Object)blockFileSubdir);
        LOG.info("Generated file path {}", (Object)testFilePath);
        ReplicaInfo info = (ReplicaInfo)Mockito.mock(ReplicaInfo.class);
        Mockito.when((Object)info.getBlockURI()).thenReturn((Object)new File(testFilePath).toURI());
        Assertions.assertThat((String)this.storage.getTrashDirectory(info)).isEqualTo((Object)expectedTrashPath);
    }

    public void getRestoreDirectoryForBlockFile(String fileName, int nestingLevel) {
        BlockPoolSliceStorage storage = this.makeBlockPoolStorage();
        String blockFileSubdir = this.makeRandomBlockFileSubdir(nestingLevel);
        String blockFileName = fileName;
        String deletedFilePath = storage.getSingularStorageDir().getRoot() + File.separator + "trash" + blockFileSubdir + blockFileName;
        String expectedRestorePath = storage.getSingularStorageDir().getRoot() + File.separator + "current" + blockFileSubdir.substring(0, blockFileSubdir.length() - 1);
        LOG.info("Generated deleted file path {}", (Object)deletedFilePath);
        Assertions.assertThat((String)storage.getRestoreDirectory(new File(deletedFilePath))).isEqualTo((Object)expectedRestorePath);
    }

    @Test
    @Timeout(value=300L)
    public void testGetTrashAndRestoreDirectories() {
        this.storage = this.makeBlockPoolStorage();
        for (int i = 0; i < 3; ++i) {
            this.getTrashDirectoryForBlockFile("blk_myblockfile", i);
            this.getTrashDirectoryForBlockFile("blk_myblockfile.meta", i);
            this.getRestoreDirectoryForBlockFile("blk_myblockfile", i);
            this.getRestoreDirectoryForBlockFile("blk_myblockfile.meta", i);
        }
    }

    private static class StubBlockPoolSliceStorage
    extends BlockPoolSliceStorage {
        StubBlockPoolSliceStorage(int namespaceID, String bpID, long cTime, String clusterId) {
            super(namespaceID, bpID, cTime, clusterId);
            this.addStorageDir(new Storage.StorageDirectory(new File("/tmp/dontcare/" + bpID)));
            Assertions.assertThat((int)this.getStorageDirs().size()).isEqualTo(1);
        }
    }
}

