/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hdfs.server.common.HostRestrictingAuthorizationFilter;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHostRestrictingAuthorizationFilter {
    private Logger log = LoggerFactory.getLogger(TestHostRestrictingAuthorizationFilter.class);

    @Test
    public void testAcceptAll() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)new StringBuffer("/webhdfs/v1/user/ubuntu/foo").toString());
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"op=OPEN");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"192.168.1.2");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            }
        };
        HostRestrictingAuthorizationFilter filter = new HostRestrictingAuthorizationFilter();
        HashMap<String, String> configs = new HashMap<String, String>(){};
        String allowRule = "*,*,/";
        this.log.trace("Passing configs:\n{}", (Object)allowRule);
        configs.put("host.allow.rules", allowRule);
        configs.put("type", "simple");
        DummyFilterConfig fc = new DummyFilterConfig((Map<String, String>)configs);
        filter.init((FilterConfig)fc);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).sendError(Mockito.eq((int)403), Mockito.anyString());
        filter.destroy();
    }

    @Test
    public void testAcceptGETFILECHECKSUM() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)new StringBuffer("/webhdfs/v1/user/ubuntu/").toString());
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"op=GETFILECHECKSUM ");
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"192.168.1.2");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            }
        };
        HostRestrictingAuthorizationFilter filter = new HostRestrictingAuthorizationFilter();
        HashMap<String, String> configs = new HashMap<String, String>(){};
        configs.put("type", "simple");
        DummyFilterConfig fc = new DummyFilterConfig((Map<String, String>)configs);
        filter.init((FilterConfig)fc);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).sendError(Mockito.eq((int)403), Mockito.anyString());
        filter.destroy();
    }

    @Test
    public void testRuleAllowedGet() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        String queryString = "op=OPEN";
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)new StringBuffer("/webhdfs/v1/user/ubuntu/foo?" + queryString).toString());
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)queryString);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"192.168.1.2");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            }
        };
        HostRestrictingAuthorizationFilter filter = new HostRestrictingAuthorizationFilter();
        HashMap<String, String> configs = new HashMap<String, String>(){};
        String allowRule = "ubuntu,127.0.0.1/32,/localbits/*|*,192.168.0.1/22,/user/ubuntu/*";
        this.log.trace("Passing configs:\n{}", (Object)allowRule);
        configs.put("host.allow.rules", allowRule);
        configs.put("type", "simple");
        DummyFilterConfig fc = new DummyFilterConfig((Map<String, String>)configs);
        filter.init((FilterConfig)fc);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        filter.destroy();
    }

    @Test
    public void testRejectsGETs() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        String queryString = "bar=foo&delegationToken=dt&op=OPEN";
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)new StringBuffer("/webhdfs/v1/user/ubuntu/?" + queryString).toString());
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)queryString);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"192.168.1.2");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            }
        };
        HostRestrictingAuthorizationFilter filter = new HostRestrictingAuthorizationFilter();
        HashMap<String, String> configs = new HashMap<String, String>(){};
        configs.put("type", "simple");
        DummyFilterConfig fc = new DummyFilterConfig((Map<String, String>)configs);
        filter.init((FilterConfig)fc);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        filter.destroy();
    }

    @Test
    public void testUnexpectedInputMissingOpParameter() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)new StringBuffer("/webhdfs/v1/IAmARandomRequest/").toString());
        Mockito.when((Object)request.getQueryString()).thenReturn(null);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"192.168.1.2");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
            }
        };
        HostRestrictingAuthorizationFilter filter = new HostRestrictingAuthorizationFilter();
        HashMap<String, String> configs = new HashMap<String, String>(){};
        configs.put("type", "simple");
        DummyFilterConfig fc = new DummyFilterConfig((Map<String, String>)configs);
        filter.init((FilterConfig)fc);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        this.log.error("XXX {}", (Object)response.getStatus());
        filter.destroy();
    }

    @Test
    public void testNotWebhdfsAPIRequest() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/conf");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        HostRestrictingAuthorizationFilter filter = new HostRestrictingAuthorizationFilter();
        HashMap<String, String> configs = new HashMap<String, String>(){};
        configs.put("type", "simple");
        DummyFilterConfig fc = new DummyFilterConfig((Map<String, String>)configs);
        filter.init((FilterConfig)fc);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (servletRequest, servletResponse) -> {});
        filter.destroy();
    }

    private static class DummyFilterConfig
    implements FilterConfig {
        final Map<String, String> map;

        DummyFilterConfig(Map<String, String> map) {
            this.map = map;
        }

        public String getFilterName() {
            return "dummy";
        }

        public String getInitParameter(String arg0) {
            return this.map.get(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(this.map.keySet());
        }

        public ServletContext getServletContext() {
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            return context;
        }
    }
}

