/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithNodeGroup;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReplicationPolicyWithNodeGroup
extends BaseReplicationPolicyTest {
    private static final DatanodeStorageInfo[] storagesInBoundaryCase;
    private static final DatanodeDescriptor[] dataNodesInBoundaryCase;
    private static final DatanodeStorageInfo[] storagesInMoreTargetsCase;
    private static final DatanodeDescriptor[] dataNodesInMoreTargetsCase;
    private static final DatanodeDescriptor NODE;
    private static final DatanodeStorageInfo[] storagesForDependencies;
    private static final DatanodeDescriptor[] dataNodesForDependencies;

    public TestReplicationPolicyWithNodeGroup() {
        this.blockPlacementPolicy = BlockPlacementPolicyWithNodeGroup.class.getName();
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        conf.setBoolean("dfs.use.dfs.network.topology", false);
        conf.set("net.topology.impl", NetworkTopologyWithNodeGroup.class.getName());
        String[] racks = new String[]{"/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n2", "/d1/r2/n3", "/d1/r2/n3", "/d1/r2/n4", "/d2/r3/n5", "/d2/r3/n6"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        return DFSTestUtil.toDatanodeDescriptor(this.storages);
    }

    @Test
    public void testVerifyBlockPlacement() throws Exception {
        ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
        ArrayList<DatanodeStorageInfo> set = new ArrayList<DatanodeStorageInfo>();
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[4]);
        LocatedBlock locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        BlockPlacementStatus status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[2]);
        set.add(this.storages[5]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertTrue((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[2]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("node group"));
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("more rack(s)"));
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[5]);
        set.add(this.storages[7]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertTrue((boolean)status.isPlacementPolicySatisfied());
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[5]);
        set.add(this.storages[7]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("node group"));
        Assertions.assertFalse((boolean)status.getErrorDescription().contains("more rack(s)"));
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        set.add(this.storages[2]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("node group"));
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("more rack(s)"));
        set.clear();
        set.add(this.storages[0]);
        set.add(this.storages[1]);
        locatedBlock = BlockManager.newLocatedBlock((ExtendedBlock)b, (DatanodeStorageInfo[])set.toArray(new DatanodeStorageInfo[set.size()]), (long)0L, (boolean)false);
        status = this.replicator.verifyBlockPlacement((DatanodeInfo[])locatedBlock.getLocations(), set.size());
        Assertions.assertFalse((boolean)status.isPlacementPolicySatisfied());
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("node group"));
        Assertions.assertTrue((boolean)status.getErrorDescription().contains("more rack(s)"));
    }

    private static boolean checkTargetsOnDifferentNodeGroup(DatanodeStorageInfo[] targets) {
        if (targets.length == 0) {
            return true;
        }
        HashSet<String> targetSet = new HashSet<String>();
        for (DatanodeStorageInfo storage : targets) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            String nodeGroup = NetworkTopology.getLastHalf((String)node.getNetworkLocation());
            if (targetSet.contains(nodeGroup)) {
                return false;
            }
            targetSet.add(nodeGroup);
        }
        return true;
    }

    private boolean isOnSameRack(DatanodeDescriptor left, DatanodeStorageInfo right) {
        return this.cluster.isOnSameRack((Node)left, (Node)right.getDatanodeDescriptor());
    }

    private boolean isOnSameNodeGroup(DatanodeStorageInfo left, DatanodeStorageInfo right) {
        return this.isOnSameNodeGroup(left.getDatanodeDescriptor(), right);
    }

    private boolean isOnSameNodeGroup(DatanodeDescriptor left, DatanodeStorageInfo right) {
        return this.cluster.isOnSameNodeGroup((Node)left, (Node)right.getDatanodeDescriptor());
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, Set<Node> excludedNodes, List<DatanodeDescriptor> favoredNodes) {
        return this.replicator.chooseTarget("/dummyfile.txt", numOfReplicas, (Node)writer, excludedNodes, 1024L, favoredNodes, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
    }

    @Test
    public void testChooseTarget1() throws Exception {
        this.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 4, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        Assertions.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assertions.assertFalse((boolean)this.isOnSameNodeGroup(targets[1], targets[2]));
        targets = this.chooseTarget(4);
        Assertions.assertEquals((int)targets.length, (int)4);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        this.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 0, 0);
    }

    private void verifyNoTwoTargetsOnSameNodeGroup(DatanodeStorageInfo[] targets) {
        HashSet<String> nodeGroupSet = new HashSet<String>();
        for (DatanodeStorageInfo target : targets) {
            nodeGroupSet.add(target.getDatanodeDescriptor().getNetworkLocation());
        }
        Assertions.assertEquals((int)nodeGroupSet.size(), (int)targets.length);
    }

    @Test
    public void testChooseTarget2() throws Exception {
        int i;
        BlockPlacementPolicyDefault repl = (BlockPlacementPolicyDefault)this.replicator;
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<DatanodeDescriptor> excludedNodes = new HashSet<DatanodeDescriptor>();
        excludedNodes.add(this.dataNodes[1]);
        DatanodeStorageInfo[] targets = repl.chooseTarget("/dummyfile.txt", 4, (Node)this.dataNodes[0], chosenNodes, false, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
        Assertions.assertEquals((int)targets.length, (int)4);
        Assertions.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assertions.assertTrue((boolean)this.cluster.isNodeGroupAware());
        for (i = 1; i < 4; ++i) {
            Assertions.assertFalse((boolean)this.isOnSameNodeGroup(targets[0], targets[i]));
        }
        Assertions.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[1], targets[3]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(this.dataNodes[1]);
        chosenNodes.add(this.storages[2]);
        targets = repl.chooseTarget("/dummyfile.txt", 1, (Node)this.dataNodes[0], chosenNodes, true, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
        System.out.println("targets=" + Arrays.asList(targets));
        Assertions.assertEquals((int)2, (int)targets.length);
        for (i = 0; i < targets.length && !this.storages[2].equals((Object)targets[i]); ++i) {
        }
        Assertions.assertTrue((i < targets.length ? 1 : 0) != 0);
    }

    @Test
    public void testChooseTarget3() throws Exception {
        this.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertEquals((Object)this.storages[1], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assertions.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(4);
        Assertions.assertEquals((int)targets.length, (int)4);
        Assertions.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assertions.assertTrue((boolean)this.cluster.isNodeGroupAware());
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        Assertions.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        this.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 0, 0);
    }

    @Test
    public void testChooseTarget4() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assertions.assertEquals((int)targets.length, (int)3);
        for (int i = 0; i < 3; ++i) {
            Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[i]));
        }
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
        Assertions.assertTrue((this.isOnSameRack(targets[0], targets[1]) || this.isOnSameRack(targets[1], targets[2]) ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
    }

    @Test
    public void testChooseTarget5() throws Exception {
        this.updateHeartbeatWithUsage();
        DatanodeStorageInfo[] targets = this.chooseTarget(0, NODE);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1, NODE);
        Assertions.assertEquals((int)targets.length, (int)1);
        targets = this.chooseTarget(2, NODE);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, NODE);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        this.verifyNoTwoTargetsOnSameNodeGroup(targets);
    }

    @Test
    public void testChooseTargetForLocalStorage() throws Exception {
        this.updateHeartbeatWithUsage(this.dataNodes[7], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(1, this.dataNodes[7]);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertTrue((boolean)targets[0].getDatanodeDescriptor().equals((Object)this.dataNodes[6]));
    }

    @Test
    public void testRereplicate1() throws Exception {
        this.updateHeartbeatWithUsage();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodes[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        this.updateHeartbeatWithUsage();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        chosenNodes.add(this.storages[1]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertFalse((this.isOnSameRack(this.dataNodes[0], targets[0]) && this.isOnSameRack(this.dataNodes[0], targets[1]) ? 1 : 0) != 0);
    }

    @Test
    public void testRereplicate3() throws Exception {
        this.updateHeartbeatWithUsage();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        chosenNodes.add(this.storages[3]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[3], targets[0]));
        targets = this.chooseTarget(1, this.dataNodes[3], chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertTrue((boolean)this.isOnSameRack(this.dataNodes[3], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodes[3], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertTrue((boolean)this.isOnSameRack(this.dataNodes[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameNodeGroup(this.dataNodes[0], targets[0]));
        targets = this.chooseTarget(2, this.dataNodes[3], chosenNodes);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertTrue((boolean)this.isOnSameRack(this.dataNodes[3], targets[0]));
    }

    @Test
    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeStorageInfo> replicaList = new ArrayList<DatanodeStorageInfo>();
        HashMap rackMap = new HashMap();
        this.storages[0].setRemainingForTests(0x400000);
        this.dataNodes[0].setRemaining(this.calculateRemaining(this.dataNodes[0]));
        replicaList.add(this.storages[0]);
        this.storages[1].setRemainingForTests(0x300000);
        this.dataNodes[1].setRemaining(this.calculateRemaining(this.dataNodes[1]));
        replicaList.add(this.storages[1]);
        this.storages[2].setRemainingForTests(0x200000);
        this.dataNodes[2].setRemaining(this.calculateRemaining(this.dataNodes[2]));
        replicaList.add(this.storages[2]);
        this.storages[4].setRemainingForTests(0x6400000);
        this.storages[5].setRemainingForTests(524288);
        this.dataNodes[5].setRemaining(this.calculateRemaining(this.dataNodes[5]));
        replicaList.add(this.storages[5]);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        this.replicator.splitNodesWithRack(replicaList, replicaList, rackMap, first, second);
        Assertions.assertEquals((int)3, (int)first.size());
        Assertions.assertEquals((int)1, (int)second.size());
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.DEFAULT);
        DatanodeStorageInfo chosen = ((BlockPlacementPolicyDefault)this.replicator).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assertions.assertEquals((Object)chosen, (Object)this.storages[1]);
        this.replicator.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assertions.assertEquals((int)2, (int)first.size());
        Assertions.assertEquals((int)1, (int)second.size());
        excessTypes.add(StorageType.DEFAULT);
        chosen = ((BlockPlacementPolicyDefault)this.replicator).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assertions.assertEquals((Object)chosen, (Object)this.storages[2]);
        this.replicator.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assertions.assertEquals((int)0, (int)first.size());
        Assertions.assertEquals((int)2, (int)second.size());
        excessTypes.add(StorageType.DEFAULT);
        chosen = ((BlockPlacementPolicyDefault)this.replicator).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assertions.assertEquals((Object)chosen, (Object)this.storages[5]);
    }

    private long calculateRemaining(DatanodeDescriptor dataNode) {
        long sum = 0L;
        for (DatanodeStorageInfo storageInfo : dataNode.getStorageInfos()) {
            sum += storageInfo.getRemaining();
        }
        return sum;
    }

    @Test
    public void testChooseTargetsOnBoundaryTopology() throws Exception {
        int i;
        for (i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.remove((Node)this.dataNodes[i]);
        }
        for (i = 0; i < dataNodesInBoundaryCase.length; ++i) {
            this.cluster.add((Node)dataNodesInBoundaryCase[i]);
        }
        for (i = 0; i < dataNodesInBoundaryCase.length; ++i) {
            this.updateHeartbeatWithUsage(dataNodesInBoundaryCase[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(0, dataNodesInBoundaryCase[0]);
        Assertions.assertEquals((int)targets.length, (int)0);
        targets = this.chooseTarget(1, dataNodesInBoundaryCase[0]);
        Assertions.assertEquals((int)targets.length, (int)1);
        targets = this.chooseTarget(2, dataNodesInBoundaryCase[0]);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, dataNodesInBoundaryCase[0]);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
    }

    @Test
    public void testRereplicateOnBoundaryTopology() throws Exception {
        for (int i = 0; i < dataNodesInBoundaryCase.length; ++i) {
            this.updateHeartbeatWithUsage(dataNodesInBoundaryCase[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(storagesInBoundaryCase[0]);
        chosenNodes.add(storagesInBoundaryCase[5]);
        DatanodeStorageInfo[] targets = this.chooseTarget(1, dataNodesInBoundaryCase[0], chosenNodes);
        Assertions.assertFalse((boolean)this.isOnSameNodeGroup(dataNodesInBoundaryCase[0], targets[0]));
        Assertions.assertFalse((boolean)this.isOnSameNodeGroup(dataNodesInBoundaryCase[5], targets[0]));
        Assertions.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
    }

    @Test
    public void testChooseMoreTargetsThanNodeGroups() throws Exception {
        int i;
        for (i = 0; i < this.dataNodes.length; ++i) {
            this.cluster.remove((Node)this.dataNodes[i]);
        }
        for (i = 0; i < dataNodesInBoundaryCase.length; ++i) {
            DatanodeDescriptor node = dataNodesInBoundaryCase[i];
            if (!this.cluster.contains((Node)node)) continue;
            this.cluster.remove((Node)node);
        }
        for (i = 0; i < dataNodesInMoreTargetsCase.length; ++i) {
            this.cluster.add((Node)dataNodesInMoreTargetsCase[i]);
        }
        for (i = 0; i < dataNodesInMoreTargetsCase.length; ++i) {
            this.updateHeartbeatWithUsage(dataNodesInMoreTargetsCase[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(3, dataNodesInMoreTargetsCase[0]);
        Assertions.assertEquals((int)targets.length, (int)3);
        Assertions.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
        targets = this.chooseTarget(10, dataNodesInMoreTargetsCase[0]);
        Assertions.assertTrue((boolean)TestReplicationPolicyWithNodeGroup.checkTargetsOnDifferentNodeGroup(targets));
        Assertions.assertEquals((int)targets.length, (int)6);
    }

    @Test
    public void testChooseTargetWithDependencies() throws Exception {
        int i;
        int i2;
        for (i2 = 0; i2 < this.dataNodes.length; ++i2) {
            this.cluster.remove((Node)this.dataNodes[i2]);
        }
        for (i2 = 0; i2 < dataNodesInMoreTargetsCase.length; ++i2) {
            DatanodeDescriptor node = dataNodesInMoreTargetsCase[i2];
            if (!this.cluster.contains((Node)node)) continue;
            this.cluster.remove((Node)node);
        }
        Host2NodesMap host2DatanodeMap = this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHost2DatanodeMap();
        for (i = 0; i < dataNodesForDependencies.length; ++i) {
            this.cluster.add((Node)dataNodesForDependencies[i]);
            host2DatanodeMap.add(dataNodesForDependencies[i]);
        }
        dataNodesForDependencies[1].addDependentHostName(dataNodesForDependencies[2].getHostName());
        dataNodesForDependencies[2].addDependentHostName(dataNodesForDependencies[1].getHostName());
        dataNodesForDependencies[3].addDependentHostName(dataNodesForDependencies[4].getHostName());
        dataNodesForDependencies[4].addDependentHostName(dataNodesForDependencies[3].getHostName());
        for (i = 0; i < dataNodesForDependencies.length; ++i) {
            this.updateHeartbeatWithUsage(dataNodesForDependencies[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add((Node)dataNodesForDependencies[5]);
        DatanodeStorageInfo[] targets = this.chooseTarget(3, dataNodesForDependencies[1], chosenNodes, excludedNodes);
        Assertions.assertEquals((int)targets.length, (int)2);
        Assertions.assertEquals((Object)targets[0], (Object)storagesForDependencies[1]);
        Assertions.assertTrue((targets[1].equals((Object)storagesForDependencies[3]) || targets[1].equals((Object)storagesForDependencies[4]) ? 1 : 0) != 0);
        Assertions.assertEquals((int)excludedNodes.size(), (int)dataNodesForDependencies.length);
        for (int i3 = 0; i3 < dataNodesForDependencies.length; ++i3) {
            Assertions.assertTrue((boolean)excludedNodes.contains(dataNodesForDependencies[i3]));
        }
    }

    @Test
    public void testChooseTargetAsFavouredNodes() throws Exception {
        ArrayList<DatanodeDescriptor> favoredNodes = new ArrayList<DatanodeDescriptor>();
        favoredNodes.add(this.dataNodes[6]);
        favoredNodes.add(this.dataNodes[0]);
        favoredNodes.add(this.dataNodes[1]);
        DatanodeStorageInfo[] targets = this.chooseTarget(1, this.dataNodes[7], null, favoredNodes);
        Assertions.assertEquals((int)targets.length, (int)1);
        Assertions.assertTrue((boolean)favoredNodes.contains(targets[0].getDatanodeDescriptor()));
    }

    @Test
    public void testChooseFavoredNodesNodeGroup() throws Exception {
        this.updateHeartbeatWithUsage(this.dataNodes[3], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        ArrayList<DatanodeDescriptor> expectedTargets = new ArrayList<DatanodeDescriptor>();
        expectedTargets.add(this.dataNodes[0]);
        expectedTargets.add(this.dataNodes[4]);
        ArrayList<DatanodeDescriptor> favouredNodes = new ArrayList<DatanodeDescriptor>();
        favouredNodes.add(this.dataNodes[3]);
        favouredNodes.add(this.dataNodes[0]);
        DatanodeStorageInfo[] targets = this.chooseTarget(2, this.dataNodes[7], null, favouredNodes);
        Assertions.assertTrue((boolean)expectedTargets.contains(targets[0].getDatanodeDescriptor()), (String)"1st Replica is incorrect");
        Assertions.assertTrue((boolean)expectedTargets.contains(targets[1].getDatanodeDescriptor()), (String)"2nd Replica is incorrect");
    }

    @Test
    public void testChooseRemainingReplicasApartFromFavoredNodes() throws Exception {
        ArrayList<DatanodeDescriptor> expectedTargets = new ArrayList<DatanodeDescriptor>();
        expectedTargets.add(this.dataNodes[0]);
        expectedTargets.add(this.dataNodes[2]);
        expectedTargets.add(this.dataNodes[3]);
        expectedTargets.add(this.dataNodes[6]);
        expectedTargets.add(this.dataNodes[7]);
        ArrayList<DatanodeDescriptor> favouredNodes = new ArrayList<DatanodeDescriptor>();
        favouredNodes.add(this.dataNodes[0]);
        favouredNodes.add(this.dataNodes[1]);
        favouredNodes.add(this.dataNodes[2]);
        DatanodeStorageInfo[] targets = this.chooseTarget(3, this.dataNodes[3], null, favouredNodes);
        for (int i = 0; i < targets.length; ++i) {
            Assertions.assertTrue((boolean)expectedTargets.contains(targets[i].getDatanodeDescriptor()), (String)"Target should be a part of Expected Targets");
        }
    }

    static {
        String[] racksInBoundaryCase = new String[]{"/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n2", "/d1/r2/n3", "/d1/r2/n3"};
        storagesInBoundaryCase = DFSTestUtil.createDatanodeStorageInfos(racksInBoundaryCase);
        dataNodesInBoundaryCase = DFSTestUtil.toDatanodeDescriptor(storagesInBoundaryCase);
        String[] racksInMoreTargetsCase = new String[]{"/r1/n1", "/r1/n1", "/r1/n2", "/r1/n2", "/r1/n3", "/r1/n3", "/r2/n4", "/r2/n4", "/r2/n5", "/r2/n5", "/r2/n6", "/r2/n6"};
        storagesInMoreTargetsCase = DFSTestUtil.createDatanodeStorageInfos(racksInMoreTargetsCase);
        dataNodesInMoreTargetsCase = DFSTestUtil.toDatanodeDescriptor(storagesInMoreTargetsCase);
        NODE = DFSTestUtil.getDatanodeDescriptor("9.9.9.9", "/d2/r4/n7");
        String[] racksForDependencies = new String[]{"/d1/r1/n1", "/d1/r1/n1", "/d1/r1/n2", "/d1/r1/n2", "/d1/r1/n3", "/d1/r1/n4"};
        String[] hostNamesForDependencies = new String[]{"h1", "h2", "h3", "h4", "h5", "h6"};
        storagesForDependencies = DFSTestUtil.createDatanodeStorageInfos(racksForDependencies, hostNamesForDependencies);
        dataNodesForDependencies = DFSTestUtil.toDatanodeDescriptor(storagesForDependencies);
    }
}

