/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.net.Node;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;

@MethodSource(value={"data"})
@ParameterizedClass
public class TestReplicationPolicyConsiderLoad
extends BaseReplicationPolicyTest {
    private final double EPSILON = 1.0E-4;

    public TestReplicationPolicyConsiderLoad(String blockPlacementPolicy) {
        this.blockPlacementPolicy = blockPlacementPolicy;
    }

    public static Iterable<Object[]> data() {
        return Arrays.asList({BlockPlacementPolicyDefault.class.getName()}, {BlockPlacementPolicyWithUpgradeDomain.class.getName()});
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        conf.setDouble("dfs.namenode.redundancy.considerLoad.factor", 1.2);
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2", "/rack3", "/rack3"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        return DFSTestUtil.toDatanodeDescriptor(this.storages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithDecomNodes() throws IOException {
        this.namenode.getNamesystem().writeLock(RwLockMode.BM);
        try {
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[3], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[3]), this.dataNodes[3].getCacheCapacity(), this.dataNodes[3].getCacheUsed(), 2, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[4], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[4]), this.dataNodes[4].getCacheCapacity(), this.dataNodes[4].getCacheUsed(), 4, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[5], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[5]), this.dataNodes[5].getCacheCapacity(), this.dataNodes[5].getCacheUsed(), 4, 0, null);
            int load = 10;
            Assertions.assertEquals((double)1.6666666666666667, (double)this.dnManager.getFSClusterStats().getInServiceXceiverAverage(), (double)1.0E-4);
            for (int i = 0; i < 3; ++i) {
                DatanodeDescriptor d = this.dataNodes[i];
                this.dnManager.getDatanodeAdminManager().startDecommission(d);
                d.setDecommissioned();
            }
            Assertions.assertEquals((double)3.3333333333333335, (double)this.dnManager.getFSClusterStats().getInServiceXceiverAverage(), (double)1.0E-4);
            DatanodeDescriptor writerDn = this.dataNodes[0];
            DatanodeStorageInfo[] targets = this.namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 3, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assertions.assertEquals((int)3, (int)targets.length);
            HashSet<DatanodeStorageInfo> targetSet = new HashSet<DatanodeStorageInfo>(Arrays.asList(targets));
            for (int i = 3; i < this.storages.length; ++i) {
                Assertions.assertTrue((boolean)targetSet.contains(this.storages[i]));
            }
        }
        finally {
            this.dataNodes[0].stopDecommission();
            this.dataNodes[1].stopDecommission();
            this.dataNodes[2].stopDecommission();
            this.namenode.getNamesystem().writeUnlock(RwLockMode.BM, "testChooseTargetWithDecomNodes");
        }
        NameNode.LOG.info("Done working on it");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsiderLoadFactor() throws IOException {
        this.namenode.getNamesystem().writeLock(RwLockMode.BM);
        try {
            DatanodeStorageInfo[] targets;
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[0], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[0]), this.dataNodes[0].getCacheCapacity(), this.dataNodes[0].getCacheUsed(), 5, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[1], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[1]), this.dataNodes[1].getCacheCapacity(), this.dataNodes[1].getCacheUsed(), 10, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[2], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[2]), this.dataNodes[2].getCacheCapacity(), this.dataNodes[2].getCacheUsed(), 5, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[3], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[3]), this.dataNodes[3].getCacheCapacity(), this.dataNodes[3].getCacheUsed(), 10, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[4], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[4]), this.dataNodes[4].getCacheCapacity(), this.dataNodes[4].getCacheUsed(), 15, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[5], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[5]), this.dataNodes[5].getCacheCapacity(), this.dataNodes[5].getCacheUsed(), 15, 0, null);
            double load = 60.0;
            DatanodeDescriptor writerDn = this.dataNodes[0];
            for (DatanodeStorageInfo info : targets = this.namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 3, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null)) {
                Assertions.assertTrue(((double)info.getDatanodeDescriptor().getXceiverCount() <= load / 6.0 * 1.2 ? 1 : 0) != 0, (String)("The node " + info.getDatanodeDescriptor().getName() + " has higher load and should not have been picked!"));
            }
        }
        finally {
            this.namenode.getNamesystem().writeUnlock(RwLockMode.BM, "testConsiderLoadFactor");
        }
    }
}

