/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHost2NodesMap {
    private final Host2NodesMap map = new Host2NodesMap();
    private DatanodeDescriptor[] dataNodes;

    @BeforeEach
    public void setup() {
        for (DatanodeDescriptor node : this.dataNodes = new DatanodeDescriptor[]{DFSTestUtil.getDatanodeDescriptor("1.1.1.1", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("2.2.2.2", "/d1/r1"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r2"), DFSTestUtil.getDatanodeDescriptor("3.3.3.3", 5021, "/d1/r2")}) {
            this.map.add(node);
        }
        this.map.add(null);
    }

    @Test
    public void testContains() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r4");
        for (int i = 0; i < this.dataNodes.length; ++i) {
            Assertions.assertTrue((boolean)this.map.contains(this.dataNodes[i]));
        }
        Assertions.assertFalse((boolean)this.map.contains(null));
        Assertions.assertFalse((boolean)this.map.contains(nodeNotInMap));
    }

    @Test
    public void testGetDatanodeByHost() throws Exception {
        Assertions.assertEquals((Object)this.map.getDatanodeByHost("1.1.1.1"), (Object)this.dataNodes[0]);
        Assertions.assertEquals((Object)this.map.getDatanodeByHost("2.2.2.2"), (Object)this.dataNodes[1]);
        DatanodeDescriptor node = this.map.getDatanodeByHost("3.3.3.3");
        Assertions.assertTrue((node == this.dataNodes[2] || node == this.dataNodes[3] ? 1 : 0) != 0);
        Assertions.assertNull((Object)this.map.getDatanodeByHost("4.4.4.4"));
    }

    @Test
    public void testRemove() throws Exception {
        DatanodeDescriptor nodeNotInMap = DFSTestUtil.getDatanodeDescriptor("3.3.3.3", "/d1/r4");
        Assertions.assertFalse((boolean)this.map.remove(nodeNotInMap));
        Assertions.assertTrue((boolean)this.map.remove(this.dataNodes[0]));
        Assertions.assertTrue((this.map.getDatanodeByHost("1.1.1.1.") == null ? 1 : 0) != 0);
        Assertions.assertTrue((this.map.getDatanodeByHost("2.2.2.2") == this.dataNodes[1] ? 1 : 0) != 0);
        DatanodeDescriptor node = this.map.getDatanodeByHost("3.3.3.3");
        Assertions.assertTrue((node == this.dataNodes[2] || node == this.dataNodes[3] ? 1 : 0) != 0);
        Assertions.assertNull((Object)this.map.getDatanodeByHost("4.4.4.4"));
        Assertions.assertTrue((boolean)this.map.remove(this.dataNodes[2]));
        Assertions.assertNull((Object)this.map.getDatanodeByHost("1.1.1.1"));
        Assertions.assertEquals((Object)this.map.getDatanodeByHost("2.2.2.2"), (Object)this.dataNodes[1]);
        Assertions.assertEquals((Object)this.map.getDatanodeByHost("3.3.3.3"), (Object)this.dataNodes[3]);
        Assertions.assertTrue((boolean)this.map.remove(this.dataNodes[3]));
        Assertions.assertNull((Object)this.map.getDatanodeByHost("1.1.1.1"));
        Assertions.assertEquals((Object)this.map.getDatanodeByHost("2.2.2.2"), (Object)this.dataNodes[1]);
        Assertions.assertNull((Object)this.map.getDatanodeByHost("3.3.3.3"));
        Assertions.assertFalse((boolean)this.map.remove(null));
        Assertions.assertTrue((boolean)this.map.remove(this.dataNodes[1]));
        Assertions.assertFalse((boolean)this.map.remove(this.dataNodes[1]));
    }
}

