/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBlockUnderConstructionFeature {
    @Test
    public void testInitializeBlockRecovery() throws Exception {
        DatanodeStorageInfo s1 = DFSTestUtil.createDatanodeStorageInfo("10.10.1.1", "s1");
        DatanodeDescriptor dd1 = s1.getDatanodeDescriptor();
        DatanodeStorageInfo s2 = DFSTestUtil.createDatanodeStorageInfo("10.10.1.2", "s2");
        DatanodeDescriptor dd2 = s2.getDatanodeDescriptor();
        DatanodeStorageInfo s3 = DFSTestUtil.createDatanodeStorageInfo("10.10.1.3", "s3");
        DatanodeDescriptor dd3 = s3.getDatanodeDescriptor();
        dd1.setAlive(true);
        dd2.setAlive(true);
        dd3.setAlive(true);
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(new Block(0L, 0L, 1000L), 3);
        blockInfo.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, new DatanodeStorageInfo[]{s1, s2, s3});
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -3000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, -2000L);
        blockInfo.getUnderConstructionFeature().initializeBlockRecovery((BlockInfo)blockInfo, 1L, true);
        BlockInfo[] blockInfoRecovery = dd2.getLeaseRecoveryCommand(1);
        Assertions.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -2000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, -3000L);
        blockInfo.getUnderConstructionFeature().initializeBlockRecovery((BlockInfo)blockInfo, 2L, true);
        blockInfoRecovery = dd1.getLeaseRecoveryCommand(1);
        Assertions.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -2000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, -3000L);
        blockInfo.getUnderConstructionFeature().initializeBlockRecovery((BlockInfo)blockInfo, 3L, true);
        blockInfoRecovery = dd3.getLeaseRecoveryCommand(1);
        Assertions.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd1, -2000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd2, -1000L);
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dd3, 0L);
        blockInfo.getUnderConstructionFeature().initializeBlockRecovery((BlockInfo)blockInfo, 3L, true);
        blockInfoRecovery = dd3.getLeaseRecoveryCommand(1);
        Assertions.assertEquals((Object)blockInfoRecovery[0], (Object)blockInfo);
    }
}

