/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=300L)
public class TestBlockStatsMXBean {
    private MiniDFSCluster cluster;

    @BeforeEach
    public void setup() throws IOException {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        this.cluster = null;
        StorageType[][] types = new StorageType[7][];
        for (i = 0; i < 3; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.DISK};
        }
        for (i = 3; i < 5; ++i) {
            types[i] = new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE};
        }
        types[5] = new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE, StorageType.ARCHIVE};
        types[6] = new StorageType[]{StorageType.RAM_DISK, StorageType.NVDIMM};
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(7).storageTypes(types).storagesPerDatanode(3).build();
        this.cluster.waitActive();
    }

    @AfterEach
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testStorageTypeStats() throws Exception {
        Map storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        Assertions.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.RAM_DISK));
        Assertions.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.DISK));
        Assertions.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.ARCHIVE));
        Assertions.assertTrue((boolean)storageTypeStatsMap.containsKey(StorageType.NVDIMM));
        StorageTypeStats storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assertions.assertEquals((int)7, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assertions.assertEquals((int)3, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assertions.assertEquals((int)3, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.NVDIMM);
        Assertions.assertEquals((int)1, (int)storageTypeStats.getNodesInService());
    }

    protected static String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }

    @Test
    public void testStorageTypeStatsJMX() throws Exception {
        URL baseUrl = new URL(this.cluster.getHttpUri(0));
        String result = TestBlockStatsMXBean.readOutput(new URL(baseUrl, "/jmx"));
        Map stat = (Map)JSON.parse((String)result);
        Object[] beans = (Object[])stat.get("beans");
        Map blockStats = null;
        for (Object bean : beans) {
            Map map = (Map)bean;
            if (!map.get("name").equals("Hadoop:service=NameNode,name=BlockStats")) continue;
            blockStats = map;
        }
        Assertions.assertNotNull(blockStats);
        Object[] storageTypeStatsList = (Object[])blockStats.get("StorageTypeStats");
        Assertions.assertNotNull((Object)storageTypeStatsList);
        Assertions.assertEquals((int)4, (int)storageTypeStatsList.length);
        HashSet<String> typesPresent = new HashSet<String>();
        block12: for (Object obj : storageTypeStatsList) {
            Map entry = (Map)obj;
            String storageType = (String)entry.get("key");
            Map storageTypeStats = (Map)entry.get("value");
            typesPresent.add(storageType);
            switch (storageType) {
                case "ARCHIVE": 
                case "DISK": {
                    Assertions.assertEquals((Object)3L, storageTypeStats.get("nodesInService"));
                    continue block12;
                }
                case "RAM_DISK": {
                    Assertions.assertEquals((Object)7L, storageTypeStats.get("nodesInService"));
                    continue block12;
                }
                case "NVDIMM": {
                    Assertions.assertEquals((Object)1L, storageTypeStats.get("nodesInService"));
                    continue block12;
                }
                default: {
                    Assertions.fail();
                }
            }
        }
        Assertions.assertTrue((boolean)typesPresent.contains("ARCHIVE"));
        Assertions.assertTrue((boolean)typesPresent.contains("DISK"));
        Assertions.assertTrue((boolean)typesPresent.contains("RAM_DISK"));
        Assertions.assertTrue((boolean)typesPresent.contains("NVDIMM"));
    }

    @Test
    public void testStorageTypeStatsWhenStorageFailed() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), new Path("/blockStatsFile1"), 1024L, (short)1, 0L);
        Map storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        StorageTypeStats storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assertions.assertEquals((int)7, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assertions.assertEquals((int)3, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assertions.assertEquals((int)3, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.NVDIMM);
        Assertions.assertEquals((int)1, (int)storageTypeStats.getNodesInService());
        File dn1ArcVol1 = this.cluster.getInstanceStorageDir(0, 1);
        File dn2ArcVol1 = this.cluster.getInstanceStorageDir(1, 1);
        File dn3ArcVol1 = this.cluster.getInstanceStorageDir(2, 1);
        File dn4ArcVol1 = this.cluster.getInstanceStorageDir(3, 1);
        DataNodeTestUtils.injectDataDirFailure(dn1ArcVol1);
        DataNodeTestUtils.injectDataDirFailure(dn2ArcVol1);
        DataNodeTestUtils.injectDataDirFailure(dn3ArcVol1);
        DataNodeTestUtils.injectDataDirFailure(dn4ArcVol1);
        try {
            DFSTestUtil.createFile((FileSystem)this.cluster.getFileSystem(), new Path("/blockStatsFile2"), 1024L, (short)1, 0L);
            Assertions.fail((String)"Should throw exception, becuase no DISK storage available");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("could only be written to 0 of the 1 minReplication"));
        }
        Thread.sleep(6000L);
        storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        Assertions.assertFalse((boolean)storageTypeStatsMap.containsKey(StorageType.DISK), (String)"StorageTypeStatsMap should not contain DISK Storage type");
        DataNodeTestUtils.restoreDataDirFromFailure(dn1ArcVol1);
        DataNodeTestUtils.restoreDataDirFromFailure(dn2ArcVol1);
        DataNodeTestUtils.restoreDataDirFromFailure(dn3ArcVol1);
        DataNodeTestUtils.restoreDataDirFromFailure(dn4ArcVol1);
        for (int i = 0; i < 4; ++i) {
            this.cluster.restartDataNode(0, true);
        }
        Thread.sleep(6000L);
        storageTypeStatsMap = this.cluster.getNamesystem().getBlockManager().getStorageTypeStats();
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.RAM_DISK);
        Assertions.assertEquals((int)7, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK);
        Assertions.assertEquals((int)3, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE);
        Assertions.assertEquals((int)3, (int)storageTypeStats.getNodesInService());
        storageTypeStats = (StorageTypeStats)storageTypeStatsMap.get(StorageType.NVDIMM);
        Assertions.assertEquals((int)1, (int)storageTypeStats.getNodesInService());
    }

    @Test
    public void testStorageTypeLoad() throws Exception {
        HeartbeatManager heartbeatManager = this.cluster.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager();
        Map storageTypeStatsMap = heartbeatManager.getStorageTypeStats();
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        Path hotSpDir = new Path("/HOT");
        dfs.mkdir(hotSpDir, FsPermission.getDirDefault());
        dfs.setStoragePolicy(hotSpDir, "HOT");
        FSDataOutputStream hotSpFileStream = dfs.create(new Path(hotSpDir, "hotFile"));
        hotSpFileStream.write("Storage Policy Hot".getBytes());
        hotSpFileStream.hflush();
        Path coldSpDir = new Path("/COLD");
        dfs.mkdir(coldSpDir, FsPermission.getDirDefault());
        dfs.setStoragePolicy(coldSpDir, "COLD");
        FSDataOutputStream coldSpFileStream = dfs.create(new Path(coldSpDir, "coldFile"));
        coldSpFileStream.write("Writing to ARCHIVE storage type".getBytes());
        coldSpFileStream.hflush();
        this.cluster.triggerHeartbeats();
        GenericTestUtils.waitFor(() -> ((StorageTypeStats)storageTypeStatsMap.get(StorageType.DISK)).getNodesInServiceXceiverCount() == 6, (long)100L, (long)5000L);
        GenericTestUtils.waitFor(() -> ((StorageTypeStats)storageTypeStatsMap.get(StorageType.ARCHIVE)).getNodesInServiceXceiverCount() == 6, (long)100L, (long)5000L);
        GenericTestUtils.waitFor(() -> heartbeatManager.getInServiceXceiverCount() == 12, (long)100L, (long)5000L);
        IOUtils.closeStreams((Closeable[])new Closeable[]{hotSpFileStream, coldSpFileStream});
    }

    @Test
    public void testStorageTypePercentJMX() throws Exception {
        URL baseUrl = new URL(this.cluster.getHttpUri(0));
        String result = TestBlockStatsMXBean.readOutput(new URL(baseUrl, "/jmx"));
        Map stat = (Map)JSON.parse((String)result);
        Object[] beans = (Object[])stat.get("beans");
        Map blockStats = null;
        for (Object bean : beans) {
            Map map = (Map)bean;
            if (!map.get("name").equals("Hadoop:service=NameNode,name=BlockStats")) continue;
            blockStats = map;
        }
        Assertions.assertNotNull(blockStats);
        Object[] storageTypeStatsList = (Object[])blockStats.get("StorageTypeStats");
        Assertions.assertNotNull((Object)storageTypeStatsList);
        Map entry = (Map)storageTypeStatsList[0];
        Map storageTypeStats = (Map)entry.get("value");
        Assertions.assertTrue((boolean)storageTypeStats.containsKey("percentUsed"));
        Assertions.assertTrue((boolean)storageTypeStats.containsKey("percentBlockPoolUsed"));
        Assertions.assertTrue((boolean)storageTypeStats.containsKey("percentRemaining"));
    }
}

