/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestBlockInfo");

    @Test
    public void testIsDeleted() {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
        blockInfo.setBlockCollectionId(1000L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)blockInfo.isDeleted());
        blockInfo.setBlockCollectionId(-1L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)blockInfo.isDeleted());
    }

    @Test
    public void testAddStorage() throws Exception {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        boolean added = blockInfo.addStorage(storage, (Block)blockInfo);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)added);
        org.junit.jupiter.api.Assertions.assertEquals((Object)storage, (Object)blockInfo.getStorageInfo(0));
    }

    @Test
    public void testAddProvidedStorage() throws Exception {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        DatanodeStorageInfo providedStorage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        Mockito.when((Object)providedStorage.getStorageType()).thenReturn((Object)StorageType.PROVIDED);
        boolean added = blockInfo.addStorage(providedStorage, (Block)blockInfo);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)added);
        org.junit.jupiter.api.Assertions.assertEquals((Object)providedStorage, (Object)blockInfo.getStorageInfo(0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)blockInfo.isProvided());
    }

    @Test
    public void testAddTwoStorageTypes() throws Exception {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        DatanodeStorageInfo diskStorage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        DatanodeDescriptor mockDN = (DatanodeDescriptor)Mockito.mock(DatanodeDescriptor.class);
        Mockito.when((Object)diskStorage.getDatanodeDescriptor()).thenReturn((Object)mockDN);
        Mockito.when((Object)diskStorage.getStorageType()).thenReturn((Object)StorageType.DISK);
        boolean added = blockInfo.addStorage(diskStorage, (Block)blockInfo);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)added);
        org.junit.jupiter.api.Assertions.assertEquals((Object)diskStorage, (Object)blockInfo.getStorageInfo(0));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)blockInfo.isProvided());
        DatanodeStorageInfo providedStorage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        Mockito.when((Object)providedStorage.getStorageType()).thenReturn((Object)StorageType.PROVIDED);
        added = blockInfo.addStorage(providedStorage, (Block)blockInfo);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)added);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)blockInfo.isProvided());
    }

    @Test
    public void testReplaceStorage() throws Exception {
        DatanodeStorageInfo storage1 = DFSTestUtil.createDatanodeStorageInfo("storageID1", "127.0.0.1");
        DatanodeStorageInfo storage2 = new DatanodeStorageInfo(storage1.getDatanodeDescriptor(), new DatanodeStorage("storageID2"));
        int NUM_BLOCKS = 10;
        BlockInfo[] blockInfos = new BlockInfo[10];
        for (int i = 0; i < 10; ++i) {
            blockInfos[i] = new BlockInfoContiguous(3);
            storage1.addBlock(blockInfos[i]);
        }
        boolean added = storage2.addBlock(blockInfos[5]) == DatanodeStorageInfo.AddBlockResult.ADDED;
        Assertions.assertThat((boolean)added).isEqualTo(false);
        Assertions.assertThat((Object)blockInfos[5].getStorageInfo(0)).isEqualTo((Object)storage2);
    }

    @Test
    public void testAddStorageWithDifferentBlock() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            BlockInfoContiguous blockInfo1 = new BlockInfoContiguous(new Block(1000L), 3);
            BlockInfoContiguous blockInfo2 = new BlockInfoContiguous(new Block(1001L), 3);
            DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
            blockInfo1.addStorage(storage, (Block)blockInfo2);
        });
    }

    @Test
    public void testBlockListMoveToHead() throws Exception {
        int curIndex;
        LOG.info("BlockInfo moveToHead tests...");
        int maxBlocks = 10;
        DatanodeStorageInfo dd = DFSTestUtil.createDatanodeStorageInfo("s1", "1.1.1.1");
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        ArrayList<BlockInfoContiguous> blockInfoList = new ArrayList<BlockInfoContiguous>();
        LOG.info("Building block list...");
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
            blockInfoList.add(new BlockInfoContiguous((Block)blockList.get(i), 3));
            dd.addBlock((BlockInfo)blockInfoList.get(i));
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((BlockInfo)blockInfoList.get(i)).findStorageInfo(dd), (String)"Find datanode should be 0");
        }
        LOG.info("Checking list length...");
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)dd.numBlocks(), (String)"Length should be MAX_BLOCK");
        Iterator it = dd.getBlockIterator();
        int len = 0;
        while (it.hasNext()) {
            it.next();
            ++len;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)len, (String)"There should be MAX_BLOCK blockInfo's");
        int headIndex = dd.getBlockListHeadForTesting().findStorageInfo(dd);
        LOG.info("Moving each block to the head of the list...");
        for (int i = 0; i < 10; ++i) {
            curIndex = ((BlockInfo)blockInfoList.get(i)).findStorageInfo(dd);
            headIndex = dd.moveBlockToHead((BlockInfo)blockInfoList.get(i), curIndex, headIndex);
            org.junit.jupiter.api.Assertions.assertEquals(blockInfoList.get(i), (Object)dd.getBlockListHeadForTesting(), (String)"Block should be at the head of the list now.");
        }
        LOG.info("Moving head to the head...");
        BlockInfo temp = dd.getBlockListHeadForTesting();
        curIndex = 0;
        headIndex = 0;
        dd.moveBlockToHead(temp, curIndex, headIndex);
        org.junit.jupiter.api.Assertions.assertEquals((Object)temp, (Object)dd.getBlockListHeadForTesting(), (String)"Moving head to the head of the list shopuld not change the list");
        LOG.info("Checking elements of the list...");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)temp, (String)"Head should not be null");
        int c = 9;
        for (temp = dd.getBlockListHeadForTesting(); temp != null; temp = temp.getNext(0)) {
            org.junit.jupiter.api.Assertions.assertEquals(blockInfoList.get(c--), (Object)temp, (String)"Expected element is not on the list");
        }
        LOG.info("Moving random blocks to the head of the list...");
        headIndex = dd.getBlockListHeadForTesting().findStorageInfo(dd);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int j = rand.nextInt(10);
            curIndex = ((BlockInfo)blockInfoList.get(j)).findStorageInfo(dd);
            headIndex = dd.moveBlockToHead((BlockInfo)blockInfoList.get(j), curIndex, headIndex);
            org.junit.jupiter.api.Assertions.assertEquals(blockInfoList.get(j), (Object)dd.getBlockListHeadForTesting(), (String)"Block should be at the head of the list now.");
        }
    }
}

